/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.core;

import java.util.concurrent.atomic.AtomicBoolean;
import kd.ai.aicc.core.DataManager;
import kd.ai.aicc.core.Executor;
import kd.ai.aicc.core.Queue;
import kd.ai.aicc.core.client.SyncTaskLockManager;
import kd.ai.aicc.core.domain.Task;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class Dispatcher
implements Runnable {
    private static final Log log = LogFactory.getLog(Dispatcher.class);
    public static final String DISPATCHER_THREAD_POOL_NAME = "ai-aicc-dispatcher-threadpool";
    private static Dispatcher instance = null;
    private static final ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"ai-aicc-dispatcher-threadpool", (int)1, (String)"aicc");
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private Queue queue;
    private Executor executor;
    private final Object notifyObject = new Object();

    private Dispatcher() {
    }

    public static synchronized Dispatcher getInstance() {
        if (instance == null) {
            instance = new Dispatcher();
            instance.init();
        }
        return instance;
    }

    private void init() {
        DataManager.getInstance().init();
        this.queue = new Queue();
        this.queue.init();
        this.executor = new Executor();
        this.executor.init();
        this.isRunning.set(true);
        threadPool.execute((Runnable)this);
        log.info("\u521d\u59cb\u5316\u5b8c\u6210");
    }

    public void start() {
        this.isRunning.set(true);
        log.info("\u670d\u52a1\u542f\u52a8");
    }

    public void stop() {
        log.warn("\u6536\u5230\u670d\u52a1\u505c\u6b62\u4fe1\u53f7");
        this.isRunning.set(false);
    }

    public boolean isStarted() {
        return this.isRunning.get();
    }

    public void newSyncTask(Task task) {
        this.newASyncTask(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newASyncTask(Task task) {
        DataManager.getInstance().setTaskRequestContext(task);
        this.queue.enqueue(task);
        Object object = this.notifyObject;
        synchronized (object) {
            this.notifyObject.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskCompleted(Task task) {
        Object object = this.notifyObject;
        synchronized (object) {
            this.notifyObject.notifyAll();
        }
        SyncTaskLockManager.release(task.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        log.info("\u4efb\u52a1\u5206\u53d1\u5668\u5f00\u59cb\u8fd0\u884c");
        while (this.isRunning.get()) {
            try {
                this.running();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            if (!this.isRunning.get()) continue;
            Object object = this.notifyObject;
            synchronized (object) {
                try {
                    this.notifyObject.wait(5000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        log.info("\u4efb\u52a1\u5206\u53d1\u5668\u7ed3\u675f\u8fd0\u884c");
    }

    private void running() {
        Task task = this.queue.next();
        while (this.isRunning.get() && task != null) {
            try {
                this.executor.executeTask(task, task.getInstance());
            }
            catch (Exception e) {
                task.releaseLock();
                task.getInstance().releaseResource();
                log.error((Throwable)e);
            }
            task = this.queue.next();
        }
    }
}

