/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.core;

import kd.ai.aicc.core.CacheHelper;
import kd.ai.aicc.core.Constant;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;

public class DistributeCounter {
    private DistributeCounter() {
    }

    public static void reset(String key) {
        CacheHelper.removeKey(key);
    }

    public static int getValue(String key) {
        return CacheHelper.getInt(key);
    }

    public static int addOne(String key) {
        return DistributeCounter.add(key, 1);
    }

    public static int subOne(String key) {
        return DistributeCounter.add(key, -1);
    }

    public static int add(String key, int value) {
        try (DLock dLock = DLock.create((String)key);){
            if (dLock.fastMode().tryLock(3000L)) {
                int currentValue = DistributeCounter.getValue(key);
                int sum = currentValue + value;
                CacheHelper.putInt(key, sum);
                int n = sum;
                return n;
            }
        }
        throw new KDBizException(Constant.DISTRIBUTECOUNT_ERROR, new Object[0]);
    }
}

