/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.core;

import com.google.common.base.Strings;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.UUID;
import kd.ai.aicc.core.AsyncTaskNotifier;
import kd.ai.aicc.core.Authorization;
import kd.ai.aicc.core.CacheHelper;
import kd.ai.aicc.core.Constant;
import kd.ai.aicc.core.DataManager;
import kd.ai.aicc.core.Dispatcher;
import kd.ai.aicc.core.TaskResult;
import kd.ai.aicc.core.TaskStatusEnum;
import kd.ai.aicc.core.Utils;
import kd.ai.aicc.core.XfWebSocketRunner;
import kd.ai.aicc.core.dao.TaskDao;
import kd.ai.aicc.core.domain.Instance;
import kd.ai.aicc.core.domain.Task;
import kd.bos.context.RequestContext;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;

public class Executor {
    private static final Log log = LogFactory.getLog(Executor.class);
    public static final String TASK_EXEC_THREAD_POOL_NAME = "ai-aicc-task_exec-threadpool";
    public static final int TASK_EXEC_MAX_THREAD_NUM = 100;
    private static ThreadPool threadPool = null;

    public synchronized void init() {
        if (threadPool == null) {
            threadPool = ThreadPools.newFixedThreadPool((String)TASK_EXEC_THREAD_POOL_NAME, (int)100, (String)"aicc");
        }
        log.info("\u5b8c\u6210\u521d\u59cb\u5316");
    }

    public void executeTask(Task task, Instance atInstance) {
        RequestContext requestContext = DataManager.getInstance().getTaskRequestContext(task);
        threadPool.execute((Runnable)new TaskRunner(task, atInstance), requestContext);
    }

    public static class TaskRunner
    implements Runnable {
        private static final Log log = LogFactory.getLog(TaskRunner.class);
        private final Task task;
        private final Instance atInstance;

        public Task getTask() {
            return this.task;
        }

        public Instance getAtInstance() {
            return this.atInstance;
        }

        public TaskRunner(Task task, Instance atInstance) {
            this.task = task;
            this.atInstance = atInstance;
        }

        @Override
        public void run() {
            try {
                if (this.before()) {
                    if (this.atInstance.getProtocol().equalsIgnoreCase("http") || this.atInstance.getProtocol().equalsIgnoreCase("https")) {
                        this.httpRunning();
                    } else if (this.atInstance.getProtocol().equalsIgnoreCase("ws") || this.atInstance.getProtocol().equalsIgnoreCase("wss")) {
                        XfWebSocketRunner wsRunner = new XfWebSocketRunner();
                        wsRunner.run(this);
                    } else {
                        ErrorCode errorCode = Constant.notSupportProtocol(this.atInstance.getProtocol());
                        this.execTaskFailed(errorCode.getCode(), errorCode.getMessage());
                    }
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                ErrorCode errorCode = Constant.internalError(e.getMessage());
                this.execTaskFailed(errorCode.getCode(), errorCode.getMessage());
            }
            finally {
                this.releaseTask();
            }
        }

        public void releaseTask() {
            this.releaseResources();
            Dispatcher.getInstance().taskCompleted(this.task);
            DataManager.getInstance().removeTaskRequestContext(this.task);
        }

        private boolean before() {
            String taskStopKey = "ST_ST_" + this.task.getId();
            if ("[STOP]".equals(CacheHelper.getString(taskStopKey))) {
                CacheHelper.removeKey(taskStopKey);
                this.task.setStatusEnum(TaskStatusEnum.STOPPED);
                TaskDao.updateStatus(this.task);
                this.notifyStopped();
                log.info("task stopped : {}", (Object)this.task.getId());
                return false;
            }
            this.task.setStatusEnum(TaskStatusEnum.RUNNING);
            this.task.setInstance(this.atInstance);
            TaskDao.updateStatus(this.task);
            return true;
        }

        private void httpRunning() {
            log.info("running task : {}", (Object)this.task.getId());
            HttpUriRequest httpRequest = this.buildRequest();
            if (this.task.isStream() && this.atInstance.getService().isSupportStream()) {
                log.info("execute stream task : {}", (Object)this.task.getId());
                this.httpStreamExecute(httpRequest);
                log.info("execute stream task : {} done", (Object)this.task.getId());
            } else {
                log.info("execute task : {}", (Object)this.task.getId());
                this.task.setStream(false);
                TaskDao.updateStreamFlag(this.task);
                this.httpExecute(httpRequest);
                log.info("execute task : {} done", (Object)this.task.getId());
            }
        }

        private void httpStreamExecute(HttpUriRequest httpRequest) {
            block34: {
                try (CloseableHttpResponse httpResponse = Utils.httpClient.execute(httpRequest);){
                    int errCode = httpResponse.getStatusLine().getStatusCode();
                    HttpEntity entity = httpResponse.getEntity();
                    if (200 == errCode) {
                        boolean isContainDONE = false;
                        StringBuilder contentBuffer = new StringBuilder();
                        int seq = 1;
                        boolean isStopped = false;
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(entity.getContent()));){
                            String line;
                            String taskStopKey = "ST_ST_" + this.task.getId();
                            while ((line = reader.readLine()) != null) {
                                String stopVal;
                                contentBuffer.append(line);
                                if (this.isStreamDone(line)) {
                                    this.notifyStreamDone(seq++);
                                    isContainDONE = true;
                                } else {
                                    this.notifyStream(line, seq++);
                                }
                                if (!"[STOP]".equals(stopVal = CacheHelper.getString(taskStopKey))) continue;
                                CacheHelper.removeKey(taskStopKey);
                                isStopped = true;
                                break;
                            }
                        }
                        if (isStopped) {
                            this.stopTask(contentBuffer.toString());
                        } else {
                            if (!isContainDONE) {
                                this.notifyStreamDone(seq);
                            }
                            this.execTaskSuccess(contentBuffer.toString(), false);
                        }
                        break block34;
                    }
                    String resp = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                    log.error(resp);
                    this.execTaskFailed(String.valueOf(errCode), resp);
                }
                catch (Exception e) {
                    log.error(e.getMessage() + "," + httpRequest.getURI().toString(), (Throwable)e);
                    ErrorCode errorCode = Constant.httpError(this.removeToken(httpRequest.getURI().toString()), e.getMessage());
                    this.execTaskFailed(errorCode.getCode(), errorCode.getMessage());
                }
            }
        }

        private String removeToken(String url) {
            int pos = url.indexOf("access_token");
            if (pos > 0) {
                return url.substring(0, pos);
            }
            return url;
        }

        private boolean isStreamDone(String streamLine) {
            return streamLine != null && streamLine.contains("data: [DONE]");
        }

        public void notifyStopped() {
            TaskResult result = new TaskResult();
            result.setId(this.task.getId());
            result.setErrCode(Constant.USER_STOPPED.getCode());
            result.setErrMsg(Constant.USER_STOPPED.getMessage());
            result.setStatus(TaskStatusEnum.STOPPED.getValue());
            AsyncTaskNotifier.notifyTaskResult(result);
        }

        public void notifyError(String errCode, String errMsg) {
            TaskResult result = new TaskResult();
            result.setId(this.task.getId());
            result.setErrCode(errCode);
            result.setErrMsg(errMsg);
            result.setStatus(TaskStatusEnum.FAILED.getValue());
            AsyncTaskNotifier.notifyTaskResult(result);
        }

        public void notifyStream(String streamLine, int seqNo) {
            TaskResult result = new TaskResult();
            result.setId(this.task.getId());
            result.setErrCode("0");
            result.setStatus(TaskStatusEnum.RUNNING.getValue());
            result.setResult(streamLine);
            result.setStream(true);
            result.setStreamSeqNO(seqNo);
            AsyncTaskNotifier.notifyTaskResult(result);
        }

        public void notifyStreamDone(int seqNo) {
            TaskResult result = new TaskResult();
            result.setId(this.task.getId());
            result.setErrCode("0");
            result.setStatus(TaskStatusEnum.SUCCESS.getValue());
            result.setResult("data: [DONE]");
            result.setStream(true);
            result.setStreamSeqNO(seqNo);
            AsyncTaskNotifier.notifyTaskResult(result);
        }

        private void httpExecute(HttpUriRequest httpRequest) {
            try (CloseableHttpResponse httpResponse = Utils.httpClient.execute(httpRequest);){
                int errCode = httpResponse.getStatusLine().getStatusCode();
                HttpEntity entity = httpResponse.getEntity();
                String resp = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                if (200 == errCode && !resp.startsWith("<!doctype html>")) {
                    this.execTaskSuccess(resp, true);
                } else {
                    log.error(resp);
                    this.execTaskFailed(String.valueOf(errCode), resp);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage() + "," + httpRequest.getURI().toString(), (Throwable)e);
                ErrorCode errorCode = Constant.httpError(this.removeToken(httpRequest.getURI().toString()), e.getMessage());
                this.execTaskFailed(errorCode.getCode(), errorCode.getMessage());
            }
        }

        private void releaseResources() {
            this.task.releaseLock();
            this.atInstance.releaseResource();
        }

        private void stopTask(String result) {
            this.task.setStatusEnum(TaskStatusEnum.STOPPED);
            this.task.setResult(result);
            TaskDao.updateStatus(this.task);
        }

        public void execTaskSuccess(String result, boolean needNotify) {
            this.task.setStatusEnum(TaskStatusEnum.SUCCESS);
            this.task.setErrCode("0");
            this.task.setResult(result);
            TaskDao.updateStatus(this.task);
            if (this.task.isAsyncTask() && needNotify) {
                TaskResult taskResult = new TaskResult();
                taskResult.setId(this.task.getId());
                taskResult.setErrCode("0");
                taskResult.setStatus(TaskStatusEnum.SUCCESS.getValue());
                taskResult.setResult(result);
                AsyncTaskNotifier.notifyTaskResult(taskResult);
            }
        }

        public void execTaskFailed(String errorCode, String errMsg) {
            this.task.setStatusEnum(TaskStatusEnum.FAILED);
            this.task.setErrCode(errorCode);
            this.task.setErrMsg(errMsg);
            TaskDao.updateStatus(this.task);
            if (this.task.isAsyncTask()) {
                this.notifyError(errorCode, errMsg);
            }
        }

        private HttpUriRequest buildRequest() {
            TaskDao.queryRequestParameters(this.task);
            HttpPost httpPost = Authorization.createPost(this.atInstance, this.task);
            RequestContext context = RequestContext.get();
            String traceId = Strings.isNullOrEmpty((String)context.getTraceId()) ? UUID.randomUUID().toString() : context.getTraceId();
            httpPost.addHeader("X-Request-Id", traceId);
            return httpPost;
        }
    }
}

