/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.core;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.PriorityBlockingQueue;
import kd.ai.aicc.core.DataManager;
import kd.ai.aicc.core.TaskStatusEnum;
import kd.ai.aicc.core.domain.Instance;
import kd.ai.aicc.core.domain.Service;
import kd.ai.aicc.core.domain.Task;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class Queue {
    private static final Log log = LogFactory.getLog(Queue.class);
    public static final int SERVICE_QUEUE_INIT_SIZE = 100;
    private final Map<String, PriorityBlockingQueue<Task>> serviceQueueMap = new ConcurrentHashMap<String, PriorityBlockingQueue<Task>>();
    private int currentServiceIndex = 0;
    private final List<String> serviceList = new ArrayList<String>(50);

    public void init() {
        this.serviceList.clear();
        this.currentServiceIndex = 0;
        log.info("\u961f\u5217\u521d\u59cb\u5316\u5b8c\u6210");
    }

    public void enqueue(Task task) {
        boolean existed = false;
        String serviceFlag = this.getServiceFlag(task);
        for (String serviceFlag2 : this.serviceList) {
            if (!serviceFlag.equals(serviceFlag2)) continue;
            existed = true;
            break;
        }
        if (!existed) {
            this.serviceList.add(serviceFlag);
        }
        this.addTaskQueue(task);
        log.info("\u6570\u636e\u4e2d\u5fc3{}, \u670d\u52a1{}\u6709\u65b0\u4efb\u52a1{}\u5165\u961f", new Object[]{task.getAccountId(), task.getService().getName(), task.getId()});
    }

    private String getServiceFlag(Task task) {
        return String.format("%s_%s", task.getAccountId(), task.getServiceId());
    }

    private void addTaskQueue(Task task) {
        if (task.getService() == null) {
            task.setService(DataManager.getInstance().findService(task.getAccountId(), task.getServiceId()));
        }
        if (task.getTenant() == null) {
            task.setTenant(DataManager.getInstance().findTenantById(task.getAccountId(), task.getTenantId()));
        }
        PriorityBlockingQueue serviceQueue = this.serviceQueueMap.computeIfAbsent(this.getServiceFlag(task), k -> new PriorityBlockingQueue<Task>(100, new TaskCompare()));
        serviceQueue.put(task);
    }

    public Task next() {
        if (this.serviceList.isEmpty()) {
            return null;
        }
        Task task = null;
        int theIndex = this.currentServiceIndex = this.currentServiceIndex < this.serviceList.size() ? this.currentServiceIndex : 0;
        do {
            String serviceFlag = this.serviceList.get(this.currentServiceIndex);
            String[] serviceData = serviceFlag.split("_");
            String accountId = serviceData[0];
            long serviceId = Long.parseLong(serviceData[1]);
            Service service = DataManager.getInstance().findService(accountId, serviceId);
            if (service != null) {
                task = this.findTask(service, serviceFlag);
                ++this.currentServiceIndex;
            } else {
                log.error("\u6570\u636e\u4e2d\u5fc3{}, \u670d\u52a1{} \u5931\u6548\uff0c\u79fb\u9664\u4efb\u52a1", (Object)accountId, (Object)serviceId);
                this.serviceList.remove(this.currentServiceIndex);
                this.serviceQueueMap.remove(serviceFlag);
            }
            int n = this.currentServiceIndex = this.currentServiceIndex < this.serviceList.size() ? this.currentServiceIndex : 0;
        } while (task == null && this.currentServiceIndex != theIndex);
        if (task != null) {
            log.info("\u627e\u5230\u6570\u636e\u4e2d\u5fc3{},  \u670d\u52a1{}\u7684\u53ef\u6267\u884c\u4efb\u52a1{}\u8fd0\u884c\u5728\u670d\u52a1\u5b9e\u4f8b{}", new Object[]{task.getAccountId(), task.getService().getName(), task.getId(), task.getInstance().getName()});
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task findTask(Service service, String serviceFlag) {
        Task task = null;
        Instance atInstance = null;
        try {
            PriorityBlockingQueue<Task> serviceQueue = this.serviceQueueMap.get(serviceFlag);
            if (serviceQueue != null && !serviceQueue.isEmpty()) {
                log.info("\u670d\u52a1{}\u6709{}\u4e2a\u4efb\u52a1\u7b49\u5f85\u6267\u884c", (Object)service.getName(), (Object)serviceQueue.size());
                atInstance = service.findIdleInstance();
                if (atInstance != null) {
                    task = serviceQueue.poll();
                    while (!(task == null || TaskStatusEnum.CREATE == task.getStatusEnum() && task.lockTask())) {
                        task = serviceQueue.poll();
                    }
                    if (task != null) {
                        task.setInstance(atInstance);
                    }
                }
            } else {
                log.info("\u670d\u52a1{}\u6ca1\u6709\u4efb\u52a1\u7b49\u5f85\u6267\u884c", (Object)service.getName());
            }
        }
        catch (KDBizException exp) {
            log.error(exp.getMessage(), (Throwable)exp);
        }
        finally {
            if (atInstance != null && task == null) {
                atInstance.releaseResource();
            }
        }
        return task;
    }

    public static class TaskCompare
    implements Comparator<Task> {
        @Override
        public int compare(Task task1, Task task2) {
            if (task1.getServiceId() > task2.getServiceId()) {
                return 1;
            }
            if (task1.getServiceId() < task2.getServiceId()) {
                return -1;
            }
            if (task1.getPriority() > task2.getPriority()) {
                return 1;
            }
            if (task1.getPriority() < task2.getPriority()) {
                return -1;
            }
            return task1.getCreateTime().compareTo(task2.getCreateTime());
        }
    }
}

