/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alipay.api.java_websocket.client.WebSocketClient;
import com.alipay.api.java_websocket.handshake.ServerHandshake;
import com.google.common.hash.Hashing;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kd.ai.aicc.core.Constant;
import kd.ai.aicc.core.Executor;
import kd.ai.aicc.core.domain.Instance;
import kd.ai.aicc.core.domain.Task;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class XfWebSocketRunner {
    private static final Log log = LogFactory.getLog(XfWebSocketRunner.class);
    private static final String ERROR_FLAG = "ERROR:";
    private static final int ERROR = 9;
    private static final int CONTINUE = 0;
    private static final int END = 2;
    private static final int MAX_TIME_OUT = 300000;
    BlockingQueue<String> messageQueue = new LinkedBlockingQueue<String>();
    private Executor.TaskRunner taskRunner;
    private int seqNo = 1;
    private final StringBuilder responseTextSb = new StringBuilder();

    public void run(Executor.TaskRunner taskRunner) {
        this.taskRunner = taskRunner;
        Instance atInstance = taskRunner.getAtInstance();
        Task task = taskRunner.getTask();
        try {
            String authUrl = XfWebSocketRunner.getAuthUrl(atInstance.getUrl(), atInstance.getSecretKey(), atInstance.getProxyUserSecretKey());
            XfWebSocketClient webSocketClient = new XfWebSocketClient(this.messageQueue, new URI(authUrl));
            boolean succ = webSocketClient.connectBlocking(10L, TimeUnit.SECONDS);
            log.info("xunfei task id : {} \u8fde\u63a5\u670d\u52a1\u5668 : {} {}", new Object[]{task.getId(), atInstance.getUrl(), succ});
            if (succ) {
                JSONObject requestJson = this.buildRequestBody(task, atInstance);
                webSocketClient.send(requestJson.toString());
                this.onMessage();
            } else {
                ErrorCode errorCode = Constant.connectXfError(atInstance.getUrl());
                taskRunner.execTaskFailed(errorCode.getCode(), errorCode.getMessage());
            }
        }
        catch (Throwable e) {
            log.error(String.format("xunfei task id : %s, error : %s", task.getId(), e.getMessage()), e);
            ErrorCode errorCode = Constant.internalError(e.getMessage());
            taskRunner.execTaskFailed(errorCode.getCode(), errorCode.getMessage());
        }
    }

    public void onMessage() throws InterruptedException {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < 300000L) {
            String text = this.messageQueue.poll(100L, TimeUnit.MILLISECONDS);
            while (text != null) {
                if (text.startsWith(ERROR_FLAG)) {
                    ErrorCode errorCode = Constant.internalError(text.substring(ERROR_FLAG.length()));
                    this.taskRunner.execTaskFailed(errorCode.getCode(), errorCode.getMessage());
                    return;
                }
                int status = this.processMessage(text);
                if (status == 2 || status == 9) {
                    return;
                }
                text = this.messageQueue.poll(100L, TimeUnit.MILLISECONDS);
            }
        }
        if (System.currentTimeMillis() - startTime > 300000L) {
            ErrorCode errorCode = Constant.taskTimeOutError(String.valueOf(this.taskRunner.getTask().getId()));
            this.taskRunner.execTaskFailed(errorCode.getCode(), errorCode.getMessage());
        }
    }

    public int processMessage(String text) {
        try {
            JSONObject responseObj = JSON.parseObject((String)text);
            JSONObject header = responseObj.getJSONObject("header");
            int code = header.getIntValue("code");
            if (code == 0) {
                int status = header.getIntValue("status");
                JSONArray textArr = responseObj.getJSONObject("payload").getJSONObject("choices").getJSONArray("text");
                StringBuilder textSb = new StringBuilder();
                for (int i = 0; i < textArr.size(); ++i) {
                    textSb.append(textArr.getJSONObject(i).getString("content"));
                }
                this.responseTextSb.append((CharSequence)textSb);
                if (this.taskRunner.getTask().isStream()) {
                    this.taskRunner.notifyStream(textSb.toString(), this.seqNo++);
                }
                if (status == 2) {
                    if (this.taskRunner.getTask().isStream()) {
                        this.taskRunner.notifyStreamDone(this.seqNo);
                    }
                    this.taskRunner.execTaskSuccess(this.responseTextSb.toString(), !this.taskRunner.getTask().isStream());
                    JSONObject usageObj = responseObj.getJSONObject("payload").getJSONObject("usage");
                    this.usage(usageObj);
                    return 2;
                }
                return 0;
            }
            this.taskRunner.execTaskFailed(String.valueOf(code), header.getString("message"));
            return 9;
        }
        catch (Exception e) {
            log.error(String.format("xunfei task id : %s ,error : %s", this.taskRunner.getTask().getId(), e.getMessage()), (Throwable)e);
            ErrorCode errorCode = Constant.internalError(e.getMessage());
            this.taskRunner.execTaskFailed(errorCode.getCode(), errorCode.getMessage());
            return 9;
        }
    }

    private void usage(JSONObject usageObj) {
    }

    private JSONObject buildRequestBody(Task task, Instance atInstance) {
        JSONObject requestJson = JSON.parseObject((String)task.getRequestBody());
        JSONObject header = new JSONObject();
        header.put("app_id", (Object)atInstance.getClientId());
        header.put("uid", (Object)String.valueOf(task.getId()));
        requestJson.put("header", (Object)header);
        return requestJson;
    }

    public static String getAuthUrl(String wsUrlStr, String apiKey, String apiSecret) {
        URL url;
        try {
            url = new URL(wsUrlStr.replace("ws://", "http://").replace("wss://", "https://"));
        }
        catch (MalformedURLException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new KDBizException(Constant.internalError(e.getMessage()), new Object[0]);
        }
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        String date = format.format(new Date());
        String preStr = "host: " + url.getHost() + "\ndate: " + date + "\nGET " + url.getPath() + " HTTP/1.1";
        byte[] hexDigits = Hashing.hmacSha256((byte[])apiSecret.getBytes(StandardCharsets.UTF_8)).hashString((CharSequence)preStr, StandardCharsets.UTF_8).asBytes();
        String sha = Base64.getEncoder().encodeToString(hexDigits);
        String authorization = String.format("api_key=\"%s\", algorithm=\"%s\", headers=\"%s\", signature=\"%s\"", apiKey, "hmac-sha256", "host date request-line", sha);
        try {
            return String.format("%s?authorization=%s&date=%s&host=%s", url.toString(), Base64.getEncoder().encodeToString(authorization.getBytes(StandardCharsets.UTF_8)), URLEncoder.encode(date, "UTF-8"), url.getHost()).replace("http://", "ws://").replace("https://", "wss://");
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new KDBizException(Constant.internalError(e.getMessage()), new Object[0]);
        }
    }

    static class XfWebSocketClient
    extends WebSocketClient {
        private static final Log log = LogFactory.getLog(XfWebSocketClient.class);
        BlockingQueue<String> messageQueue;

        public XfWebSocketClient(BlockingQueue<String> messageQueue, URI serverUri) {
            super(serverUri);
            this.messageQueue = messageQueue;
        }

        public void onMessage(String text) {
            boolean b = this.messageQueue.offer(text);
            if (!b) {
                log.warn("offer message: {} error", (Object)text);
            }
        }

        public void onError(Exception e) {
            boolean b = this.messageQueue.offer(XfWebSocketRunner.ERROR_FLAG + e.getMessage());
            if (!b) {
                log.warn("offer error to queue ");
            }
        }

        public void onOpen(ServerHandshake serverHandshake) {
        }

        public void onClose(int code, String status, boolean b) {
        }
    }
}

