/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.core.client;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kd.ai.aicc.core.Constant;
import kd.ai.aicc.core.Dispatcher;
import kd.ai.aicc.core.IClient;
import kd.ai.aicc.core.RequestParameter;
import kd.ai.aicc.core.TaskResult;
import kd.ai.aicc.core.TaskStatusEnum;
import kd.ai.aicc.core.client.SyncTaskLockManager;
import kd.ai.aicc.core.dao.TaskDao;
import kd.ai.aicc.core.domain.Task;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class LocalClient
implements IClient {
    private static final Log log = LogFactory.getLog(LocalClient.class);
    public static final int SYNC_TASK_WAIT_TIMEOUT = 600;

    @Override
    public TaskResult syncService(RequestParameter requestParameter) {
        Dispatcher dispatcher = Dispatcher.getInstance();
        long taskId = this.getTaskId(requestParameter);
        Task task = TaskDao.saveRequestAsTask(taskId, requestParameter, false);
        dispatcher.newSyncTask(task);
        TaskResult taskResult = new TaskResult();
        taskResult.setId(taskId);
        try {
            CountDownLatch latch = SyncTaskLockManager.genTaskLatch(task.getId());
            boolean success = latch.await(600L, TimeUnit.SECONDS);
            if (success) {
                List<TaskResult> resultList = TaskDao.queryTaskResult(new long[]{task.getId()});
                if (resultList.isEmpty()) {
                    ErrorCode errorCode = Constant.taskDataError(task.getId());
                    taskResult.setErrCode(errorCode.getCode());
                    taskResult.setErrMsg(errorCode.getMessage());
                } else {
                    taskResult = resultList.get(0);
                }
            } else {
                task.setStatusEnum(TaskStatusEnum.TIMEOUT);
                TaskDao.updateStatus(task);
                taskResult.setStatus(TaskStatusEnum.TIMEOUT.getValue());
                ErrorCode errorCode = Constant.taskTimeOutError(String.valueOf(task.getId()));
                taskResult.setErrCode(errorCode.getCode());
                taskResult.setErrMsg(errorCode.getMessage());
            }
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
            ErrorCode errorCode = Constant.internalError(e.getMessage());
            taskResult.setErrCode(errorCode.getCode());
            taskResult.setErrMsg(errorCode.getMessage());
        }
        return taskResult;
    }

    private long getTaskId(RequestParameter requestParameter) {
        if (requestParameter.getContext().getTaskId() == 0L) {
            return TaskDao.genTaskID();
        }
        return requestParameter.getContext().getTaskId();
    }

    @Override
    public TaskResult asyncService(RequestParameter requestParameter) {
        Dispatcher dispatcher = Dispatcher.getInstance();
        long taskId = this.getTaskId(requestParameter);
        Task task = TaskDao.saveRequestAsTask(taskId, requestParameter, true);
        dispatcher.newASyncTask(task);
        TaskResult taskResult = new TaskResult();
        taskResult.setId(task.getId());
        taskResult.setErrCode("0");
        return taskResult;
    }
}

