/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.core.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.ai.aicc.core.IClient;
import kd.ai.aicc.core.RequestParameter;
import kd.ai.aicc.core.TaskResult;
import kd.ai.aicc.core.TaskStatusEnum;
import kd.ai.aicc.core.Utils;
import kd.ai.aicc.core.dao.ConfigDao;
import kd.ai.aicc.core.dao.TaskDao;
import kd.ai.aicc.core.domain.Config;
import kd.ai.aicc.core.domain.Task;
import kd.bos.util.StringUtils;

public class RemoteClient
implements IClient {
    public static final String ASYNC_SERVICE = "/kapi/v2/aicc/service/async";
    public static final String SYNC_SERVICE = "/kapi/v2/aicc/service/sync";

    @Override
    public TaskResult syncService(RequestParameter requestParameter) {
        return this.callSerice(requestParameter, false);
    }

    @Override
    public TaskResult asyncService(RequestParameter requestParameter) {
        return this.callSerice(requestParameter, true);
    }

    private TaskResult callSerice(RequestParameter requestParameter, boolean isAsync) {
        String requestBodyStr;
        Config config = ConfigDao.getConfig();
        Map<String, Object> result = Utils.api2PostRequest(config, isAsync ? ASYNC_SERVICE : SYNC_SERVICE, requestBodyStr = JSON.toJSONString((Object)requestParameter));
        if ("0".equals(result.get("errorCode"))) {
            JSONObject jsonObject = (JSONObject)result.get("data");
            TaskResult taskResult = (TaskResult)jsonObject.toJavaObject(TaskResult.class);
            Task task = TaskDao.convert2Task(taskResult.getId(), requestParameter, isAsync);
            if (!isAsync) {
                if (StringUtils.isNotEmpty((String)taskResult.getStatus())) {
                    TaskStatusEnum statusEnum = TaskStatusEnum.parse(taskResult.getStatus());
                    task.setStatusEnum(statusEnum);
                }
                task.setResult(taskResult.getResult());
            }
            TaskDao.saveTask(task);
            return taskResult;
        }
        Task task = TaskDao.convert2Task(TaskDao.genTaskID(), requestParameter, isAsync);
        task.setStatusEnum(TaskStatusEnum.FAILED);
        String code = (String)result.get("errorCode");
        String errMsg = (String)result.get("message");
        task.setErrMsg(String.format("errorcode=%s error message=%s", code, errMsg));
        TaskDao.saveTask(task);
        TaskResult result1 = new TaskResult();
        result1.setId(task.getId());
        result1.setStatus(TaskStatusEnum.FAILED.getValue());
        result1.setErrCode(code);
        result1.setErrMsg(errMsg);
        return result1;
    }
}

