/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.core.dao;

import java.util.ArrayList;
import java.util.List;
import kd.ai.aicc.core.AuthorizationType;
import kd.ai.aicc.core.domain.Instance;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.encrypt.Encrypters;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class InstanceDao {
    public static final String INSTANCE_ENTITY_NAME = "aicc_instance";
    private static final Log log = LogFactory.getLog(InstanceDao.class);

    private InstanceDao() {
    }

    public static List<Instance> queryAllInstance() {
        return InstanceDao.queryInstanceByServiceIdList(null);
    }

    public static List<Instance> queryInstanceByServiceIdList(List<Long> idList) {
        String properties = String.format("%s,%s,%s,%s,%s,%s,%s.id,%s,%s,%s,%s", "name", "maxparallel", "host", "port", "contexturl", "protocol", "service", "authtype", "clientid", "secretkey", "usersecretkey");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter filterStatus = new QFilter("enable", "=", (Object)"1");
        filters.add(filterStatus);
        if (idList != null && !idList.isEmpty()) {
            QFilter filterStatus2 = new QFilter("service", "in", idList);
            filters.add(filterStatus2);
        }
        DynamicObject[] instanceObjs = BusinessDataServiceHelper.load((String)INSTANCE_ENTITY_NAME, (String)properties, (QFilter[])filters.toArray(new QFilter[0]));
        ArrayList<Instance> instanceList = new ArrayList<Instance>(instanceObjs.length);
        for (DynamicObject obj : instanceObjs) {
            String proxyUserSecretKey;
            String secretKey;
            Instance instance = new Instance();
            instance.setId(obj.getLong("id"));
            instance.setName(obj.getString("name"));
            instance.setProtocol(obj.getString("protocol"));
            instance.setHost(obj.getString("host"));
            instance.setPort(obj.getInt("port"));
            instance.setMaxParallel(obj.getInt("maxparallel"));
            instance.setContextUrl(obj.getString("contexturl"));
            instance.setAuthType(AuthorizationType.parse(obj.getString("authtype")));
            String clientId = obj.getString("clientid");
            if (StringUtils.isNotEmpty((String)clientId)) {
                instance.setClientId(Encrypters.decode((String)clientId));
            }
            if (StringUtils.isNotEmpty((String)(secretKey = obj.getString("secretkey")))) {
                instance.setSecretKey(Encrypters.decode((String)secretKey));
            }
            if (StringUtils.isNotEmpty((String)(proxyUserSecretKey = obj.getString("usersecretkey")))) {
                instance.setProxyUserSecretKey(Encrypters.decode((String)proxyUserSecretKey));
            }
            instance.setServiceId(obj.getLong(String.format("%s.id", "service")));
            instanceList.add(instance);
        }
        return instanceList;
    }
}

