/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.core.dao;

import java.util.ArrayList;
import java.util.List;
import kd.ai.aicc.core.dao.InstanceDao;
import kd.ai.aicc.core.domain.Instance;
import kd.ai.aicc.core.domain.Service;
import kd.ai.aicc.core.domain.enuz.ModelType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ServiceDao {
    public static final String SERVICE_ENTITY_NAME = "aicc_service";
    public static final String modelType = "modeltype";

    private ServiceDao() {
    }

    public static List<Service> queryAllServiceAndInstances() {
        String properties = String.format("%s,%s,%s,%s,%s,%s", "id", "number", "name", "requestsample_tag", "responsesample_tag", "supportstream");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter filterStatus = new QFilter("enable", "in", (Object)"1");
        filters.add(filterStatus);
        List<Instance> instances = InstanceDao.queryAllInstance();
        DynamicObject[] serviceObjs = BusinessDataServiceHelper.load((String)SERVICE_ENTITY_NAME, (String)properties, (QFilter[])filters.toArray(new QFilter[0]));
        ArrayList<Service> services = new ArrayList<Service>(serviceObjs.length);
        for (DynamicObject obj : serviceObjs) {
            Service service = new Service();
            service.setId(obj.getLong("id"));
            service.setNumber(obj.getString("number"));
            service.setName(obj.getString("name"));
            service.setSupportStream(obj.getBoolean("supportstream"));
            service.setRequestSample(obj.getString("requestsample_tag"));
            service.setResponseSample(obj.getString("responsesample_tag"));
            services.add(service);
            ArrayList<Instance> serviceInstances = new ArrayList<Instance>();
            for (Instance instance : instances) {
                if (service.getId() != instance.getServiceId()) continue;
                instance.setService(service);
                serviceInstances.add(instance);
            }
            service.setInstances(serviceInstances);
        }
        return services;
    }

    public static List<Service> getLlmList() {
        QFilter[] filters = new QFilter[]{new QFilter("enable", "in", (Object)"1"), new QFilter(modelType, "=", (Object)ModelType.LLM)};
        String properties = String.format("%s,%s,%s,%s,%s,%s,%s,%s", "id", "number", "name", modelType, "llmtype", "requestsample_tag", "responsesample_tag", "supportstream");
        DynamicObject[] serviceObjs = BusinessDataServiceHelper.load((String)SERVICE_ENTITY_NAME, (String)properties, (QFilter[])filters);
        ArrayList<Service> services = new ArrayList<Service>(serviceObjs.length);
        ArrayList<Long> serviceIdList = new ArrayList<Long>();
        for (DynamicObject obj : serviceObjs) {
            serviceIdList.add(obj.getLong("id"));
        }
        List<Instance> instances = InstanceDao.queryInstanceByServiceIdList(serviceIdList);
        for (DynamicObject obj : serviceObjs) {
            Service service = new Service();
            service.setId(obj.getLong("id"));
            service.setNumber(obj.getString("number"));
            service.setName(obj.getString("name"));
            service.setModelType(obj.getString(modelType));
            DynamicObject dynamicObject = (DynamicObject)obj.get("llmtype");
            if (dynamicObject != null) {
                service.setLlmType(dynamicObject.getString("number"));
            }
            service.setSupportStream(obj.getBoolean("supportstream"));
            service.setRequestSample(obj.getString("requestsample_tag"));
            service.setResponseSample(obj.getString("responsesample_tag"));
            services.add(service);
            ArrayList<Instance> serviceInstances = new ArrayList<Instance>();
            for (Instance instance : instances) {
                if (service.getId() != instance.getServiceId()) continue;
                instance.setService(service);
                serviceInstances.add(instance);
            }
            service.setInstances(serviceInstances);
        }
        return services;
    }

    public static List<Service> getEmbeddingList() {
        return null;
    }
}

