/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.core.dao;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.ai.aicc.core.Constant;
import kd.ai.aicc.core.DataManager;
import kd.ai.aicc.core.DeployMethod;
import kd.ai.aicc.core.RequestParameter;
import kd.ai.aicc.core.TaskResult;
import kd.ai.aicc.core.TaskStatusEnum;
import kd.ai.aicc.core.Utils;
import kd.ai.aicc.core.dao.TenantDao;
import kd.ai.aicc.core.domain.Task;
import kd.ai.aicc.core.domain.Tenant;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class TaskDao {
    public static final int TOP_TASK_COUNT = 500;
    public static final String TASK_ENTITY_NAME = "aicc_task";
    public static final String TASK_TABLE_NAME = "t_aicc_task";
    public static final String TASK_HISTORY_ENTITY_NAME = "aicc_task_history";

    private TaskDao() {
    }

    public static long genTaskID() {
        return DB.genLongId((String)TASK_TABLE_NAME);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Task saveRequestAsTask(long taskId, RequestParameter parameter, boolean isAsync) {
        Task task = TaskDao.convert2Task(taskId, parameter, isAsync);
        String accountId = RequestContext.get().getAccountId();
        task.setAccountId(accountId);
        Tenant tenant = DataManager.getInstance().findTenantByCqTenantIdAndProdInstId(accountId, parameter.getTenantId(), parameter.getProdInstCode());
        if (tenant == null) {
            DeployMethod deployMethod = Utils.checkLicenseType();
            if (DeployMethod.PUBLIC_CLOUND_CLIENT != deployMethod && DeployMethod.PRIVATE_CLOUND != deployMethod) throw new KDBizException(Constant.tenantNotExistError(parameter.getTenantId(), parameter.getProdInstCode()), new Object[0]);
            tenant = TenantDao.findTenantById(900000001L);
            if (tenant == null) throw new KDBizException(Constant.tenantNotExistError(parameter.getTenantId(), parameter.getProdInstCode()), new Object[0]);
            tenant.setCqTenantId(Utils.getTenantID());
            tenant.setProdInstId(Utils.getProdInstCode());
            TenantDao.updatePrivateTenant(tenant);
            DataManager.getInstance().tenantDataChanged(accountId);
        }
        task.setTenant(tenant);
        task.setService(DataManager.getInstance().findServiceByNumber(accountId, parameter.getServiceNumber()));
        TaskDao.saveTask(task);
        return task;
    }

    public static Task convert2Task(long taskId, RequestParameter parameter, boolean isAsync) {
        Task task = new Task();
        task.setId(taskId);
        if (parameter.getContext() != null && parameter.getContext().isEncrypt()) {
            task.setRequestBody(Encrypters.encode((String)parameter.getServiceParams()));
        } else {
            task.setRequestBody(parameter.getServiceParams());
        }
        if (parameter.getContext() != null) {
            task.setPriority(parameter.getContext().getPriority());
        } else {
            task.setPriority(1);
        }
        if (isAsync && parameter.getContext() != null) {
            task.setStream(parameter.getContext().isStream());
        }
        task.setAsyncTask(isAsync);
        task.setStatusEnum(TaskStatusEnum.CREATE);
        Date createTime = new Date();
        task.setCreateTime(createTime);
        task.setLastUpdateTime(createTime);
        return task;
    }

    public static void saveTask(Task task) {
        if (QueryServiceHelper.exists((String)TASK_ENTITY_NAME, (Object)task.getId())) {
            return;
        }
        DynamicObject taskObj = BusinessDataServiceHelper.newDynamicObject((String)TASK_ENTITY_NAME);
        taskObj.set("id", (Object)task.getId());
        taskObj.set("createtime", (Object)task.getCreateTime());
        taskObj.set("lastupdatetime", (Object)task.getLastUpdateTime());
        taskObj.set("status", (Object)task.getStatusEnum().getValue());
        taskObj.set("isasync", (Object)task.isAsyncTask());
        taskObj.set("isstream", (Object)task.isStream());
        taskObj.set("requestbody_tag", (Object)task.getRequestBody());
        taskObj.set("priority", (Object)task.getPriority());
        if (StringUtils.isNotEmpty((String)task.getErrCode())) {
            taskObj.set("errcode", (Object)task.getErrCode());
        }
        if (StringUtils.isNotEmpty((String)task.getErrMsg())) {
            if (task.getErrMsg().length() > 1024) {
                taskObj.set("errmsg", (Object)task.getErrMsg().substring(0, 1024));
            } else {
                taskObj.set("errmsg", (Object)task.getErrMsg());
            }
        }
        if (StringUtils.isNotEmpty((String)task.getResult())) {
            taskObj.set("result_tag", (Object)task.getResult());
        }
        if (task.getService() != null) {
            taskObj.set("service", (Object)task.getService().getId());
        }
        if (task.getTenant() != null) {
            taskObj.set("tenant", (Object)task.getTenant().getId());
        }
        if (task.getInstance() != null) {
            taskObj.set("instance", (Object)task.getInstance().getId());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskObj});
    }

    public static void updateStatus(Task task) {
        task.setLastUpdateTime(new Date());
        DynamicObject taskObj = BusinessDataServiceHelper.newDynamicObject((String)TASK_ENTITY_NAME);
        taskObj.set("id", (Object)task.getId());
        taskObj.set("lastupdatetime", (Object)task.getLastUpdateTime());
        taskObj.set("status", (Object)task.getStatusEnum().getValue());
        if (task.getStatusEnum() == TaskStatusEnum.RUNNING && task.getInstance() != null) {
            taskObj.set("instance", (Object)task.getInstance().getId());
        }
        if (StringUtils.isNotEmpty((String)task.getResult())) {
            taskObj.set("result_tag", (Object)task.getResult());
        }
        if (StringUtils.isNotEmpty((String)task.getErrCode())) {
            taskObj.set("errcode", (Object)task.getErrCode());
        }
        if (StringUtils.isNotEmpty((String)task.getErrMsg())) {
            if (task.getErrMsg().length() > 1024) {
                taskObj.set("errmsg", (Object)task.getErrMsg().substring(0, 1024));
            } else {
                taskObj.set("errmsg", (Object)task.getErrMsg());
            }
        }
        SaveServiceHelper.update((DynamicObject)taskObj);
        TaskDao.saveStatusHistory(task);
    }

    public static void updateStreamFlag(Task task) {
        DynamicObject taskObj = BusinessDataServiceHelper.newDynamicObject((String)TASK_ENTITY_NAME);
        taskObj.set("id", (Object)task.getId());
        taskObj.set("isstream", (Object)task.isStream());
        SaveServiceHelper.update((DynamicObject)taskObj);
    }

    private static void saveStatusHistory(Task task) {
        DynamicObject statusHistoryObj = BusinessDataServiceHelper.newDynamicObject((String)TASK_HISTORY_ENTITY_NAME);
        statusHistoryObj.set("task", (Object)task.getId());
        statusHistoryObj.set("lastupdatetime", (Object)task.getLastUpdateTime());
        statusHistoryObj.set("status", (Object)task.getStatusEnum().getValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{statusHistoryObj});
    }

    public static void queryRequestParameters(Task task) {
        if (task.getRequestBody() == null) {
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)task.getId(), (String)TASK_ENTITY_NAME, (String)String.format("%s,%s", "id", "requestbody_tag"));
            task.setRequestBody(obj.getString("requestbody_tag"));
        }
    }

    public static List<Task> queryTaskForExecute(Date fromTime) {
        String properties = String.format("%s,%s,%s,%s.id,%s.id,%s", "status", "priority", "isstream", "service", "tenant", "createtime");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        String[] status = new String[]{TaskStatusEnum.CREATE.getValue()};
        QFilter filterStatus = new QFilter("status", "in", (Object)status);
        filters.add(filterStatus);
        QFilter filterTime = new QFilter("createtime", ">=", (Object)fromTime);
        filters.add(filterTime);
        QFilter filterAsync = new QFilter("isasync", "=", (Object)"1");
        filters.add(filterAsync);
        String orderBy = String.format("%s", "createtime");
        DynamicObject[] taskCol = BusinessDataServiceHelper.load((String)TASK_ENTITY_NAME, (String)properties, (QFilter[])filters.toArray(new QFilter[0]), (String)orderBy, (int)500);
        ArrayList<Task> tasks = new ArrayList<Task>(taskCol.length);
        for (DynamicObject taskObj : taskCol) {
            Task task = new Task();
            task.setId(taskObj.getLong("id"));
            task.setPriority(taskObj.getInt("priority"));
            task.setCreateTime(taskObj.getDate("createtime"));
            task.setStatusEnum(TaskStatusEnum.parse(taskObj.getString("status")));
            task.setServiceId(taskObj.getLong(String.format("%s.id", "service")));
            task.setTenantId(taskObj.getLong(String.format("%s.id", "tenant")));
            task.setAsyncTask(true);
            task.setStream(taskObj.getBoolean("isstream"));
            tasks.add(task);
        }
        return tasks;
    }

    public static List<Task> queryRunningTasks(Date fromTime) {
        String properties = String.format("%s,%s.id,%s.id", "id", "instance", "tenant");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        String[] status = new String[]{TaskStatusEnum.RUNNING.getValue()};
        QFilter filterStatus = new QFilter("status", "in", (Object)status);
        filters.add(filterStatus);
        QFilter filterTime = new QFilter("createtime", ">=", (Object)fromTime);
        filters.add(filterTime);
        DynamicObject[] taskCol = BusinessDataServiceHelper.load((String)TASK_ENTITY_NAME, (String)properties, (QFilter[])filters.toArray(new QFilter[0]));
        ArrayList<Task> tasks = new ArrayList<Task>(taskCol.length);
        for (DynamicObject taskObj : taskCol) {
            Task task = new Task();
            task.setId(taskObj.getLong("id"));
            task.setInstanceId(taskObj.getLong(String.format("%s.id", "instance")));
            task.setTenantId(taskObj.getLong(String.format("%s.id", "tenant")));
            tasks.add(task);
        }
        return tasks;
    }

    public static String[] queryTaskStatus(String[] taskIdStrList) {
        String properties = String.format("%s,%s", "id", "status");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        long[] taskIdArray = TaskDao.convertIdType(taskIdStrList);
        QFilter filterStatus = new QFilter("id", "in", (Object)taskIdArray);
        filters.add(filterStatus);
        DynamicObject[] taskCol = BusinessDataServiceHelper.load((String)TASK_ENTITY_NAME, (String)properties, (QFilter[])filters.toArray(new QFilter[0]));
        String[] taskStatus = new String[taskIdArray.length];
        block0: for (DynamicObject taskObj : taskCol) {
            long id = taskObj.getLong("id");
            String status = taskObj.getString("status");
            for (int i = 0; i < taskIdArray.length; ++i) {
                if (taskIdArray[i] != id) continue;
                taskStatus[i] = status;
                continue block0;
            }
        }
        for (int i = 0; i < taskStatus.length; ++i) {
            if (taskStatus[i] != null) continue;
            taskStatus[i] = "NOTEXIST";
        }
        return taskStatus;
    }

    public static long[] queryRunningAsyncTasks() {
        String properties = String.format("%s", "id");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        String[] status = new String[]{TaskStatusEnum.CREATE.getValue(), TaskStatusEnum.RUNNING.getValue()};
        QFilter filterStatus = new QFilter("status", "in", (Object)status);
        filters.add(filterStatus);
        QFilter filterAsync = new QFilter("isasync", "=", (Object)Boolean.TRUE);
        filters.add(filterAsync);
        DynamicObject[] taskCol = BusinessDataServiceHelper.load((String)TASK_ENTITY_NAME, (String)properties, (QFilter[])filters.toArray(new QFilter[0]));
        long[] taskIdArray = new long[taskCol.length];
        int i = 0;
        for (DynamicObject taskObj : taskCol) {
            taskIdArray[i++] = taskObj.getLong("id");
        }
        return taskIdArray;
    }

    public static List<TaskResult> queryTaskResult(long[] taskIdList) {
        String properties = String.format("%s,%s,%s,%s,%s", "id", "result_tag", "status", "errcode", "errmsg");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter filterStatus = new QFilter("id", "in", (Object)taskIdList);
        filters.add(filterStatus);
        DynamicObject[] taskCol = BusinessDataServiceHelper.load((String)TASK_ENTITY_NAME, (String)properties, (QFilter[])filters.toArray(new QFilter[0]));
        ArrayList<TaskResult> results = new ArrayList<TaskResult>(taskCol.length);
        for (DynamicObject taskObj : taskCol) {
            TaskResult taskResult = new TaskResult();
            taskResult.setId(taskObj.getLong("id"));
            taskResult.setStatus(taskObj.getString("status"));
            taskResult.setResult(taskObj.getString("result_tag"));
            taskResult.setErrCode(taskObj.getString("errcode"));
            taskResult.setErrMsg(taskObj.getString("errmsg"));
            results.add(taskResult);
        }
        return results;
    }

    public static long[] convertIdType(String[] taskIdStrList) {
        long[] taskIdLongList = new long[taskIdStrList.length];
        for (int i = 0; i < taskIdStrList.length; ++i) {
            taskIdLongList[i] = Long.parseLong(taskIdStrList[i]);
        }
        return taskIdLongList;
    }

    public static void updateTaskResult(TaskResult taskResult) {
        DynamicObject taskObj = BusinessDataServiceHelper.newDynamicObject((String)TASK_ENTITY_NAME);
        taskObj.set("id", (Object)taskResult.getId());
        taskObj.set("lastupdatetime", (Object)new Date());
        taskObj.set("status", (Object)taskResult.getStatus());
        if (StringUtils.isNotEmpty((String)taskResult.getErrCode())) {
            taskObj.set("result_tag", (Object)taskResult.getErrCode());
        }
        if (StringUtils.isNotEmpty((String)taskResult.getResult())) {
            taskObj.set("result_tag", (Object)taskResult.getResult());
        }
        if (StringUtils.isNotEmpty((String)taskResult.getErrMsg())) {
            taskObj.set("errmsg", (Object)taskResult.getErrMsg());
        }
        SaveServiceHelper.update((DynamicObject)taskObj);
    }

    public static boolean isStreamTask(long taskId) {
        String properties = String.format("%s,%s", "id", "isstream");
        try {
            DynamicObject taskObj = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)TASK_ENTITY_NAME, (String)properties);
            return taskObj != null && taskObj.getBoolean("isstream");
        }
        catch (KDException e) {
            return false;
        }
    }

    public static Task queryTaskStatus(long taskId) {
        String properties = String.format("%s,%s,%s", "id", "status", "createtime");
        DynamicObject taskObj = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)TASK_ENTITY_NAME, (String)properties);
        Task task = new Task();
        task.setId(taskId);
        task.setStatusEnum(TaskStatusEnum.parse(taskObj.getString("status")));
        task.setCreateTime(taskObj.getDate("createtime"));
        return task;
    }
}

