/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.core.dao;

import java.util.ArrayList;
import java.util.List;
import kd.ai.aicc.core.domain.Tenant;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class TenantDao {
    public static final String TENANT_ENTITY_NAME = "aicc_tenant";

    private TenantDao() {
    }

    public static Tenant findTenantByCqTenantIdAndProdInstId(String cqTenatId, String prodInstId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("cqtenantid", "=", (Object)cqTenatId));
        filters.add(new QFilter("prodinstid", "=", (Object)prodInstId));
        return TenantDao.findByFilter(filters);
    }

    public static void updatePrivateTenant(Tenant tenant) {
        DynamicObject tenantObj = BusinessDataServiceHelper.newDynamicObject((String)TENANT_ENTITY_NAME);
        tenantObj.set("id", (Object)tenant.getId());
        tenantObj.set("cqtenantid", (Object)tenant.getCqTenantId());
        tenantObj.set("prodinstid", (Object)tenant.getProdInstId());
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{tenantObj});
    }

    public static Tenant findTenantById(long tenantId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("id", "=", (Object)tenantId));
        return TenantDao.findByFilter(filters);
    }

    public static Tenant findByFilter(List<QFilter> filters) {
        String properties = String.format("%s,%s,%s,%s,%s", "id", "name", "cqtenantid", "prodinstid", "buyqps");
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)TENANT_ENTITY_NAME, (String)properties, (QFilter[])filters.toArray(new QFilter[0]));
        if (obj == null) {
            return null;
        }
        Tenant tenant = new Tenant();
        tenant.setId(obj.getLong("id"));
        tenant.setName(obj.getString("name"));
        tenant.setBuyQPS(obj.getInt("buyqps"));
        tenant.setCqTenantId(obj.getString("cqtenantid"));
        tenant.setProdInstId(obj.getString("prodinstid"));
        return tenant;
    }

    public static List<Tenant> queryAllTenant() {
        String properties = String.format("%s,%s,%s,%s,%s", "id", "name", "cqtenantid", "prodinstid", "buyqps");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter filterStatus = new QFilter("enable", "=", (Object)"1");
        filters.add(filterStatus);
        DynamicObject[] tenentObjs = BusinessDataServiceHelper.load((String)TENANT_ENTITY_NAME, (String)properties, (QFilter[])filters.toArray(new QFilter[0]));
        ArrayList<Tenant> tenants = new ArrayList<Tenant>(tenentObjs.length);
        for (DynamicObject obj : tenentObjs) {
            Tenant tenant = new Tenant();
            tenant.setId(obj.getLong("id"));
            tenant.setName(obj.getString("name"));
            tenant.setBuyQPS(obj.getInt("buyqps"));
            tenant.setCqTenantId(obj.getString("cqtenantid"));
            tenant.setProdInstId(obj.getString("prodinstid"));
            tenants.add(tenant);
        }
        return tenants;
    }
}

