/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.core.domain;

import java.net.URI;
import java.util.Locale;
import kd.ai.aicc.core.AuthorizationType;
import kd.ai.aicc.core.CacheHelper;
import kd.ai.aicc.core.DistributeCounter;
import kd.ai.aicc.core.domain.Service;

public class Instance {
    private Service service;
    private long serviceId;
    private long id;
    private String name;
    private int maxParallel;
    private String host;
    private int port;
    private String contextUrl;
    private String protocol = "http";
    private AuthorizationType authType;
    private String clientId;
    private String secretKey;
    private String proxyUserSecretKey;

    public long getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(long serviceId) {
        this.serviceId = serviceId;
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getMaxParallel() {
        return this.maxParallel;
    }

    public void setMaxParallel(int maxParallel) {
        this.maxParallel = maxParallel;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getContextUrl() {
        return this.contextUrl;
    }

    public void setContextUrl(String contextUrl) {
        this.contextUrl = contextUrl;
    }

    public URI getURI() {
        return URI.create(this.getUrl());
    }

    public String getUrl() {
        return String.format("%s://%s:%s%s", this.getProtocol().toLowerCase(Locale.ENGLISH), this.getHost(), this.getPort(), this.getContextUrl());
    }

    public AuthorizationType getAuthType() {
        return this.authType;
    }

    public void setAuthType(AuthorizationType authType) {
        this.authType = authType;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getProxyUserSecretKey() {
        return this.proxyUserSecretKey;
    }

    public void setProxyUserSecretKey(String proxyUserSecretKey) {
        this.proxyUserSecretKey = proxyUserSecretKey;
    }

    public int taskCount() {
        int runningCount = 0;
        String lastSecKey = this.buildRunningTaskLastSecKey();
        String taskCountKey = this.buildRunningTaskCountKey();
        String valStr = CacheHelper.getString(lastSecKey);
        if (valStr == null) {
            this.reCycle();
        } else {
            long lastSec = Long.parseLong(valStr);
            if (System.currentTimeMillis() - lastSec <= 1000L) {
                runningCount = CacheHelper.getInt(taskCountKey);
            } else {
                this.reCycle();
            }
        }
        return runningCount;
    }

    private void reCycle() {
        long lastSec = System.currentTimeMillis();
        CacheHelper.putString(this.buildRunningTaskLastSecKey(), String.valueOf(lastSec));
        CacheHelper.putInt(this.buildRunningTaskCountKey(), 0);
    }

    public int idleCount() {
        return Math.max(0, this.maxParallel - this.taskCount());
    }

    public int requestResource() {
        this.taskCount();
        return DistributeCounter.addOne(this.buildRunningTaskCountKey());
    }

    public void releaseResource() {
    }

    private String buildRunningTaskCountKey() {
        return "I_R_TC_" + this.getId();
    }

    private String buildRunningTaskLastSecKey() {
        return "I_R_LS_" + this.getId();
    }
}

