/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.core.domain;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import kd.ai.aicc.core.domain.Instance;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class Service {
    private static final Log log = LogFactory.getLog(Service.class);
    private long id;
    private String number;
    private String name;
    private boolean supportStream;
    private String requestSample;
    private String responseSample;
    private List<Instance> instances;
    private String modelType;
    private String llmType;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isSupportStream() {
        return this.supportStream;
    }

    public void setSupportStream(boolean supportStream) {
        this.supportStream = supportStream;
    }

    public String getRequestSample() {
        return this.requestSample;
    }

    public void setRequestSample(String requestSample) {
        this.requestSample = requestSample;
    }

    public String getResponseSample() {
        return this.responseSample;
    }

    public void setResponseSample(String responseSample) {
        this.responseSample = responseSample;
    }

    public List<Instance> getInstances() {
        return this.instances;
    }

    public void setInstances(List<Instance> instances) {
        this.instances = instances;
    }

    public String getModelType() {
        return this.modelType;
    }

    public void setModelType(String modelType) {
        this.modelType = modelType;
    }

    public String getLlmType() {
        return this.llmType;
    }

    public void setLlmType(String llmType) {
        this.llmType = llmType;
    }

    public Instance findIdleInstance() {
        if (this.instances == null || this.instances.isEmpty()) {
            log.warn("service " + this.name + " \u6ca1\u6709\u90e8\u7f72\u5b9e\u4f8b");
            return null;
        }
        for (Instance instance : this.loadBalance(this.instances)) {
            try {
                if (instance.idleCount() > 0) {
                    int runningTaskCount = instance.requestResource();
                    if (runningTaskCount <= instance.getMaxParallel()) {
                        log.info("\u5b9e\u4f8b{}\u53ef\u7528\uff0c\u5f53\u524d\u8fd0\u884c\u4efb\u52a1\u6570{}", (Object)instance.getName(), (Object)runningTaskCount);
                        return instance;
                    }
                    instance.releaseResource();
                    log.info("\u5b9e\u4f8b{}\u7e41\u5fd91\uff0c\u5f53\u524d\u8fd0\u884c\u4efb\u52a1\u6570{}", (Object)instance.getName(), (Object)instance.taskCount());
                    continue;
                }
                log.info("\u5b9e\u4f8b{}\u7e41\u5fd92\uff0c\u5f53\u524d\u8fd0\u884c\u4efb\u52a1\u6570{}", (Object)instance.getName(), (Object)instance.taskCount());
            }
            catch (KDBizException e) {
                log.error((Throwable)e);
            }
        }
        log.warn("\u670d\u52a1{}\u6240\u6709\u5b9e\u4f8b\u7e41\u5fd9", (Object)this.getName());
        return null;
    }

    public List<Instance> loadBalance(List<Instance> instanceList) {
        if (instanceList.isEmpty() || instanceList.size() == 1) {
            return instanceList;
        }
        Instance[] instances1 = instanceList.toArray(new Instance[0]);
        Arrays.sort(instances1, Comparator.comparingInt(Instance::idleCount));
        List<Instance> orderList = Arrays.asList(instances1);
        Collections.reverse(orderList);
        return orderList;
    }
}

