/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.core.service;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.util.DynamicObjectUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class AiccService {
    private static Log logger = LogFactory.getLog(AiccService.class);

    public static List<Map<String, Object>> queryInstance(String groupNumber, String serviceNumber, String instanceNumber) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("enable", "=", (Object)"1"));
        filters.add(new QFilter("status", "=", (Object)"C"));
        if (StringUtils.isNotEmpty((String)groupNumber)) {
            logger.info("groupNumber" + groupNumber);
            filters.add(new QFilter("service.group.number", "=", (Object)groupNumber));
        }
        if (StringUtils.isNotEmpty((String)serviceNumber)) {
            logger.info("serviceNumber" + serviceNumber);
            filters.add(new QFilter("service.number", "=", (Object)serviceNumber));
        }
        if (StringUtils.isNotEmpty((String)instanceNumber)) {
            logger.info("instanceNumber" + instanceNumber);
            filters.add(new QFilter("number", "=", (Object)instanceNumber));
        }
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"aicc_instance", (String)"id,number,name,service.name,service.number,status,enable,maxparallel,authtype,usersecretkey,clientid,secretkey,protocol,contexturl,host,port", (QFilter[])filters.toArray(new QFilter[filters.size()]), (String)"createtime desc");
        List tenants = DynamicObjectUtil.serializeToMap((DynamicObject[])((DynamicObject[])objs.toArray((Object[])new DynamicObject[objs.size()])), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"aicc_instance"));
        return tenants;
    }

    public static List<Map<String, Object>> queryLlmAiccServiceList() {
        ArrayList filters = new ArrayList();
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"aicc_service", (String)"id,number,name,createtime,supportstream,enable,group,requestsample,requestsample_tag,llmtype,responsesample,responsesample_tag,version,desc,status", (QFilter[])filters.toArray(new QFilter[filters.size()]), (String)"createtime desc");
        List tenants = DynamicObjectUtil.serializeToMap((DynamicObject[])((DynamicObject[])objs.toArray((Object[])new DynamicObject[objs.size()])), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"aicc_service"));
        for (Map tenant : tenants) {
            List<Map<String, Object>> instances;
            tenant.put("hasInstance", false);
            String serviceNumber = tenant.getOrDefault("number", "").toString();
            if (!StringUtils.isNotEmpty((String)serviceNumber) || !CollectionUtils.isNotEmpty(instances = AiccService.queryInstance(null, serviceNumber, null))) continue;
            tenant.put("hasInstance", true);
        }
        return tenants;
    }

    public static Map<String, Object> queryLlmAiccService(String serviceNumber) {
        DynamicObject obj;
        Long llmtype;
        List<Map<String, Object>> instances;
        if (StringUtils.isEmpty((String)serviceNumber)) {
            logger.warn("queryLlmAiccService without serviceNumber");
            return Maps.newHashMap();
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("number", "=", (Object)serviceNumber));
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"aicc_service", (String)"id,number,name,createtime,supportstream,enable,group,requestsample,requestsample_tag,responsesample,responsesample_tag,version,llmtype,desc,status", (QFilter[])filters.toArray(new QFilter[filters.size()]), (String)"createtime desc");
        List services = DynamicObjectUtil.serializeToMap((DynamicObject[])((DynamicObject[])objs.toArray((Object[])new DynamicObject[objs.size()])), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"aicc_service"));
        if (CollectionUtils.isEmpty((Collection)services)) {
            return Maps.newHashMap();
        }
        if (services.size() > 1) {
            logger.warn("queryLlmAiccService with serviceNumber\uff1a{},has more than one result", (Object)serviceNumber);
        }
        Map service = (Map)services.get(0);
        service.put("hasInstance", false);
        if (StringUtils.isNotEmpty((String)serviceNumber) && CollectionUtils.isNotEmpty(instances = AiccService.queryInstance(null, serviceNumber, null))) {
            service.put("hasInstance", true);
        }
        if ((llmtype = (Long)service.get("llmtype")) != null && !llmtype.equals(0L) && (obj = BusinessDataServiceHelper.loadSingle((Object)llmtype, (String)"aicc_llm")) != null) {
            String llmNumber = (String)obj.get("number");
            service.put("llm", llmNumber);
        }
        return service;
    }
}

