/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.plugin;

import java.lang.constant.Constable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.ai.aicc.plugin.common.DateUtil;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class AiccHomeServiceRankCardPlugin
extends AbstractFormPlugin
implements ListboxClickListener {
    private static final Log log = LogFactory.getLog(AiccHomeServiceRankCardPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"histogramchartap"});
        this.addClickListeners(new String[]{"refresh"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        try {
            Map<String, Double> map = this.getDataFromDB();
            this.rebuildchart(map);
        }
        catch (ParseException var3) {
            log.error("parse error:", (Object)e);
        }
    }

    public void listboxClick(ListboxEvent arg) {
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (control.getKey().equals("refresh")) {
            try {
                Map<String, Double> mapForChart = this.getDataFromDB();
                this.rebuildchart(mapForChart);
            }
            catch (ParseException var4) {
                log.error("parse error:", (Throwable)var4);
            }
        }
    }

    private Map<String, Double> getDataFromDB() throws ParseException {
        QFilter[] qFilter = new QFilter[]{new QFilter("createtime", ">=", (Object)DateUtil.getYearFirstDay())};
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"aicc_task_ranking", (String)"aicc_task", (String)"service.name,service.id", (QFilter[])qFilter, null);
        DataSet dataSet2 = dataSet.groupBy(new String[]{"service.name"}).count("count").finish();
        DataSet dataSet3 = dataSet2.orderBy(new String[]{"count asc"}).top(10);
        LinkedHashMap<String, Double> map = new LinkedHashMap<String, Double>();
        for (Row obj : dataSet3) {
            map.put(obj.getString("service.name"), obj.getDouble("count"));
        }
        return map;
    }

    private void rebuildchart(Map<String, Double> map) {
        HistogramChart customchart = (HistogramChart)this.getControl("histogramchartap");
        customchart.clearData();
        this.setHandlechartXaxisTick(customchart, map);
        this.setHandleChartData(customchart, map);
        customchart.setMargin(Position.right, "100px");
        customchart.setMargin(Position.top, "30px");
        customchart.setLegendPropValue("itemWidth", (Object)10);
        customchart.setLegendPropValue("itemHeight", (Object)10);
    }

    private Axis setHandlechartXaxisTick(HistogramChart customchart, Map<String, Double> logMap) {
        Axis xAxis = customchart.createXAxis("(API)", AxisType.category);
        ArrayList<String> xDimensions = new ArrayList<String>();
        Set<String> apiNames = logMap.keySet();
        xDimensions.addAll(apiNames);
        xAxis.setCategorys(xDimensions);
        xAxis.setPosition(Position.bottom);
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.FALSE);
        HashMap<String, Integer> axisLabel = new HashMap<String, Integer>();
        axisLabel.put("interval", 0);
        axisLabel.put("rotate", -40);
        xAxis.setPropValue("axisTick", axisTick);
        xAxis.setPropValue("axisLabel", axisLabel);
        this.setLineColor(xAxis, "#999999");
        return xAxis;
    }

    private void setHandleChartData(HistogramChart customchart, Map<String, Double> logMap) {
        Axis yAxis = customchart.createYAxis(ResManager.loadKDString((String)"(\u6b21)", (String)"AiccHomeServiceRankCardPlugin_0", (String)"ai-aicc-plugin", (Object[])new Object[0]), AxisType.value);
        yAxis.setPropValue("nameGap", (Object)"5");
        HashMap<String, Object> map = new HashMap<String, Object>();
        int[] padding = new int[]{0, 0, 5, 5};
        map.put("padding", padding);
        yAxis.setPropValue("nameTextStyle", map);
        BarSeries expireSeries = customchart.createBarSeries(ResManager.loadKDString((String)"\u8c03\u7528\u6b21\u6570", (String)"AiccHomeServiceRankCardPlugin_1", (String)"ai-aicc-plugin", (Object[])new Object[0]));
        expireSeries.setBarWidth("20px");
        expireSeries.setAnimationDuration(5);
        expireSeries.setData((Number[])logMap.values().toArray(new Double[logMap.size()]));
        map = new HashMap();
        HashMap<String, HashMap<String, Object>> normap = new HashMap<String, HashMap<String, Object>>();
        map.put("color", "new echarts.graphic.LinearGradient(0, 0, 0, 1, [{\"offset\": 0,\"color\": '#02A7F0'}, {\"offset\": 1, \"color\": '#02A7F0'}])");
        normap.put("normal", map);
        expireSeries.setPropValue("itemStyle", normap);
        ArrayList<String> list = new ArrayList<String>();
        list.add("itemStyle");
        list.add("normal");
        list.add("color");
        expireSeries.addFuncPath(list);
        expireSeries.setLabel(null);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", Boolean.FALSE);
        yAxis.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        yAxis.setPropValue("splitLine", splitLine);
        this.setLineColor(yAxis, "#999999");
        customchart.setShowLegend(true);
        customchart.setLegendAlign(XAlign.right, YAlign.top);
        customchart.setShowTooltip(true);
        customchart.bindData(null);
    }

    private void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }
}

