/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.plugin;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.ai.aicc.core.Utils;
import kd.ai.aicc.core.domain.Config;
import kd.ai.aicc.plugin.common.AiccServiceDataHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.tenant.TenantInfo;

public class AiccInitializeOpPlugin
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(AiccInitializeOpPlugin.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("publiccloudserverurl");
        e.getFieldKeys().add("secretkey");
        e.getFieldKeys().add("usersecretkey");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>();
        OperateOption operateOption = this.getOption();
        for (DynamicObject obj : e.getDataEntities()) {
            Config config = new Config();
            config.setPublicCloudServerUrl(obj.get("publiccloudserverurl").toString());
            config.setSecretKey(obj.get("secretkey").toString());
            config.setProxyUserSecretKey(obj.get("usersecretkey").toString());
            String url = "/kapi/v2/aicc/initializePublicAiccService";
            HashMap<String, String> body = new HashMap<String, String>();
            body.put("tenatId", Utils.getTenantID());
            body.put("prodInstCode", Utils.getProdInstCode());
            body.put("tenatType", "public");
            TenantInfo tenantInfo = RequestContext.get().getTenantInfo();
            body.put("tenatName", tenantInfo.getName());
            body.put("tenatCode", tenantInfo.getId());
            String requestBodyStr = JSON.toJSONString(body);
            Map result = Utils.api2PostRequest((Config)config, (String)url, (String)requestBodyStr);
            if ("0".equals(result.get("errorCode"))) {
                logger.info("\u521d\u59cb\u5316\u8c03\u7528\u6210\u529f\uff0c\u66f4\u65b0\u7b97\u6cd5\u670d\u52a1\u5217\u8868\u4fe1\u606f\u3002");
                Map data = (Map)result.get("data");
                operateOption.setVariableValue("tenantId", data.get("tenantId").toString());
                AiccServiceDataHelper.SaveAiccService(result);
                successObjs.add(obj);
                continue;
            }
            this.operationResult.addErrorInfo((OperateErrorInfo)new ValidationErrorInfo("", obj.getPkValue(), 0, 0, result.get("errorCode").toString(), "", result.get("message").toString(), ErrorLevel.Error));
        }
        e.setDataEntities(successObjs.toArray(new DynamicObject[successObjs.size()]));
    }
}

