/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.ai.aicc.core.DataManager;
import kd.ai.aicc.core.domain.enuz.ModelType;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Audit;
import kd.bos.entity.operate.UnAudit;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;

public class ServiceEditPlugin
extends AbstractFormPlugin {
    private static String modelTypeControl = "modeltype";
    private static String llmTypeControl = "llmtype";

    public void afterBindData(EventObject e) {
        ComboEdit modelTypeCombo = (ComboEdit)this.getView().getControl(modelTypeControl);
        if (modelTypeCombo != null) {
            modelTypeCombo.setComboItems(ServiceEditPlugin.createModelTypeComboItem());
        }
    }

    public static List<ComboItem> createModelTypeComboItem() {
        ModelType[] modelTypes = ModelType.values();
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(modelTypes.length);
        int i = 0;
        for (ModelType modelType : modelTypes) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(modelType.getName()));
            comboItem.setValue(modelType.getValue());
            comboItem.setId(i + "");
            list.add(comboItem);
            ++i;
        }
        return list;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getProperty().getName().equals(modelTypeControl)) {
            this.getView().setVisible(Boolean.valueOf(ModelType.LLM.getValue().equals(e.getChangeSet()[0].getNewValue())), new String[]{llmTypeControl});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getSource() instanceof Audit || afterDoOperationEventArgs.getSource() instanceof UnAudit) {
            DataManager.getInstance().serviceInstanceDataChanged();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Audit) {
            // empty if block
        }
    }
}

