/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.plugin.common;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.ai.aicc.core.DataManager;
import kd.ai.aicc.plugin.common.DateUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class AiccServiceDataHelper {
    private static final Log logger = LogFactory.getLog(AiccServiceDataHelper.class);

    public static void SaveAiccService(Map<String, Object> result) {
        DynamicObject obj;
        int i;
        Map response = (Map)result.get("data");
        List services = (List)response.get("services");
        List serviceTypes = (List)response.get("serviceTypes");
        ArrayList<DynamicObject> serviceTypeDynamicObjects = new ArrayList<DynamicObject>(serviceTypes.size());
        ArrayList<DynamicObject> serviceDynamicObjects = new ArrayList<DynamicObject>(services.size());
        for (i = 0; i < serviceTypes.size(); ++i) {
            obj = BusinessDataServiceHelper.newDynamicObject((String)"aicc_servicetype");
            obj.set("id", ((Map)serviceTypes.get(i)).get("id"));
            obj.set("number", ((Map)serviceTypes.get(i)).get("number"));
            obj.set("name", ((Map)serviceTypes.get(i)).get("name"));
            obj.set("creator", (Object)1);
            obj.set("status", (Object)"A");
            obj.set("enable", (Object)1);
            serviceTypeDynamicObjects.add(obj);
        }
        for (i = 0; i < services.size(); ++i) {
            obj = BusinessDataServiceHelper.newDynamicObject((String)"aicc_service");
            obj.set("id", ((Map)services.get(i)).get("id"));
            obj.set("number", ((Map)services.get(i)).get("number"));
            obj.set("name", ((Map)services.get(i)).get("name"));
            obj.set("masterid", ((Map)services.get(i)).get("id"));
            try {
                obj.set("createtime", (Object)DateUtil.StrConvertToDate(((Map)services.get(i)).get("createtime").toString()));
            }
            catch (ParseException e) {
                obj.set("createtime", (Object)new Date());
            }
            obj.set("supportstream", ((Map)services.get(i)).get("supportstream"));
            obj.set("group", ((Map)services.get(i)).get("group"));
            obj.set("requestsample", ((Map)services.get(i)).get("requestsample"));
            obj.set("requestsample_tag", ((Map)services.get(i)).get("requestsample_tag"));
            obj.set("responsesample", ((Map)services.get(i)).get("responsesample"));
            obj.set("responsesample_tag", ((Map)services.get(i)).get("responsesample_tag"));
            obj.set("version", ((Map)services.get(i)).get("version"));
            obj.set("desc", ((Map)services.get(i)).get("desc"));
            obj.set("creator", (Object)1);
            obj.set("status", ((Map)services.get(i)).get("status"));
            obj.set("enable", (Object)1);
            serviceDynamicObjects.add(obj);
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                DeleteServiceHelper.delete((String)"aicc_servicetype", null);
                DeleteServiceHelper.delete((String)"aicc_service", null);
                SaveServiceHelper.save((DynamicObject[])serviceTypeDynamicObjects.toArray(new DynamicObject[serviceTypeDynamicObjects.size()]));
                SaveServiceHelper.save((DynamicObject[])serviceDynamicObjects.toArray(new DynamicObject[serviceDynamicObjects.size()]));
                DataManager.getInstance().serviceInstanceDataChanged();
                logger.info("\u66f4\u65b0\u7b97\u6cd5\u670d\u52a1\u6210\u529f");
            }
            catch (Exception ex) {
                logger.error("\u66f4\u65b0\u7b97\u6cd5\u670d\u52a1\u5f02\u5e38:", (Throwable)ex);
                h.markRollback();
                throw ex;
            }
        }
    }
}

