/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.operate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.lowagie.text.pdf.PdfReader;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.ai.cvp.common.Enum.AlgoApiEnum;
import kd.ai.cvp.common.Enum.AlgoMapClassEnum;
import kd.ai.cvp.common.Enum.DistingushFileTypeEnum;
import kd.ai.cvp.common.Enum.FileServiceTypeEnum;
import kd.ai.cvp.common.Enum.SourceTypeEnum;
import kd.ai.cvp.entity.AlgoResultDataVO;
import kd.ai.cvp.entity.OcrPlanTemplateField;
import kd.ai.cvp.utils.CommonUtil;
import kd.ai.cvp.utils.LicenseUtils;
import kd.ai.cvp.utils.OcrControlUtils;
import kd.ai.cvp.utils.OcrDistinguisUtils;
import kd.ai.cvp.utils.StreamHandleUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class OcrUploadPlugin
extends AbstractFormPlugin
implements ClickListener,
UploadListener {
    private static Log logger = LogFactory.getLog(OcrUploadPlugin.class);
    private static final String CVP_DISTINGUISH = "cvp_distinguish";
    private static final String PLAN_BUSINESS_OBJECT = "businessobject";
    private static final String PLAN_CONFIG = "templateconfig";
    private static final String OCR_DISTINGUISH_TEMPLATE = "ocrtemplate";
    private static final String IMAGE_DISTINGUISH = "imageapdistinguish";
    private static final String IMAGE_PATH = "imagepath";
    private static final String BTN_DISTINGUISH = "btnok";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btncancel", BTN_DISTINGUISH});
        Image image = (Image)this.getView().getControl(IMAGE_DISTINGUISH);
        image.addUploadListener((UploadListener)this);
        image.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String businessObjectStr = (String)customParams.get(PLAN_BUSINESS_OBJECT);
        DynamicObject plan = OcrControlUtils.getObjByPlanBusinessObject((String)businessObjectStr);
        if (plan == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u4e1a\u52a1\u5bf9\u8c61,\u672a\u914d\u7f6e\u65b9\u6848,\u8bf7\u5148\u914d\u7f6e", (String)"OcrUploadPlugin_0", (String)"ai-cvp-plugin", (Object[])new Object[0]));
            return;
        }
        this.setComboEdit(view, plan);
        try {
            LicenseUtils.checkLicenseAndDosage((IFormView)view);
        }
        catch (KDBizException ex) {
            logger.error("\u8bf7\u6c42\u68c0\u67e5\u8bb8\u53ef\u5931\u8d25", (Throwable)ex);
            view.showErrorNotification(String.format("\u8bf7\u6c42\u5931\u8d25\uff0c%s", ex.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void upload(UploadEvent evt) {
        block12: {
            block10: {
                block9: {
                    model = this.getModel();
                    urls = evt.getUrls();
                    if (urls.length <= 0) break block12;
                    originInputStream = null;
                    pdfReader = null;
                    inputStream = null;
                    inputStream = FileServiceFactory.getAttachmentFileService().getInputStream(urls[0].toString());
                    tempUrl = urls[0].toString();
                    suffixStr = tempUrl.substring(tempUrl.lastIndexOf(46) + 1);
                    fileName = tempUrl.substring(tempUrl.lastIndexOf(47) + 1);
                    result = StreamHandleUtils.validFileType((InputStream)inputStream, (String)suffixStr);
                    StreamHandleUtils.closeResource((Closeable)inputStream);
                    if (StringUtils.isEmpty((String)result)) break block9;
                    evt.setCancel(true);
                    this.getView().showTipNotification(result);
                    StreamHandleUtils.closeResource(originInputStream);
                    StreamHandleUtils.closeResource((Closeable)inputStream);
                    if (pdfReader != null) {
                        pdfReader.close();
                    }
                    return;
                }
                try {
                    if (!suffixStr.equalsIgnoreCase(DistingushFileTypeEnum.PDF.getVlaue())) break block10;
                    originInputStream = FileServiceFactory.getAttachmentFileService().getInputStream(urls[0].toString());
                    pdfReader = new PdfReader(originInputStream);
                    numberOfPages = pdfReader.getNumberOfPages();
                    StreamHandleUtils.closeResource((Closeable)originInputStream);
                    pdfReader.close();
                    if (numberOfPages <= 1) break block10;
                    this.getView().showTipNotification(ResManager.loadKDString((String)String.format("\u6587\u4ef6\u201c%s\u201d\u4e0a\u4f20\u6210\u529f\uff0c\u591a\u9875pdf\u4ec5\u652f\u6301\u8bc6\u522b\u9996\u9875\u5185\u5bb9\u3002", new Object[]{fileName}), (String)"OcrPersetTemplateTestPlugin_1", (String)"ai-cvp-plugin", (Object[])new Object[0]));
                }
                catch (Exception e) {
                    try {
                        OcrUploadPlugin.logger.error("\u4e0a\u4f20\u5f02\u5e38", (Throwable)e);
                        this.getView().showErrorNotification("\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002");
                        evt.setCancel(true);
                    }
                    catch (Throwable var12_13) {
                        StreamHandleUtils.closeResource(originInputStream);
                        StreamHandleUtils.closeResource(inputStream);
                        if (pdfReader != null) {
                            pdfReader.close();
                        }
                        throw var12_13;
                    }
                    StreamHandleUtils.closeResource(originInputStream);
                    StreamHandleUtils.closeResource((Closeable)inputStream);
                    if (pdfReader != null) {
                        pdfReader.close();
                    } else {
                        ** GOTO lbl54
                    }
                }
            }
            StreamHandleUtils.closeResource(originInputStream);
            StreamHandleUtils.closeResource((Closeable)inputStream);
            if (pdfReader != null) {
                pdfReader.close();
            }
            OcrUploadPlugin.logger.info(String.format("\u9644\u4ef6\u670d\u52a1\u5668\u4e0a\u4f20\u3002\u3002\u3002url:%s", new Object[]{urls[0]}));
            model.setValue("imagepath", urls[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String imagePath = (String)model.getValue(IMAGE_PATH);
        boolean clearFlag = false;
        try {
            if (BTN_DISTINGUISH.equals(key)) {
                String templateNumber = (String)model.getValue(OCR_DISTINGUISH_TEMPLATE);
                if (StringUtils.isEmpty((String)templateNumber)) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u8bc6\u522b\u6a21\u677f,\u8bf7\u5148\u9009\u62e9\u3002", (String)"OcrUploadPlugin_0", (String)"ai-cvp-plugin", (Object[])new Object[0]));
                    return;
                }
                if (StringUtils.isEmpty((String)imagePath)) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u672a\u4e0a\u4f20\u8bc6\u522b\u56fe\u7247,\u8bf7\u5148\u4e0a\u4f20\u56fe\u7247\u3002", (String)"OcrUploadPlugin_1", (String)"ai-cvp-plugin", (Object[])new Object[0]));
                    return;
                }
                clearFlag = this.ocrDistinguish(imagePath, view, templateNumber);
            }
        }
        catch (Exception e) {
            view.showTipNotification("OCR Exception ");
            logger.error("OCR,\u667a\u80fd\u8bc6\u522b\u5f02\u5e38,\u64cd\u4f5c\u5f02\u5e38: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (clearFlag) {
                CommonUtil.clearUploadFile((String)imagePath, (FileServiceTypeEnum)FileServiceTypeEnum.ATTACHMENT_FILE_SERVICE);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String imagePath = (String)this.getModel().getValue(IMAGE_PATH);
        if (!StringUtils.isEmpty((String)imagePath)) {
            CommonUtil.clearUploadFile((String)imagePath, (FileServiceTypeEnum)FileServiceTypeEnum.ATTACHMENT_FILE_SERVICE);
        }
    }

    public boolean ocrDistinguish(String imagePath, IFormView view, String templateId) throws Exception {
        AlgoResultDataVO info;
        logger.info("OCR\u8bc6\u522b - start\uff1b \u5165\u53e3\uff1a\u64cd\u4f5c\u7c7b\u578b\uff0c\u5f39\u6846\u4e0a\u4f20");
        boolean distinguishStatus = false;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String businessobject = (String)customParams.get(PLAN_BUSINESS_OBJECT);
        Long templateID = Long.valueOf(templateId);
        DynamicObject template = BusinessDataServiceHelper.loadSingleFromCache((Object)templateID, (String)"cvp_template");
        String templateNumber = template.getString("number");
        String api = AlgoApiEnum.getValue((String)templateNumber);
        SourceTypeEnum sourceTypeEnum = SourceTypeEnum.PRESETTEMPLATE;
        String countKey = UUID.randomUUID().toString();
        Boolean licenseCheckFlag = this.pluginChcekLicense(countKey, view);
        if (!licenseCheckFlag.booleanValue()) {
            return false;
        }
        long start = System.currentTimeMillis();
        if (StringUtils.isNotEmpty((String)api)) {
            Class clazz = AlgoMapClassEnum.getValue((String)templateNumber);
            info = OcrDistinguisUtils.distinguishPersetImage((String)businessobject, (String)templateNumber, (String)imagePath, (String)api, (Class)clazz);
        } else {
            sourceTypeEnum = SourceTypeEnum.SELFDESIGNTEMPLATE;
            info = OcrDistinguisUtils.distinguishOcrImage((String)businessobject, (String)templateNumber, (String)imagePath);
        }
        long end = System.currentTimeMillis();
        boolean ensureSuc = false;
        if (0 == info.getRepCode()) {
            ensureSuc = LicenseUtils.ensureCallNumToAlgo((boolean)true, (String)countKey, (SourceTypeEnum)sourceTypeEnum);
            if (ensureSuc) {
                view.returnDataToParent((Object)SerializationUtils.toJsonString((Object)info));
                view.close();
                distinguishStatus = true;
            } else {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff0c\u82e5\u8fde\u7eed\u591a\u6b21\u51fa\u73b0\u672c\u63d0\u793a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406", (String)"OcrUploadPlugin_09", (String)"ai-cvp-plugin", (Object[])new Object[0]));
            }
        } else {
            LicenseUtils.ensureCallNumToAlgo((boolean)false, (String)countKey, (SourceTypeEnum)sourceTypeEnum);
            view.showTipNotification(info.getRepMessage());
        }
        this.setApiInfo(view, info, templateID, template.getString("name"), end - start);
        logger.info(String.format("OCR\u8bc6\u522b - end\uff1b \u5165\u53e3\uff1a\u64cd\u4f5c\u7c7b\u578b\uff0c\u5f39\u6846\u4e0a\u4f20\uff1b traceId:%s, errorCode:%s, message:%s,", RequestContext.get().getTraceId(), info.getRepCode(), info.getRepMessage()));
        return distinguishStatus;
    }

    private Boolean pluginChcekLicense(String countKey, IFormView view) {
        Boolean licenseCheckFlag = Boolean.FALSE;
        try {
            licenseCheckFlag = LicenseUtils.checkLicense((int)1, (String)"ocr", (String)countKey);
        }
        catch (KDBizException be) {
            logger.error("\u8bb8\u53ef\u6821\u9a8c\u5931\u8d25\uff0c\u4e1a\u52a1\u5f02\u5e38", (Throwable)be);
            view.showTipNotification(be.getMessage());
        }
        catch (Exception e) {
            logger.error("\u8bb8\u53ef\u68c0\u67e5\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u6b64\u5904\u65e5\u5fd7\u3002", (Throwable)e);
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bb8\u53ef\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff0c\u82e5\u4f9d\u65e7\u51fa\u73b0\u672c\u63d0\u793a\uff0c\u5219\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"OcrUploadPlugin_10", (String)"ai-cvp-Plugin", (Object[])new Object[0]));
        }
        return licenseCheckFlag;
    }

    private void setApiInfo(IFormView view, AlgoResultDataVO info, long templateID, String templateName, long callTime) {
        RequestContext rc = RequestContext.get();
        DynamicObject apiInfo = ORM.create().newDynamicObject("cvp_api_invoke_info");
        Map customParams = view.getFormShowParameter().getCustomParams();
        String businessObject = (String)customParams.get(PLAN_BUSINESS_OBJECT);
        String businessName = MetadataServiceHelper.getDataEntityType((String)businessObject).getDisplayName().getLocaleValue();
        apiInfo.set("createdate", (Object)new Date());
        apiInfo.set("calltime", (Object)callTime);
        apiInfo.set("errorcode", (Object)info.getRepCode());
        apiInfo.set("traceid", (Object)rc.getTraceId());
        apiInfo.set("templateid", (Object)templateID);
        apiInfo.set("templatename", (Object)templateName);
        apiInfo.set("callobjectid", (Object)businessObject);
        apiInfo.set("callobjectname", (Object)businessName);
        apiInfo.set("userid", (Object)String.valueOf(rc.getCurrUserId()));
        apiInfo.set("username", (Object)rc.getUserName());
        apiInfo.set("status", (Object)"A");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{apiInfo});
    }

    private void setComboEdit(IFormView view, DynamicObject plan) {
        String configStr = (String)plan.get(PLAN_CONFIG);
        JSONObject config = JSON.parseObject((String)configStr);
        List<ComboItem> comboItem = this.createComboItem(config);
        ComboEdit ocrtemplate = (ComboEdit)view.getControl(OCR_DISTINGUISH_TEMPLATE);
        ocrtemplate.setComboItems(comboItem);
        if (comboItem != null && comboItem.size() > 0) {
            ComboItem c = comboItem.get(0);
            this.getModel().setValue(OCR_DISTINGUISH_TEMPLATE, (Object)c.getValue());
        }
    }

    private List<ComboItem> createComboItem(JSONObject config) {
        if (config == null) {
            return null;
        }
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(config.size());
        Set entries = config.entrySet();
        for (Map.Entry map : entries) {
            ComboItem comboItem = new ComboItem();
            OcrPlanTemplateField planTemplateField = (OcrPlanTemplateField)JSON.parseObject((String)map.getValue().toString(), OcrPlanTemplateField.class);
            comboItem.setCaption(new LocaleString(planTemplateField.getName()));
            comboItem.setValue((String)map.getKey());
            list.add(comboItem);
        }
        return list;
    }
}

