/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.plugin;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.ai.cvp.entity.ExportColumnSiteVO;
import kd.ai.cvp.utils.CommonUtil;
import kd.ai.cvp.utils.StreamHandleUtils;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.events.BeforeExportFileEvent;
import kd.bos.form.events.BeforeQueryOfExportEvent;
import kd.bos.form.events.ExportFileEvent;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class OcrTemplateExportListPlugin
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(OcrTemplateExportListPlugin.class);
    private static final String TEMPLATEIMG = "templateimg";
    private static final String REFERENCEIMG = "referenceimg";

    public void beforeQueryOfExport(BeforeQueryOfExportEvent e) {
        FileService imageFileService = FileServiceFactory.getImageFileService();
        ListSelectedRowCollection selectedRows = ((IListView)e.getSource()).getSelectedRows();
        List<Object> needList = new ArrayList();
        QFilter[] filters = e.getFilters();
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(Arrays.asList(filters));
        if (!selectedRows.isEmpty()) {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"cvp_template");
            DynamicObject[] selectedObjArr = BusinessDataServiceHelper.load((Object[])selectedRows.getPrimaryKeyValues(), (DynamicObjectType)dataEntityType);
            if (selectedObjArr != null && selectedObjArr.length > 0) {
                needList = Arrays.stream(selectedObjArr).filter(obj -> !StringUtils.isEmpty((String)obj.getString(TEMPLATEIMG)) && imageFileService.exists(obj.getString(TEMPLATEIMG)) || !StringUtils.isEmpty((String)obj.getString(REFERENCEIMG)) && imageFileService.exists(obj.getString(REFERENCEIMG))).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            }
            QFilter existImg = new QFilter("id", "in", needList);
            qFilterList.add(existImg);
        }
        QFilter qFilter = new QFilter("status", "=", (Object)"B");
        qFilterList.add(qFilter);
        e.setFilters(qFilterList.toArray(new QFilter[0]));
    }

    public void beforeExportFile(BeforeExportFileEvent e) {
        e.setFileName(e.getMainEntityType().getDisplayName() + ResManager.loadKDString((String)"_\u81ea\u5b9a\u4e49\u6a21\u677f\u5bfc\u51fa_", (String)"OcrTemplateExprotListPlugin_01", (String)"ai-cvp", (Object[])new Object[0]) + System.currentTimeMillis());
    }

    public void afterExportFile(ExportFileEvent e) {
        File file = e.getFile();
        if (file != null) {
            FileOutputStream out = null;
            try (FileInputStream fis = new FileInputStream(file);
                 XSSFWorkbook wb = new XSSFWorkbook((InputStream)fis);){
                Sheet sheet = wb.getSheetAt(0);
                ExportColumnSiteVO sitevo = new ExportColumnSiteVO();
                Iterator rowIterator = sheet.rowIterator();
                while (rowIterator.hasNext()) {
                    Row theRow = (Row)rowIterator.next();
                    int rowNum = theRow.getRowNum();
                    try {
                        this.doHandleData((Workbook)wb, sheet, theRow, rowNum, sitevo);
                    }
                    catch (Exception ex) {
                        logger.error(String.format("\u6570\u636e\u884c%s\u51fa\u9519\uff0c\u5ffd\u7565\u6389\u6570\u636e\u884c\u3002", rowNum), (Throwable)ex);
                        sheet.createRow(rowNum);
                    }
                }
                out = new FileOutputStream(file);
                wb.write((OutputStream)out);
            }
            catch (Exception ex) {
                try {
                    logger.error("\u5bfc\u51fa\u5f02\u5e38", (Throwable)ex);
                    throw new KDBizException(ex.getMessage());
                }
                catch (Throwable throwable) {
                    StreamHandleUtils.closeResource(out);
                    throw throwable;
                }
            }
            StreamHandleUtils.closeResource((Closeable)out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doHandleData(Workbook wb, Sheet sheet, Row theRow, int rowNum, ExportColumnSiteVO sitevo) throws IOException {
        String referUrl;
        int tempCellSite = sitevo.getTempCellSite();
        int referCellSite = sitevo.getReferCellSite();
        int temptageinfoSite = sitevo.getTemptageinfoSite();
        int temptableheadSite = sitevo.getTemptableheadSite();
        int tempreferenceinfoSite = sitevo.getTempreferenceinfoSite();
        if (rowNum < 4) {
            if (rowNum == 2) {
                sitevo.setTempCellSite(CommonUtil.getCellSiteByField((Row)theRow, (String)TEMPLATEIMG));
                sitevo.setReferCellSite(CommonUtil.getCellSiteByField((Row)theRow, (String)REFERENCEIMG));
                sitevo.setTemptageinfoSite(CommonUtil.getCellSiteByField((Row)theRow, (String)"temptageinfo"));
                sitevo.setTemptableheadSite(CommonUtil.getCellSiteByField((Row)theRow, (String)"temptablehead"));
                sitevo.setTempreferenceinfoSite(CommonUtil.getCellSiteByField((Row)theRow, (String)"temprenfenceinfo"));
            }
            return;
        }
        if (tempCellSite == -1 || referCellSite == -1) {
            throw new KDBizException("\u5bfc\u51fa\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u6807\u9898\u5934\u7b2c2\u884c\u662f\u5426\u662f\u5b57\u6bb5\u7f16\u7801\u884c\u3002");
        }
        Cell templateCell = theRow.getCell(tempCellSite);
        Cell referCell = theRow.getCell(referCellSite);
        String templateUrl = templateCell != null ? templateCell.getStringCellValue() : "";
        String string = referUrl = referCell != null ? referCell.getStringCellValue() : "";
        if (templateCell != null) {
            templateCell.setCellType(CellType.BLANK);
        }
        if (referCell != null) {
            referCell.setCellType(CellType.BLANK);
        }
        InputStream templateImgInputStream = null;
        InputStream referImgInputStream = null;
        try {
            if (!StringUtils.isEmpty((String)referUrl)) {
                referImgInputStream = this.getPicInputStream(referUrl);
                this.insertPic(wb, sheet, referImgInputStream, rowNum, referCellSite);
            } else if (!StringUtils.isEmpty((String)templateUrl)) {
                templateImgInputStream = this.getPicInputStream(templateUrl);
                this.insertPic(wb, sheet, templateImgInputStream, rowNum, referCellSite);
            }
        }
        catch (Throwable throwable) {
            StreamHandleUtils.closeResource(templateImgInputStream);
            StreamHandleUtils.closeResource(referImgInputStream);
            throw throwable;
        }
        StreamHandleUtils.closeResource(templateImgInputStream);
        StreamHandleUtils.closeResource((Closeable)referImgInputStream);
        CommonUtil.updateStringCellForOutputExcel((Row)theRow, (int)temptageinfoSite, (CommonUtil.TypeTransferEnum)CommonUtil.TypeTransferEnum.ToBase64Str);
        CommonUtil.updateStringCellForOutputExcel((Row)theRow, (int)temptableheadSite, (CommonUtil.TypeTransferEnum)CommonUtil.TypeTransferEnum.ToBase64Str);
        CommonUtil.updateStringCellForOutputExcel((Row)theRow, (int)tempreferenceinfoSite, (CommonUtil.TypeTransferEnum)CommonUtil.TypeTransferEnum.ToBase64Str);
    }

    private InputStream getPicInputStream(String url) {
        FileService imageFileService = FileServiceFactory.getImageFileService();
        boolean exists = imageFileService.exists(url);
        if (exists) {
            return imageFileService.getInputStream(url);
        }
        return null;
    }

    private void insertPic(Workbook wb, Sheet sheet, InputStream inputStream, int row, int col) throws IOException {
        if (inputStream != null) {
            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
            int picIdx = wb.addPicture(bytes, 6);
            CreationHelper helper = wb.getCreationHelper();
            Drawing drawing = sheet.createDrawingPatriarch();
            ClientAnchor clientAnchor = helper.createClientAnchor();
            clientAnchor.setCol1(col);
            clientAnchor.setRow1(row);
            Picture picture = drawing.createPicture(clientAnchor, picIdx);
            picture.resize();
        }
    }
}

