/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.ai.cvp.entity.ImportExportVO;
import kd.ai.cvp.entity.renfence.RenfenceInfoVO;
import kd.ai.cvp.entity.template.TemplateDistInfoVO;
import kd.ai.cvp.utils.CommonUtil;
import kd.ai.cvp.utils.StreamHandleUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.BatchImportSheetHandler;
import kd.bos.form.plugin.impt.HeartBeat;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFPicture;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFShape;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTMarker;

public class OcrTemplateImportHandlerPlugin
extends BatchImportPlugin {
    private static final Log logger = LogFactory.getLog(OcrTemplateImportHandlerPlugin.class);
    private int batchQueryNum = 10;
    private boolean isForceBatch = true;
    private static final String IMPORTTYPE = "new";
    private static final String ROWNUM = "ROWNUM";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String DESCRIPTION = "description";
    private static final String STATUS = "status";
    private static final String CREATORID = "creatorid";
    private static final String CREATEDATE = "createdate";
    private static final String MODIFIERID = "modifierid";
    private static final String MODIFYDATE = "modifydate";
    private static final String ISVALID = "isvalid";
    private static final String BINDINGDATA = "bindingdata";
    private static final String BINDINGID = "bindingid";
    private static final String TEMPTAGEINFO = "temptageinfo";
    private static final String TEMPTABLEHEAD = "temptablehead";
    private static final String TEMPRENFENCEINFO = "temprenfenceinfo";
    private static final String TEMPLATEIMG = "templateimg";
    private static final String REFERENCEIMG = "referenceimg";
    private static final String[] unvisible = new String[]{"radiofield1", "radiofield2", "btndownload", "flexpanelap9"};
    private HeartBeat heartbeat = new HeartBeat();
    protected String entityName;

    public String getDefaultImportType() {
        return IMPORTTYPE;
    }

    protected boolean isForceBatch() {
        return this.isForceBatch;
    }

    protected int getBatchImportSize() {
        return this.batchQueryNum;
    }

    protected void resolveExcel() {
        this.resolveExcelForPic();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveExcelForPic() {
        FileService service = FileServiceFactory.getAttachmentFileService();
        Iterator urls = this.ctx.getAllUrls().iterator();
        ExcelReader reader = new ExcelReader();
        while (urls.hasNext()) {
            String url = (String)urls.next();
            InputStream newInputStream = null;
            try (InputStream in = service.getInputStream(url);){
                newInputStream = this.replacePicToUrl(in);
                Map option = this.ctx.getOption();
                MainEntityType mainEntityType = this.buildMainEntityType(null);
                if (mainEntityType instanceof QueryEntityType) {
                    mainEntityType = ((QueryEntityType)mainEntityType).getMainEntityType();
                }
                reader.read(newInputStream, (SheetHandler)new BatchImportSheetHandler(this.ctx, mainEntityType, url, option, this.heartbeat));
            }
            catch (Exception e) {
                try {
                    String importErrMsg = e.getMessage();
                    if (StringUtils.isEmpty((String)importErrMsg)) {
                        importErrMsg = "excel\u6570\u636e\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\u3002";
                    }
                    logger.error("\u81ea\u5b9a\u4e49\u6a21\u677f\u5f15\u5165\u5931\u8d25\uff0c\u5f02\u5e38\u4e3a\uff1a", (Throwable)e);
                    this.ctx.getLogger(url).log(Integer.valueOf(0), importErrMsg);
                    this.ctx.addBillData(url, new ImportBillData(new JSONObject(), 0, 0));
                    this.ctx.setResolveComplete(url);
                }
                catch (Throwable throwable) {
                    StreamHandleUtils.closeResource(newInputStream);
                    throw throwable;
                }
                StreamHandleUtils.closeResource((Closeable)newInputStream);
                continue;
            }
            StreamHandleUtils.closeResource((Closeable)newInputStream);
        }
    }

    /*
     * Exception decompiling
     */
    private InputStream replacePicToUrl(InputStream in) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void handlerCell(XSSFSheet xssfSheet) {
        Map<String, PictureData> picData = this.getAllPicUrls(xssfSheet);
        if (picData.isEmpty()) {
            logger.error("\u672a\u83b7\u53d6\u5230\u56fe\u7247\u4fe1\u606f");
            throw new KDBizException("\u672a\u83b7\u53d6\u5230\u5fc5\u8981\u7684\u56fe\u7247\u4fe1\u606f\uff0c\u8bf7\u786e\u4fdd\u9700\u8981\u5f15\u5165\u7684\u6587\u4ef6\u4e2d\u5305\u542b\u56fe\u7247\u4fe1\u606f\u3002");
        }
        Map<String, String> locatePicUrlMap = this.batchUploadPics(picData);
        int rownum = xssfSheet.getPhysicalNumberOfRows();
        int tempCellSite = -1;
        int referCellSite = -1;
        XSSFRow fieldCodeRow = xssfSheet.getRow(2);
        if (fieldCodeRow != null) {
            tempCellSite = CommonUtil.getCellSiteByField((Row)fieldCodeRow, (String)TEMPLATEIMG);
            referCellSite = CommonUtil.getCellSiteByField((Row)fieldCodeRow, (String)REFERENCEIMG);
        }
        if (tempCellSite == -1 || referCellSite == -1) {
            throw new KDBizException("\u5f15\u5165\u5f02\u5e38\uff0c\u8bf7\u52ff\u4fee\u6539\u9700\u8981\u5f15\u5165\u7684excel\u6587\u4ef6\u3002\u82e5\u786e\u8ba4\u540e\u4ecd\u51fa\u73b0\u672c\u5f02\u5e38\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002");
        }
        for (int cellIndex = 4; cellIndex < rownum; ++cellIndex) {
            XSSFRow rowInfo = xssfSheet.getRow(cellIndex);
            if (rowInfo == null) continue;
            this.setExcelPicUrl(rowInfo, locatePicUrlMap, cellIndex, referCellSite, false);
            this.setExcelPicUrl(rowInfo, locatePicUrlMap, cellIndex, tempCellSite, true);
        }
    }

    private void setExcelPicUrl(XSSFRow rowInfo, Map<String, String> locatePicUrlMap, int rowIndex, int colIndex, boolean isTemplatePic) {
        String url = locatePicUrlMap.get(rowIndex + "-" + colIndex);
        XSSFCell templateImgCell = rowInfo.getCell(colIndex);
        if (templateImgCell == null) {
            templateImgCell = rowInfo.createCell(colIndex);
        }
        templateImgCell.setCellType(CellType.STRING);
        logger.info("\u56fe\u7247url\uff1a" + url);
        if (StringUtils.isEmpty((String)url)) {
            if (isTemplatePic) {
                url = locatePicUrlMap.get(rowIndex + "-" + (colIndex + 1));
                logger.info("\u65cb\u8f6c\u56fe\u4e0e\u9ed8\u8ba4\u56fe\u4e00\u81f4\uff0c\u586b\u5145\u4e3a\u9ed8\u8ba4\u56feurl\uff1a" + url);
            } else {
                logger.warn("\u6a21\u677f\u65cb\u8f6c\u56fe\u4e3a\u7a7a\uff0c\u76f4\u63a5\u8ba4\u4e3a\u7a7a\u3002");
                url = "";
            }
        }
        templateImgCell.setCellValue(url);
    }

    private Map<String, String> batchUploadPics(Map<String, PictureData> picData) {
        HashMap<String, String> urlMap = new HashMap<String, String>(picData.size());
        FileService imageFileService = FileServiceFactory.getImageFileService();
        picData.forEach((key, pictureData) -> {
            String imageId = UUID.randomUUID().toString().replace("-", "");
            String permanentUrl = CommonUtil.getPermanentUrlByBytes((byte[])pictureData.getData(), (String)imageId, (String)"png", (String)"cvp_template", (FileService)imageFileService);
            urlMap.put((String)key, permanentUrl);
        });
        return urlMap;
    }

    private Map<String, PictureData> getAllPicUrls(XSSFSheet sheet) {
        HashMap<String, PictureData> picMap = new HashMap<String, PictureData>();
        if (sheet == null) {
            return picMap;
        }
        List relations = sheet.getRelations();
        if (!relations.isEmpty()) {
            relations.forEach(relate -> {
                if (relate instanceof XSSFDrawing) {
                    List shapes = ((XSSFDrawing)relate).getShapes();
                    for (XSSFShape shape : shapes) {
                        XSSFPicture picture = (XSSFPicture)shape;
                        XSSFClientAnchor anchor = picture.getPreferredSize();
                        CTMarker maker = anchor.getFrom();
                        String mapKey = maker.getRow() + "-" + maker.getCol();
                        picMap.put(mapKey, (PictureData)picture.getPictureData());
                    }
                }
            });
        }
        return picMap;
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        ApiResult apiResult = new ApiResult();
        Map<String, String> errorMap = this.validateBatchBills(rowdatas, logger);
        if (!rowdatas.isEmpty()) {
            this.doSave(errorMap, rowdatas, logger);
        }
        ArrayList<ImportExportVO> savedBillResults = new ArrayList<ImportExportVO>(16);
        Iterator<ImportBillData> iterator = rowdatas.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            ImportBillData importBillData = iterator.next();
            String number = importBillData.getData().getString(NUMBER);
            ImportExportVO result = new ImportExportVO();
            result.setIndex(index);
            result.setNumber(number);
            result.setSucess(true);
            result.setData((Map)importBillData.getData());
            result.setId((Object)importBillData.getData().getLong("id"));
            savedBillResults.add(result);
            ++index;
        }
        HashSet<String> uploadFailUrls = new HashSet<String>();
        if (!errorMap.isEmpty()) {
            Iterator saveiterator = savedBillResults.iterator();
            while (saveiterator.hasNext()) {
                String errorMsg;
                ImportExportVO bill = (ImportExportVO)saveiterator.next();
                Map data = bill.getData();
                Object number = data.get(NUMBER);
                Object templateImgUrl = data.get(TEMPLATEIMG);
                Object referenceImgUrl = data.get(REFERENCEIMG);
                if (number == null || StringUtils.isEmpty((String)(errorMsg = errorMap.get(number.toString())))) continue;
                bill.setSucess(false);
                bill.setMessage(errorMsg);
                if (!org.apache.commons.lang3.ObjectUtils.isEmpty(templateImgUrl)) {
                    uploadFailUrls.add(templateImgUrl.toString());
                }
                if (!ObjectUtils.isEmpty(referenceImgUrl)) {
                    uploadFailUrls.add(referenceImgUrl.toString());
                }
                saveiterator.remove();
            }
            apiResult.setSuccess(false);
            this.clearPic(uploadFailUrls);
        }
        ArrayList apiResultData = new ArrayList(10);
        savedBillResults.forEach(t -> apiResultData.add(t.toMap()));
        apiResult.setData(apiResultData);
        return apiResult;
    }

    private void clearPic(Set<String> urls) {
        if (urls.isEmpty()) {
            logger.info("\u65e0\u987b\u6e05\u7406\u56fe\u7247\uff0c\u56fe\u7247\u5931\u8d25\u96c6\u4e3a\u7a7a");
            return;
        }
        FileService imageFileService = FileServiceFactory.getImageFileService();
        urls.forEach(url -> {
            if (imageFileService.exists(url)) {
                logger.info("\u6b63\u5728\u6e05\u9664\u5f15\u5165\u5931\u8d25\u56fe\u7247\uff0c\u56fe\u7247url:" + url);
                imageFileService.delete(url);
            }
        });
    }

    private void doSave(Map<String, String> errorMap, List<ImportBillData> rowdatas, ImportLogger logger) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"cvp_template");
        long[] ids = DBServiceHelper.genLongIds((String)this.entityName, (int)(rowdatas.size() * 2));
        String[] numbers = this.genNumberArrs(rowdatas.size(), 13);
        int index = 0;
        int numberIndex = 0;
        Iterator<ImportBillData> it = rowdatas.iterator();
        while (it.hasNext()) {
            ImportBillData data = it.next();
            JSONObject templateBill = data.getData();
            String number = templateBill.getString(NUMBER);
            int rowNum = templateBill.getInteger("rowNum");
            ArrayList<DynamicObject> singleTemplateObjList = new ArrayList<DynamicObject>();
            try {
                this.saveForRow((DynamicObjectType)type, ids[index++], ids[index++], numbers[numberIndex++], templateBill, singleTemplateObjList);
            }
            catch (Exception e) {
                String message = e.getMessage();
                OcrTemplateImportHandlerPlugin.logger.error(message, (Throwable)e);
                String importLogMessage = message.contains("value too long for type character") ? "\u5f15\u5165\u5f02\u5e38,\u8bf7\u68c0\u67e5\u672c\u884c\u5355\u5143\u683c\u4e2d\u503c\u957f\u5ea6\u662f\u5426\u8d85\u8fc7\u5355\u636e\u5b57\u6bb5\u53ef\u5f55\u5165\u6700\u5927\u957f\u5ea6\u3002" : "\u5f15\u5165\u5f02\u5e38,\u8bf7\u6839\u636e\u5355\u636e\u5b57\u6bb5\u53ef\u586b\u5165\u6700\u5927\u957f\u5ea6\u68c0\u67e5\u6570\u636e\u662f\u5426\u7b26\u5408\u8981\u6c42,\u5e76\u5c3d\u91cf\u4e0d\u8981\u4fee\u6539\u9700\u8981\u5f15\u5165\u7684\u6570\u636e\u3002";
                logger.log(Integer.valueOf(rowNum), importLogMessage).fail();
                errorMap.put(number, importLogMessage);
                it.remove();
            }
        }
    }

    private void saveForRow(DynamicObjectType type, long id, long bindId, String number, JSONObject templateBill, List<DynamicObject> singleTemplateObjList) {
        DynamicObject templateBindingObj = new DynamicObject(type, (Object)id);
        templateBindingObj.set(NAME, templateBill.get((Object)NAME));
        templateBindingObj.set(NUMBER, (Object)("OCRTEMPLATE-import-" + number));
        templateBindingObj.set(DESCRIPTION, (Object)templateBill.getString(DESCRIPTION));
        templateBindingObj.set(STATUS, (Object)"A");
        templateBindingObj.set(CREATORID, (Object)RequestContext.get().getCurrUserId());
        Date date = new Date();
        templateBindingObj.set(CREATEDATE, (Object)date);
        templateBindingObj.set(MODIFIERID, (Object)RequestContext.get().getCurrUserId());
        templateBindingObj.set(MODIFYDATE, (Object)date);
        templateBindingObj.set(ISVALID, (Object)"0");
        templateBindingObj.set(BINDINGDATA, (Object)"0");
        templateBindingObj.set(TEMPTAGEINFO, (Object)templateBill.getString(TEMPTAGEINFO));
        templateBindingObj.set(TEMPRENFENCEINFO, (Object)templateBill.getString(TEMPRENFENCEINFO));
        templateBindingObj.set(TEMPLATEIMG, (Object)templateBill.getString(TEMPLATEIMG));
        templateBindingObj.set(REFERENCEIMG, (Object)templateBill.getString(REFERENCEIMG));
        long bingdataId = bindId;
        templateBindingObj.set(BINDINGID, (Object)bingdataId);
        singleTemplateObjList.add(templateBindingObj);
        DynamicObject templateUnbindingObj = new DynamicObject(type, (Object)bingdataId);
        templateUnbindingObj.set(NAME, (Object)templateBindingObj.getString(NAME));
        templateUnbindingObj.set(NUMBER, (Object)templateBindingObj.getString(NUMBER));
        templateUnbindingObj.set(DESCRIPTION, (Object)templateBindingObj.getString(DESCRIPTION));
        templateUnbindingObj.set(STATUS, (Object)templateBindingObj.getString(STATUS));
        templateUnbindingObj.set(CREATORID, (Object)RequestContext.get().getCurrUserId());
        templateUnbindingObj.set(CREATEDATE, (Object)date);
        templateUnbindingObj.set(MODIFIERID, (Object)RequestContext.get().getCurrUserId());
        templateUnbindingObj.set(MODIFYDATE, (Object)date);
        templateUnbindingObj.set(ISVALID, (Object)"0");
        templateUnbindingObj.set(BINDINGDATA, (Object)"1");
        templateUnbindingObj.set(BINDINGID, templateBindingObj.getPkValue());
        singleTemplateObjList.add(templateUnbindingObj);
        SaveServiceHelper.save((DynamicObject[])singleTemplateObjList.toArray(new DynamicObject[0]));
    }

    private String[] genNumberArrs(int size, int len) {
        String[] str = new String[size];
        for (int i = 0; i < size; ++i) {
            str[i] = RandomStringUtils.randomAlphanumeric((int)len);
        }
        return str;
    }

    private Map<String, String> validateBatchBills(List<ImportBillData> bills, ImportLogger log) {
        if (bills.isEmpty()) {
            throw new KDBizException("\u5f85\u5f15\u5165\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6b63\u5e38\u3002");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator<ImportBillData> iterator = bills.iterator();
        HashSet<String> numberSet = new HashSet<String>();
        while (iterator.hasNext()) {
            boolean addFlag;
            String errorMsg;
            ImportBillData billdata = iterator.next();
            JSONObject data = billdata.getData();
            String number = data.getString(NUMBER);
            Object name = data.get((Object)NAME);
            String temptageinfo = data.getString(TEMPTAGEINFO);
            String temprenfenceinfo = data.getString(TEMPRENFENCEINFO);
            String templateimg = data.getString(TEMPLATEIMG);
            String referenceimg = data.getString(REFERENCEIMG);
            boolean isRemove = false;
            StringBuilder sb = new StringBuilder();
            boolean replaceFlag = false;
            if (!(StringUtils.isEmpty((String)number) || org.apache.commons.lang3.ObjectUtils.isEmpty((Object)name) || StringUtils.isEmpty((String)temptageinfo) || StringUtils.isEmpty((String)temprenfenceinfo) || StringUtils.isEmpty((String)templateimg) || StringUtils.isEmpty((String)referenceimg))) {
                String logMsg;
                try {
                    replaceFlag = this.updateStringValueForImportBill(data);
                }
                catch (Exception e) {
                    logger.error("base64\u6570\u636e\u89e3\u6790\u5931\u8d25\u3002", (Throwable)e);
                    logMsg = "base64\u6570\u636e\u89e3\u6790\u5931\u8d25\u3002";
                    errorMsg = "\u6a21\u677f\u8bc6\u522b\u6807\u6ce8\u4fe1\u606f\u3001\u6a21\u677f\u8bc6\u522b\u8868\u5934\u4fe1\u606f\u6216\u6a21\u677f\u53c2\u7167\u5b57\u6bb5\u4fe1\u606f(\u951a\u70b9\u4fe1\u606f+\u63a7\u4ef6\u4fe1\u606f))\u7ed3\u6784\u4e0d\u6b63\u786e\uff0c\u8bf7\u4e0d\u8981\u4fee\u6539\u539f\u59cb\u5bfc\u51fa\u7684excel\u6570\u636e\u7ed3\u6784;";
                    if (e instanceof KDBizException && !StringUtils.isEmpty((String)e.getMessage())) {
                        errorMsg = e.getMessage();
                    }
                    isRemove = this.errorHandler(sb, logMsg, errorMsg, data.get((Object)ROWNUM));
                }
                if (replaceFlag) {
                    temptageinfo = data.getString(TEMPTAGEINFO);
                    temprenfenceinfo = data.getString(TEMPRENFENCEINFO);
                    try {
                        TemplateDistInfoVO templateDistInfoVO = (TemplateDistInfoVO)JSON.parseObject((String)temptageinfo, TemplateDistInfoVO.class);
                        Object distinguishData = templateDistInfoVO.getDistinguishData();
                        Object distinguishPos = templateDistInfoVO.getDistinguishPos();
                        if (distinguishData == null || distinguishPos == null) {
                            throw new KDBizException("\u5f85\u8bc6\u522b\u4fe1\u606f\u89e3\u6790\u5f02\u5e38\u3002");
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u5f85\u8bc6\u522b\u6807\u6ce8\u4fe1\u606f\u89e3\u6790\u5f02\u5e38\u3002", (Throwable)e);
                        logMsg = "excel\u6570\u636e\u8f6c\u6362\u5931\u8d25,\u5f85\u8bc6\u522b\u6807\u6ce8\u4fe1\u606f\u7ed3\u6784\u4e0d\u6b63\u786e\u3002";
                        errorMsg = "\u6a21\u677f\u8bc6\u522b\u6807\u6ce8\u4fe1\u606f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4e0d\u8981\u4fee\u6539\u539f\u59cb\u5bfc\u51fa\u7684excel\u6570\u636e\u7ed3\u6784;";
                        isRemove = this.errorHandler(sb, logMsg, errorMsg, data.get((Object)ROWNUM));
                    }
                    try {
                        RenfenceInfoVO renfenceInfoVO = (RenfenceInfoVO)JSON.parseObject((String)temprenfenceinfo, RenfenceInfoVO.class);
                        Object anchor = renfenceInfoVO.getAnchor();
                        Object referenceData = renfenceInfoVO.getReferenceData();
                        if (anchor == null || referenceData == null) {
                            throw new KDBizException("\u53c2\u7167\u5b57\u6bb5\u4fe1\u606f\u89e3\u6790\u5f02\u5e38\u3002");
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u53c2\u7167\u5b57\u6bb5\u4fe1\u606f\u89e3\u6790\u5f02\u5e38\u3002", (Throwable)e);
                        logMsg = "excel\u6570\u636e\u8f6c\u6362\u5931\u8d25,\u6a21\u677f\u53c2\u7167\u5b57\u6bb5\u4fe1\u606f\u7ed3\u6784\u4e0d\u6b63\u786e\u3002";
                        errorMsg = "\u6a21\u677f\u53c2\u7167\u5b57\u6bb5\u4fe1\u606f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4e0d\u8981\u4fee\u6539\u539f\u59cb\u5bfc\u51fa\u7684excel\u6570\u636e\u7ed3\u6784;";
                        isRemove = this.errorHandler(sb, logMsg, errorMsg, data.get((Object)ROWNUM));
                    }
                }
                FileService imageFileService = FileServiceFactory.getImageFileService();
                boolean templateImgExists = imageFileService.exists(templateimg);
                boolean referenceExists = imageFileService.exists(referenceimg);
                if (!templateImgExists) {
                    errorMsg = "\u6a21\u677f\u539f\u56fe\u4e0d\u5b58\u5728\uff0c\u8bf7\u4e0d\u8981\u4fee\u6539\u539f\u59cb\u5bfc\u51fa\u7684excel\u6570\u636e\u6216\u8005\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u56fe\u7247\u670d\u52a1\u5668\u662f\u5426\u6b63\u5e38;";
                    isRemove = this.errorHandler(sb, StringUtils.getEmpty(), errorMsg, data.get((Object)ROWNUM));
                }
                if (!referenceExists) {
                    errorMsg = "\u65cb\u8f6c\u540e\u6a21\u677f\u56fe\u7247\u4e0d\u5b58\u5728\uff0c\u8bf7\u4e0d\u8981\u4fee\u6539\u539f\u59cb\u5bfc\u51fa\u7684excel\u6570\u636e\u6216\u8005\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u56fe\u7247\u670d\u52a1\u5668\u662f\u5426\u6b63\u5e38;";
                    isRemove = this.errorHandler(sb, StringUtils.getEmpty(), errorMsg, data.get((Object)ROWNUM));
                }
            } else {
                errorMsg = "\u5fc5\u987b\u5305\u542b\u6a21\u677f\u7f16\u7801\u3001\u6a21\u677f\u540d\u79f0\u3001\u6a21\u677f\u8bc6\u522b\u6807\u6ce8\u4fe1\u606f\u3001\u6a21\u677f\u53c2\u7167\u4fe1\u606f\u3001\u6a21\u677f\u539f\u56fe\u3002";
                isRemove = this.errorHandler(sb, StringUtils.getEmpty(), errorMsg, data.get((Object)ROWNUM));
            }
            if (!StringUtils.isEmpty((String)number) && !(addFlag = numberSet.add(number))) {
                errorMsg = String.format("\u6821\u9a8c\u5f02\u5e38\uff0c\u5df2\u5b58\u5728\u76f8\u540c\u7684\u7f16\u7801\u4e3a%s\u7684\u6570\u636e\uff0c\u76ee\u524d\u4ec5\u5141\u8bb8\u5f15\u5165\u4e0d\u540c\u7f16\u7801\u7684\u6a21\u677f\u6570\u636e\u3002", number);
                isRemove = this.errorHandler(sb, StringUtils.getEmpty(), errorMsg, data.get((Object)ROWNUM), number);
            }
            if (!isRemove) continue;
            if (sb.length() > 0) {
                log.log(Integer.valueOf(billdata.getStartIndex()), sb.toString()).fail();
                map.put(number, sb.toString());
            }
            iterator.remove();
        }
        return map;
    }

    private boolean updateStringValueForImportBill(JSONObject data) {
        String temptageinfo = data.getString(TEMPTAGEINFO);
        String temptablehead = data.getString(TEMPTABLEHEAD);
        String temprenfenceinfo = data.getString(TEMPRENFENCEINFO);
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isEmpty((String)temptageinfo)) {
            sb.append("\u6a21\u677f\u8bc6\u522b\u6807\u6ce8\u4fe1\u606f\u4e3a\u7a7a;");
        }
        if (StringUtils.isEmpty((String)temprenfenceinfo)) {
            sb.append("\u6a21\u677f\u53c2\u7167\u5b57\u6bb5\u4fe1\u606f(\u951a\u70b9\u4fe1\u606f+\u63a7\u4ef6\u4fe1\u606f))\u4e3a\u7a7a;");
        }
        if (sb.length() > 0) {
            throw new KDBizException(sb.toString());
        }
        this.validAndPutValue(sb, data, TEMPTAGEINFO, temptageinfo, "\u6a21\u677f\u8bc6\u522b\u6807\u6ce8\u4fe1\u606f");
        this.validAndPutValue(sb, data, TEMPTABLEHEAD, temptablehead, "\u6a21\u677f\u8bc6\u522b\u8868\u5934\u4fe1\u606f");
        this.validAndPutValue(sb, data, TEMPRENFENCEINFO, temprenfenceinfo, "\u6a21\u677f\u53c2\u7167\u5b57\u6bb5\u4fe1\u606f(\u951a\u70b9\u4fe1\u606f+\u63a7\u4ef6\u4fe1\u606f))");
        if (sb.length() > 0) {
            throw new KDBizException(sb.toString());
        }
        return true;
    }

    private void validAndPutValue(StringBuilder sb, JSONObject data, String keyName, String value, String errorName) {
        try {
            data.put(keyName, (Object)CommonUtil.decodeBase64Str((String)value));
        }
        catch (Exception e) {
            sb.append(errorName).append("\u7ed3\u6784\u4e0d\u6b63\u786e;");
        }
    }

    private boolean errorHandler(StringBuilder sb, String logMsg, String errorMsgStr, Object ... param) {
        String errorMsg = String.format(errorMsgStr, param);
        if (StringUtils.isEmpty((String)logMsg)) {
            logMsg = errorMsg;
        }
        logger.error(logMsg);
        sb.append(errorMsg);
        return true;
    }

    public BatchImportPlugin setContext(RequestContext rc, ImportContext ctx, List<String> startArgs) {
        try {
            this.entityName = ctx.getBillFormId();
            Field view = ctx.getClass().getDeclaredField("view");
            ReflectionUtils.makeAccessible((Field)view);
            FormView formView = (FormView)view.get(ctx);
            formView.setVisible(Boolean.FALSE, unvisible);
            Label labelap4 = (Label)formView.getControl("labelap4");
            if (labelap4 != null) {
                labelap4.setText("\u4e0a\u4f20\u6587\u4ef6\u9700\u4f7f\u7528\u89c6\u89c9\u8bc6\u522b\u670d\u52a1\u5bfc\u51fa\u6587\u4ef6\uff0c\u5e76\u8bf7\u52ff\u4fee\u6539\u5185\u5bb9\u3002");
            }
        }
        catch (NoSuchFieldException var8) {
            logger.error(var8.getMessage());
        }
        catch (Exception ex) {
            logger.error("\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7", (Throwable)ex);
        }
        return super.setContext(rc, ctx, startArgs);
    }
}

