/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.plugin.classifier;

import com.alibaba.fastjson.JSONArray;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.ai.cvp.core.op.ClassifierOperateTest;
import kd.ai.cvp.entity.classifier.ClsCustomVO;
import kd.ai.cvp.entity.classifier.ClsTargetFile;
import kd.ai.cvp.entity.classifier.ClsTaskDataVO;
import kd.ai.cvp.utils.OcrControlUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.url.UrlService;

public class ClassifierOperateBillPlugin
extends AbstractFormPlugin
implements ClickListener,
UploadListener {
    private static Log LOGGER = LogFactory.getLog(ClassifierOperateBillPlugin.class);
    private static final String custom_init = "init";
    private static final String custom_init_status_y = "init";
    private static final String custom_init_status_n = "non_init";
    private static final String custom_key = "customtda";

    public void customEvent(CustomEventArgs e) {
        List fileInfos = null;
        String eventName = e.getEventName();
        try {
            if (OcrControlUtils.checkWebStatus((IFormView)this.getView(), (String)eventName, (String)e.getEventArgs())) {
                return;
            }
            long classifierId = (Long)this.getView().getFormShowParameter().getCustomParam("bill_classifier_id");
            String operateKey = (String)this.getView().getFormShowParameter().getCustomParam("operate_key");
            DynamicObject cInfo = BusinessDataServiceHelper.loadSingle((Object)classifierId, (String)"cvp_cls_info");
            if (Objects.isNull(cInfo)) {
                String message = ResManager.loadKDString((String)"\u8be5\u7ec4\u5408\u8bc6\u522b\u5668\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u5b9a\u8be5\u7ec4\u5408\u8bc6\u522b\u5668\u662f\u5426\u5df2\u88ab\u6e05\u7406", (String)"TdaEntityOperate_1", (String)"ai-cvp-plugin", (Object[])new Object[0]);
                LOGGER.info(String.format("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u7ec4\u5408\u8bc6\u522b\u5668\uff0c%s", message));
                this.getView().showTipNotification(message);
                OcrControlUtils.setCustomcontrolData((IFormView)this.getView(), (String)custom_key, (String)"tdaBreakOff", (Object)Boolean.TRUE);
                return;
            }
            int fileSizeMax = "operate_test".equalsIgnoreCase(operateKey) ? 5 : 50;
            String domainContextUrl = UrlService.getDomainContextUrl();
            String attUrl = String.format("%s/attachment/upload.do", domainContextUrl);
            ClsCustomVO customVO = new ClsCustomVO(operateKey, attUrl, classifierId, fileSizeMax);
            switch (eventName) {
                case "init": {
                    customVO.setStatus("init");
                    OcrControlUtils.setCustomcontrolData((IFormView)this.getView(), (String)custom_key, (String)"init", (Object)customVO);
                    break;
                }
                case "operate_test": {
                    fileInfos = JSONArray.parseArray((String)e.getEventArgs(), ClsTargetFile.class);
                    ClsTaskDataVO claData = ClassifierOperateTest.instance.operate(fileInfos, classifierId);
                    customVO.setStatus(custom_init_status_n);
                    customVO.setClaData(claData);
                    OcrControlUtils.setCustomcontrolData((IFormView)this.getView(), (String)custom_key, (String)"operate_test", (Object)customVO);
                    break;
                }
                default: {
                    throw new KDBizException("\u7ec4\u5408\u8bc6\u522b-\u975e\u6cd5\u6307\u4ee4\u64cd\u4f5c");
                }
            }
        }
        catch (Exception ex) {
            String message = ResManager.loadKDString((String)(eventName + " \u7ec4\u5408\u8bc6\u522b\u5f02\u5e38:" + ex.getMessage()), (String)"ClassifierOperatePlugin_1", (String)"ai-cvp-plugin", (Object[])new Object[0]);
            LOGGER.error("\u7ec4\u5408\u8bc6\u522b-\u81ea\u5b9a\u4e49\u63a7\u4ef6\u533a\u5f02\u5e38 \u64cd\u4f5c:" + eventName + "\u64cd\u4f5c\u5f02\u5e38 " + ex.getMessage(), (Throwable)ex);
            HashMap<String, String> toWeb = new HashMap<String, String>(3);
            toWeb.put("message", message);
            OcrControlUtils.setCustomcontrolData((IFormView)this.getView(), (String)custom_key, (String)"error", toWeb);
        }
    }
}

