/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.plugin.tda;

import com.alibaba.fastjson.JSON;
import java.util.EventObject;
import java.util.Map;
import kd.ai.cvp.common.Enum.VisualTypeEnum;
import kd.ai.cvp.entity.tda.InitCustomVO;
import kd.ai.cvp.task.TdaCancelTaskService;
import kd.ai.cvp.task.TdaFlushDataExcutors;
import kd.ai.cvp.utils.LicenseUtils;
import kd.ai.cvp.utils.OcrControlUtils;
import kd.ai.cvp.utils.TdaUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;

public class TdaInfoPlugin
extends AbstractFormPlugin
implements ClickListener,
UploadListener {
    private static Log logger = LogFactory.getLog(TdaInfoPlugin.class);
    private static final String PAGE_ID = "pageId";

    public void customEvent(CustomEventArgs e) {
        IFormView view = this.getView();
        TdaUtils.tdaCustomOpreat((IFormView)view, (String)e.getEventName(), (String)e.getEventArgs());
    }

    public void beforeClosed(BeforeClosedEvent e) {
        IPageCache pageCache;
        String contractAttStr;
        super.beforeClosed(e);
        String bigObjKey = "contractAtt";
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Object parentPageId = formShowParameter.getCustomParam(PAGE_ID);
        IFormView parentView = null;
        if (parentPageId != null) {
            parentView = view.getViewNoPlugin(String.valueOf(parentPageId));
        }
        if (parentView != null && !StringUtils.isEmpty((String)(contractAttStr = (pageCache = parentView.getPageCache()).getBigObject(bigObjKey)))) {
            logger.info("\u6e05\u7406bigObj...");
            pageCache.removeBigObject(bigObjKey);
        }
        pageCache = this.getView().getPageCache();
        String pageId = pageCache.getPageId();
        String testTaskId = pageCache.get("tdaTestTaskId_".concat(pageId));
        TdaCancelTaskService.asyncCancelTdaTask((RequestContext)RequestContext.get(), (String)testTaskId, (VisualTypeEnum)VisualTypeEnum.DIFF_COMPARISON);
    }

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        try {
            LicenseUtils.checkLicenseAndDosage((IFormView)view);
            this.initCustomData(view);
            TdaFlushDataExcutors.excuteTask((RequestContext)RequestContext.get());
        }
        catch (KDBizException ex) {
            logger.error("\u8bf7\u6c42\u68c0\u67e5\u8bb8\u53ef\u5931\u8d25", (Throwable)ex);
            view.showErrorNotification(String.format("\u8bf7\u6c42\u5931\u8d25\uff0c%s", ex.getMessage()));
        }
        catch (Exception e1) {
            logger.error("\u8bb8\u53ef\u68c0\u67e5\u5931\u8d25", (Throwable)e1);
            view.showErrorNotification(String.format("\u8bf7\u6c42\u5931\u8d25\uff0c%s", e1.getMessage()));
        }
    }

    private void initCustomData(IFormView view) {
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Object billid = formShowParameter.getCustomParam("billid");
        Object tdaOperateType = formShowParameter.getCustomParam("tda_operate_type");
        long planId = (Long)formShowParameter.getCustomParam("tda_plan_id");
        Object baseFileObj = formShowParameter.getCustomParam("baseFile");
        Object compareFileObj = formShowParameter.getCustomParam("compareFile");
        if (tdaOperateType != null && !tdaOperateType.toString().equals("tda_show_task")) {
            String domainContextUrl = UrlService.getDomainContextUrl();
            String attUrl = String.format("%s/attachment/upload.do", domainContextUrl);
            InitCustomVO initCustomVO = new InitCustomVO(String.valueOf(tdaOperateType), attUrl, String.valueOf(billid));
            if (!ObjectUtils.isEmpty((Object)baseFileObj) && !ObjectUtils.isEmpty((Object)compareFileObj)) {
                Map baseMap = (Map)JSON.parseObject((String)baseFileObj.toString(), Map.class);
                initCustomVO.setBaseFile(baseMap);
                Map compareMap = (Map)JSON.parseObject((String)compareFileObj.toString(), Map.class);
                initCustomVO.setCompareFile(compareMap);
            }
            initCustomVO.setPlanId(planId);
            OcrControlUtils.setTdaOrTieCustomcontrolData((IFormView)view, (String)"customtda", (String)"init", (Object)initCustomVO);
        }
    }
}

