/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.plugin.tda;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.ai.cvp.entity.tda.TdaPlanIgnore;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillModel;

public class TdaPlanPlugin
extends AbstractBillPlugIn
implements ItemClickListener,
ClickListener {
    private static final String KEY_SAVE = "save";
    private static final String ITEM_ADD = "additem";
    private static final String ITEM_UPDATE = "updateitem";
    private static final String ITEM_DELETE = "deleteitem";
    private static final String ITEM_BIZDIFF = "bizdiffitem";
    private static final String ITEM_COMMON = "commonitem";
    private static final String KEY_MULIGNORE = "mulignore";
    private static final String ITEM_FOOTERITEM = "footeritem";
    private static final String ITEM_HEADERITEM = "headeritem";
    private static final String ITEM_CONTENTSITEM = "contentsitem";
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String KEY_SUPPORTENTITY = "supportentity";
    private static final String KEY_SHOWLEVEL2 = "showlevel2";
    private static Log logger = LogFactory.getLog(TdaPlanPlugin.class);

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        OpenStyle openStyle = e.getFormShowParameter().getOpenStyle();
        openStyle.setShowType(ShowType.Modal);
    }

    public void afterLoadData(EventObject e) {
        IDataModel model = this.getModel();
        this.setDefaultValue(model);
    }

    private List<DynamicObject> createDefaultEntryRow() {
        ArrayList<DynamicObject> objs = new ArrayList<DynamicObject>();
        EntryProp entryProp = (EntryProp)this.getModel().getDataEntityType().getProperties().get((Object)KEY_ENTRYENTITY);
        EntryType entryType = (EntryType)entryProp.getItemType();
        DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
        row.set("difftype", (Object)"total");
        row.set("showname", (Object)"\u5168\u90e8");
        objs.add(row);
        DynamicObject row2 = new DynamicObject((DynamicObjectType)entryType);
        row2.set("difftype", (Object)"entityDiff");
        row2.set("showname", (Object)"\u8981\u7d20\u5dee\u5f02");
        objs.add(row2);
        DynamicObject row3 = new DynamicObject((DynamicObjectType)entryType);
        row3.set("difftype", (Object)"commonDiff");
        row3.set("showname", (Object)"\u666e\u901a\u5dee\u5f02");
        objs.add(row3);
        return objs;
    }

    private void setDefaultValue(IDataModel model) {
        List ignoreList;
        List ignoreKeys;
        DynamicObject planObj = model.getDataEntity();
        String mulIgnore = planObj.getString(KEY_MULIGNORE);
        if (StringUtils.isNotEmpty((CharSequence)mulIgnore) && !(ignoreKeys = TdaPlanIgnore.getKeyListByValue(ignoreList = Arrays.stream(mulIgnore.split(",")).filter(StringUtils::isNotEmpty).map(Integer::parseInt).collect(Collectors.toList()))).isEmpty()) {
            for (String ignoreKey : ignoreKeys) {
                model.setValue(ignoreKey, (Object)true);
            }
        }
        model.setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        IDataEntityProperty property = e.getProperty();
        String key = property.getName();
        for (ChangeData changeData : changeSet = e.getChangeSet()) {
            if (!key.equals(KEY_SUPPORTENTITY)) continue;
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
            if (!(changeData.getNewValue() instanceof Boolean) || !changeData.getNewValue().equals(Boolean.TRUE) || entryEntity.size() != 0) continue;
            this.createDefaultEntryRows();
        }
    }

    private void createDefaultEntryRows() {
        IDataModel model = this.getModel();
        List<DynamicObject> defaultEntryRow = this.createDefaultEntryRow();
        model.batchCreateNewEntryRow(KEY_ENTRYENTITY, defaultEntryRow.size());
        for (int i = 0; i < defaultEntryRow.size(); ++i) {
            DynamicObject object = defaultEntryRow.get(i);
            if (object == null) continue;
            model.setValue("difftype", (Object)object.getString("difftype"), i);
            model.setValue("showname", (Object)object.getString("showname"), i);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterBindData(e);
        BillModel model = (BillModel)e.getSource();
        this.setDefaultValue((IDataModel)model);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        IDataModel model = this.getModel();
        try {
            if (source instanceof Save) {
                if (model.getValue(KEY_SUPPORTENTITY).equals(Boolean.FALSE)) {
                    model.deleteEntryData(KEY_ENTRYENTITY);
                }
                this.setHideFieldValue(model);
            }
        }
        catch (Exception e) {
            logger.error("\u5dee\u5f02\u5206\u6790\u65b9\u6848\u4fdd\u5b58\u6821\u9a8c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (Throwable)e);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5dee\u5f02\u5206\u6790\u65b9\u6848\u4fdd\u5b58\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"TdaPlanPlugin_001", (String)"ai-cvp-plugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void setHideFieldValue(IDataModel model) {
        Object footerValue = model.getValue(ITEM_FOOTERITEM);
        Object headerValue = model.getValue(ITEM_HEADERITEM);
        Object contentValue = model.getValue(ITEM_CONTENTSITEM);
        StringBuilder ignoreSb = new StringBuilder();
        if (((Boolean)footerValue).booleanValue()) {
            ignoreSb.append("1,");
        }
        if (((Boolean)headerValue).booleanValue()) {
            ignoreSb.append("2,");
        }
        if (((Boolean)contentValue).booleanValue()) {
            ignoreSb.append("3,");
        }
        model.setValue(KEY_MULIGNORE, (Object)ignoreSb.toString());
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (KEY_SAVE.equals(operateKey) && args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                parentView.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"TdaPlanPlugin_001", (String)"ai-cvp-plugin", (Object[])new Object[0]));
            }
            this.getView().close();
        }
    }
}

