/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.webapi;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.ai.cvp.common.ClsCommon;
import kd.ai.cvp.common.Enum.AlgoApiEnum;
import kd.ai.cvp.common.Enum.SourceTypeEnum;
import kd.ai.cvp.common.Enum.StorageTypeEnum;
import kd.ai.cvp.core.op.ClassifierOperateMService;
import kd.ai.cvp.entity.ClassifierRecVO;
import kd.ai.cvp.entity.ClassifierVO;
import kd.ai.cvp.entity.classifier.ClsMServiceSingleData;
import kd.ai.cvp.entity.classifier.ClsTargetFile;
import kd.ai.cvp.utils.LicenseUtils;
import kd.ai.cvp.utils.OcrControlUtils;
import kd.ai.cvp.utils.StreamHandleUtils;
import kd.ai.cvp.webapi.CvpCustomApi;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiGetMapping;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.custom.annotation.ApiRequestBody;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

@ApiController(value="cvp", desc="\u82cd\u7a79\u89c6\u89c9\u8bc6\u522b\u670d\u52a1\u7ec4\u5408\u8bc6\u522b\u5668\u5206\u7c7b\u8bc6\u522b\u63a5\u53e3")
@ApiMapping(value="/classifier")
public class OcrClassifierWebApiPlugin {
    private static final Log logger = LogFactory.getLog(OcrClassifierWebApiPlugin.class);
    private static final String PLUGIN_NAME_PREFFIX = "OcrClassifierWebApiPlugin_";
    private static final String APP_SUFFIX = "ai-cvp-plugin";

    @ApiGetMapping(value="/queryAllClassifier", desc="\u7ec4\u5408\u8bc6\u522b\u5668\u67e5\u8be2")
    public CustomApiResult<List<ClassifierVO>> queryAllClassifier() {
        logger.info("\u5f00\u59cb\u8fdb\u884c\u7ec4\u5408\u8bc6\u522b\u5668\u4fe1\u606f\u67e5\u8be2");
        String traceId = RequestContext.get().getTraceId();
        ArrayList classifierList = new ArrayList();
        try {
            QFilter statusFilter = new QFilter("status", "=", (Object)"C");
            DynamicObject[] classifierObj = BusinessDataServiceHelper.load((String)"cvp_cls_info", (String)"id,number,name", (QFilter[])new QFilter[]{statusFilter});
            if (classifierObj != null) {
                classifierList.addAll(Arrays.stream(classifierObj).map(classifier -> {
                    ClassifierVO classifierVO = new ClassifierVO();
                    String name = classifier.getString("name");
                    Object pkValue = classifier.getPkValue();
                    String number = classifier.getString("number");
                    classifierVO.setClassifierId(pkValue + "");
                    classifierVO.setClassifierName(name);
                    classifierVO.setClassifierNumber(number);
                    return classifierVO;
                }).collect(Collectors.toList()));
            }
            return CvpCustomApi.success(classifierList, traceId);
        }
        catch (Exception e) {
            logger.error("\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
            return CvpCustomApi.fail("40000", kd.bos.util.StringUtils.isEmpty((String)e.getMessage()) ? ResManager.loadKDString((String)"\u8bf7\u6c42\u5f02\u5e38\uff0c\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u95ee\u9898\u3002", (String)"OcrClassifierWebApiPlugin_002", (String)APP_SUFFIX, (Object[])new Object[0]) : e.getMessage(), traceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiPostMapping(value="/singleClassify", desc="\u5355\u6587\u4ef6\u5206\u7c7b\u8bc6\u522b")
    public CustomApiResult<ClsMServiceSingleData> singleClassify(@ApiRequestBody ClassifierRecVO vo) {
        String message;
        CustomApiResult fileSize;
        String traceId = RequestContext.get().getTraceId();
        if (vo == null) {
            return CvpCustomApi.fail(String.valueOf(40002), ResManager.loadKDString((String)"\u8bf7\u6c42\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u8c03\u7528\u4fe1\u606f\u662f\u5426\u6b63\u5e38\u3002", (String)PLUGIN_NAME_PREFFIX.concat("001"), (String)APP_SUFFIX, (Object[])new Object[0]), traceId);
        }
        logger.info("\u7ec4\u5408\u8bc6\u522b\u5668\u8bc6\u522b\u63a5\u53e3OpenApi\u5f00\u59cb\uff0c\u5165\u53c2\uff1a{},traceId:{}", (Object)JSON.toJSONString((Object)vo), (Object)traceId);
        String templateNumber = "";
        boolean status = false;
        try {
            Map<String, Object> map = this.validParam(vo);
            String fileName = (String)map.get("fileName");
            String fileType = (String)map.get("fileType");
            fileSize = map.get("fileSize");
            StorageTypeEnum storageType = (StorageTypeEnum)map.get("storageType");
            String filePath = (String)map.get("filePath");
            long classifierId = Long.parseLong(map.get("classifierId").toString());
            String businessObject = vo.getBusinessObject();
            ClsTargetFile clsTargetFile = new ClsTargetFile(filePath, UUID.randomUUID().toString().replace("-", ""), fileName, fileType, String.valueOf(fileSize), storageType);
            LicenseUtils.checkLicense((int)1, (String)"", (String)traceId);
            long beginTime = System.currentTimeMillis();
            ClsMServiceSingleData operate = ClassifierOperateMService.instance.operate(clsTargetFile, classifierId);
            String errorCode = operate.getErrorCode();
            templateNumber = operate.getTemplateNumber();
            this.setApiInfo(kd.bos.util.StringUtils.isEmpty((String)businessObject) ? "cvp_template" : businessObject, templateNumber, kd.bos.util.StringUtils.isNotEmpty((String)errorCode) ? errorCode : "0", "C", System.currentTimeMillis() - beginTime);
            if (kd.bos.util.StringUtils.isNotEmpty((String)errorCode)) {
                logger.error(String.format("\u89c6\u89c9\u8bc6\u522b\u3010\u7ec4\u5408\u8bc6\u522b\u5668\u3011OPENAPI\u8c03\u7528\uff0c\u5206\u7c7b\u8c03\u7528\u5f02\u5e38: %s", operate.toString()));
                String progress = operate.getProgress();
                CustomApiResult customApiResult = CvpCustomApi.fail(errorCode, progress, traceId);
                return customApiResult;
            }
            status = true;
            CustomApiResult<ClsMServiceSingleData> customApiResult = CvpCustomApi.success(operate, traceId);
            return customApiResult;
        }
        catch (KDBizException kde) {
            message = String.format("\u89c6\u89c9\u8bc6\u522b\u3010\u7ec4\u5408\u8bc6\u522b\u5668\u3011\u5fae\u670d\u52a1API\u8c03\u7528\u5f02\u5e38\uff0c%s", kde.getMessage());
            logger.error(message, (Throwable)kde);
            ErrorCode code = kde.getErrorCode();
            if (code != null) {
                fileSize = CvpCustomApi.fail(code.getCode(), code.getMessage(), traceId);
                return fileSize;
            }
            fileSize = CvpCustomApi.fail(String.valueOf(40000), message, traceId);
            return fileSize;
        }
        catch (Exception e) {
            message = String.format("\u89c6\u89c9\u8bc6\u522b\u3010\u7ec4\u5408\u8bc6\u522b\u5668\u3011\u5fae\u670d\u52a1API\u8c03\u7528\u5f02\u5e38\uff0c%s", e.getMessage());
            logger.error(message, (Throwable)e);
            CustomApiResult customApiResult = CvpCustomApi.fail(String.valueOf(40000), message, traceId);
            return customApiResult;
        }
        finally {
            String api = AlgoApiEnum.getValue((String)templateNumber);
            if (kd.bos.util.StringUtils.isEmpty((String)api)) {
                LicenseUtils.ensureCallNumToAlgo((boolean)status, (String)traceId, (SourceTypeEnum)SourceTypeEnum.SELFDESIGNTEMPLATE);
            } else {
                LicenseUtils.ensureCallNumToAlgo((boolean)status, (String)traceId, (SourceTypeEnum)SourceTypeEnum.PRESETTEMPLATE);
            }
            logger.info("\u89c6\u89c9\u8bc6\u522b\u3010\u7ec4\u5408\u8bc6\u522b\u5668\u3011openAPI\u8c03\u7528-\u8bb8\u53ef\u6838\u9500 \u7ed3\u675f");
        }
    }

    public void setApiInfo(String businessObject, String templateNumber, String errorCode, String invokeType, long callTime) {
        logger.info(String.format("\u6a21\u7248\uff1a%s  ,\u8bb0\u5f55\u82cd\u7a79-API \u8c03\u7528\u4fe1\u606f", templateNumber));
        RequestContext rc = RequestContext.get();
        DynamicObject template = OcrControlUtils.getBindingObjCacheByNumber((String)"cvp_template", (String)templateNumber);
        DynamicObject apiInfo = ORM.create().newDynamicObject("cvp_api_invoke_info");
        String businessName = MetadataServiceHelper.getDataEntityType((String)businessObject).getDisplayName().getLocaleValue();
        apiInfo.set("createdate", (Object)new Date());
        apiInfo.set("calltime", (Object)callTime);
        apiInfo.set("errorcode", (Object)errorCode);
        apiInfo.set("traceid", (Object)rc.getTraceId());
        apiInfo.set("templateid", template != null ? template.getPkValue() : Integer.valueOf(0));
        apiInfo.set("templatename", (Object)(template != null ? template.getString("name") : ""));
        apiInfo.set("callobjectid", (Object)businessObject);
        apiInfo.set("callobjectname", (Object)businessName);
        apiInfo.set("userid", (Object)String.valueOf(rc.getCurrUserId()));
        apiInfo.set("username", (Object)rc.getUserName());
        apiInfo.set("status", (Object)invokeType);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{apiInfo});
    }

    private Map<String, Object> validParam(ClassifierRecVO vo) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String fileUrl = vo.getFileUrl();
        String classifierNumber = vo.getClassifierNumber();
        String businessObject = vo.getBusinessObject();
        if (kd.bos.util.StringUtils.isEmpty((String)fileUrl)) {
            throw new KDBizException(new ErrorCode("40002", ResManager.loadKDString((String)"\u5fc5\u8981\u53c2\u6570\uff1a\u5f85\u5206\u7c7b\u8bc6\u522b\u6587\u4ef6\u8def\u5f84[fileUrl]\u4e3a\u7a7a\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u8bd5\u3002", (String)PLUGIN_NAME_PREFFIX.concat("003"), (String)APP_SUFFIX, (Object[])new Object[0])), new Object[0]);
        }
        if (kd.bos.util.StringUtils.isEmpty((String)classifierNumber)) {
            throw new KDBizException(new ErrorCode("40002", ResManager.loadKDString((String)"\u5fc5\u8981\u53c2\u6570\uff1a\u7ec4\u5408\u8bc6\u522b\u5668\u7f16\u7801[classifierNumber]\u4e3a\u7a7a\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u8bd5\u3002", (String)PLUGIN_NAME_PREFFIX.concat("004"), (String)APP_SUFFIX, (Object[])new Object[0])), new Object[0]);
        }
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter qFilter = new QFilter("number", "=", (Object)classifierNumber);
        DynamicObject classifierObj = BusinessDataServiceHelper.loadSingle((String)"cvp_cls_info", (String)"id,number,name", (QFilter[])new QFilter[]{statusFilter, qFilter});
        if (classifierObj == null) {
            throw new KDBizException(new ErrorCode("40002", ResManager.loadKDString((String)"\u7ec4\u5408\u8bc6\u522b\u5668\u7f16\u7801[classifierNumber]\u67e5\u8be2\u4e0d\u5230\u6709\u6548\u6570\u636e\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u8bd5\u3002", (String)PLUGIN_NAME_PREFFIX.concat("005"), (String)APP_SUFFIX, (Object[])new Object[0])), new Object[0]);
        }
        map.put("classifierId", classifierObj.getPkValue() + "");
        if (kd.bos.util.StringUtils.isNotEmpty((String)businessObject)) {
            try {
                MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)businessObject);
                if (entityType == null) {
                    throw new KDBizException("\u6807\u8bc6\u4e3a\u7a7a");
                }
            }
            catch (Exception e) {
                throw new KDBizException(new ErrorCode("40002", ResManager.loadKDString((String)"\u53c2\u6570:businessObject \u4e1a\u52a1\u5bf9\u8c61\u6807\u8bc6 \u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728,\u8bf7\u4f20\u6709\u6548\u6807\u8bc6 ", (String)PLUGIN_NAME_PREFFIX.concat("006"), (String)APP_SUFFIX, (Object[])new Object[0])), new Object[0]);
            }
        }
        map.putAll(this.validFile(fileUrl));
        return map;
    }

    private Map<String, Object> validFile(String fileUrl) {
        StorageTypeEnum type;
        long fileSize;
        String fileType;
        String fileName;
        String filePath;
        HashMap<String, Object> map = new HashMap<String, Object>();
        FileService service = FileServiceFactory.getAttachmentFileService();
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        boolean attaExist = service.exists(fileUrl);
        boolean tempExist = false;
        try {
            if (!attaExist) {
                tempExist = tempFileCache.exists(fileUrl);
            }
        }
        catch (KDException e) {
            ErrorCode errorCode = e.getErrorCode();
            if (errorCode == BosErrorCode.downloadFailed || errorCode == BosErrorCode.fileIsExistFailed) {
                logger.warn("\u4f20\u9012\u7684\u6587\u4ef6url\u65e0\u6cd5\u6821\u9a8c\u901a\u8fc7\u4e34\u65f6\u6587\u4ef6", (Throwable)e);
            }
            throw new KDBizException(new ErrorCode("40002", ResManager.loadKDString((String)"\u6821\u9a8c\u6587\u4ef6\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"OcrServiceImpl_203", (String)APP_SUFFIX, (Object[])new Object[0])), new Object[0]);
        }
        catch (Exception ee) {
            throw new KDBizException(new ErrorCode("40002", ResManager.loadKDString((String)"\u6821\u9a8c\u6587\u4ef6\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"OcrServiceImpl_203", (String)APP_SUFFIX, (Object[])new Object[0])), new Object[0]);
        }
        if (!attaExist && !tempExist) {
            throw new KDBizException(new ErrorCode("40002", ResManager.loadKDString((String)"\u6821\u9a8c\u6587\u4ef6\u5f02\u5e38\uff0c\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e\u540e\u91cd\u8bd5\u3002\u82e5\u591a\u6b21\u51fa\u73b0\u672c\u63d0\u793a\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OcrServiceImpl_203", (String)APP_SUFFIX, (Object[])new Object[0])), new Object[0]);
        }
        if (attaExist) {
            filePath = service.getFileServiceExt().getRealPath(fileUrl);
            logger.info("realPath:{}", (Object)filePath);
            fileName = filePath.substring(filePath.lastIndexOf("/") + 1);
            fileType = fileName.substring(fileName.lastIndexOf(".") + 1);
            fileSize = service.getFileSize(fileUrl);
            type = StorageTypeEnum.ATTACHMENT;
        } else {
            type = StorageTypeEnum.TMP;
            filePath = fileUrl;
            InputStream inputStream = tempFileCache.getInputStream(fileUrl);
            byte[] bytes = StreamHandleUtils.copyStream((InputStream)inputStream);
            try {
                fileType = StreamHandleUtils.getFileTypeWithByteArr((byte[])bytes);
                logger.info("\u6587\u4ef6\u7c7b\u578b\u7ed3\u679c\uff1a{}", (Object)fileType);
            }
            catch (IOException e) {
                throw new KDBizException(new ErrorCode("40002", ResManager.loadKDString((String)"\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OcrServiceImpl_206", (String)APP_SUFFIX, (Object[])new Object[0])), new Object[0]);
            }
            if (kd.bos.util.StringUtils.isEmpty((String)fileType)) {
                throw new KDBizException(new ErrorCode("40002", ResManager.loadKDString((String)"\u6587\u4ef6\u7c7b\u578b\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)PLUGIN_NAME_PREFFIX.concat("207"), (String)APP_SUFFIX, (Object[])new Object[0])), new Object[0]);
            }
            fileName = UUID.randomUUID().toString().replace("-", "").concat(".").concat(fileType);
            fileSize = bytes.length;
        }
        if (kd.bos.util.StringUtils.isEmpty((String)fileName)) {
            throw new KDBizException(new ErrorCode("40002", ResManager.loadKDString((String)"\u53c2\u6570:fileName \u6587\u4ef6\u540d \u4e3a\u7a7a ", (String)"OcrClassifierServiceImpl_03", (String)APP_SUFFIX, (Object[])new Object[0])), new Object[0]);
        }
        this.validFileInfo(fileType, fileSize);
        map.put("fileName", fileName);
        map.put("fileType", fileType);
        map.put("fileSize", fileSize);
        map.put("storageType", type);
        map.put("filePath", filePath);
        return map;
    }

    private void validFileInfo(String fileType, long fileSize) {
        String msg = "";
        if (StringUtils.isEmpty((CharSequence)fileType)) {
            msg = ResManager.loadKDString((String)"\u53c2\u6570:fileType \u6587\u4ef6\u7c7b\u578b \u4e3a\u7a7a ", (String)"OcrClassifierServiceImpl_04", (String)APP_SUFFIX, (Object[])new Object[0]);
        } else if (!Arrays.asList(ClsCommon.ViewParam.FILE_ALL_TYPE).contains(fileType)) {
            msg = ResManager.loadKDString((String)"\u53c2\u6570:fileType \u6587\u4ef6\u7c7b\u578b\u53c2\u6570\u6709\u8bef,\u53ef\u652f\u6301\u7684\u7c7b\u578b\uff1ajpg,jpeg,png,pdf", (String)"OcrClassifierServiceImpl_05", (String)APP_SUFFIX, (Object[])new Object[0]);
        } else if ("pdf".equalsIgnoreCase(fileType) && fileSize > 0x800000L) {
            msg = ResManager.loadKDString((String)"\u53c2\u6570:fileSize \u6587\u4ef6\u8d85\u51fa\u9650\u5236\uff0c\u56fe\u7247\u5355\u5f20<=8m ", (String)"OcrClassifierServiceImpl_07", (String)APP_SUFFIX, (Object[])new Object[0]);
        } else if (Arrays.asList(ClsCommon.ViewParam.FILE_IMAGE_TYPE).contains(fileType) && fileSize > 0xA00000L) {
            msg = ResManager.loadKDString((String)"\u53c2\u6570:fileSize \u6587\u4ef6\u8d85\u51fa\u9650\u5236\uff0cpdf\u6587\u5355\u9875\u5927\u5c0f<=10m ", (String)"OcrClassifierServiceImpl_07", (String)APP_SUFFIX, (Object[])new Object[0]);
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)msg)) {
            throw new KDBizException(new ErrorCode("40002", msg), new Object[0]);
        }
    }
}

