/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.webapi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import kd.ai.cvp.entity.AlgoResultData;
import kd.ai.cvp.entity.ie.ComplexExtractVO;
import kd.ai.cvp.entity.ie.CtieResultVO;
import kd.ai.cvp.entity.ie.TieOpenAPIVO;
import kd.ai.cvp.entity.ie.TieViewResult;
import kd.ai.cvp.mservice.OcrServiceImpl;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiGetMapping;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.custom.annotation.ApiRequestBody;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.util.StringUtils;

@ApiController(value="cvp", desc="\u82cd\u7a79\u63d0\u53d6\u6587\u6863\u5185\u5bb9")
@ApiMapping(value="/docExtract")
public class OcrExtractDocInfoController {
    private static final Log logger = LogFactory.getLog(OcrExtractDocInfoController.class);

    @ApiPostMapping(value="/complexDocExtract", desc="\u590d\u6742\u6587\u6863\u63d0\u53d6\u63a5\u53e3")
    public CustomApiResult<Long> extractDoc(@ApiRequestBody ComplexExtractVO vo) {
        String traceId = RequestContext.get().getTraceId();
        if (vo == null) {
            return CustomApiResult.fail((String)String.valueOf(40002), (String)ResManager.loadKDString((String)"\u8bf7\u6c42\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u8c03\u7528\u4fe1\u606f\u662f\u5426\u6b63\u5e38\u3002", (String)"OcrExtractDocInfoController_0", (String)"ai-cvp-plugin", (Object[])new Object[0]));
        }
        logger.info("\u89c6\u89c9\u8bc6\u522b-\u590d\u6742\u6587\u6863\u63d0\u53d6\u63a5\u53e3\u5f00\u59cb\uff0c\u5165\u53c2\uff1a{},traceId:{}", (Object)JSON.toJSONString((Object)vo), (Object)traceId);
        String fileUrl = vo.getFileUrl();
        boolean extractTable = vo.getExtractTable();
        boolean extractImageInDoc = vo.getExtractImageInDoc();
        String tableOutType = vo.getTableOutType();
        CustomApiResult resultApi = CustomApiResult.fail((String)"40000", (String)ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"OcrExtractDocInfoController_002", (String)"ai-cvp-plugin", (Object[])new Object[0]));
        try {
            JSONObject jsonObject;
            OcrServiceImpl ocrService = new OcrServiceImpl();
            String result = ocrService.complexDocExtractForOpanAPI(fileUrl, extractTable, extractImageInDoc, tableOutType);
            if (StringUtils.isNotEmpty((String)result) && (jsonObject = JSON.parseObject((String)result)) != null && jsonObject.getInteger("errorCode") != null) {
                Integer errorCode = jsonObject.getInteger("errorCode");
                if (errorCode != 0) {
                    String description = jsonObject.getString("description");
                    resultApi = CustomApiResult.fail((String)(errorCode + ""), (String)description);
                } else {
                    Object data = jsonObject.get((Object)"data");
                    resultApi = CustomApiResult.success((Object)Long.parseLong(data.toString()));
                    resultApi.setMessage("\u8bf7\u6c42\u6210\u529f");
                }
            }
        }
        catch (KDBizException kde) {
            logger.error("\u5dee\u5f02\u4e1a\u52a1\u5f02\u5e38", (Throwable)kde);
            ErrorCode errorCode = kde.getErrorCode();
            if (errorCode != null) {
                String message = errorCode.getMessage();
                String code = errorCode.getCode();
                resultApi.setMessage(message);
                resultApi.setErrorCode(code);
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5f02\u5e38", (Throwable)e);
            resultApi.setMessage(e.getMessage());
        }
        return resultApi;
    }

    @ApiGetMapping(value="/queryExtractResult", desc="\u67e5\u8be2\u63d0\u53d6\u7ed3\u679c\u63a5\u53e3")
    public CustomApiResult<CtieResultVO> queryExtractResult(@ApiParam(value="\u4efb\u52a1id") @ApiParam(value="\u4efb\u52a1id") String taskId) {
        String traceId = RequestContext.get().getTraceId();
        logger.info("\u89c6\u89c9\u8bc6\u522b-\u590d\u6742\u6587\u6863\u63d0\u53d6-\u67e5\u8be2\u63a5\u53e3\u5f00\u59cb\uff0c\u5165\u53c2\uff1a{},traceId:{}", (Object)taskId, (Object)traceId);
        CustomApiResult resultApi = CustomApiResult.fail((String)"40000", (String)ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"OcrExtractDocInfoController_002", (String)"ai-cvp-plugin", (Object[])new Object[0]));
        try {
            JSONObject jsonObject;
            OcrServiceImpl ocrService = new OcrServiceImpl();
            String result = ocrService.queryComplexDocExtractInfo(taskId);
            if (StringUtils.isNotEmpty((String)result) && (jsonObject = JSON.parseObject((String)result)) != null && jsonObject.getInteger("errorCode") != null) {
                Integer errorCode = jsonObject.getInteger("errorCode");
                if (errorCode != 0) {
                    String description = jsonObject.getString("description");
                    resultApi = CustomApiResult.fail((String)(errorCode + ""), (String)description);
                } else {
                    CtieResultVO data = (CtieResultVO)JSON.parseObject((String)jsonObject.get((Object)"data").toString(), CtieResultVO.class);
                    resultApi = CustomApiResult.success((Object)data);
                }
            }
        }
        catch (KDBizException kde) {
            logger.error("\u5dee\u5f02\u4e1a\u52a1\u5f02\u5e38", (Throwable)kde);
            ErrorCode errorCode = kde.getErrorCode();
            if (errorCode != null) {
                String message = errorCode.getMessage();
                String code = errorCode.getCode();
                resultApi.setMessage(message);
                resultApi.setErrorCode(code);
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5f02\u5e38", (Throwable)e);
            resultApi.setMessage(e.getMessage());
        }
        return resultApi;
    }

    @ApiPostMapping(value="/createTieTask", desc="\u521b\u5efa\u4fe1\u606f\u63d0\u53d6\u4efb\u52a1")
    public CustomApiResult<Long> createTieTask(@ApiRequestBody TieOpenAPIVO vo) {
        String traceId = RequestContext.get().getTraceId();
        if (vo == null) {
            return CustomApiResult.fail((String)String.valueOf(40002), (String)ResManager.loadKDString((String)"\u8bf7\u6c42\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u8c03\u7528\u4fe1\u606f\u662f\u5426\u6b63\u5e38\u3002", (String)"OcrExtractDocInfoController_0", (String)"ai-cvp-plugin", (Object[])new Object[0]));
        }
        logger.info("\u89c6\u89c9\u8bc6\u522b-\u4fe1\u606f\u63d0\u53d6openapi\u521b\u5efa\u4efb\u52a1\u63a5\u53e3\u5f00\u59cb\uff0c\u5165\u53c2\uff1a{},traceId:{}", (Object)JSON.toJSONString((Object)vo), (Object)traceId);
        CustomApiResult resultApi = CustomApiResult.fail((String)"40000", (String)ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"OcrExtractDocInfoController_002", (String)"ai-cvp-plugin", (Object[])new Object[0]));
        try {
            AlgoResultData algoResultData;
            OcrServiceImpl ocrService = new OcrServiceImpl();
            String tieTask = ocrService.createTieTask4OpenAPI(vo.getFileUrl(), vo.getPageListStr(), vo.getPlanNumber());
            if (StringUtils.isNotEmpty((String)tieTask) && (algoResultData = (AlgoResultData)JSON.parseObject((String)tieTask, AlgoResultData.class)) != null) {
                int errorCode = algoResultData.getErrorCode();
                Object data = algoResultData.getData();
                String requestId = algoResultData.getRequestId();
                String description = algoResultData.getDescription();
                if (errorCode != 0) {
                    resultApi = CustomApiResult.fail((String)(errorCode + ""), (String)(StringUtils.isNotEmpty((String)description) ? description : ResManager.loadKDString((String)"\u8bf7\u6c42\u5f02\u5e38\uff0c\u82e5\u591a\u6b21\u51fa\u73b0\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OcrExtractDocInfoController_001", (String)"ai-cvp-plugin", (Object[])new Object[0])));
                } else {
                    JSONObject jsonObject = JSON.parseObject((String)data.toString());
                    String taskId = jsonObject.getString("taskId");
                    resultApi = CustomApiResult.success((Object)Long.parseLong(taskId));
                    resultApi.setMessage("\u8bf7\u6c42\u6210\u529f");
                }
            }
        }
        catch (KDBizException kde) {
            logger.error("\u521b\u5efa\u4fe1\u606f\u63d0\u53d6\u4e1a\u52a1\u5f02\u5e38", (Throwable)kde);
            ErrorCode errorCode = kde.getErrorCode();
            if (errorCode != null) {
                String message = errorCode.getMessage();
                String code = errorCode.getCode();
                resultApi.setMessage(message);
                resultApi.setErrorCode(code);
            }
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u4efb\u52a1\u5f02\u5e38", (Throwable)e);
            resultApi.setMessage(e.getMessage());
        }
        return resultApi;
    }

    @ApiGetMapping(value="/queryTieTaskResult", desc="\u67e5\u8be2\u4fe1\u606f\u63d0\u53d6\u7ed3\u679c")
    public CustomApiResult<TieViewResult> queryTieTask(@ApiParam(value="\u4efb\u52a1id") @ApiParam(value="\u4efb\u52a1id") String taskId) {
        String traceId = RequestContext.get().getTraceId();
        logger.info("\u89c6\u89c9\u8bc6\u522b-\u4fe1\u606f\u63d0\u53d6-\u67e5\u8be2\u63a5\u53e3\u5f00\u59cb\uff0c\u5165\u53c2\uff1a{},traceId:{}", (Object)taskId, (Object)traceId);
        CustomApiResult resultApi = CustomApiResult.fail((String)"40000", (String)ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"OcrExtractDocInfoController_002", (String)"ai-cvp-plugin", (Object[])new Object[0]));
        try {
            JSONObject jsonObject;
            OcrServiceImpl ocrService = new OcrServiceImpl();
            String result = ocrService.queryTieTaskResult(taskId);
            if (StringUtils.isNotEmpty((String)result) && (jsonObject = JSON.parseObject((String)result)) != null && jsonObject.getInteger("errorCode") != null) {
                Integer errorCode = jsonObject.getInteger("errorCode");
                if (errorCode != 0) {
                    String description = jsonObject.getString("description");
                    resultApi = CustomApiResult.fail((String)(errorCode + ""), (String)description);
                } else {
                    TieViewResult data = (TieViewResult)JSON.parseObject((String)jsonObject.get((Object)"data").toString(), TieViewResult.class);
                    resultApi = CustomApiResult.success((Object)data);
                }
            }
        }
        catch (KDBizException kde) {
            logger.error("\u67e5\u8be2\u4e1a\u52a1\u5f02\u5e38", (Throwable)kde);
            ErrorCode errorCode = kde.getErrorCode();
            if (errorCode != null) {
                String message = errorCode.getMessage();
                String code = errorCode.getCode();
                resultApi.setMessage(message);
                resultApi.setErrorCode(code);
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5f02\u5e38", (Throwable)e);
            resultApi.setMessage(e.getMessage());
        }
        return resultApi;
    }
}

