/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.common.Enum;

import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public enum TableOutputTypeEnum {
    JSON("json"),
    MARKDOWN("markdown");

    private static Log logger;
    private String type;

    private TableOutputTypeEnum(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public static String getOutputType(String customType) {
        if (StringUtils.isEmpty((CharSequence)customType)) {
            return "json";
        }
        if (customType.contains("\uff0c")) {
            customType = customType.replace("\uff0c", ",");
        }
        String[] split = customType.split(",");
        StringBuilder sb = new StringBuilder();
        for (String cusType : split) {
            if (!StringUtils.isNotEmpty((CharSequence)cusType)) continue;
            try {
                for (TableOutputTypeEnum value : TableOutputTypeEnum.values()) {
                    if (!value.getType().equalsIgnoreCase(cusType)) continue;
                    sb.append(value.getType()).append(",");
                }
            }
            catch (IllegalArgumentException e) {
                logger.error("\u7528\u6237\u8f93\u5165\u4e0d\u5b58\u5728\u7684\u7c7b\u578b,{}", (Object)cusType);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)sb.toString())) {
            return sb.substring(0, sb.lastIndexOf(","));
        }
        return "";
    }

    static {
        logger = LogFactory.getLog(TableOutputTypeEnum.class);
    }
}

