/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.core.cls;

import com.alibaba.fastjson.JSON;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kd.ai.cvp.common.Enum.StorageTypeEnum;
import kd.ai.cvp.core.cls.ClassifierProxy;
import kd.ai.cvp.entity.classifier.ClsAlgoResult;
import kd.ai.cvp.entity.classifier.ClsAlgoResultData;
import kd.ai.cvp.entity.classifier.ClsFileInfo;
import kd.ai.cvp.entity.classifier.ClsInfo;
import kd.ai.cvp.entity.classifier.ClsProcessResult;
import kd.ai.cvp.entity.classifier.ClsTargetFile;
import kd.ai.cvp.utils.CvpFileServiceUtils;
import kd.ai.cvp.utils.OcrHttpClientUtils;
import kd.bos.ai.util.JsonUtil;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.pdfbox.io.IOUtils;

public class ClassifierImageImpl
extends ClassifierProxy {
    private static Log LOGGER = LogFactory.getLog(ClassifierImageImpl.class);
    public static final ClassifierImageImpl instance = new ClassifierImageImpl();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ClsProcessResult classify(StorageTypeEnum storageType, ClsTargetFile file, List<ClsInfo> classifierInfos, int covertPageMaxSize) {
        try (InputStream fin = CvpFileServiceUtils.getFileIn(storageType, file.getUrl());){
            String imagesId = String.valueOf(DB.genLongId((String)"cvp_classifier"));
            MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
            entityBuilder.setCharset(StandardCharsets.UTF_8);
            entityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            String fileName = String.format("%s.png", imagesId);
            byte[] fileBytes = IOUtils.toByteArray((InputStream)fin);
            String fullUrl = file.getUrl();
            ArrayList<ClsFileInfo> fileInfos = new ArrayList<ClsFileInfo>(1);
            ClsFileInfo clsFileInfo = new ClsFileInfo(file.getFileId(), imagesId, fullUrl, storageType, 1);
            entityBuilder.addPart("acrFiles", (ContentBody)new ByteArrayBody(fileBytes, fileName));
            StringBody stringBody = new StringBody(JsonUtil.encodeToString(classifierInfos), ContentType.create((String)"text/plain", (Charset)Consts.UTF_8));
            entityBuilder.addPart("acrInfos", (ContentBody)stringBody);
            HttpEntity httpEntity = entityBuilder.build();
            StopWatch watch = new StopWatch();
            watch.start();
            String resultStr = OcrHttpClientUtils.kdCloudHttpClientPost("/template/classify", httpEntity);
            ClsAlgoResult algoResult = (ClsAlgoResult)JSON.parseObject((String)resultStr, ClsAlgoResult.class);
            watch.stop();
            fileInfos.add(clsFileInfo);
            ClsAlgoResultData data = algoResult.getData();
            if (0 != algoResult.getErrorCode()) {
                ClsAlgoResultData.ClassifierInfo classifierInfo = new ClsAlgoResultData.ClassifierInfo(imagesId, algoResult.getErrorCode(), algoResult.getDescription());
                data = new ClsAlgoResultData();
                data.getClsFailure().add(classifierInfo);
            }
            LOGGER.info(String.format("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u5206\u7c7b\u5668,\u56fe\u7247\u5206\u7c7b\u4efb\u52a1\u5b8c\u6210\uff0c\u8017\u65f6\uff1a%s\u79d2,\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\uff1a%s", watch.getTime(TimeUnit.SECONDS), resultStr.length() > 200 ? resultStr.substring(0, 199) : resultStr));
            ClsProcessResult clsProcessResult = new ClsProcessResult(fileInfos, data);
            return clsProcessResult;
        }
        catch (Exception ex) {
            String message = ResManager.loadKDString((String)String.format("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u5206\u7c7b\u5668 \u56fe\u7247\u5206\u7c7b\u4efb\u52a1\u5f02: %s", ex.getMessage()), (String)"ClasifierImageImpl_1", (String)"ai-cvp-plugin", (Object[])new Object[0]);
            LOGGER.error(message, (Throwable)ex);
            throw new KDBizException(message);
        }
    }
}

