/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.core.cls;

import java.util.Arrays;
import java.util.List;
import kd.ai.cvp.common.ClsCommon;
import kd.ai.cvp.common.Enum.StorageTypeEnum;
import kd.ai.cvp.core.cls.ClassifierImageImpl;
import kd.ai.cvp.core.cls.ClassifierPDFImpl;
import kd.ai.cvp.core.cls.IClassifierExecutor;
import kd.ai.cvp.entity.classifier.ClsInfo;
import kd.ai.cvp.entity.classifier.ClsProcessResult;
import kd.ai.cvp.entity.classifier.ClsTargetFile;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;

public abstract class ClassifierProxy
implements IClassifierExecutor {
    private static final int default_max_cover_page = 500;

    public static ClsProcessResult execute(StorageTypeEnum storageType, ClsTargetFile file, List<ClsInfo> classifierInfos, int covertPageMaxSize) {
        ClassifierProxy proxy;
        if (covertPageMaxSize <= 0) {
            covertPageMaxSize = 500;
        }
        if ("pdf".equalsIgnoreCase(file.getFileType())) {
            proxy = ClassifierPDFImpl.instance;
        } else if (Arrays.stream(ClsCommon.ViewParam.FILE_IMAGE_TYPE).anyMatch(t -> t.equalsIgnoreCase(file.getFileType()))) {
            proxy = ClassifierImageImpl.instance;
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u6587\u4ef6\u7c7b\u578b\u4e0d\u652f\u6301\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u9700\u8981\u5206\u7c7b\u7684\u6587\u4ef6", (String)"TdaEntityOperate_2", (String)"ai-cvp-plugin", (Object[])new Object[0]));
        }
        return proxy.classify(storageType, file, classifierInfos, covertPageMaxSize);
    }
}

