/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.core.ocr.rec;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import kd.ai.cvp.core.ocr.AbsRec;
import kd.ai.cvp.entity.classifier.param.ClsRecOcrParams;
import kd.ai.cvp.entity.classifier.param.ClsRecParams;
import kd.ai.cvp.utils.OcrHttpClientUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;

public class OcrRecImpl
extends AbsRec {
    private static final Log LOGGER = LogFactory.getLog(OcrRecImpl.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String recognize(ClsRecParams params) {
        String result = null;
        ClsRecOcrParams param = (ClsRecOcrParams)params;
        try (InputStream in = this.getRecIn(param.getStorageType(), param.getFilePath());){
            if (StringUtils.isEmpty((CharSequence)param.getFilePath())) {
                throw new KDBizException("\u5f85\u8bc6\u522b\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setCharset(StandardCharsets.UTF_8);
            builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            String fileName = String.format("%s.png", UUID.randomUUID().toString());
            builder.addBinaryBody("imageFile", in, ContentType.MULTIPART_FORM_DATA, fileName);
            builder.addTextBody("ocrId", param.getOcrId());
            HttpEntity httpEntity = builder.build();
            String string = result = OcrHttpClientUtils.kdCloudHttpClientPost("/template/recognize", httpEntity);
            return string;
        }
        catch (Exception e) {
            String message = String.format("\u6a21\u7248\u7f16\u53f7\uff1a%s - \u81ea\u5b9a\u4e49\u6a21\u677f\u7b97\u6cd5\u7aef\u8bc6\u522b\u5f02\u5e38,\u8bc6\u522b\u7ed3\u679c\u4e3a: %s", param.getTemplateNumber(), result);
            LOGGER.error(message, (Throwable)e);
            throw new KDBizException(message);
        }
    }
}

