/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.core.ocr.rec;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import kd.ai.cvp.common.Enum.perset.IDCBEnum;
import kd.ai.cvp.common.Enum.perset.IDCFEnum;
import kd.ai.cvp.core.ocr.AbsRec;
import kd.ai.cvp.entity.classifier.param.ClsRecParams;
import kd.ai.cvp.entity.classifier.param.ClsRecPreParams;
import kd.ai.cvp.utils.OcrControlUtils;
import kd.ai.cvp.utils.OcrHttpClientUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.message.BasicNameValuePair;

public class PerRecImpl
extends AbsRec {
    private static final Log LOGGER = LogFactory.getLog(PerRecImpl.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String recognize(ClsRecParams params) {
        ClsRecPreParams param = (ClsRecPreParams)params;
        String fileBase64 = null;
        if (StringUtils.isEmpty((CharSequence)param.getFilePath())) {
            throw new KDBizException("\u5f85\u8bc6\u522b\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        try (InputStream zipIn = this.getRecIn(param.getStorageType(), param.getFilePath());){
            HttpEntity httpEntity;
            if ("/vatinvoice/recognition/five".equals(param.getApi())) {
                httpEntity = OcrHttpClientUtils.getHttpFileEntity(zipIn, "file");
            } else {
                ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>(2);
                if (zipIn != null) {
                    fileBase64 = OcrControlUtils.getFileBase64ByIO(zipIn);
                }
                if ("/presetocr/idcard/recognize".equals(param.getApi())) {
                    list.add(new BasicNameValuePair("imageData", fileBase64));
                    String cardSide = null;
                    if (IDCBEnum.class.equals(param.getClazz())) {
                        cardSide = "FRONT";
                    } else if (IDCFEnum.class.equals(param.getClazz())) {
                        cardSide = "BACK";
                    }
                    list.add(new BasicNameValuePair("cardSide", cardSide));
                } else if ("/template/bankTicket".equals(param.getApi()) || "/presetocr/general/spotting".equals(param.getApi())) {
                    list.add(new BasicNameValuePair("imageBase64", fileBase64));
                } else {
                    list.add(new BasicNameValuePair("imageData", fileBase64));
                }
                httpEntity = new UrlEncodedFormEntity(list, StandardCharsets.UTF_8);
            }
            String string = OcrHttpClientUtils.kdCloudHttpClientPost(param.getApi(), httpEntity);
            return string;
        }
        catch (Exception e) {
            String message = "\u89c6\u89c9\u8bc6\u522b-\u7ec4\u5408\u8bc6\u522b\uff0c\u9884\u7f6e\u6a21\u677f\u8bc6\u522b\u5f02\u5e38";
            LOGGER.error(message, (Throwable)e);
            throw new KDBizException(message);
        }
    }
}

