/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.core.op;

import java.util.List;
import java.util.Objects;
import kd.ai.cvp.common.Enum.StorageTypeEnum;
import kd.ai.cvp.core.op.ClassifierOperateProxy;
import kd.ai.cvp.entity.classifier.ClsTargetFile;
import kd.ai.cvp.task.cls.ClassifierService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ClassifierOperateFormal
extends ClassifierOperateProxy {
    private static Log LOGGER = LogFactory.getLog(ClassifierOperateFormal.class);
    private static final String systemType = "ai-cvp-plugin";
    public static final ClassifierOperateFormal instance = new ClassifierOperateFormal();

    public boolean operate(List<ClsTargetFile> files, String bussinessBillId, long classifierId) {
        if (Objects.isNull(files)) {
            throw new KDBizException(String.format("%s\uff0c\u5206\u7c7b\u76ee\u6807\u6587\u4ef6\u4e3a\u7a7a", this.getOperateName()));
        }
        DynamicObject clsTask = ORM.create().newDynamicObject("cvp_classifier_task");
        DynamicObjectCollection clsFileInfos = clsTask.getDynamicObjectCollection("cvp_cls_original_info");
        clsTask.set("billid", (Object)bussinessBillId);
        clsTask.set("classifierid", (Object)classifierId);
        clsTask.set("billstatus", (Object)"new");
        files.forEach(f -> {
            DynamicObject clsFileInfo = clsFileInfos.addNew();
            clsFileInfo.set("filename", (Object)f.getFileName());
            clsFileInfo.set("filetype", (Object)f.getFileType());
            clsFileInfo.set("filepath", (Object)f.getUrl());
            clsFileInfo.set("filesize", (Object)f.getFileSize());
            clsFileInfo.set("storagetype", (Object)StorageTypeEnum.ATTACHMENT.getStorageType());
            clsFileInfo.set("clstype", (Object)"await");
        });
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{clsTask});
        ClassifierService.excuteTask();
        return true;
    }

    @Override
    protected int covertPageMaxSize() {
        return 10;
    }

    @Override
    protected StorageTypeEnum getStorageType() {
        return StorageTypeEnum.ATTACHMENT;
    }

    @Override
    protected String getOperateName() {
        return ResManager.loadKDString((String)"\u3010\u7ec4\u5408\u8bc6\u522b-\u64cd\u4f5c\u670d\u52a1\u3011", (String)"ClassifierOperateTest_0", (String)systemType, (Object[])new Object[0]);
    }
}

