/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.core.op;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.ai.cvp.common.Enum.StorageTypeEnum;
import kd.ai.cvp.core.ocr.rec.RecDispatcherService;
import kd.ai.cvp.core.op.ClassifierOperateProxy;
import kd.ai.cvp.entity.AlgoResultData;
import kd.ai.cvp.entity.classifier.ClsAlgoResultData;
import kd.ai.cvp.entity.classifier.ClsFileInfo;
import kd.ai.cvp.entity.classifier.ClsInfo;
import kd.ai.cvp.entity.classifier.ClsMServiceSingleData;
import kd.ai.cvp.entity.classifier.ClsProcessResult;
import kd.ai.cvp.entity.classifier.ClsTargetFile;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class ClassifierOperateMService
extends ClassifierOperateProxy {
    private static Log LOGGER = LogFactory.getLog(ClassifierOperateMService.class);
    private static final String systemType = "ai-cvp-plugin";
    public static final ClassifierOperateMService instance = new ClassifierOperateMService();

    public ClsMServiceSingleData operate(ClsTargetFile file, long classifierId) {
        List<ClsAlgoResultData.ClassifierInfo> clsFailures;
        if (file != null && StringUtils.isBlank((CharSequence)file.getUrl())) {
            throw new KDBizException(String.format("%s\uff0c\u5206\u7c7b\u76ee\u6807\u6587\u4ef6\u5730\u5740\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u9644\u4ef6\u670d\u52a1\u662f\u5426\u6b63\u5e38", this.getOperateName()));
        }
        ArrayList<ClsTargetFile> files = new ArrayList<ClsTargetFile>(1);
        files.add(file);
        ClsProcessResult cla = this.run(files, classifierId);
        List<ClsFileInfo> claFileInfos = cla.getClsFileInfos();
        List<ClsAlgoResultData.ClassifierInfo> clsSuccess = cla.getClsResult().getClsSuccess();
        ClsMServiceSingleData singleData = null;
        if (Objects.nonNull(clsSuccess) && clsSuccess.size() > 0) {
            ClsAlgoResultData.ClassifierInfo c = clsSuccess.get(0);
            String imagesId = c.getFileId();
            ClsFileInfo fileInfo = claFileInfos.stream().filter(f -> imagesId.equals(f.getImageId())).findAny().get();
            String templateNum = c.getTemplateNum();
            AlgoResultData result = RecDispatcherService.dispatcherByMService(fileInfo.getStoragetype(), templateNum, c.getOcrId(), fileInfo.getImagePath());
            String tId = c.getTId();
            String desc = result.getDescription();
            singleData = 0 == result.getErrorCode() ? ClsMServiceSingleData.SUCCESS(tId, templateNum, desc, result.getData()) : ClsMServiceSingleData.NO_REC(tId, templateNum, desc, String.valueOf(result.getErrorCode()));
        }
        if (Objects.nonNull(clsFailures = cla.getClsResult().getClsFailure()) && clsFailures.size() > 0) {
            singleData = ClsMServiceSingleData.NO_CLS(StringUtils.isBlank((CharSequence)clsFailures.get(0).getDescription()) ? "\u672a\u5339\u914d\u5230\u6a21\u7248\u4fe1\u606f" : clsFailures.get(0).getDescription());
        }
        return singleData;
    }

    @Override
    protected int covertPageMaxSize() {
        return 1;
    }

    @Override
    protected StorageTypeEnum getStorageType() {
        return StorageTypeEnum.ATTACHMENT;
    }

    @Override
    protected String getOperateName() {
        return ResManager.loadKDString((String)"\u3010\u7ec4\u5408\u8bc6\u522b-\u5fae\u670d\u52a1\u670d\u52a1\u3011", (String)"ClassifierOperateTest_0", (String)systemType, (Object[])new Object[0]);
    }

    @Override
    protected List<ClsInfo> getClsInfos(long classifierId) {
        DynamicObjectCollection ds = QueryServiceHelper.query((String)"cvp_cls_push_template", (String)"classifyid,included_template,keyoword", (QFilter[])new QFilter[]{new QFilter("classifyid", "=", (Object)classifierId)});
        if (Objects.isNull(ds) || ds.size() <= 0) {
            throw new KDBizException(new ErrorCode(String.valueOf(40006), "\u5f53\u524d\u4f7f\u7528\u7684\u7ec4\u5408\u8bc6\u522b\u5668\u5df2\u7ecf\u88ab\u4fee\u6539\uff0c\u8bf7\u91cd\u65b0\u53d1\u5e03\u540e\u4f7f\u7528\u3002"), new Object[0]);
        }
        return ds.stream().map(o -> {
            String[] keywords;
            Object tId = o.get("included_template");
            DynamicObject t = BusinessDataServiceHelper.loadSingle((Object)tId, (String)"cvp_template");
            String templateNum = t.getString("number");
            String ocrId = t.getString("algoid");
            String keywordStr = o.getString("keyoword");
            if (StringUtils.isNotBlank((CharSequence)keywordStr)) {
                keywordStr = new String(keywordStr.getBytes(), StandardCharsets.UTF_8);
                keywords = keywordStr.split(",");
            } else {
                keywords = new String[]{};
            }
            return new ClsInfo(String.valueOf(tId), ocrId, templateNum, keywords);
        }).collect(Collectors.toList());
    }
}

