/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.core.op;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.ai.cvp.common.Enum.StorageTypeEnum;
import kd.ai.cvp.core.cls.ClassifierProxy;
import kd.ai.cvp.core.op.IClassifierOperate;
import kd.ai.cvp.entity.classifier.ClsAlgoResultData;
import kd.ai.cvp.entity.classifier.ClsFileInfo;
import kd.ai.cvp.entity.classifier.ClsInfo;
import kd.ai.cvp.entity.classifier.ClsProcessResult;
import kd.ai.cvp.entity.classifier.ClsTargetFile;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public abstract class ClassifierOperateProxy
implements IClassifierOperate {
    public ClsProcessResult run(List<ClsTargetFile> files, long classifierId) {
        if (Objects.isNull(files) || files.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u9700\u8981\u5206\u7c7b\u7684\u6587\u4ef6", (String)"TdaEntityOperate_1", (String)"ai-cvp-plugin", (Object[])new Object[0]));
        }
        int count = 0;
        int execSize = Math.min(files.size(), this.covertPageMaxSize());
        List<ClsInfo> classifierInfos = this.getClsInfos(classifierId);
        ArrayList<ClsFileInfo> converFiles = new ArrayList<ClsFileInfo>(execSize);
        ClsAlgoResultData rData = new ClsAlgoResultData();
        for (int i = 0; i < execSize; ++i) {
            if (count >= this.covertPageMaxSize()) {
                return new ClsProcessResult(converFiles, rData);
            }
            ClsTargetFile f = files.get(i);
            int covert = this.covertPageMaxSize() - count;
            ClsProcessResult processResult = ClassifierProxy.execute(f.getStorageType(), f, classifierInfos, covert);
            List<ClsFileInfo> clsFileInfos = processResult.getClsFileInfos();
            converFiles.addAll(clsFileInfos);
            List<ClsAlgoResultData.ClassifierInfo> clsSuccess = processResult.getClsResult().getClsSuccess();
            List<ClsAlgoResultData.ClassifierInfo> clsFailure = processResult.getClsResult().getClsFailure();
            if (Objects.nonNull(clsFailure)) {
                rData.getClsFailure().addAll(clsFailure);
            }
            if (Objects.nonNull(clsSuccess)) {
                rData.getClsSuccess().addAll(clsSuccess);
            }
            count += clsFileInfos.size();
        }
        return new ClsProcessResult(converFiles, rData);
    }

    protected List<ClsInfo> getClsInfos(long classifierId) {
        DynamicObject clsIngo = BusinessDataServiceHelper.loadSingle((Object)classifierId, (String)"cvp_cls_info");
        DynamicObjectCollection tInfos = clsIngo.getDynamicObjectCollection("template_infos");
        return tInfos.stream().map(o -> {
            String[] keywords;
            DynamicObject row = (DynamicObject)o.get("included_template");
            Object tId = row.getPkValue();
            DynamicObject t = BusinessDataServiceHelper.loadSingle((Object)tId, (String)"cvp_template");
            String templateNum = t.getString("number");
            String ocrId = t.getString("algoid");
            String keywordStr = o.getString("keyoword");
            if (StringUtils.isNotBlank((CharSequence)keywordStr)) {
                keywordStr = new String(keywordStr.getBytes(), StandardCharsets.UTF_8);
                keywords = keywordStr.split(",");
            } else {
                keywords = new String[]{};
            }
            return new ClsInfo(String.valueOf(tId), ocrId, templateNum, keywords);
        }).collect(Collectors.toList());
    }

    protected abstract int covertPageMaxSize();

    protected abstract StorageTypeEnum getStorageType();

    protected abstract String getOperateName();
}

