/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.entity.license;

import java.util.regex.Pattern;
import kd.bos.exception.KDBizException;
import org.apache.commons.lang3.StringUtils;

public class LicenseApiInfoVO {
    private String tenantId;
    private String tenantCode;
    private String tenantName;
    private String licenseProductId;
    private String licenseProductNo;
    private String licenseProdInstCode;
    private String licenseType;
    private String sourceType;
    private int callNum;

    public LicenseApiInfoVO(String tenantId, String tenantCode, String tenantName, String licenseProductId, String licenseProductNo, String licenseProdInstCode, String licenseType, String sourceType, int callNum) {
        this.checkPatternValue("^[1-9]{1}[0-9]{0,10}$", String.valueOf(callNum));
        this.tenantId = this.checkStringValue(tenantId);
        this.tenantCode = this.checkStringValue(tenantCode);
        this.tenantName = this.checkStringValue(tenantName);
        this.licenseProductId = this.checkStringValue(licenseProductId);
        this.licenseProductNo = this.checkStringValue(licenseProductNo);
        this.licenseProdInstCode = this.checkStringValue(licenseProdInstCode);
        this.licenseType = this.checkStringValue(licenseType);
        this.sourceType = this.checkStringValue(sourceType);
        this.callNum = callNum;
    }

    private String checkStringValue(String v) {
        if (StringUtils.isBlank((CharSequence)v)) {
            throw new KDBizException("\u53c2\u6570\u9519\u8bef");
        }
        return v;
    }

    private void checkPatternValue(String patern, String v) {
        if (!Pattern.matches(patern, v)) {
            throw new KDBizException("\u53c2\u6570\u9519\u8bef");
        }
    }

    public String getTenantCode() {
        return this.tenantCode;
    }

    public void setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
    }

    public String getTenantName() {
        return this.tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public String getLicenseProductId() {
        return this.licenseProductId;
    }

    public void setLicenseProductId(String licenseProductId) {
        this.licenseProductId = licenseProductId;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getLicenseProductNo() {
        return this.licenseProductNo;
    }

    public void setLicenseProductNo(String licenseProductNo) {
        this.licenseProductNo = licenseProductNo;
    }

    public String getLicenseProdInstCode() {
        return this.licenseProdInstCode;
    }

    public void setLicenseProdInstCode(String licenseProdInstCode) {
        this.licenseProdInstCode = licenseProdInstCode;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public void setLicenseType(String licenseType) {
        this.licenseType = licenseType;
    }

    public int getCallNum() {
        return this.callNum;
    }

    public void setCallNum(int callNum) {
        this.callNum = callNum;
    }
}

