/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.task;

import kd.ai.cvp.task.TaskStatus;
import kd.ai.cvp.utils.LicenseUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class TdaCheckScheduledTaskUtils {
    private static Log LOGGER = LogFactory.getLog(TdaCheckScheduledTaskUtils.class);
    private static final String SCH_TASK_DEFINE = "sch_taskdefine";
    private static final String SCH_TASK_DEFINE_ID = "2LEAXWCCA/7Z";
    private static final String SCH_JOB = "sch_job";
    private static final String SCH_JOB_ID = "2LI/0HP0E032";
    private static final String SCH_SCHEDULE = "sch_schedule";
    private static final String SCH_SCHEDULE_ID = "2LI3EN3FTJGW";
    private static final String ENABLE = "1";
    private static final String STATUS = "status";

    private TdaCheckScheduledTaskUtils() {
    }

    public static TaskStatus check() {
        ScheduleManager scheduleManager;
        LOGGER.info("\u89c6\u89c9\u8bc6\u522b-\u9884\u7f6e-\u5dee\u5f02\u5206\u6790\u540e\u53f0\u81ea\u52a8\u66f4\u65b0\u4efb\u52a1,\u68c0\u6d4b \u5f00\u59cb");
        boolean hasLicense = LicenseUtils.checkPureLicense();
        if (!hasLicense) {
            String msg = "\u89c6\u89c9\u8bc6\u522b-\u9884\u7f6e-\u5dee\u5f02\u5206\u6790\u540e\u53f0\u81ea\u52a8\u66f4\u65b0\u4efb\u52a1,\u68c0\u6d4b \u65e0\u8bb8\u53ef \u4efb\u52a1\u4e0d\u5f00\u542f";
            LOGGER.info(msg);
            return new TaskStatus(true, msg);
        }
        try {
            DynamicObject schTaskDefine = BusinessDataServiceHelper.loadSingle((Object)SCH_TASK_DEFINE_ID, (String)SCH_TASK_DEFINE);
            if (schTaskDefine == null) {
                throw new KDBizException("\u89c6\u89c9\u8bc6\u522b-\u9884\u7f6e-\u5dee\u5f02\u5206\u6790\u540e\u53f0\u81ea\u52a8\u66f4\u65b0\u4efb\u52a1\u7ed3\u679c\u7c7b\uff0c\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
        }
        catch (Exception e) {
            String msg = "\u89c6\u89c9\u8bc6\u522b-\u9884\u7f6e-\u5dee\u5f02\u5206\u6790\u540e\u53f0\u81ea\u52a8\u66f4\u65b0\u4efb\u52a1\u7ed3\u679c\u7c7b\uff0c\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458";
            LOGGER.error(msg, (Throwable)e);
            return new TaskStatus(false, msg);
        }
        try {
            DynamicObject schJob = BusinessDataServiceHelper.loadSingle((Object)SCH_JOB_ID, (String)SCH_JOB);
            String jobStatus = schJob.getString(STATUS);
            if (!ENABLE.equalsIgnoreCase(jobStatus)) {
                schJob.set(STATUS, (Object)ENABLE);
                SaveServiceHelper.update((DynamicObject)schJob);
                scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
                scheduleManager.enableJob(SCH_JOB_ID);
            }
        }
        catch (Exception e) {
            String msg = "\u89c6\u89c9\u8bc6\u522b-\u9884\u7f6e-\u5dee\u5f02\u5206\u6790\u540e\u53f0\u81ea\u52a8\u66f4\u65b0\u4efb\u52a1\u7ed3\u679c\u4f5c\u4e1a\uff0c\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458";
            LOGGER.error(msg, (Throwable)e);
            return new TaskStatus(false, msg);
        }
        try {
            DynamicObject schSchedule = BusinessDataServiceHelper.loadSingle((Object)SCH_SCHEDULE_ID, (String)SCH_SCHEDULE);
            String schStatus = schSchedule.getString(STATUS);
            if (!ENABLE.equalsIgnoreCase(schStatus)) {
                schSchedule.set(STATUS, (Object)ENABLE);
                SaveServiceHelper.update((DynamicObject)schSchedule);
                scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
                scheduleManager.enableSchedule(SCH_SCHEDULE_ID);
            }
        }
        catch (Exception e) {
            String msg = "\u89c6\u89c9\u8bc6\u522b-\u9884\u7f6e-\u5dee\u5f02\u5206\u6790\u540e\u53f0\u81ea\u52a8\u66f4\u65b0\u4efb\u52a1\u7ed3\u679c\u8ba1\u5212\uff0c\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458";
            LOGGER.error(msg, (Throwable)e);
            return new TaskStatus(false, msg);
        }
        LOGGER.info("\u89c6\u89c9\u8bc6\u522b-\u9884\u7f6e-\u5dee\u5f02\u5206\u6790\u540e\u53f0\u81ea\u52a8\u66f4\u65b0\u4efb\u52a1,\u68c0\u6d4b \u5b8c\u6210");
        return new TaskStatus(true, "\u89c6\u89c9\u8bc6\u522b-\u9884\u7f6e-\u5dee\u5f02\u5206\u6790\u540e\u53f0\u81ea\u52a8\u66f4\u65b0\u4efb\u52a1,\u6b63\u5e38");
    }
}

