/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.ai.cvp.entity.tda.TdaBatchTaskInfoResult;
import kd.ai.cvp.entity.tda.param.TdaBatchQueryParam;
import kd.ai.cvp.utils.OcrHttpClientUtils;
import kd.ai.cvp.utils.TdaUtils;
import kd.bos.ai.util.JsonUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

public class TdaFlushDataExcutors {
    private static Log LOGGER = LogFactory.getLog(TdaFlushDataExcutors.class);
    private static volatile AtomicBoolean off = new AtomicBoolean(true);
    private static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"ai-cvp-pool-update", (int)1);

    public static void excuteTask(RequestContext rc) {
        try {
            if (off.compareAndSet(true, false)) {
                LOGGER.info("cvp-\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u66f4\u65b0\u5dee\u5f02\u5206\u6790-\u542f\u52a8\u5237\u65b0\u4efb\u52a1 ai-cvp-pool-update");
                threadPool.execute((Runnable)new TdaTask(), rc);
            }
            LOGGER.info("cvp-\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u66f4\u65b0\u5dee\u5f02\u5206\u6790-\u6b63\u5728\u66f4\u65b0\u4efb\u52a1\u4e2d ai-cvp-pool-update");
        }
        catch (Exception e) {
            LOGGER.error("cvp-\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u66f4\u65b0\u5dee\u5f02\u5206\u6790-\u4efb\u52a1\u542f\u52a8\u5931\u8d25 ai-cvp-pool-update \u6267\u884c\u5668\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
        }
    }

    public static class TdaTask
    implements Runnable {
        private static Log LOGGER = LogFactory.getLog(TdaTask.class);
        private static final long LOCK_WAIT_TIME = 10000L;
        private static final long FLUSH_DATA_TIME = 10000L;
        private RequestContext rc = RequestContext.get();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                DynamicObjectCollection preTasks;
                try {
                    preTasks = TdaTask.queryRunningTask();
                }
                catch (Exception e) {
                    LOGGER.error(String.format("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u6587\u6863\u5dee\u5f02\u5206\u6790-\u4efb\u52a1\u83b7\u53d6\u6279\u5904\u7406\u4efb\u52a1\u5f02\u5e38\uff0c\u5f85\u4e0b\u6b21\u66f4\u65b0: %s", e.getMessage()));
                    off.compareAndSet(false, true);
                    return;
                }
                do {
                    block30: {
                        DLock lock;
                        String LOCK_KEY;
                        block27: {
                            List<TdaBatchTaskInfoResult.BatchTaskInfoVO> noOperations;
                            block28: {
                                Iterator iterator;
                                block29: {
                                    try {
                                        if (preTasks != null && preTasks.size() > 0) {
                                            LOCK_KEY = "cvp_".concat("updateTdaTask").concat("_").concat(this.rc.getTenantCode()).concat(this.rc.getAccountId());
                                            lock = TdaTask.getLock(LOCK_KEY);
                                            try {
                                                if (lock.tryLock(10000L)) {
                                                    DynamicObjectCollection currenTasks = TdaTask.queryRunningTask();
                                                    if (currenTasks == null || currenTasks.size() <= 0) break block27;
                                                    ArrayList<Long> taskIds = new ArrayList<Long>(currenTasks.size());
                                                    currenTasks.forEach(t -> {
                                                        String taskIdStr = "";
                                                        try {
                                                            taskIdStr = t.getString("taskid");
                                                            taskIds.add(Long.parseLong(taskIdStr));
                                                        }
                                                        catch (Exception e) {
                                                            LOGGER.warn(String.format("\u4efb\u52a1ID\u503c\uff1a%s,\u8f6c\u6362Long\u5f02\u5e38\uff0c\u65e7\u7248\u672c\u4efb\u52a1\u76f4\u63a5\u5931\u8d25\u5904\u7406", taskIdStr), (Throwable)e);
                                                            this.updateOldData(taskIdStr);
                                                        }
                                                    });
                                                    LOGGER.info(String.format("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u6587\u6863\u5dee\u5f02\u5206\u6790-\u6267\u884c\u5b9a\u65f6\u4efb\u52a1,\u83b7\u53d6\u9501: %s\uff0c\u4efb\u52a1\u6570:%s, \u4efb\u52a1:%s", LOCK_KEY, taskIds.size(), Arrays.toString(taskIds.toArray())));
                                                    TdaBatchQueryParam tdaBatchQueryParam = new TdaBatchQueryParam(this.rc.getTenantCode(), this.rc.getTenantInfo().getName(), taskIds);
                                                    StringEntity paramstr = new StringEntity(JsonUtil.encodeToString((Object)tdaBatchQueryParam), ContentType.APPLICATION_JSON);
                                                    paramstr.setContentEncoding("UTF-8");
                                                    String resultQuery = OcrHttpClientUtils.kdCloudHttpClientPost("/vrsp/doc/queryBatchTaskInfos", (HttpEntity)paramstr);
                                                    LOGGER.info(String.format("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u6587\u6863\u5dee\u5f02\u5206\u6790,\u5b9a\u65f6\u4efb\u52a1\u6279\u91cf\u67e5\u8be2\u5206\u6790\u7ed3\u679c\uff1a%s", resultQuery.length() > 200 ? resultQuery.substring(0, 199) : resultQuery));
                                                    TdaBatchTaskInfoResult btInfo = (TdaBatchTaskInfoResult)JsonUtil.decodeFromString((String)resultQuery, TdaBatchTaskInfoResult.class);
                                                    if (0 != btInfo.getErrorCode()) break block27;
                                                    List<TdaBatchTaskInfoResult.BatchTaskInfoVO> tdaData = btInfo.getData();
                                                    List operations = tdaData.stream().filter(t -> !"running".equalsIgnoreCase(t.getStatus())).collect(Collectors.toList());
                                                    noOperations = tdaData.stream().filter(t -> "running".equalsIgnoreCase(t.getStatus())).collect(Collectors.toList());
                                                    if (operations.isEmpty()) break block28;
                                                    List operationTaskIds = operations.stream().map(TdaBatchTaskInfoResult.BatchTaskInfoVO::getTaskId).collect(Collectors.toList());
                                                    LOGGER.info(String.format("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u6587\u6863\u5dee\u5f02\u5206\u6790-\u66f4\u65b0\u4efb\u52a1\uff0c\u672c\u6b21\u9884\u66f4\u65b0\u4efb\u52a1\u6570\uff1a%s, taskIds:%s", operationTaskIds.size(), Arrays.toString(operationTaskIds.toArray())));
                                                    iterator = operations.iterator();
                                                    break block29;
                                                }
                                                LOGGER.info(String.format("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u6587\u6863\u5dee\u5f02\u5206\u6790-\u66f4\u65b0\u4efb\u52a1\u6bd4\u5bf9\u7ed3\u679c\uff0c\u4efb\u52a1\u6267\u884c\u4e2d\uff0c\u83b7\u53d6\u9501:%s \u5931\u8d25\uff0c\u7b49\u5f85\u65f6\u95f4\uff1a%s", LOCK_KEY, 10000L));
                                                break block27;
                                            }
                                            catch (Exception e) {
                                                try {
                                                    LOGGER.error(String.format("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u6587\u6863\u5dee\u5f02\u5206\u6790,\u6279\u5904\u7406\u4efb\u52a1 \u5f02\u5e38\uff0c\u5f85\u4e0b\u6b21\u66f4\u65b0: %s", e.getMessage()), (Throwable)e);
                                                }
                                                catch (Throwable throwable) {
                                                    LOGGER.info(String.format("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u6587\u6863\u5dee\u5f02\u5206\u6790-\u66f4\u65b0\u4efb\u52a1\u6bd4\u5bf9\u7ed3\u679c \u5b8c\u6210, \u91ca\u653e\u9501\uff1a%s", LOCK_KEY));
                                                    lock.unlock();
                                                    throw throwable;
                                                }
                                                LOGGER.info(String.format("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u6587\u6863\u5dee\u5f02\u5206\u6790-\u66f4\u65b0\u4efb\u52a1\u6bd4\u5bf9\u7ed3\u679c \u5b8c\u6210, \u91ca\u653e\u9501\uff1a%s", LOCK_KEY));
                                                lock.unlock();
                                                break block30;
                                            }
                                        }
                                        LOGGER.info("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u6587\u6863\u5dee\u5f02\u5206\u6790-\u6279\u91cf\u66f4\u65b0\uff0c\u672c\u6b21\u65e0\u6267\u884c\u4efb\u52a1");
                                        break block30;
                                    }
                                    catch (Exception e) {
                                        try {
                                            LOGGER.error(String.format("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u6587\u6863\u5dee\u5f02\u5206\u6790-\u83b7\u53d6\u6279\u5904\u7406\u4efb\u52a1\u5f02\u5e38\uff0c\u5f85\u4e0b\u6b21\u66f4\u65b0: %s", e.getMessage()), (Throwable)e);
                                        }
                                        catch (Throwable throwable) {
                                            try {
                                                Thread.sleep(10000L);
                                                preTasks = TdaTask.queryRunningTask();
                                                throw throwable;
                                            }
                                            catch (InterruptedException e2) {
                                                LOGGER.error(String.format("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u6587\u6863\u5dee\u5f02\u5206\u6790-\u83b7\u53d6\u6279\u5904\u7406\u4efb\u52a1\u5f02\u5e38\uff0c\u5f85\u4e0b\u6b21\u66f4\u65b0: %s", e2.getMessage()), (Throwable)e2);
                                            }
                                            throw throwable;
                                        }
                                        try {
                                            Thread.sleep(10000L);
                                            preTasks = TdaTask.queryRunningTask();
                                        }
                                        catch (InterruptedException e3) {
                                            LOGGER.error(String.format("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u6587\u6863\u5dee\u5f02\u5206\u6790-\u83b7\u53d6\u6279\u5904\u7406\u4efb\u52a1\u5f02\u5e38\uff0c\u5f85\u4e0b\u6b21\u66f4\u65b0: %s", e3.getMessage()), (Throwable)e3);
                                        }
                                        continue;
                                    }
                                }
                                while (iterator.hasNext()) {
                                    TdaBatchTaskInfoResult.BatchTaskInfoVO task2 = (TdaBatchTaskInfoResult.BatchTaskInfoVO)iterator.next();
                                    try {
                                        LOGGER.info(String.format("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u6587\u6863\u5dee\u5f02\u5206\u6790-\u66f4\u65b0\u4efb\u52a1 \u5f00\u59cb TaskId:%s", task2.getTaskId()));
                                        TdaUtils.execNotRunningTask(task2);
                                        LOGGER.info(String.format("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u6587\u6863\u5dee\u5f02\u5206\u6790-\u66f4\u65b0\u4efb\u52a1 \u7ed3\u675f TaskId:%s", task2.getTaskId()));
                                    }
                                    catch (Exception e) {
                                        LOGGER.error(String.format("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u6587\u6863\u5dee\u5f02\u5206\u6790,\u66f4\u65b0\u4efb\u52a1\u5355\u4e2a\u4efb\u52a1taskId\uff1a%s,\u672c\u6b21\u5904\u7406\u5931\u8d25\uff0c\u5f85\u4e0b\u6b21\u5904\u7406\uff0c\u5f02\u5e38\u4fe1\u606f: %s", task2.getTaskId(), e.getMessage()), (Throwable)e);
                                    }
                                }
                            }
                            if (!noOperations.isEmpty()) {
                                int total = noOperations.size();
                                noOperations.forEach(task -> {
                                    TdaUtils.refreshCache(task.getTaskId());
                                    LOGGER.info(String.format("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u6587\u6863\u5dee\u5f02\u5206\u6790,\u66f4\u65b0\u4efb\u52a1\u6279\u5904\u7406,\u672a\u5b8c\u6210\u4efb\u52a1\u603b\u6570\uff1a%s ,\u4efb\u52a1: %s,\u6267\u884c\u8fdb\u5ea6\uff1a%s", total, task.getTaskId(), task.getProgress()));
                                });
                                TdaUtils.batchUpdateTdaTasks(noOperations);
                            }
                        }
                        LOGGER.info(String.format("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u6587\u6863\u5dee\u5f02\u5206\u6790-\u66f4\u65b0\u4efb\u52a1\u6bd4\u5bf9\u7ed3\u679c \u5b8c\u6210, \u91ca\u653e\u9501\uff1a%s", LOCK_KEY));
                        lock.unlock();
                    }
                    try {
                        Thread.sleep(10000L);
                        preTasks = TdaTask.queryRunningTask();
                    }
                    catch (InterruptedException e) {
                        LOGGER.error(String.format("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u6587\u6863\u5dee\u5f02\u5206\u6790-\u83b7\u53d6\u6279\u5904\u7406\u4efb\u52a1\u5f02\u5e38\uff0c\u5f85\u4e0b\u6b21\u66f4\u65b0: %s", e.getMessage()), (Throwable)e);
                    }
                } while (preTasks.size() > 0);
                return;
            }
            finally {
                off.compareAndSet(false, true);
            }
        }

        private void updateOldData(String taskIdStr) {
            String sql = "update t_cvp_tda_comparison_task set fbillenddate=?,fbillstatus=? where ftaskid=? ";
            Object[] parmas = new Object[]{new Date(), "error", taskIdStr};
            DB.update((DBRoute)new DBRoute("aidb"), (String)sql, (Object[])parmas);
        }

        private static DLock getLock(String lockKey) {
            DLock lock = DLock.create((String)lockKey, (String)String.format("\u9501:%s,\u5dee\u5f02\u5206\u6790\u4efb\u52a1\u66f4\u65b0\u9501", lockKey));
            lock.fastMode();
            return lock;
        }

        private static DynamicObjectCollection queryRunningTask() {
            QFilter filter1 = new QFilter("billstatus", "=", (Object)"running");
            return QueryServiceHelper.query((String)"cvp_tda_task_history", (String)"taskid", (QFilter[])new QFilter[]{filter1});
        }
    }
}

