/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.task;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.ai.cvp.common.Enum.IeExtractTypeEnum;
import kd.ai.cvp.common.Enum.OcrLayoutTypeEnum;
import kd.ai.cvp.common.Enum.SourceTypeEnum;
import kd.ai.cvp.entity.ie.ComplexPageInfo;
import kd.ai.cvp.entity.ie.DocTotalRecLayoutDataVO;
import kd.ai.cvp.entity.ie.GeneralIEResult;
import kd.ai.cvp.entity.ie.LayoutLocation;
import kd.ai.cvp.entity.ie.PicAndPdfTextLineVO;
import kd.ai.cvp.entity.ie.TieBatchQueryParam;
import kd.ai.cvp.entity.ie.TieExtractData;
import kd.ai.cvp.entity.ie.TieExtractResult;
import kd.ai.cvp.entity.tda.algoCompare.ConversionAlgoInfo;
import kd.ai.cvp.utils.CommonUtil;
import kd.ai.cvp.utils.LicenseUtils;
import kd.ai.cvp.utils.OcrHttpClientUtils;
import kd.ai.cvp.utils.TdaUtils;
import kd.ai.cvp.utils.ThreadUtils;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.util.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

public class TiePullResultService {
    private static final Log logger = LogFactory.getLog(TiePullResultService.class);
    private static final long LOCKWAITTIME = 10000L;
    private static final int TASKSIZE = 10;

    private TiePullResultService() {
        throw new KDBizException("tool class should not be init by new class");
    }

    public static void syncPullTieResult(RequestContext rc) {
        ThreadPool threadPool = ThreadUtils.get();
        threadPool.execute(() -> TiePullResultService.queryTieResult(rc), rc);
    }

    private static void queryTieResult(RequestContext rc) {
        String tenantCode = rc.getTenantCode();
        String lockKey = "cvp_".concat("updateTieTask").concat("_").concat(tenantCode);
        try (DLock lock = DLock.create((String)lockKey, (String)String.format("\u9501:%s,\u4fe1\u606f\u63d0\u53d6\u7ed3\u679c\u67e5\u8be2\u9501", lockKey));){
            lock.fastMode();
            if (lock.tryLock(10000L)) {
                TiePullResultService.pullTieResult(rc);
            } else {
                logger.info("\u672a\u83b7\u53d6\u5230\u9501\uff0c\u4efb\u52a1\u6b63\u5728\u6267\u884c\u4e2d\u3002\u3002\u3002\u9501\u4e3a:{}", (Object)lockKey);
            }
        }
    }

    private static void pullTieResult(RequestContext rc) {
        logger.info("\u89e6\u53d1\u4fe1\u606f\u63d0\u53d6\u67e5\u8be2\u3002\u3002\u3002");
        try {
            boolean hasTask = TiePullResultService.existTask();
            if (hasTask) {
                TiePullResultService.doPullTieResult(rc);
            } else {
                logger.info("tie-\u6279\u91cf\u66f4\u65b0\uff0c\u672c\u6b21\u65e0\u6267\u884c\u4efb\u52a1\u3002");
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                logger.error(String.format("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u6587\u6863\u4fe1\u606f\u63d0\u53d6-\u5b9a\u65f6\u4efb\u52a1\u83b7\u53d6\u6279\u5904\u7406\u4efb\u52a1\u5f02\u5e38\uff0c\u5f85\u4e0b\u6b21\u66f4\u65b0: %s", e.getMessage()), (Throwable)e);
            }
            boolean hasMoreTask = TiePullResultService.existTask();
            if (hasMoreTask) {
                TiePullResultService.pullTieResult(rc);
            } else {
                logger.info("tie-\u6279\u91cf\u66f4\u65b0\uff0c\u518d\u6b21\u786e\u8ba4\u65e0\u4efb\u52a1\u6267\u884c\u3002");
            }
        }
        catch (Exception e) {
            logger.error(String.format("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u6587\u6863\u4fe1\u606f\u63d0\u53d6-\u6587\u6863\u4fe1\u606f\u63d0\u53d6\u6279\u91cf\u67e5\u8be2\u4efb\u52a1\u5f02\u5e38\uff0c\u5f85\u4e0b\u6b21\u89e6\u53d1\u66f4\u65b0: %s", e.getMessage()), (Throwable)e);
        }
    }

    private static void doPullTieResult(RequestContext rc) {
        try {
            DynamicObject[] tieTaskArr = TiePullResultService.queryRunningTask();
            if (tieTaskArr != null && tieTaskArr.length > 0) {
                TiePullResultService.batchHandlerTieTask(tieTaskArr, rc);
            }
        }
        catch (KDBizException kde) {
            logger.error(String.format("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u6587\u6863\u4fe1\u606f\u4e1a\u52a1\u63d0\u53d6,\u6279\u67e5\u8be2\u4efb\u52a1 \u5f02\u5e38\uff0c\u5f85\u4e0b\u6b21\u66f4\u65b0: %s", kde.getMessage()), (Throwable)kde);
        }
        catch (Exception e) {
            logger.error(String.format("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u6587\u6863\u4fe1\u606f\u63d0\u53d6,\u6279\u67e5\u8be2\u4efb\u52a1 \u5f02\u5e38\uff0c\u5f85\u4e0b\u6b21\u66f4\u65b0: %s", e.getMessage()), (Throwable)e);
        }
    }

    private static void batchHandlerTieTask(DynamicObject[] tieTaskArr, RequestContext rc) {
        List<DynamicObject[]> list = TiePullResultService.splitTaskArr(tieTaskArr, 10);
        if (list != null && !list.isEmpty()) {
            list.forEach(taskObjArr -> TiePullResultService.doQueryAndUpdate(taskObjArr, rc));
        } else {
            logger.info("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u6587\u6863\u4fe1\u606f\u63d0\u53d6 -\u672a\u83b7\u53d6\u5230\u9700\u8981\u6279\u91cf\u5904\u7406\u7684\u4fe1\u606f\u63d0\u53d6\u4efb\u52a1\u3002");
        }
    }

    private static void doQueryAndUpdate(DynamicObject[] taskObjArr, RequestContext rc) {
        if (taskObjArr == null || taskObjArr.length < 1) {
            logger.info("\u6ca1\u6709\u9700\u8981\u5904\u7406\u7684\u4fe1\u606f\u63d0\u53d6\u4efb\u52a1\u3002\u3002\u3002");
            return;
        }
        try {
            List<Long> taskIds = Arrays.stream(taskObjArr).filter(taskObj -> !StringUtils.isEmpty((String)taskObj.getString("taskid"))).map(taskObj -> Long.parseLong(String.valueOf(taskObj.getString("taskid")))).collect(Collectors.toList());
            logger.info("taskIds:{}", (Object)JSON.toJSONString(taskIds));
            TieBatchQueryParam tieBatchQueryParam = new TieBatchQueryParam(rc.getTenantCode(), rc.getTenantInfo().getName(), taskIds);
            StringEntity paramStr = new StringEntity(JSON.toJSONString((Object)tieBatchQueryParam), ContentType.APPLICATION_JSON);
            paramStr.setContentEncoding("UTF-8");
            String resultQuery = OcrHttpClientUtils.kdCloudHttpClientPost("/vrsp/tie/queryTieDataByTaskIds", (HttpEntity)paramStr);
            TieExtractResult extractResult = (TieExtractResult)JSON.parseObject((String)resultQuery, TieExtractResult.class);
            if (0 == extractResult.getErrorCode()) {
                TiePullResultService.updateTask((List)extractResult.getData(), taskObjArr);
            }
        }
        catch (Exception e) {
            logger.error(String.format("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u6587\u6863\u4fe1\u606f\u63d0\u53d6,\u6279\u5904\u7406\u4efb\u52a1 \u5f02\u5e38\uff0c\u5f85\u4e0b\u6b21\u66f4\u65b0: %s", e.getMessage()), (Throwable)e);
        }
    }

    private static void updateTask(List<TieExtractData> data, DynamicObject[] taskObjArr) {
        if (data == null || data.isEmpty()) {
            logger.info("tie \u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u6587\u6863\u4fe1\u606f\u63d0\u53d6 \u6279\u5904\u7406\u4efb\u52a1 \u6ca1\u6709\u9700\u8981\u66f4\u65b0\u7684\u6570\u636e\u3002\u3002");
            return;
        }
        Map<String, DynamicObject> taskObjRef = TiePullResultService.buildTaskRef(taskObjArr);
        if (taskObjRef.isEmpty()) {
            logger.error("\u5386\u53f2\u4efb\u52a1\u6620\u5c04\u5173\u7cfb\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u3002");
            return;
        }
        TiePullResultService.prepare2CreateLLMTask(data, taskObjRef);
        List<TieExtractData> runningTaskList = data.stream().filter(tieExtractData -> "running".equalsIgnoreCase(tieExtractData.getStatus())).collect(Collectors.toList());
        List<TieExtractData> completeTaskList = data.stream().filter(tieExtractData -> !"running".equalsIgnoreCase(tieExtractData.getStatus())).collect(Collectors.toList());
        TiePullResultService.updateData4RunningTask(runningTaskList, taskObjRef);
        TiePullResultService.updateData4CompleteTask(completeTaskList, taskObjRef);
    }

    private static void updateData4CompleteTask(List<TieExtractData> completeTaskList, Map<String, DynamicObject> taskObjRef) {
        if (!completeTaskList.isEmpty()) {
            for (TieExtractData cTask : completeTaskList) {
                String taskId = cTask.getTaskId();
                DynamicObject taskObj = taskObjRef.get(taskId);
                try {
                    String status = cTask.getStatus();
                    boolean flag = false;
                    switch (status) {
                        case "success": {
                            flag = true;
                            TiePullResultService.doSuccessUpdate(taskObj, cTask);
                            break;
                        }
                        case "error": 
                        case "cancel": {
                            TiePullResultService.doFailUpdate(taskObj, cTask);
                            break;
                        }
                        default: {
                            String msg = ResManager.loadKDString((String)"\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u6587\u6863\u4fe1\u606f\u63d0\u53d6\uff0c\u72b6\u6001\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"TiePullResultService_010", (String)"ai-cvp-common", (Object[])new Object[0]);
                            logger.error(msg);
                            throw new KDBizException(msg);
                        }
                    }
                    if (!flag) {
                        LicenseUtils.ensureCallNumToAlgoAsync(false, taskId, SourceTypeEnum.INFOEXTRACT);
                        continue;
                    }
                    if (IeExtractTypeEnum.COMMON_EXTRACT.getExtractType() != Integer.parseInt(taskObj.getString("tieType"))) continue;
                    LicenseUtils.ensureCallNumToAlgoAsync(true, taskId, SourceTypeEnum.INFOEXTRACT);
                }
                catch (Exception e) {
                    logger.error("\u6587\u6863\u4fe1\u606f\u63d0\u53d6\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (Throwable)e);
                    LicenseUtils.ensureCallNumToAlgoAsync(false, taskId, SourceTypeEnum.INFOEXTRACT);
                }
            }
        }
    }

    private static void updateData4RunningTask(List<TieExtractData> runningTaskList, Map<String, DynamicObject> taskObjRef) {
        if (!runningTaskList.isEmpty()) {
            ArrayList runningList = new ArrayList();
            runningTaskList.forEach(rTask -> {
                String taskId = rTask.getTaskId();
                TdaUtils.refreshCache(taskId);
                taskId = rTask.getTaskId();
                QFilter qFilter = new QFilter("taskid", "=", (Object)taskId);
                DynamicObject task = BusinessDataServiceHelper.loadSingle((String)"cvp_ie_history", (String)"id,extractstatus", (QFilter[])new QFilter[]{qFilter});
                if (task != null && !Arrays.asList("error", "cancel", "success").contains(task.getString("extractstatus"))) {
                    DynamicObject targetObj = (DynamicObject)taskObjRef.get(taskId);
                    targetObj.set("progressinfo", (Object)rTask.getProgress());
                    logger.info("withCTIEResult:{}", (Object)rTask.getWithCTIEResult());
                    targetObj.set("withctieresult", (Object)rTask.getWithCTIEResult());
                    runningList.add(targetObj);
                    logger.info(String.format("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u4fe1\u606f\u63d0\u53d6,\u5b9a\u65f6\u4efb\u52a1\u6279\u5904\u7406,\u672a\u5b8c\u6210\u4efb\u52a1\u603b\u6570\uff1a%s ,\u4efb\u52a1: %s,\u6267\u884c\u8fdb\u5ea6\uff1a%s", runningTaskList.size(), taskId, rTask.getProgress()));
                }
            });
            SaveServiceHelper.update((DynamicObject[])runningList.toArray(new DynamicObject[0]));
        }
    }

    private static void prepare2CreateLLMTask(List<TieExtractData> data, Map<String, DynamicObject> taskObjRef) {
        data.forEach(tieExtractData -> {
            try {
                String status = tieExtractData.getStatus();
                String taskId = tieExtractData.getTaskId();
                DynamicObject targetObj = (DynamicObject)taskObjRef.get(taskId);
                if (targetObj != null && !"error,cancel".contains(status) && StringUtils.isNotEmpty((String)targetObj.getString("tieType")) && "1,2,3".contains(targetObj.getString("tieType"))) {
                    List<DocTotalRecLayoutDataVO> layoutData = tieExtractData.getLayoutData();
                    List<ComplexPageInfo> pageInfo = tieExtractData.getPageInfo();
                    DynamicObject lastIeHistory = BusinessDataServiceHelper.loadSingle((Object)targetObj.getPkValue(), (String)"cvp_ie_history", (String)"llmtaskid");
                    if (layoutData != null && !layoutData.isEmpty() && pageInfo != null && !pageInfo.isEmpty() && StringUtils.isEmpty((String)lastIeHistory.getString("llmtaskid"))) {
                        logger.info("\u53d1\u8d77\u5927\u6a21\u578b\u63d0\u53d6\u4efb\u52a1\u8c03\u7528\uff0c\u4efb\u52a1id:{}", (Object)taskId);
                        TiePullResultService.saveAndCreateLLMTask(tieExtractData, targetObj);
                    }
                } else {
                    logger.info("\u901a\u7528\u4fe1\u606f\u63d0\u53d6\u4efb\u52a1\uff0c\u4efb\u52a1id:{}", (Object)tieExtractData.getTaskId());
                }
            }
            catch (KDBizException kde) {
                logger.error("\u53d1\u8d77\u5927\u6a21\u578b\u63d0\u53d6\u5f02\u5e38\uff0c\u4efb\u52a1id:{}", (Object)tieExtractData.getTaskId(), (Object)kde);
                TiePullResultService.updateDataForError(kde, tieExtractData);
            }
            catch (Exception e) {
                logger.error("\u53d1\u8d77\u5927\u6a21\u578b\u63d0\u53d6\u4efb\u52a1\u5f02\u5e38,\u4efb\u52a1id:{}", (Object)tieExtractData.getTaskId(), (Object)e);
                TiePullResultService.updateDataForUnknownError(e, tieExtractData);
            }
        });
    }

    private static void updateDataForUnknownError(Exception e, TieExtractData tieExtractData) {
        String message = e.getMessage();
        if (StringUtils.isEmpty((String)message)) {
            message = ResManager.loadKDString((String)"\u521b\u5efa\u5927\u6a21\u578b\u4efb\u52a1\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u3002", (String)"TiePullResultService_303", (String)"ai-cvp-common", (Object[])new Object[0]);
        }
        tieExtractData.setStatus("error");
        tieExtractData.setProgress(message);
    }

    private static void updateDataForError(KDBizException e, TieExtractData tieExtractData) {
        ErrorCode errorCode = e.getErrorCode();
        if (errorCode != null) {
            String code = errorCode.getCode();
            String message = errorCode.getMessage();
            if (code.equals("403003")) {
                tieExtractData.setStatus("error");
                tieExtractData.setProgress(StringUtils.isEmpty((String)message) ? ResManager.loadKDString((String)"\u590d\u6742\u6587\u6863\u63d0\u53d6\u7ed3\u679c\u4e0d\u6b63\u786e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u3002", (String)"TiePullResultService_300", (String)"ai-cvp-common", (Object[])new Object[0]) : message);
            } else if (code.equals("aicc.100003")) {
                tieExtractData.setStatus("error");
                tieExtractData.setProgress(message);
            }
        }
    }

    private static void saveAndCreateLLMTask(TieExtractData tieExtractData, DynamicObject targetObj) {
        HashMap<String, String> varParams = new HashMap<String, String>();
        List<DocTotalRecLayoutDataVO> layoutData = tieExtractData.getLayoutData();
        String input = TiePullResultService.buildInput(layoutData);
        if (StringUtils.isEmpty((String)input)) {
            throw new KDBizException(new ErrorCode("403003", ResManager.loadKDString((String)"\u590d\u6742\u6587\u6863\u63d0\u53d6\u7ed3\u679c\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u3002", (String)"TiePullResultService_301", (String)"ai-cvp-common", (Object[])new Object[0])), new Object[0]);
        }
        varParams.put("docWord", input);
        DynamicObject iemould = targetObj.getDynamicObject("iemould");
        Object pkValue = iemould.getPkValue();
        DynamicObject planObj = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"cvp_ie_mouldplan", (String)"id,number,docdescrip,llmentryentity,llmentryentity.llmtabnum,llmentryentity.llmextractnum,llmentryentity.llmtabname,llmentryentity.llmextractfield,llmentryentity.llmfieldtype,llmentryentity.llmexdescription,llmentryentity.llmoutput");
        String docdescrip = planObj.getString("docdescrip");
        varParams.put("docDescription", docdescrip);
        varParams.put("fieldParam", CommonUtil.getFieldParam(planObj));
        String taskId = CommonUtil.createLLMTask(varParams);
        DynamicObject ieLLMhistoryObj = BusinessDataServiceHelper.newDynamicObject((String)"cvp_ie_llm_history");
        ieLLMhistoryObj.set("layoutdata_tag", (Object)JSON.toJSONString(layoutData));
        ieLLMhistoryObj.set("pageinfo_tag", (Object)JSON.toJSONString(tieExtractData.getPageInfo()));
        ieLLMhistoryObj.set("ieplan", targetObj.getDynamicObject("iemould").getPkValue());
        ieLLMhistoryObj.set("llmtaskid", (Object)taskId);
        ieLLMhistoryObj.set("iehistory", targetObj.getPkValue());
        ieLLMhistoryObj.set("id", (Object)DB.genLongId((String)"cvp_ie_llm_history"));
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)ieLLMhistoryObj.getDataEntityType().getName(), (DynamicObject)ieLLMhistoryObj, null);
        ieLLMhistoryObj.set("billno", (Object)CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)ieLLMhistoryObj));
        ieLLMhistoryObj.set("createtime", (Object)new Date());
        ieLLMhistoryObj.set("modifytime", (Object)ieLLMhistoryObj.getDate("createtime"));
        ieLLMhistoryObj.set("extractstatus", (Object)"running");
        ieLLMhistoryObj.set("firstextract", (Object)true);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{ieLLMhistoryObj});
        targetObj.set("llmtaskid", (Object)taskId);
        targetObj.set("withctieresult", (Object)false);
        targetObj.set("docstr_tag", (Object)input);
    }

    private static String buildInput(List<DocTotalRecLayoutDataVO> layoutData) {
        if (layoutData != null && !layoutData.isEmpty()) {
            int pageNum = 1;
            GeneralIEResult.Coordinate lastTop = new GeneralIEResult.Coordinate();
            GeneralIEResult.Coordinate lastBot = new GeneralIEResult.Coordinate();
            StringBuilder sb = new StringBuilder();
            boolean isBegin = true;
            for (DocTotalRecLayoutDataVO layout : layoutData) {
                String layoutType = layout.getLayoutType();
                String text = layout.getText();
                List<PicAndPdfTextLineVO> textLines = layout.getTextLines();
                LayoutLocation layoutLocation = layout.getLayoutLocation();
                GeneralIEResult.Coordinate left_top = layoutLocation.getLeft_top();
                GeneralIEResult.Coordinate right_top = layoutLocation.getRight_top();
                GeneralIEResult.Coordinate left_bottom = layoutLocation.getLeft_bottom();
                GeneralIEResult.Coordinate right_bottom = layoutLocation.getRight_bottom();
                int currentPageNum = layout.getPageNum();
                if (currentPageNum != pageNum) {
                    lastBot = new GeneralIEResult.Coordinate();
                    lastTop = new GeneralIEResult.Coordinate();
                    pageNum = currentPageNum;
                    sb.append("\n");
                }
                if (!OcrLayoutTypeEnum.TABLE.getType().equals(layoutType)) {
                    int spaceSize;
                    if (lastBot.getY() != 0 && lastTop.getY() != 0 && TiePullResultService.isNextLine(lastTop, lastBot, left_top, left_bottom) || left_bottom.getY() == 0 && left_top.getY() == 0 || !isBegin && lastBot.getY() == 0 && lastTop.getY() == 0) {
                        lastBot = new GeneralIEResult.Coordinate();
                        lastTop = new GeneralIEResult.Coordinate();
                        sb.append("\n");
                    }
                    if ((spaceSize = (left_bottom.getX() - lastBot.getX()) / 30) > 0) {
                        sb.append(TiePullResultService.getSpaceStr(spaceSize));
                    }
                    if (textLines != null && !textLines.isEmpty()) {
                        boolean isFirstTextLine = true;
                        for (PicAndPdfTextLineVO textLine : textLines) {
                            GeneralIEResult.Coordinate textLineCurrentBot = textLine.getLocation().getLeft_bottom();
                            GeneralIEResult.Coordinate textLineCurrentTop = textLine.getLocation().getLeft_top();
                            if (lastTop.getY() != 0 && lastBot.getY() != 0 && !isFirstTextLine && TiePullResultService.isNextLine(lastTop, lastBot, textLineCurrentTop, textLineCurrentBot)) {
                                sb.append("\n");
                            }
                            sb.append(textLine.getWords());
                            lastTop = textLineCurrentTop;
                            lastBot = textLineCurrentBot;
                            isFirstTextLine = false;
                        }
                    } else {
                        sb.append(text);
                    }
                } else {
                    lastBot = new GeneralIEResult.Coordinate();
                    lastTop = new GeneralIEResult.Coordinate();
                    sb.append(CommonUtil.buildMarkDownTab(isBegin, layout));
                }
                isBegin = false;
            }
            return sb.toString();
        }
        return null;
    }

    private static boolean isNextLine(GeneralIEResult.Coordinate lastTop, GeneralIEResult.Coordinate lastBot, GeneralIEResult.Coordinate currentTop, GeneralIEResult.Coordinate currentBot) {
        return currentTop.getY() >= lastBot.getY();
    }

    private static String getSpaceStr(int spaceSize) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < spaceSize; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    private static void doFailUpdate(DynamicObject taskObj, TieExtractData cTask) {
        String progress = cTask.getProgress();
        if (StringUtils.isNotEmpty((String)progress)) {
            progress = progress.length() > 200 ? progress.substring(0, 200) : progress;
        }
        taskObj.set("progressinfo", (Object)progress);
        taskObj.set("extractstatus", (Object)cTask.getStatus());
        taskObj.set("billenddate", (Object)cTask.getEndDate());
        taskObj.set("billieresult", (Object)CommonUtil.encryptString(JSON.toJSONString((Object)cTask)));
        SaveServiceHelper.update((DynamicObject)taskObj);
    }

    private static void doSuccessUpdate(DynamicObject taskObj, TieExtractData cTask) {
        List<String> filePathList;
        String taskId = cTask.getTaskId();
        List<ConversionAlgoInfo> tieImages = cTask.getTieImages();
        TiePullResultService.updateDBAlert(taskObj);
        try {
            logger.info("isTest:{}", (Object)taskObj.getBoolean("isTest"));
            filePathList = CommonUtil.batchUploadImagesNew(tieImages, taskId, false);
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u5904\u7406\u6587\u4ef6\u5931\u8d25\uff0c\u7a0d\u540e\u91cd\u8bd5", (Throwable)e);
            return;
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                CommonUtil.batchSaveImages(tieImages, taskId, "");
                TiePullResultService.updateToDb(taskObj, cTask);
            }
            catch (Exception e1) {
                h.markRollback();
                throw e1;
            }
        }
        catch (Exception e) {
            logger.error("\u6587\u6863\u4fe1\u606f\u63d0\u53d6\u4efb\u52a1\u72b6\u6001\u66f4\u65b0\u5931\u8d25\uff0c\u7b49\u5f85\u4e0b\u6b21\u66f4\u65b0\u5904\u7406\u3002", (Throwable)e);
        }
        try {
            CommonUtil.deleteZipAndTempFile(filePathList);
        }
        catch (Exception e) {
            logger.error("\u6e05\u7406\u7b97\u6cd5\u8c03\u5ea6\u4e34\u65f6\u6587\u4ef6\u548c\u538b\u7f29\u6587\u4ef6\u5f02\u5e38,\u4efb\u52a1id:{}", (Object)taskId, (Object)e);
        }
    }

    private static void updateDBAlert(DynamicObject taskObj) {
        QFilter notFaildFilter;
        QFilter qFilter;
        ORM orm = ORM.create();
        DynamicObject task = orm.queryOne("cvp_ie_history", "id,extractstatus", new QFilter[]{qFilter = new QFilter("id", "=", taskObj.getPkValue()), notFaildFilter = new QFilter("extractstatus", "!=", (Object)"error")});
        if (task != null && !Arrays.asList("error", "cancel", "success").contains(task.getString("extractstatus"))) {
            if ("1,2,3".contains(taskObj.getString("tieType"))) {
                logger.info("\u5927\u6a21\u578b\u63d0\u53d6\uff0c\u66f4\u65b0\u7ed3\u679c\u63d0\u793a\u8bcd...\u63d0\u53d6\u72b6\u6001\uff1a{}", (Object)task.getString("extractstatus"));
                taskObj.set("progressinfo", (Object)ResManager.loadKDString((String)"\u6587\u6863\u5185\u5bb9\u63d0\u53d6\u5df2\u5b8c\u6210\n\n\u6b63\u5728\u8fdb\u884c\u5927\u6a21\u578b\u63d0\u53d6\uff0c\u8bf7\u7a0d\u5019...", (String)"TiePullResultService_001", (String)"ai-cvp-common", (Object[])new Object[0]));
            } else {
                taskObj.set("progressinfo", (Object)ResManager.loadKDString((String)"\u4fe1\u606f\u63d0\u53d6\u5b8c\u6210\uff0c\u6b63\u5728\u540c\u6b65\u7ed3\u679c\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"TiePullResultService_001", (String)"ai-cvp-common", (Object[])new Object[0]));
            }
            SaveServiceHelper.update((DynamicObject)taskObj);
        }
    }

    private static void updateToDb(DynamicObject taskObj, TieExtractData cTask) {
        Date endDate = cTask.getEndDate();
        Object taskId = taskObj.getPkValue();
        taskObj.set("billieresult", (Object)CommonUtil.encryptString(JSON.toJSONString((Object)cTask)));
        taskObj.set("billenddate", (Object)endDate);
        List supportList = Stream.of(IeExtractTypeEnum.LLM_EXTRACT.getExtractType() + "", IeExtractTypeEnum.COMMON_AND_LLM_EXTRACT.getExtractType() + "", IeExtractTypeEnum.COMMON_TABLE_EXTRACT.getExtractType() + "").collect(Collectors.toList());
        if (supportList.contains(taskObj.getString("tieType"))) {
            DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"cvp_ie_history", (String)"id,extractstatus");
            if (task != null && !Arrays.asList("error", "cancel", "success").contains(task.getString("extractstatus"))) {
                boolean llmResult = "llm_suc".equals(task.getString("extractstatus"));
                if (llmResult) {
                    taskObj.set("extractstatus", (Object)"success");
                    taskObj.set("progressinfo", (Object)ResManager.loadKDString((String)"\u63d0\u53d6\u5b8c\u6210", (String)"TiePullResultService_304", (String)"ai-cvp-common", (Object[])new Object[0]));
                } else {
                    taskObj.set("extractstatus", (Object)"extract_suc");
                }
                SaveServiceHelper.update((DynamicObject)taskObj);
            }
        } else {
            String status = cTask.getStatus();
            taskObj.set("extractstatus", (Object)status);
            taskObj.set("progressinfo", (Object)ResManager.loadKDString((String)"\u63d0\u53d6\u5b8c\u6210", (String)"TiePullResultService_304", (String)"ai-cvp-common", (Object[])new Object[0]));
            SaveServiceHelper.update((DynamicObject)taskObj);
        }
    }

    private static Map<String, DynamicObject> buildTaskRef(DynamicObject[] taskObjArr) {
        HashMap<String, DynamicObject> taskIdObjRef = new HashMap<String, DynamicObject>();
        if (taskObjArr == null || taskObjArr.length < 1) {
            return taskIdObjRef;
        }
        Arrays.stream(taskObjArr).forEach(taskObj -> taskIdObjRef.put(taskObj.getString("taskid"), (DynamicObject)taskObj));
        return taskIdObjRef;
    }

    private static List<DynamicObject[]> splitTaskArr(DynamicObject[] tieTaskArr, int taskSize) {
        if (tieTaskArr == null || tieTaskArr.length < 1) {
            return Collections.emptyList();
        }
        ArrayList<DynamicObject[]> list = new ArrayList<DynamicObject[]>();
        if (tieTaskArr.length <= taskSize) {
            list.add(tieTaskArr);
        } else {
            TiePullResultService.doSplit(list, tieTaskArr, taskSize);
        }
        return list;
    }

    private static void doSplit(List<DynamicObject[]> list, DynamicObject[] tieTaskArr, int taskSize) {
        int size = tieTaskArr.length;
        int arrNum = size % taskSize == 0 ? size / taskSize : size / taskSize + 1;
        ArrayList<DynamicObject> totalList = new ArrayList<DynamicObject>(Arrays.asList(tieTaskArr));
        for (int i = 0; i < arrNum; ++i) {
            List splitList = totalList.subList(i * taskSize, (i + 1) * taskSize >= size ? size : (i + 1) * taskSize);
            list.add(splitList.toArray(new DynamicObject[0]));
        }
    }

    private static DynamicObject[] queryRunningTask() {
        QFilter statusFilter = new QFilter("extractstatus", "in", (Object)new String[]{"running", "llm_suc"});
        String orderBy = "billcreatedate desc";
        return BusinessDataServiceHelper.load((String)"cvp_ie_history", (String)"id,billenddate,extractstatus,billdocpath,billieresult,progressinfo,taskid,iemould,llmtaskid,tietype,withctieresult,docstr_tag,istest", (QFilter[])new QFilter[]{statusFilter}, (String)orderBy);
    }

    private static boolean existTask() {
        QFilter statusFilter = new QFilter("extractstatus", "in", (Object)new String[]{"running", "llm_suc"});
        ORM orm = ORM.create();
        return orm.exists("cvp_ie_history", new QFilter[]{statusFilter});
    }
}

