/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.task.cls;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.ai.cvp.common.Enum.StorageTypeEnum;
import kd.ai.cvp.core.op.ClassifierOperateFormal;
import kd.ai.cvp.entity.classifier.ClsAlgoResultData;
import kd.ai.cvp.entity.classifier.ClsFileInfo;
import kd.ai.cvp.entity.classifier.ClsProcessResult;
import kd.ai.cvp.entity.classifier.ClsTargetFile;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.WaitingRejectedHandler;
import kd.bos.threads.impl.ThreadPoolImpl;
import org.apache.commons.lang3.StringUtils;

public class ClassifierService {
    private static Log LOGGER = LogFactory.getLog(ClassifierService.class);
    private static ExecutorService ES = ClassifierService.createFixedThreadPool("ai-cvp-pool-classifier", 1);
    private static ThreadPool pool = new ThreadPoolImpl(ES, null, aBoolean -> {});
    private static final int MAX_FIX_QUEUESIZE = 100000;
    private static volatile LinkedBlockingQueue queue;

    private static ExecutorService createFixedThreadPool(final String poolName, int nThreads) {
        if (nThreads > 1000) {
            nThreads = 1000;
        }
        queue = new LinkedBlockingQueue(100000);
        return ThreadLifeCycleManager.wrapExecutorService((ExecutorService)new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, queue, new ThreadFactory(){
            private AtomicInteger atomicInteger = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, poolName + "-" + this.atomicInteger.incrementAndGet());
            }
        }, (RejectedExecutionHandler)new WaitingRejectedHandler()));
    }

    public static synchronized void excuteTask() {
        try {
            LOGGER.info("cvp-\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u542f\u52a8\u5206\u7c7b\u4efb\u52a1 ai-cvp-pool-classifier");
            DynamicObjectCollection ids = QueryServiceHelper.query((String)"cvp_classifier_task", (String)"id", (QFilter[])new QFilter[]{new QFilter("billstatus", "=", (Object)"new")}, (String)"createtime asc");
            for (DynamicObject idObj : ids) {
                long id = idObj.getLong("id");
                pool.execute((Runnable)new ClassifierTask(id));
            }
            LOGGER.info("cvp-\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u542f\u52a8\u5206\u7c7b\u4efb\u52a1-\u6b63\u5728\u66f4\u65b0\u4efb\u52a1\u4e2d ai-cvp-pool-classifier");
        }
        catch (Exception e) {
            LOGGER.info("cvp-\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u542f\u52a8\u5206\u7c7b\u4efb\u52a1-\u4efb\u52a1\u542f\u52a8\u5931\u8d25 ai-cvp-pool-classifier  \u6267\u884c\u5668\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static class ClassifierTask
    implements Runnable {
        private final long classifyTaskId;
        private RequestContext rc = RequestContext.get();
        private static final long LOCK_WAIT_TIME = 3000L;
        private static final String LOCK_KEY_PER = "cvp_classifier_";

        public ClassifierTask(long classifyTaskId) {
            this.classifyTaskId = classifyTaskId;
        }

        @Override
        public void run() {
            DynamicObject task;
            block9: {
                task = null;
                try {
                    boolean isExec = QueryServiceHelper.exists((String)"cvp_classifier_task", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.classifyTaskId).and("billstatus", "=", (Object)"new")});
                    String lockKey = LOCK_KEY_PER.concat(this.rc.getTenantCode()).concat(this.rc.getAccountId()).concat(String.valueOf(this.classifyTaskId));
                    DLock lock = ClassifierTask.getLock(lockKey);
                    if (!isExec || !lock.tryLock(3000L)) {
                        LOGGER.info(String.format("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u5206\u7c7b\u8bc6\u522b\u5668-\u5206\u7c7b\u4efb\u52a1,\u83b7\u4efb\u52a1\u6267\u884c\u6743\u5931\u8d25\uff0c\u4e2d\u65ad\u672c\u6b21\u4efb\u52a1\uff0c\u5206\u7c7b\u4efb\u52a1ID: %s ,\u67e5\u8be2\u65b0\u5efa\u72b6\u6001: %s", this.classifyTaskId, isExec));
                        return;
                    }
                    try {
                        task = BusinessDataServiceHelper.loadSingle((Object)this.classifyTaskId, (String)"cvp_classifier_task");
                        task.set("billstatus", (Object)"running");
                        SaveServiceHelper.update((DynamicObject)task);
                        DynamicObjectCollection originals = task.getDynamicObjectCollection("cvp_cls_original_info");
                        long classifierId = task.getLong("classifierid");
                        ArrayList<ClsTargetFile> files = new ArrayList<ClsTargetFile>(originals.size());
                        for (DynamicObject o : originals) {
                            String fileId = String.valueOf(o.getPkValue());
                            String filename = o.getString("filename");
                            String fileType = o.getString("filetype");
                            String filePath = o.getString("filepath");
                            String fileSize = o.getString("filesize");
                            String storagetypeStr = o.getString("storagetype");
                            StorageTypeEnum storagetype = StorageTypeEnum.getStorageTypeEnum(storagetypeStr);
                            ClsTargetFile file = new ClsTargetFile(filePath, fileId, filename, fileType, fileSize, storagetype);
                            files.add(file);
                            o.set("clstype", (Object)"success");
                        }
                        ClsProcessResult clsResult = ClassifierOperateFormal.instance.run(files, classifierId);
                        List<ClsFileInfo> clsFileInfos = clsResult.getClsFileInfos();
                        ClsAlgoResultData algoResult = clsResult.getClsResult();
                        List<ClsAlgoResultData.ClassifierInfo> clsDatas = algoResult.getClsSuccess();
                        List<ClsAlgoResultData.ClassifierInfo> clsFailure = algoResult.getClsFailure();
                        clsDatas.addAll(clsFailure);
                        DynamicObject[] ds = new DynamicObject[clsFileInfos.size()];
                        for (int i = 0; i < clsFileInfos.size(); ++i) {
                            DynamicObject recTask;
                            ds[i] = recTask = this.createRecTask(clsFileInfos, clsDatas, i);
                        }
                        SaveServiceHelper.save((DynamicObject[])ds);
                        task.set("billstatus", (Object)"success");
                    }
                    catch (Exception e) {
                        try {
                            String message = String.format("\u5355\u524d\u4efb\u52a1\u6267\u884c\u7684traceId:%s ,\u5f02\u5e38\u4fe1\u606f\uff1a%s", this.rc.getTraceId(), e.getMessage().length() > 300 ? e.getMessage().substring(0, 299) : e.getMessage());
                            LOGGER.error(String.format("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u5206\u7c7b\u8bc6\u522b\u5668-\u5206\u7c7b\u4efb\u52a1 \u5f02\u5e38\uff0c\u5f85\u4e0b\u6b21\u66f4\u65b0: %s", message), (Throwable)e);
                            throw new KDBizException(message);
                        }
                        catch (Throwable throwable) {
                            LOGGER.info(String.format("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u5206\u7c7b\u8bc6\u522b\u5668-\u5206\u7c7b\u4efb\u52a1, \u91ca\u653e\u9501\uff1a%s", lockKey));
                            lock.unlock();
                            throw throwable;
                        }
                    }
                    LOGGER.info(String.format("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u5206\u7c7b\u8bc6\u522b\u5668-\u5206\u7c7b\u4efb\u52a1, \u91ca\u653e\u9501\uff1a%s", lockKey));
                    lock.unlock();
                }
                catch (Exception e) {
                    LOGGER.error(String.format("\u7ec4\u5408\u8bc6\u522b-\u5206\u7c7b\u4efb\u52a1\uff0c\u5931\u8d25 >>>> \u5206\u7c7b\u4efb\u52a1ID:%s ", this.classifyTaskId));
                    if (!Objects.nonNull(task)) break block9;
                    task.set("billstatus", (Object)"error");
                    task.set("process", (Object)e.getMessage());
                }
            }
            SaveServiceHelper.update(task);
        }

        public DynamicObject createRecTask(List<ClsFileInfo> clsFileInfos, List<ClsAlgoResultData.ClassifierInfo> clsDatas, int i) {
            DynamicObject recTask = ORM.create().newDynamicObject("cvp_classifier_rec_task");
            ClsFileInfo f = clsFileInfos.get(i);
            String imageId = f.getImageId();
            ClsAlgoResultData.ClassifierInfo cInfo = clsDatas.stream().filter(c -> imageId.equals(c.getFileId())).findFirst().get();
            String templateNum = cInfo.getTemplateNum();
            recTask.set("templatenum", (Object)templateNum);
            recTask.set("billno", (Object)this.classifyTaskId);
            recTask.set("originalfileid", (Object)f.getOriginalfileid());
            recTask.set("fileid", (Object)imageId);
            recTask.set("filepath", (Object)f.getImagePath());
            recTask.set("filenum", (Object)f.getPageNum());
            recTask.set("storagetype", (Object)f.getStoragetype().getStorageType());
            recTask.set("tid", (Object)cInfo.getTId());
            recTask.set("ocrid", (Object)cInfo.getOcrId());
            recTask.set("confidence", (Object)cInfo.getConfidence());
            recTask.set("billstatus", (Object)(StringUtils.isBlank((CharSequence)templateNum) ? "non" : "new"));
            return recTask;
        }

        private static DLock getLock(String lockKey) {
            DLock lock = DLock.create((String)lockKey, (String)String.format("\u9501:%s,\u5dee\u5f02\u5206\u6790\u4efb\u52a1\u66f4\u65b0\u9501", lockKey));
            lock.fastMode();
            return lock;
        }
    }
}

