/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kd.ai.cvp.common.Enum.FileServiceTypeEnum;
import kd.ai.cvp.common.Enum.FileValidTypeEnum;
import kd.ai.cvp.common.Enum.LicenseCountServiceNameEnum;
import kd.ai.cvp.common.Enum.SourceTypeEnum;
import kd.ai.cvp.common.Enum.StorageTypeEnum;
import kd.ai.cvp.common.Enum.VisualTypeEnum;
import kd.ai.cvp.entity.AlgoPageNumAndFileIdVO;
import kd.ai.cvp.entity.AlgoResultData;
import kd.ai.cvp.entity.AlgoResultForDeleteZipTempFileVO;
import kd.ai.cvp.entity.AlgoResultForTdaOrTie;
import kd.ai.cvp.entity.InitTdaTieAttData;
import kd.ai.cvp.entity.ValidFileVO;
import kd.ai.cvp.entity.ie.DocTotalRecLayoutDataVO;
import kd.ai.cvp.entity.ie.IeCellEntity;
import kd.ai.cvp.entity.ie.PicAndPdfCellVO;
import kd.ai.cvp.entity.ie.PicAndPdfTableVO;
import kd.ai.cvp.entity.param.OcrParam;
import kd.ai.cvp.entity.tda.TdaCancelTaskResultVO;
import kd.ai.cvp.entity.tda.algoCompare.ConversionAlgoInfo;
import kd.ai.cvp.entity.tda.att.AttData;
import kd.ai.cvp.entity.tda.att.AttachmentVO;
import kd.ai.cvp.utils.CvpFileServiceUtils;
import kd.ai.cvp.utils.LicenseUtils;
import kd.ai.cvp.utils.LocalTempFileCache;
import kd.ai.cvp.utils.OcrControlUtils;
import kd.ai.cvp.utils.OcrHttpClientUtils;
import kd.ai.cvp.utils.PDFPageNumUtil;
import kd.ai.cvp.utils.StreamHandleUtils;
import kd.ai.cvp.utils.ThreadUtils;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.encrypt.Encrypters;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.session.SessionManager;
import kd.bos.util.FileNameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;

public class CommonUtil {
    private static final Log logger = LogFactory.getLog(CommonUtil.class);
    private static final int TIMEOUT = 86400;
    private static final String TIPS = "\u81ea\u5b9a\u4e49\u63d0\u53d6\u8303\u56f4\u65e0\u6548\uff0c\u8bf7\u6309\u63d0\u793a\u8f93\u5165\u3002";
    private static final String TIPS_BLANK_INPUT = "\u8f93\u5165\u5185\u5bb9\u5305\u542b\u7a7a\u9875\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002";
    private static final long MAXFILESIZE = 0xA00000L;
    private static final String SUPPORT_IMAGE_TYPE = "jpg,jpeg,png,bmp";
    private static final String SECKEY = "HmacSHA256";
    private static final String CHARSET_UTF8 = "utf-8";
    private static final String KEY_TEMP_FILE_ID = "tempFileId";
    private static final String KEY_VALID_RESULT = "validResult";
    private static final String KEY_SERVICE = "service";
    private static final String KEY_PROMPT = "prompt";

    private CommonUtil() {
        throw new KDBizException("init error");
    }

    public static String HMACSHA256(byte[] data, byte[] key) throws InvalidKeyException, NoSuchAlgorithmException {
        SecretKeySpec signingKey = new SecretKeySpec(key, SECKEY);
        Mac mac = Mac.getInstance(SECKEY);
        mac.init(signingKey);
        return CommonUtil.byte2hex(mac.doFinal(data));
    }

    public static String HMACSHA256(String data, String key) throws Exception {
        Mac sha256_HMAC = Mac.getInstance(SECKEY);
        SecretKeySpec secret_key = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), SECKEY);
        sha256_HMAC.init(secret_key);
        byte[] array = sha256_HMAC.doFinal(data.getBytes(StandardCharsets.UTF_8));
        StringBuilder sb = new StringBuilder();
        for (byte item : array) {
            sb.append(Integer.toHexString(item & 0xFF | 0x100).substring(1, 3));
        }
        return sb.toString().toUpperCase();
    }

    public static String sign(String method, String url, TreeMap<String, String> params, TreeMap<String, String> headers, String key) throws Exception {
        String source = method.toUpperCase() + "\n";
        source = source + URLEncoder.encode(url, CHARSET_UTF8) + "\n";
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            sb.append(URLEncoder.encode(entry.getKey(), CHARSET_UTF8)).append('=').append(URLEncoder.encode(entry.getValue(), CHARSET_UTF8)).append('&');
        }
        String paramsString = sb.toString();
        if (paramsString.length() > 0) {
            paramsString = paramsString.substring(0, paramsString.length() - 1);
            source = source + paramsString + "\n";
        } else {
            source = source + paramsString + "\n";
        }
        sb = new StringBuilder();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            sb.append(entry.getKey().toLowerCase()).append(':').append(entry.getValue().trim()).append('\n');
        }
        StringBuilder stringBuilder = new StringBuilder(source);
        stringBuilder.append((CharSequence)sb);
        return CommonUtil.hmac(stringBuilder.toString(), key);
    }

    private static byte[] bytesToHex(byte[] hashInBytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < hashInBytes.length; ++i) {
            String hex = Integer.toHexString(hashInBytes[i] & 0xFF);
            if (hex.length() < 2) {
                hex = '0' + hex;
            }
            sb.append(hex);
        }
        return sb.toString().getBytes(StandardCharsets.ISO_8859_1);
    }

    private static String byte2hex(byte[] b) {
        StringBuilder hs = new StringBuilder();
        for (int n = 0; b != null && n < b.length; ++n) {
            String stmp = Integer.toHexString(b[n] & 0xFF);
            if (stmp.length() == 1) {
                hs.append('0');
            }
            hs.append(stmp);
        }
        return hs.toString().toUpperCase();
    }

    private static String hmac(String source, String key) throws Exception {
        byte[] keyBytes = key.getBytes(StandardCharsets.ISO_8859_1);
        SecretKeySpec signingKey = new SecretKeySpec(keyBytes, SECKEY);
        Mac mac = Mac.getInstance(SECKEY);
        mac.init(signingKey);
        byte[] rawHmac = mac.doFinal(source.getBytes(StandardCharsets.ISO_8859_1));
        byte[] bytes1 = CommonUtil.bytesToHex(rawHmac);
        Base64.Encoder encoder = Base64.getEncoder();
        byte[] bytes = encoder.encode(bytes1);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static String getBillNumber(DynamicObject parentObj) {
        String number = kd.bos.util.StringUtils.getEmpty();
        try {
            number = parentObj.getString("number");
        }
        catch (Exception e) {
            logger.error("\u7236\u5355\u636e\u4e0d\u5b58\u5728number\u5c5e\u6027\uff0c\u5c1d\u8bd5\u83b7\u53d6billno\u5c5e\u6027", (Throwable)e);
            try {
                number = parentObj.getString("billno");
            }
            catch (Exception ex) {
                logger.error("\u7236\u5355\u636e\u4e0d\u5b58\u5728billno\u5c5e\u6027\uff0c\u65e0\u6cd5\u83b7\u53d6\u7f16\u7801\u5b57\u6bb5\uff0c\u5ffd\u7565", (Throwable)ex);
            }
        }
        return number;
    }

    public static String getBillName(DynamicObject parentObj) {
        String name = kd.bos.util.StringUtils.getEmpty();
        try {
            name = parentObj.getString("name");
        }
        catch (Exception e) {
            logger.error("\u7236\u5355\u636e\u4e0d\u5b58\u5728name\u5c5e\u6027\uff0c\u5c1d\u8bd5\u83b7\u53d6billname\u5c5e\u6027", (Throwable)e);
            try {
                name = parentObj.getString("billname");
            }
            catch (Exception ex) {
                logger.error("\u7236\u5355\u636e\u83b7\u53d6billname\u5931\u8d25\uff0c\u5ffd\u7565\u5c5e\u6027\u503c", (Throwable)ex);
            }
        }
        return name;
    }

    public static AlgoPageNumAndFileIdVO getWordOrOfdPages(InputStream inputStream, String fileName) throws Exception {
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        multipartEntityBuilder.setCharset(StandardCharsets.UTF_8);
        multipartEntityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        multipartEntityBuilder.addBinaryBody("file", inputStream, ContentType.MULTIPART_FORM_DATA, fileName);
        HttpEntity httpEntity = multipartEntityBuilder.build();
        logger.info("\u5f00\u59cb\u8bf7\u6c42\u7b97\u6cd5\u8c03\u5ea6\u83b7\u53d6\u9875\u7801\u6570\u63a5\u53e3...");
        String resultStr = OcrHttpClientUtils.kdCloudHttpClientPost("/vrsp/license/queryFilePageCountAndFileId", httpEntity);
        logger.info("\u7ed3\u675f\u7b97\u6cd5\u8c03\u5ea6\u9875\u7801\u6570\u63a5\u53e3...");
        AlgoResultData resultData = (AlgoResultData)JSON.parseObject((String)resultStr, AlgoResultData.class);
        if (0 != resultData.getErrorCode()) {
            logger.info(String.format("\u89c6\u89c9\u8bc6\u522b\u4fe1\u606f\u63d0\u53d6\uff0c\u6587\u4ef6\u89e3\u6790\u83b7\u53d6\u9875\u6570\u5f02\u5e38\uff0c\u64cd\u4f5c\u8bf7\u6c42\u4fe1\u606f: %s", resultStr));
            throw new KDBizException(new ErrorCode("41009", ResManager.loadKDString((String)"\u89e3\u6790\u6587\u4ef6\u83b7\u53d6\u9875\u6570\u5f02\u5e38", (String)"CommonUtil_4", (String)"ai-cvp-common", (Object[])new Object[0])), new Object[0]);
        }
        AlgoPageNumAndFileIdVO algoPageNumAndFileIdVO = (AlgoPageNumAndFileIdVO)JSON.parseObject((String)String.valueOf(resultData.getData()), AlgoPageNumAndFileIdVO.class);
        return algoPageNumAndFileIdVO;
    }

    public static void validSelectedFile(IFormView view, String args, String selfControlName, String commandStr, VisualTypeEnum typeEnum) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (kd.bos.util.StringUtils.isEmpty((String)args)) {
            CommonUtil.errorTips(view, resultMap, "\u6587\u4ef6\u6821\u9a8c\u5931\u8d25\uff0c\u6587\u4ef6\u4e0d\u5b58\u5728\u3002", "\u6587\u4ef6\u6821\u9a8c\u5165\u53c2\u4e3a\u7a7a", selfControlName, commandStr);
            return;
        }
        ValidFileVO validFileInfo = (ValidFileVO)JSON.parseObject((String)args, ValidFileVO.class);
        String url = validFileInfo.getUrl();
        String fileName = validFileInfo.getFileName();
        String type = validFileInfo.getType();
        if (kd.bos.util.StringUtils.isEmpty((String)url) || kd.bos.util.StringUtils.isEmpty((String)fileName)) {
            CommonUtil.errorTips(view, resultMap, "\u6587\u4ef6\u6821\u9a8c\u5931\u8d25\uff0c\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", "\u6587\u4ef6\u6821\u9a8c\u5931\u8d25\uff0c\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a\u3002", selfControlName, commandStr);
            return;
        }
        url = FileServiceFactory.getAttachmentFileService().getFileServiceExt().getRealPath(url);
        try {
            IPageCache pageCache = view.getPageCache();
            if (typeEnum == VisualTypeEnum.DIFF_COMPARISON) {
                boolean baseFlag = CommonUtil.diffComparisonBaseValid(view, selfControlName, commandStr, resultMap, type, url);
                if (!baseFlag) {
                    return;
                }
                String localTempId = CvpFileServiceUtils.attFile2TempFile(url);
                resultMap.put(KEY_TEMP_FILE_ID, localTempId);
                resultMap.put(KEY_VALID_RESULT, Boolean.TRUE);
                OcrControlUtils.setTdaOrTieCustomcontrolData(view, selfControlName, commandStr, resultMap);
            } else if (typeEnum == VisualTypeEnum.INFO_EXTRACT) {
                boolean exists = FileServiceFactory.getAttachmentFileService().exists(url);
                if (!exists) {
                    CommonUtil.errorTips(view, resultMap, "\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u4e0a\u4f20\u540e\u91cd\u8bd5\uff01", "\u4e0a\u4f20\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\u3002", selfControlName, commandStr);
                    return;
                }
                String localTempId = CvpFileServiceUtils.attFile2TempFile(url);
                resultMap.put(KEY_TEMP_FILE_ID, localTempId);
                pageCache.put("tempFileId_extract", localTempId);
                resultMap.put(KEY_VALID_RESULT, Boolean.TRUE);
                OcrControlUtils.setTdaOrTieCustomcontrolData(view, selfControlName, commandStr, resultMap);
            }
        }
        catch (KDBizException kde) {
            CommonUtil.errorTips(view, resultMap, kde.getMessage(), kde.getMessage(), selfControlName, commandStr);
        }
        catch (Exception th) {
            CommonUtil.errorTips(view, resultMap, "\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", th.getMessage(), selfControlName, commandStr);
        }
    }

    public static void validFileWhenInit(InitTdaTieAttData attData, String type) throws Exception {
        if (attData == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u4e0a\u4f20\u540e\u91cd\u8bd5\u3002", (String)"TdaUtils_020", (String)"ai-cvp-common", (Object[])new Object[0]));
        }
        Object fileType = attData.getFileType();
        Object fileSizeObj = attData.getFileSize();
        Object fileNameObj = attData.getFileName();
        Object urlObj = attData.getUrl();
        if (urlObj == null || fileNameObj == null || fileSizeObj == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u4e0a\u4f20\u540e\u91cd\u8bd5\u3002", (String)"TdaUtils_020", (String)"ai-cvp-common", (Object[])new Object[0]));
        }
        String url = urlObj.toString();
        String fileSize = fileSizeObj.toString();
        String fileName = fileNameObj.toString();
        boolean exists = FileServiceFactory.getAttachmentFileService().exists(url);
        if (!exists) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u4e0a\u4f20\u540e\u91cd\u8bd5\u3002", (String)"TdaUtils_020", (String)"ai-cvp-common", (Object[])new Object[0]));
        }
        String localTempId = CvpFileServiceUtils.attFile2TempFile(url);
        FileValidTypeEnum tEnum = FileValidTypeEnum.getTypeEnum(type);
        CommonUtil.fileValid(localTempId, fileName, tEnum, "jpg,jpeg,png,bmp,pdf,doc,docx,ofd,wps", 0xC800000L, 500);
    }

    private static boolean diffComparisonBaseValid(IFormView view, String selfControlName, String commandStr, Map<String, Object> resultMap, String type, String url) {
        if (kd.bos.util.StringUtils.isEmpty((String)type) || !FileValidTypeEnum.exist(type)) {
            CommonUtil.errorTips(view, resultMap, "\u6587\u4ef6\u6821\u9a8c\u5931\u8d25\uff0c\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a\u6216\u65e0\u6548\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", "\u6587\u4ef6\u6821\u9a8c\u5931\u8d25\uff0c\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a\u6216\u65e0\u6548\u3002", selfControlName, commandStr);
            return false;
        }
        FileValidTypeEnum tEnum = FileValidTypeEnum.getTypeEnum(type);
        if (tEnum == null) {
            CommonUtil.errorTips(view, resultMap, "\u6587\u4ef6\u6821\u9a8c\u5931\u8d25\uff0c\u5fc5\u8981\u53c2\u6570\u65e0\u6548\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", "\u6587\u4ef6\u6821\u9a8c\u5931\u8d25\uff0c\u5fc5\u8981\u53c2\u6570\u65e0\u6548\u3002", selfControlName, commandStr);
            return false;
        }
        boolean exists = FileServiceFactory.getAttachmentFileService().exists(url);
        if (!exists) {
            CommonUtil.errorTips(view, resultMap, CommonUtil.getTypeStr(tEnum).concat("\u4e0d\u5b58\u5728\u3002\u8bf7\u4e0a\u4f20\u540e\u91cd\u8bd5\uff01"), "\u4e0a\u4f20\u6587\u4ef6\u4e0d\u5b58\u5728\u3002", selfControlName, commandStr);
            return false;
        }
        return true;
    }

    public static AlgoPageNumAndFileIdVO fileValid(String localTempId, String fileName, FileValidTypeEnum fileTypeEnum, String allowTypes, long maxFileSize, int maxFileNum) throws Exception {
        if (kd.bos.util.StringUtils.isEmpty((String)localTempId)) {
            throw new KDBizException(BosErrorCode.nullError, new Object[]{"\u6821\u9a8c\u5931\u8d25\uff0c\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002"});
        }
        try {
            CommonUtil.validFileType(localTempId, allowTypes, fileTypeEnum);
            return CommonUtil.checkFilePageNum(localTempId, fileName, fileTypeEnum, maxFileNum);
        }
        catch (IOException e) {
            logger.error("io \u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u3002", (Throwable)e);
            throw new KDBizException("\u7cfb\u7edfio \u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002");
        }
    }

    public static void md5SumValid(String baseLocalTempId, String compareLocalTempId) throws NoSuchAlgorithmException {
        try {
            long beginMd5Valid = System.currentTimeMillis();
            logger.info("\u6587\u4ef6\u91cd\u590d\u4ea4\u9a8c\u5f00\u59cb");
            try (InputStream baseInputStream = CvpFileServiceUtils.getFileIn(StorageTypeEnum.TMP, baseLocalTempId);
                 InputStream compareInputStream = CvpFileServiceUtils.getFileIn(StorageTypeEnum.TMP, compareLocalTempId);){
                if (baseInputStream == null || compareInputStream == null) {
                    throw new KDBizException("\u7cfb\u7edf\u5f02\u5e38\uff0c\u83b7\u53d6\u6587\u4ef6\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002");
                }
                byte[] salt = new byte[16];
                SecureRandom random = new SecureRandom();
                random.nextBytes(salt);
                String baseMD5Str = CommonUtil.calculateHash(baseInputStream, salt);
                String compareMD5Str = CommonUtil.calculateHash(compareInputStream, salt);
                logger.info("\u91cd\u590d\u6027\u6821\u9a8c\u7ed3\u675f\uff0c\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - beginMd5Valid));
                if (baseMD5Str.equals(compareMD5Str)) {
                    throw new KDBizException(new ErrorCode("30110", ResManager.loadKDString((String)"\u4e24\u7bc7\u6587\u6863\u4e3a\u540c\u4e00\u7bc7\uff0c\u8bf7\u4e0a\u4f20\u4e0d\u540c\u7248\u672c\u7684\u6587\u6863\u8fdb\u884c\u6bd4\u5bf9\u3002", (String)"CommonUtil_01", (String)"ai-cvp-common", (Object[])new Object[0])), new Object[0]);
                }
            }
        }
        catch (IOException e) {
            throw new KDBizException(new ErrorCode("41008", ResManager.loadKDString((String)"\u6587\u4ef6\u91cd\u590d\u6027\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002\u82e5\u91cd\u590d\u51fa\u73b0\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"CommonUtil_012", (String)"ai-cvp-common", (Object[])new Object[0])), new Object[0]);
        }
    }

    private static String calculateHash(InputStream is, byte[] salt) throws IOException {
        int numBytesRead;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((numBytesRead = is.read(buffer)) != -1) {
            outputStream.write(buffer, 0, numBytesRead);
        }
        outputStream.flush();
        HashFunction hashFunction = Hashing.hmacSha512((byte[])salt);
        HashCode hashCode = hashFunction.hashBytes(outputStream.toByteArray());
        return hashCode.toString();
    }

    private static AlgoPageNumAndFileIdVO checkFilePageNum(String id, String fileName, FileValidTypeEnum fileTypeEnum, int maxFileNum) throws Exception {
        AlgoPageNumAndFileIdVO algoPageNumAndFileIdVO;
        logger.info("checkFilePageNum begin...");
        try (InputStream inputStream = CvpFileServiceUtils.getFileIn(StorageTypeEnum.TMP, id);){
            if (inputStream == null) {
                throw new KDBizException("\u83b7\u53d6\u6587\u4ef6\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002");
            }
            if (kd.bos.util.StringUtils.isEmpty((String)fileName)) {
                throw new KDBizException("\u6587\u4ef6\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u662f\u5426\u6b63\u5e38\u3002");
            }
            int pageNum = -1;
            algoPageNumAndFileIdVO = CommonUtil.getFilePageNumAndFilePath(inputStream, fileName);
            if (algoPageNumAndFileIdVO != null) {
                pageNum = algoPageNumAndFileIdVO.getPageNum();
            }
            if (pageNum < 0) {
                logger.error("\u83b7\u53d6pdf\u9875\u7801\u5f02\u5e38\u3002");
                throw new KDBizException("\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002");
            }
            if (pageNum > maxFileNum) {
                throw new KDBizException(CommonUtil.getTypeStr(fileTypeEnum).concat("\u9875\u6570\u8d85\u51fa").concat(String.valueOf(maxFileNum)).concat("\u9875,\u8bf7\u91cd\u65b0\u4e0a\u4f20\u3002"));
            }
        }
        return algoPageNumAndFileIdVO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AlgoPageNumAndFileIdVO getFilePageNumAndFilePath(InputStream inputStream, String fileName) throws Exception {
        if (inputStream == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"CommonUtil_033", (String)"ai-cvp-common", (Object[])new Object[0]));
        }
        AlgoPageNumAndFileIdVO algoPageNumAndFileIdVO = new AlgoPageNumAndFileIdVO();
        byte[] bytes = StreamHandleUtils.copyStream(inputStream);
        StreamHandleUtils.closeResource(inputStream);
        ByteArrayInputStream headInputStream = null;
        ByteArrayInputStream secondInpuStream = null;
        int pageNum = -1;
        try {
            headInputStream = new ByteArrayInputStream(bytes);
            String typeHead = StreamHandleUtils.getTypeResult(headInputStream);
            String suffix = "";
            if (kd.bos.util.StringUtils.isNotEmpty((String)fileName) && fileName.contains(".")) {
                suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
            }
            List<String> imageSupportList = Arrays.asList(SUPPORT_IMAGE_TYPE.split(","));
            long begin = System.currentTimeMillis();
            if (StreamHandleUtils.validFileTypeInTypes(typeHead, imageSupportList)) {
                logger.info("\u4e0a\u4f20\u56fe\u7247\u7c7b\u578b\u6587\u4ef6\u3002");
                pageNum = 1;
            } else if (StreamHandleUtils.validFileTypeInTypes(typeHead, Collections.singletonList("pdf"))) {
                logger.info("\u5f00\u59cb\u81ea\u7814\u83b7\u53d6pdf\u9875\u7801\u6570");
                pageNum = CommonUtil.getPdfPageNumByInputStream(bytes);
            } else if (StreamHandleUtils.validFileTypeInTypes(typeHead, Collections.singletonList("ofd")) && kd.bos.util.StringUtils.isNotEmpty((String)suffix) && "ofd".equalsIgnoreCase(suffix)) {
                logger.info("\u5f00\u59cb\u67e5\u8be2ofd\u6587\u6863\u7684\u9875\u6570");
                secondInpuStream = new ByteArrayInputStream(bytes);
                if (kd.bos.util.StringUtils.isEmpty((String)fileName)) {
                    throw new KDBizException(new ErrorCode("40002", ResManager.loadKDString((String)"\u53c2\u6570\u5f02\u5e38\uff0c\u6587\u4ef6\u4e3a\u7a7a\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"CommonUtil_032", (String)"ai-cvp-common", (Object[])new Object[0])), new Object[0]);
                }
                pageNum = CommonUtil.getOfdPageNum(secondInpuStream, fileName);
            } else if (StreamHandleUtils.validFileTypeInTypes(typeHead, Arrays.asList("doc", "docx")) || StreamHandleUtils.validFileTypeInTypes(typeHead, Collections.singletonList("wps"))) {
                logger.info("\u5f00\u59cb\u67e5\u8be2word\u6587\u6863\u7684\u9875\u6570");
                secondInpuStream = new ByteArrayInputStream(bytes);
                if (kd.bos.util.StringUtils.isEmpty((String)fileName)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"CommonUtil_032", (String)"ai-cvp-common", (Object[])new Object[0]));
                }
                AlgoPageNumAndFileIdVO wordOrOfdPages = CommonUtil.getWordOrOfdPages(secondInpuStream, fileName);
                pageNum = wordOrOfdPages.getPageNum();
                algoPageNumAndFileIdVO.setFileId(wordOrOfdPages.getFileId());
            } else {
                throw new KDBizException("\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002");
            }
            logger.info("\u8bb0\u5f55\u65f6\u95f4\uff1a{}\uff0c\u9875\u6570\uff1a{}", (Object)(System.currentTimeMillis() - begin), (Object)pageNum);
        }
        catch (Throwable throwable) {
            StreamHandleUtils.closeResource(headInputStream);
            StreamHandleUtils.closeResource(secondInpuStream);
            throw throwable;
        }
        StreamHandleUtils.closeResource(headInputStream);
        StreamHandleUtils.closeResource(secondInpuStream);
        algoPageNumAndFileIdVO.setPageNum(pageNum);
        return algoPageNumAndFileIdVO;
    }

    private static int getOfdPageNum(InputStream secondInpuStream, String fileName) {
        String targetName = "Document.xml";
        int count = 0;
        try (ZipInputStream zis = new ZipInputStream(secondInpuStream);){
            ZipEntry nextEntry = zis.getNextEntry();
            while (nextEntry != null) {
                String entryName = nextEntry.getName();
                if (entryName.equals(targetName) || entryName.contains(targetName)) {
                    int len;
                    byte[] resultByteArr = new byte[]{};
                    byte[] buffer = new byte[1024];
                    while ((len = zis.read(buffer)) > 0) {
                        byte[] newByte = Arrays.copyOfRange(buffer, 0, len);
                        resultByteArr = ArrayUtils.addAll((byte[])resultByteArr, (byte[])newByte);
                    }
                    String str = new String(resultByteArr, StandardCharsets.UTF_8);
                    String regex = "<ofd:Page [^<^>]*/>";
                    Matcher matcher = Pattern.compile(regex).matcher(str);
                    while (matcher.find()) {
                        String group = matcher.group();
                        if (!kd.bos.util.StringUtils.isNotEmpty((String)group)) continue;
                        ++count;
                    }
                    break;
                }
                nextEntry = zis.getNextEntry();
            }
        }
        catch (IOException ie) {
            logger.error("\u83b7\u53d6\u9875\u7801\u6570\u5f02\u5e38\uff0cio\u5f02\u5e38", (Throwable)ie);
            throw new KDBizException(new ErrorCode("40000", ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u83b7\u53d6\u6587\u4ef6\u9875\u6570\u5f02\u5e38\u3002", (String)"CommonUtil_022", (String)"ai-cvp-common", (Object[])new Object[0])), new Object[0]);
        }
        logger.info("\u6587\u4ef6\u540d\uff1a{},\u9875\u7801\u6570\uff1a{}", (Object)fileName, (Object)count);
        if (count < 1) {
            throw new KDBizException(new ErrorCode("30112", ResManager.loadKDString((String)"\u83b7\u53d6\u6587\u6863\u9875\u6570\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"CommonUtil_023", (String)"ai-cvp-common", (Object[])new Object[0])), new Object[0]);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getPdfPageNumByInputStream(byte[] bytes) {
        int pageNum = 0;
        ByteArrayInputStream firstInputStream = null;
        ByteArrayInputStream secondInputStream = null;
        try {
            firstInputStream = new ByteArrayInputStream(bytes);
            long begin = System.currentTimeMillis();
            pageNum = PDFPageNumUtil.getPdfPageNumByBufferedArrNew(firstInputStream);
            logger.info("\u8bb0\u5f55\u4e0a\u4f20pdf\u6587\u4ef6\u9875\u7801\u6570\uff1a\u9875\u6570\u5927\u5c0f\u4e3a\uff1a{}\uff0c\u8017\u65f6\uff1a{}", (Object)pageNum, (Object)(System.currentTimeMillis() - begin));
            if (pageNum < 1) {
                secondInputStream = new ByteArrayInputStream(bytes);
                pageNum = CommonUtil.validOrGetPdfNum(secondInputStream);
                logger.info("\u8bb0\u5f55\u4fee\u6b63\u4e4b\u540e\u7684pdf\u6587\u4ef6\u9875\u7801\u6570\uff1a" + pageNum);
            }
        }
        catch (Throwable throwable) {
            StreamHandleUtils.closeResource(firstInputStream);
            StreamHandleUtils.closeResource(secondInputStream);
            throw throwable;
        }
        StreamHandleUtils.closeResource(firstInputStream);
        StreamHandleUtils.closeResource(secondInputStream);
        return pageNum;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int validOrGetPdfNum(InputStream inputStreamCopy) {
        try (PDDocument document = PDDocument.load((InputStream)inputStreamCopy);){
            if (document != null) {
                int n = document.getNumberOfPages();
                return n;
            }
            throw new KDBizException("pdf\u9875\u7801\u6570\u83b7\u53d6\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
        }
        catch (IOException ie) {
            logger.error("pdf\u83b7\u53d6\u9875\u6570\u5f02\u5e38\u3002", (Throwable)ie);
            throw new KDBizException("\u83b7\u53d6pdf\u9875\u6570\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002");
        }
    }

    public static void errorTips(IFormView view, String tips, String logMsg, String selfControlName, String commandStr) {
        if (!kd.bos.util.StringUtils.isEmpty((String)logMsg)) {
            logger.error(logMsg);
        }
        if (!kd.bos.util.StringUtils.isEmpty((String)tips)) {
            view.showTipNotification(tips);
        } else {
            view.showTipNotification("\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002");
        }
        OcrControlUtils.setCustomcontrolData(view, selfControlName, commandStr, Boolean.FALSE);
    }

    private static void errorTips(IFormView view, Map<String, Object> resultMap, String tips, String logMsg, String selfControlName, String commandStr) {
        if (!kd.bos.util.StringUtils.isEmpty((String)logMsg)) {
            logger.error(logMsg);
        }
        if (!kd.bos.util.StringUtils.isEmpty((String)tips)) {
            view.showTipNotification(tips);
        } else {
            view.showTipNotification("\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002");
        }
        if (resultMap == null) {
            resultMap = new HashMap<String, Object>();
        }
        resultMap.put(KEY_TEMP_FILE_ID, "");
        resultMap.put(KEY_VALID_RESULT, Boolean.FALSE);
        OcrControlUtils.setTdaOrTieCustomcontrolData(view, selfControlName, commandStr, resultMap);
    }

    public static void tdaErrorTips(IFormView view, Map<String, Object> resultMap, String tips, String logMsg, String selfControlName, String commandStr, boolean withView) {
        if (withView && view != null) {
            CommonUtil.tdaErrorTipsWithView(view, resultMap, tips, logMsg, selfControlName, commandStr);
        } else {
            CommonUtil.tdaErrorTipsWithoutView(resultMap, tips, logMsg, selfControlName, commandStr);
        }
    }

    private static void tdaErrorTipsWithoutView(Map<String, Object> resultMap, String tips, String logMsg, String selfControlName, String commandStr) {
        CommonUtil.tdaErrorTipsWithView(null, resultMap, tips, logMsg, selfControlName, commandStr);
    }

    private static void tdaErrorTipsWithView(IFormView view, Map<String, Object> resultMap, String tips, String logMsg, String selfControlName, String commandStr) {
        if (!kd.bos.util.StringUtils.isEmpty((String)logMsg)) {
            logger.error(logMsg);
        }
        if (view != null) {
            if (!kd.bos.util.StringUtils.isEmpty((String)tips)) {
                view.showTipNotification(tips);
            } else {
                view.showTipNotification("\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002");
            }
            if (resultMap == null) {
                resultMap = new HashMap<String, Object>();
            }
            resultMap.put("compareTempFileId", "");
            resultMap.put("baseTempFileId", "");
            resultMap.put(KEY_VALID_RESULT, Boolean.FALSE);
            OcrControlUtils.setTdaOrTieCustomcontrolData(view, selfControlName, commandStr, resultMap);
        }
    }

    private static String getTypeStr(FileValidTypeEnum fileTypeEnum) {
        return fileTypeEnum == null ? "\u4fe1\u606f\u63d0\u53d6\u6587\u4ef6" : (fileTypeEnum == FileValidTypeEnum.BASE ? "\u539f\u6587\u6863" : (fileTypeEnum == FileValidTypeEnum.COMPARISON ? "\u6bd4\u5bf9\u6587\u6863" : "\u6587\u4ef6"));
    }

    public static void validFileType(String url, String allowedTypes, FileValidTypeEnum fileTypeEnum) throws IOException {
        logger.info("validFileType begin...");
        List<String> allowTypesList = Arrays.asList(allowedTypes.split(","));
        try (InputStream inputStream = CvpFileServiceUtils.getFileIn(StorageTypeEnum.TMP, url);){
            if (inputStream == null) {
                throw new KDBizException(new ErrorCode("40002", ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u83b7\u53d6\u6587\u4ef6\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"CommonUtil_010", (String)"ai-cvp-common", (Object[])new Object[0])), new Object[0]);
            }
            boolean fileTypeValid = StreamHandleUtils.validFileTypeInTypes(inputStream, allowTypesList);
            if (!fileTypeValid) {
                throw new KDBizException(new ErrorCode("30111", CommonUtil.getTypeStr(fileTypeEnum).concat("\u683c\u5f0f\u4e0d\u662f\u7cfb\u7edf\u652f\u6301\u7684\u683c\u5f0f\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u8bd5\u3002")), new Object[0]);
            }
        }
    }

    public static void validFileTypeByCommonCache(String cacheUrl, String allowedTypes) throws IOException {
        logger.info("common cache valid file type begin ...");
        List<String> allowTypesList = Arrays.asList(allowedTypes.split(","));
        try (InputStream fileIn = CvpFileServiceUtils.getFileIn(StorageTypeEnum.TMP, cacheUrl);){
            if (fileIn == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u83b7\u53d6\u6587\u4ef6\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"CommonUtil_030", (String)"ai-cvp-common", (Object[])new Object[0]));
            }
            if (!StreamHandleUtils.validFileTypeInTypes(fileIn, allowTypesList)) {
                throw new KDBizException(new ErrorCode("30010", ResManager.loadKDString((String)"\u4f20\u9012\u7684\u6587\u4ef6\u7c7b\u578b\u4e0d\u652f\u6301,\u8bf7\u68c0\u67e5\u4f20\u9012\u7684\u6587\u4ef6\u7c7b\u578b\u662f\u5426\u6b63\u786e\u3002\uff08\u53ef\u901a\u8fc7\u6587\u4ef6\u6d41\u67e5\u770b\u6587\u4ef6\u771f\u5b9e\u7c7b\u578b\u3002\uff09", (String)"CommonUtil_031", (String)"ai-cvp-common", (Object[])new Object[0])), new Object[0]);
            }
        }
    }

    public static void validFileType(String tempfileId, String allowedTypes) throws IOException {
        logger.info("common valid file type begin ...");
        List<String> allowTypesList = Arrays.asList(allowedTypes.split(","));
        try (InputStream inputStream = LocalTempFileCache.getInputStream(tempfileId);){
            if (inputStream == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u83b7\u53d6\u6587\u4ef6\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"CommonUtil_030", (String)"ai-cvp-common", (Object[])new Object[0]));
            }
            if (!StreamHandleUtils.validFileTypeInTypes(inputStream, allowTypesList)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u9012\u7684\u6587\u4ef6\u7c7b\u578b\u4e0d\u652f\u6301,\u8bf7\u68c0\u67e5\u4f20\u9012\u7684\u6587\u4ef6\u7c7b\u578b\u662f\u5426\u6b63\u786e\u3002\uff08\u53ef\u901a\u8fc7\u6587\u4ef6\u6d41\u67e5\u770b\u6587\u4ef6\u771f\u5b9e\u7c7b\u578b\u3002\uff09", (String)"CommonUtil_031", (String)"ai-cvp-common", (Object[])new Object[0]));
            }
        }
    }

    public static void createAttachmentList(IFormView view, String args, String selfControlName, String commandStr, String[] allowTypesArr) {
        ArrayList<AttachmentVO> attachments = new ArrayList<AttachmentVO>(3);
        CommonUtil.addContractAttachments(attachments, view, allowTypesArr);
        FormShowParameter showParameter = view.getFormShowParameter();
        String billId = args;
        String billKey = (String)showParameter.getCustomParam("businessobject");
        Object parentPageId = showParameter.getCustomParam("pageId");
        if (parentPageId == null) {
            logger.info("parent pageid is null,no attachments added.");
            return;
        }
        IFormView parentView = view.getViewNoPlugin(String.valueOf(parentPageId));
        if (parentView == null) {
            logger.info("parent view is null");
            return;
        }
        String idByNumber = MetadataDao.getIdByNumber((String)billKey, (MetaCategory)MetaCategory.Form);
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)idByNumber, (MetaCategory)MetaCategory.Form);
        List items = formMetadata.getItems();
        items.forEach(obj -> {
            if (obj instanceof AttachmentPanelAp) {
                String key = obj.getKey();
                Control control = parentView.getControl(key);
                boolean invisible = true;
                if (control != null) {
                    invisible = control.isInvisible();
                    logger.info("invisible:{}", (Object)invisible);
                }
                QFilter[] filters = new QFilter[]{new QFilter("FBillType", "=", (Object)billKey), new QFilter("FInterID", "=", (Object)billId), new QFilter("fattachmentpanel", "=", (Object)key), new QFilter("fextname", "in", (Object)allowTypesArr)};
                String attachmentEntity = "bos_attachment";
                String selectField = "fnumber,fcreatemen,fcreatetime,ffileid,fattachmentname,fextname,fattachmentsize,fdescription";
                DynamicObject[] atts = BusinessDataServiceHelper.load((String)attachmentEntity, (String)selectField, (QFilter[])filters);
                logger.info(String.format("TDA/TIE \u81ea\u5b9a\u4e49\u63a7\u4ef6\u64cd\u4f5c - \u83b7\u53d6\u9644\u4ef6\u5217\u8868 \u9644\u4ef6\u9762\u677f\u6807\u8bc6\uff1a%s,\u6587\u4ef6\u6570\u91cf:%s ", key, atts != null ? atts.length : 0));
                if (atts != null) {
                    List<AttData> attDatas = Arrays.stream(atts).map(o -> {
                        String createName = kd.bos.util.StringUtils.getEmpty();
                        try {
                            DynamicObject fcreatemen = o.getDynamicObject("fcreatemen");
                            if (fcreatemen != null) {
                                createName = ((OrmLocaleValue)fcreatemen.get(((BasedataEntityType)fcreatemen.getDataEntityType()).getNameProperty())).getLocaleValue();
                            }
                        }
                        catch (Exception e) {
                            logger.error("\u83b7\u53d6\u521b\u5efa\u7528\u6237\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
                        }
                        return new AttData(o.get("fnumber"), createName, o.getDate("fcreatetime").getTime(), o.getString("ffileid"), o.getString("fattachmentname"), o.getString("fextname"), o.getLong("fattachmentsize"), o.getString("fdescription"));
                    }).collect(Collectors.toList());
                    if (!invisible || !attDatas.isEmpty()) {
                        attachments.add(new AttachmentVO(key, obj.getName().getLocaleValue(), attDatas));
                    }
                }
            }
        });
        OcrControlUtils.setCustomcontrolData(view, selfControlName, commandStr, attachments);
    }

    public static void addContractAttachments(List<AttachmentVO> attachments, IFormView view, String[] allowTypesArr) {
        String PAGE_ID = "pageId";
        FormShowParameter formShowParameter = view.getFormShowParameter();
        if (formShowParameter == null) {
            return;
        }
        Object parentPageId = formShowParameter.getCustomParam(PAGE_ID);
        if (parentPageId == null) {
            logger.info("parent pageid is null,no attachments added.");
            return;
        }
        IFormView parentView = view.getViewNoPlugin(String.valueOf(parentPageId));
        if (parentView == null) {
            logger.info("parent view is null");
            return;
        }
        String contractAttStr = parentView.getPageCache().getBigObject("contractAtt");
        try {
            if (!kd.bos.util.StringUtils.isEmpty((String)contractAttStr)) {
                logger.info("\u81ea\u5b9a\u4e49\u5408\u540c\u6a21\u677f\uff1a{}", (Object)(contractAttStr.length() > 200 ? contractAttStr.substring(0, 199) : contractAttStr));
                Object parse = JSON.parse((String)contractAttStr);
                if (parse instanceof JSONObject) {
                    logger.info("\u5355\u9875\u7b7e");
                    AttachmentVO contractAttVo = (AttachmentVO)JSON.parseObject((String)contractAttStr, AttachmentVO.class);
                    CommonUtil.validAndAdd(attachments, contractAttVo, allowTypesArr);
                } else if (parse instanceof JSONArray) {
                    logger.info("\u591a\u9875\u7b7e");
                    List attachmentVOS = JSON.parseArray((String)contractAttStr, AttachmentVO.class);
                    for (AttachmentVO att : attachmentVOS) {
                        CommonUtil.validAndAdd(attachments, att, allowTypesArr);
                    }
                } else {
                    logger.error("\u65e0\u6cd5\u5904\u7406\u7684\u7c7b\u578b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002");
                }
            } else {
                logger.warn("\u5f53\u524d\u4e0d\u5b58\u5728\u81ea\u5b9a\u4e49\u5408\u540c\u6a21\u677f...");
            }
        }
        catch (Exception e) {
            logger.error("\u6dfb\u52a0\u81ea\u5b9a\u4e49\u5408\u540c\u6a21\u677f\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5408\u540c\u6a21\u677f\u7684\u683c\u5f0f\u662f\u5426\u6b63\u786e\u3002", (Throwable)e);
            view.showErrorNotification("\u6dfb\u52a0\u81ea\u5b9a\u4e49\u5408\u540c\u6a21\u677f\u9519\u8bef\uff0c\u5408\u540c\u6a21\u677f\u683c\u5f0f\u9519\u8bef\u3002");
        }
    }

    private static void validAndAdd(List<AttachmentVO> attachments, AttachmentVO contractAttVo, String[] allowTypesArr) {
        String contractKeyName = contractAttVo.getKey();
        String contractName = contractAttVo.getName();
        List<AttData> data = contractAttVo.getData();
        if (data != null && !data.isEmpty()) {
            contractAttVo.setData(data.stream().filter(att -> att.getFileType() != null && Arrays.asList(allowTypesArr).contains(att.getFileType().toString())).collect(Collectors.toList()));
        }
        contractAttVo.setKey(kd.bos.util.StringUtils.isEmpty((String)contractKeyName) ? "contractAtt" : contractKeyName);
        contractAttVo.setName(kd.bos.util.StringUtils.isEmpty((String)contractName) ? "\u5408\u540c\u6a21\u677f\u9644\u4ef6" : contractName);
        attachments.add(contractAttVo);
    }

    public static boolean validStrByPattern(String str, String regexStr) {
        if (kd.bos.util.StringUtils.isEmpty((String)regexStr)) {
            return false;
        }
        Pattern pattern = Pattern.compile(regexStr);
        Matcher matcher = pattern.matcher(str);
        String result = "";
        while (matcher.find()) {
            result = matcher.group();
        }
        return !kd.bos.util.StringUtils.isEmpty((String)result);
    }

    public static void validAndGetInputPages(Set<Integer> resultSet, String str) throws KDBizException {
        if (kd.bos.util.StringUtils.isEmpty((String)str)) {
            logger.error("\u7528\u6237\u8f93\u5165\u4e3a\u7a7a\u3002\u3002\u3002");
            throw new KDBizException("\u8f93\u5165\u5185\u5bb9\u4e3a\u7a7a,\u8bf7\u8f93\u5165\u540e\u518d\u8bd5\u3002");
        }
        if (str.contains("\uff0c")) {
            str = str.replace('\uff0c', ',');
        }
        if (str.endsWith(",")) {
            throw new KDBizException(TIPS_BLANK_INPUT);
        }
        String[] split = str.split(",");
        List emptyList = Arrays.stream(split).filter(s -> kd.bos.util.StringUtils.isEmpty((String)s.trim())).collect(Collectors.toList());
        if (!emptyList.isEmpty()) {
            throw new KDBizException(TIPS_BLANK_INPUT);
        }
        Set strings = Arrays.stream(split).map(String::trim).collect(Collectors.toSet());
        for (String st : strings) {
            if (st.contains("-")) {
                String[] split1 = st.split("-");
                if (split1.length > 2) {
                    throw new KDBizException(TIPS);
                }
                List collect1 = Arrays.stream(split1).filter(s -> !kd.bos.util.StringUtils.isEmpty((String)s.trim())).map(String::trim).collect(Collectors.toList());
                if (collect1.size() < 2) {
                    throw new KDBizException(TIPS);
                }
                String smallerStr = (String)collect1.get(0);
                String biggerStr = (String)collect1.get(1);
                if (kd.bos.util.StringUtils.isEmpty((String)smallerStr) || kd.bos.util.StringUtils.isEmpty((String)biggerStr)) {
                    throw new KDBizException(TIPS);
                }
                int bigInt = Integer.parseInt(biggerStr);
                int smallint = Integer.parseInt(smallerStr);
                if (smallint < 1 || bigInt <= smallint) {
                    throw new KDBizException(TIPS);
                }
                Set<Integer> set = CommonUtil.transferToSet(smallint, bigInt);
                if (set.isEmpty()) continue;
                resultSet.addAll(set);
                continue;
            }
            resultSet.add(Integer.parseInt(st));
        }
    }

    public static void setTaskIdAndTraceIdRelation(String taskId, String traceId) {
        boolean cvprn_License = LicenseServiceHelper.checkPerformGroup((String)"PROCVPRN").getHasLicense();
        String productVersion = LicenseServiceHelper.getProductVersion();
        if ("1.0".equalsIgnoreCase(productVersion) || !cvprn_License) {
            return;
        }
        IAppCache appCache = AppCache.get((String)"ai-cvp");
        appCache.put(taskId, (Object)traceId);
    }

    private static Set<Integer> transferToSet(int smallint, int bigint) throws KDBizException {
        if (smallint < 1 || bigint < 1 || bigint <= smallint) {
            throw new KDBizException("\u81ea\u5b9a\u4e49\u63d0\u53d6\u8303\u56f4\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002");
        }
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (int i = smallint - 1; i < bigint; ++i) {
            set.add(i + 1);
        }
        return set;
    }

    public static void asyncClearTempFile(final String tempFileId) {
        ThreadUtils.get().execute(new Runnable(){

            @Override
            public void run() {
                boolean removeFlag = LocalTempFileCache.remove(tempFileId);
                logger.info("\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u7ed3\u679c\uff1a{},\u6587\u4ef6id:{}", (Object)removeFlag, (Object)tempFileId);
            }
        });
    }

    public static String getPermanentUrlByImageService(InputStream inputStream, String imageId, String fileType, String entityNumber) {
        FileService imageFileService = FileServiceFactory.getImageFileService();
        return CommonUtil.getPermanentUrl(inputStream, imageId, fileType, entityNumber, imageFileService);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getPermanentUrlByBytes(byte[] bytes, String imageId, String fileType, String entityNumber, FileService fileService) {
        RequestContext rc = RequestContext.get();
        String tenantId = rc.getTenantId();
        String accountId = rc.getAccountId();
        try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);){
            String fullFileName = String.format("%s.%s", imageId, fileType);
            String path = FileNameUtils.getBillImageFileName((String)tenantId, (String)accountId, (String)entityNumber, (String)fullFileName);
            FileItem item = new FileItem(fullFileName, path, (InputStream)in);
            String string = fileService.upload(item);
            return string;
        }
        catch (IOException ie) {
            logger.error("\u83b7\u53d6\u6587\u4ef6io \u5f02\u5e38\u3002", (Throwable)ie);
            throw new KDBizException("\u83b7\u53d6\u6587\u4ef6\u5f02\u5e38,\u8bf7\u91cd\u65b0\u5c1d\u8bd5\u3002");
        }
    }

    public static String getPermanentUrl(InputStream inputStream, String imageId, String fileType, String entityNumber, FileService fileService) {
        RequestContext rc = RequestContext.get();
        String tenantId = rc.getTenantId();
        String accountId = rc.getAccountId();
        String fullFileName = String.format("%s.%s", imageId, fileType);
        String path = FileNameUtils.getBillImageFileName((String)tenantId, (String)accountId, (String)entityNumber, (String)fullFileName);
        FileItem item = new FileItem(fullFileName, path, inputStream);
        return fileService.upload(item);
    }

    public static int getCellSiteByField(Row theRow, String fieldCode) {
        for (Cell nextCell : theRow) {
            String cellValue = nextCell.getStringCellValue();
            if (kd.bos.util.StringUtils.isEmpty((String)cellValue) || !cellValue.equals(fieldCode)) continue;
            return nextCell.getColumnIndex();
        }
        return -1;
    }

    public static void updateStringCellForOutputExcel(Row theRow, int col, TypeTransferEnum typeEnum) {
        Cell oldCell = theRow.getCell(col);
        if (oldCell == null) {
            oldCell = theRow.createCell(col);
        }
        String oldCellValue = oldCell.getStringCellValue();
        Cell newCell = theRow.createCell(col);
        if (typeEnum == TypeTransferEnum.ToBase64Str) {
            oldCellValue = CommonUtil.encodeASBase64(oldCellValue);
        } else if (typeEnum == TypeTransferEnum.ToCommonStr) {
            oldCellValue = CommonUtil.decodeBase64Str(oldCellValue);
        }
        newCell.setCellValue(oldCellValue);
    }

    public static String encodeASBase64(String str) {
        if (null == str) {
            return str;
        }
        Charset utf8 = StandardCharsets.UTF_8;
        return new String(Base64.getEncoder().encode(str.getBytes(utf8)), utf8);
    }

    public static String decodeBase64Str(String base64Str) {
        if (null == base64Str) {
            return base64Str;
        }
        Charset utf8 = StandardCharsets.UTF_8;
        return new String(Base64.getDecoder().decode(base64Str.getBytes(utf8)), utf8);
    }

    public static void clearUploadFile(String path, FileServiceTypeEnum fileServiceTypeEnum) {
        FileService service = null;
        if (fileServiceTypeEnum == FileServiceTypeEnum.IMAGE_FILE_SERVICE) {
            service = FileServiceFactory.getImageFileService();
        } else if (fileServiceTypeEnum == FileServiceTypeEnum.ATTACHMENT_FILE_SERVICE) {
            service = FileServiceFactory.getAttachmentFileService();
        } else {
            logger.error("\u672a\u77e5\u7684\u6587\u4ef6\u4e0a\u4f20\u65b9\u5f0f\uff0c\u65e0\u6cd5\u6e05\u7406\u3002");
            return;
        }
        if (!kd.bos.util.StringUtils.isEmpty((String)path) && service.exists(path)) {
            logger.info("\u5220\u9664\u4e0a\u4f20\u7684\u6e90\u6587\u4ef6\u3002\u3002\u3002");
            try {
                service.delete(path);
            }
            catch (Exception e) {
                logger.error("\u5220\u9664\u6587\u4ef6\u5f02\u5e38\uff0c\u8bf7\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7", (Throwable)e);
            }
        }
    }

    public static String encryptString(String str) {
        return !kd.bos.util.StringUtils.isEmpty((String)str) ? Encrypters.encode((String)str) : str;
    }

    public static String decodeString(String str) {
        return !kd.bos.util.StringUtils.isEmpty((String)str) ? Encrypters.decode((String)str) : str;
    }

    public static List<String> batchUploadImagesNew(List<ConversionAlgoInfo> images, String taskId, boolean isTest) throws Exception {
        if (images == null || images.isEmpty()) {
            logger.error("\u56fe\u7247\u4e3a\u7a7a\u3002\u3002\u3002");
            throw new KDBizException(new ErrorCode("40002", ResManager.loadKDString((String)"\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"CommonUtil_002", (String)"ai-cvp-common", (Object[])new Object[0])), new Object[0]);
        }
        List<String> zipFileKeys = CommonUtil.getZipFileKeys(taskId);
        if (zipFileKeys == null || zipFileKeys.isEmpty()) {
            throw new KDBizException(new ErrorCode("41009", ResManager.loadKDString((String)"\u83b7\u53d6\u538b\u7f29\u6587\u4ef6\u6216\u5206\u7247\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"CommonUtil_001", (String)"ai-cvp-common", (Object[])new Object[0])), new Object[0]);
        }
        CommonUtil.doDownloadAllFiles(images, zipFileKeys, isTest, taskId);
        return zipFileKeys;
    }

    public static String getAccountUrl(String path) {
        return CommonUtil.getAccountCookieUrl(path, RequestContext.get().getTenantId(), RequestContext.get().getAccountId());
    }

    private static String getAccountCookieUrl(String path, String tenantId, String accountId) {
        return CommonUtil.getUrlByParams(path, kd.bos.util.StringUtils.isNotEmpty((String)accountId) ? accountId : RequestContext.get().getAccountId());
    }

    private static String getUrlByParams(String path, String accountId) {
        if (path.contains("kdcdc=")) {
            return path;
        }
        if (path.contains("?")) {
            return path + "&kdcdc=" + accountId;
        }
        return path + "?kdcdc=" + accountId;
    }

    private static void doDownloadAllFiles(List<ConversionAlgoInfo> images, List<String> zipFileKeys, boolean isTest, String taskId) throws Exception {
        String localZipFileKey;
        if (zipFileKeys != null && !zipFileKeys.isEmpty()) {
            localZipFileKey = CommonUtil.getLocalZipFileKey(zipFileKeys, taskId);
            if (kd.bos.util.StringUtils.isEmpty((String)localZipFileKey)) {
                throw new KDBizException("\u672c\u5730\u7f13\u5b58\u6587\u4ef6\u5f02\u5e38\u3002");
            }
        } else {
            logger.error("\u5904\u7406\u6587\u4ef6\u5f02\u5e38\uff0c\u7a0d\u540e\u91cd\u8bd5\u3002");
            throw new KDBizException("\u5904\u7406\u6587\u4ef6\u5f02\u5e38\uff0c\u7a0d\u540e\u91cd\u8bd5");
        }
        CommonUtil.setCosmicFileUrl(images, localZipFileKey, "cvp_tda_task_image", isTest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void setCosmicFileUrl(List<ConversionAlgoInfo> images, String zipFileKey, String entityNumber, boolean isTest) {
        InputStream inputStream = LocalTempFileCache.getInputStream(zipFileKey);
        if (inputStream == null) {
            logger.info("\u7cfb\u7edf\u5f02\u5e38\uff0c\u672c\u5730\u4e34\u65f6\u6587\u4ef6\u4e0d\u5b58\u5728\u3002");
            throw new KDBizException("\u7cfb\u7edf\u5f02\u5e38\uff0c\u672c\u5730\u4e34\u65f6\u6587\u4ef6\u4e0d\u5b58\u5728\u3002");
        }
        try (ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
            ZipEntry entry;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    logger.info("zip\u4e2d\u7684\u76ee\u5f55\u4e0d\u5904\u7406\u3002");
                    continue;
                }
                String name = entry.getName();
                logger.info("\u6587\u4ef6\u540d\u79f0\uff1a{}", (Object)name);
                if (kd.bos.util.StringUtils.isEmpty((String)name)) {
                    logger.error("\u6587\u4ef6\u540d\u4e3a\u7a7a\u3002\u3002\u3002zip\u89e3\u538b\u5931\u8d25");
                    throw new KDBizException("\u83b7\u53d6\u63d0\u53d6\u7ed3\u679c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002");
                }
                String fileKey = UUID.randomUUID().toString().replace("-", "");
                InputStream localFileInputStream = null;
                try {
                    CommonUtil.fillInFile(zipInputStream, fileKey);
                    String imageId = name.substring(0, name.lastIndexOf(46));
                    localFileInputStream = LocalTempFileCache.getInputStream(fileKey);
                    String fullUrl = isTest ? CommonUtil.getTempUrl(localFileInputStream, imageId) : CommonUtil.getPermanentUrlByImageService(localFileInputStream, imageId, "png", entityNumber);
                    CommonUtil.setUrl(images, fullUrl, imageId);
                    zipInputStream.closeEntry();
                }
                catch (Throwable throwable) {
                    StreamHandleUtils.closeResource(localFileInputStream);
                    LocalTempFileCache.remove(fileKey);
                    throw throwable;
                    return;
                }
                StreamHandleUtils.closeResource(localFileInputStream);
                LocalTempFileCache.remove(fileKey);
            }
        }
        catch (Exception e) {
            String message = ResManager.loadKDString((String)String.format("TIE \u4fe1\u606f\u63d0\u53d6\u4fdd\u5b58\u56fe\u7247\u5230\u56fe\u7247\u670d\u52a1\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%s", e.getMessage()), (String)"IeUitls_1", (String)"ai-cvp-common", (Object[])new Object[0]);
            logger.error(message, (Throwable)e);
            throw new KDBizException(message);
        }
        finally {
            StreamHandleUtils.closeResource(inputStream);
            LocalTempFileCache.remove(zipFileKey);
        }
    }

    private static String getLocalZipFileKey(List<String> zipFileIds, String taskId) throws Exception {
        StopWatch sw = new StopWatch();
        logger.info("\u5faa\u73af\u4e0b\u8f7d\u6587\u4ef6\u5f00\u59cb...");
        ArrayList<OcrParam> params = new ArrayList<OcrParam>(2);
        OcrParam ocrParam = new OcrParam();
        ocrParam.setkParam("fileId");
        sw.start();
        for (String algoFileKey : zipFileIds) {
            ocrParam.setValue(algoFileKey);
            params.add(ocrParam);
            OcrHttpClientUtils.httpGetResponseFileAndUploadCosmic("/vrsp/file/download", params, taskId);
            ocrParam.clearObject();
            params.clear();
        }
        sw.stop();
        logger.info("\u5faa\u73af\u4e0b\u8f7d\u6587\u4ef6\u8017\u65f6\uff1a{}", (Object)sw.getTime(TimeUnit.MILLISECONDS));
        return taskId;
    }

    private static List<String> getZipFileKeys(String taskId) throws Exception {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("taskId", taskId);
        StringEntity paramStr = new StringEntity(JSON.toJSONString(paramMap), ContentType.APPLICATION_JSON);
        paramStr.setContentEncoding("UTF-8");
        logger.info("\u5f00\u59cb\u8bf7\u6c42\u538b\u7f29\u6587\u4ef6\u5206\u7247id");
        long beginTime = System.currentTimeMillis();
        String resultQuery = OcrHttpClientUtils.kdCloudHttpClientPost("/vrsp/file/queryDivideFileIds", (HttpEntity)paramStr);
        logger.info(String.format("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u83b7\u53d6\u538b\u7f29\u6587\u4ef6id,\u5b8c\u6210,\u8017\u65f6\uff1a%s\u79d2", System.currentTimeMillis() - beginTime));
        AlgoResultForTdaOrTie algoResult = (AlgoResultForTdaOrTie)JSON.parseObject((String)resultQuery, AlgoResultForTdaOrTie.class);
        int errorCode = algoResult.getErrorCode();
        if (errorCode == 0) {
            return algoResult.getData();
        }
        logger.info(String.format("\u89c6\u89c9\u8bc6\u522b\u83b7\u53d6\u6587\u4ef6\u538b\u7f29\u5206\u7247\u5931\u8d25\uff0c\u64cd\u4f5c\u8bf7\u6c42\u4fe1\u606f: %s", algoResult.getDescription()));
        throw new KDBizException(new ErrorCode("41009", "\u83b7\u53d6\u538b\u7f29\u6587\u4ef6\u5206\u7247\u4fe1\u606f\u5931\u8d25"), new Object[0]);
    }

    private static void fillInFile(ZipInputStream zipInputStream, String localFileKey) throws IOException {
        byte[] buf = new byte[8192];
        File file = LocalTempFileCache.getFile(localFileKey);
        try (FileOutputStream out = new FileOutputStream(file);){
            int len;
            while ((len = zipInputStream.read(buf)) != -1) {
                out.write(buf, 0, len);
            }
            out.flush();
        }
    }

    private static String getTempUrl(InputStream inputStream, String imageId) {
        String fullFileName = String.format("%s.%s", imageId, "png");
        TempFileCache tfc = CacheFactory.getCommonCacheFactory().getTempFileCache();
        String fullUrl = tfc.saveAsFullUrl(fullFileName, inputStream, 86400);
        if (StringUtils.isNotBlank((CharSequence)fullUrl) && !fullUrl.contains("kd_cs_ticket")) {
            String sessionId = RequestContext.get().getGlobalSessionId();
            String csrfTokenValue = SessionManager.getCSRFTokenValue((String)sessionId);
            StringBuilder builder = new StringBuilder(fullUrl);
            builder.append('&').append("kd_cs_ticket=").append(csrfTokenValue);
            fullUrl = builder.toString();
        }
        return CommonUtil.getAccountUrl(fullUrl);
    }

    private static void setUrl(List<ConversionAlgoInfo> tieImages, String fullUrl, String imageId) {
        if (tieImages == null || tieImages.isEmpty()) {
            return;
        }
        logger.info("\u56fe\u7247\u5730\u5740\uff1a{},imageId:{}", (Object)fullUrl, (Object)imageId);
        logger.info("images:{}", tieImages.stream().map(ConversionAlgoInfo::getImageId).collect(Collectors.toList()));
        List collect = tieImages.stream().filter(timage -> Long.valueOf(imageId).equals(timage.getImageId())).collect(Collectors.toList());
        if (!collect.isEmpty()) {
            ((ConversionAlgoInfo)collect.get(0)).setImagePath(fullUrl);
            logger.info("\u8bbe\u7f6e\u56fe\u7247\u5730\u5740\u6210\u529f\u3002");
        } else {
            logger.info("\u672a\u627e\u5230\u56fe\u7247\u5730\u5740\u3002imageId:{}", (Object)imageId);
        }
    }

    private static void batchUpload(String currenTaskId, String sourceFileType, List<ConversionAlgoInfo> imageList) {
        logger.info(String.format("TDA \u5f00\u59cb\u6267\u884c\u56fe\u7247\u8f6c\u5b58\uff0c\u4efb\u52a1ID\uff1a%s ,\u6587\u4ef6\u6570\uff1a%s ,\u6587\u4ef6\u4e1a\u52a1\u7c7b\u578b\uff1a%s ", currenTaskId, imageList != null ? imageList.size() : 0, sourceFileType));
        int totalSize = 0;
        if (imageList != null) {
            totalSize = imageList.size();
            DynamicObject[] images = (DynamicObject[])imageList.stream().map(file -> {
                try {
                    Long imageId = file.getImageId();
                    String imagePath = CommonUtil.uploadPngImageFile(imageId);
                    DynamicObject image = BusinessDataServiceHelper.newDynamicObject((String)"cvp_tda_task_image");
                    image.set("taskid", (Object)currenTaskId);
                    image.set("imagepath", (Object)imagePath);
                    image.set("imagewidth", (Object)file.getImageWidth());
                    image.set("imageheight", (Object)file.getImageHeight());
                    image.set("pagenum", (Object)file.getPageNum());
                    image.set("imageid", (Object)file.getImageId());
                    image.set("sourcefiletype", (Object)sourceFileType);
                    return image;
                }
                catch (Exception e) {
                    String message = ResManager.loadKDString((String)String.format("TDA \u5dee\u5f02\u5206\u6790\u4fdd\u5b58\u56fe\u7247\u5230\u56fe\u7247\u670d\u52a1\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%s", e.getMessage()), (String)"TdaUitls_1", (String)"ai-cvp-common", (Object[])new Object[0]);
                    logger.error(message, (Throwable)e);
                    throw new KDBizException(message);
                }
            }).toArray(DynamicObject[]::new);
            SaveServiceHelper.save((DynamicObject[])images);
            logger.info(String.format("TDA \u5b8c\u6210\u6267\u884c\u56fe\u7247\u8f6c\u5b58\uff0c\u4efb\u52a1ID\uff1a%s , \u6587\u4ef6\u4e1a\u52a1\u7c7b\u578b\uff1a%s ,\u603b\u6570: %s", currenTaskId, sourceFileType, totalSize));
        }
    }

    private static String uploadPngImageFile(Long imageId) throws Exception {
        RequestContext rc = RequestContext.get();
        ArrayList<OcrParam> params = new ArrayList<OcrParam>(2);
        params.add(new OcrParam("fileId", imageId));
        return OcrHttpClientUtils.httpGetResponseFileForImageUpload("/vrsp/file/download", params, imageId.toString(), rc);
    }

    public static String getPicFromAlgoForCosmicTempUrl(String path) throws Exception {
        ArrayList<OcrParam> params = new ArrayList<OcrParam>(2);
        params.add(new OcrParam("fileId", path));
        String fullUrl = OcrHttpClientUtils.httpGetResponseFileForFullUploadToCosmic("/vrsp/file/download", params, path, 86400);
        if (StringUtils.isNotBlank((CharSequence)fullUrl) && !fullUrl.contains("kd_cs_ticket")) {
            String sessionId = RequestContext.get().getGlobalSessionId();
            String csrfTokenValue = SessionManager.getCSRFTokenValue((String)sessionId);
            StringBuilder builder = new StringBuilder(fullUrl);
            builder.append('&').append("kd_cs_ticket=").append(csrfTokenValue);
            fullUrl = builder.toString();
        }
        return CommonUtil.getAccountUrl(fullUrl);
    }

    public static void batchSaveImages(List<ConversionAlgoInfo> tieImages, String taskId, String sourceType) {
        CommonUtil.saveToImageDB(tieImages, taskId, sourceType);
    }

    private static void saveToImageDB(List<ConversionAlgoInfo> images, String currenTaskId, String sourceType) {
        ArrayList imagesList = new ArrayList(images.size());
        images.forEach(extractImage -> {
            String imagePath = extractImage.getImagePath();
            Integer imageWidth = extractImage.getImageWidth();
            Integer imageHeight = extractImage.getImageHeight();
            Integer pageNum = extractImage.getPageNum();
            Long imageId = extractImage.getImageId();
            DynamicObject image = BusinessDataServiceHelper.newDynamicObject((String)"cvp_tda_task_image");
            image.set("taskid", (Object)currenTaskId);
            image.set("imagepath", (Object)imagePath);
            image.set("imagewidth", (Object)imageWidth);
            image.set("imageheight", (Object)imageHeight);
            image.set("pagenum", (Object)pageNum);
            image.set("imageid", (Object)imageId);
            if (kd.bos.util.StringUtils.isNotEmpty((String)sourceType)) {
                image.set("sourcefiletype", (Object)sourceType);
            }
            imagesList.add(image);
        });
        if (!imagesList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])imagesList.toArray(new DynamicObject[0]));
        }
    }

    public static void deleteZipAndTempFile(List<String> filePathList) throws Exception {
        HashMap<String, List<String>> paramMap = new HashMap<String, List<String>>();
        paramMap.put("fileIdList", filePathList);
        StringEntity paramStr = new StringEntity(JSON.toJSONString(paramMap), ContentType.APPLICATION_JSON);
        logger.info("\u5f00\u59cb\u8bf7\u6c42\u6e05\u7406\u7b97\u6cd5\u8c03\u5ea6\u538b\u7f29\u6587\u4ef6\u548c\u4e34\u65f6\u6587\u4ef6");
        String resultQuery = OcrHttpClientUtils.kdCloudHttpClientPost("/vrsp/file/deleteTempFiles", (HttpEntity)paramStr);
        logger.info("\u7ed3\u675f\u6e05\u7406\u3002");
        AlgoResultForDeleteZipTempFileVO result = (AlgoResultForDeleteZipTempFileVO)JSON.parseObject((String)resultQuery, AlgoResultForDeleteZipTempFileVO.class);
        if (0 == result.getErrorCode()) {
            logger.info("\u6e05\u7406\u538b\u7f29\u6587\u4ef6\u4e0e\u4e34\u65f6\u6587\u4ef6\u6b63\u5e38...");
        } else {
            logger.error("\u6e05\u7406\u6587\u4ef6\u5f02\u5e38");
        }
    }

    public static TdaCancelTaskResultVO cancelTask(String taskId, LicenseCountServiceNameEnum licenseCountEnum, SourceTypeEnum sourceTypeEnum) {
        TdaCancelTaskResultVO resultVO = CommonUtil.doCancelTask(taskId);
        if (resultVO == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d6\u6d88\u4efb\u52a1\u5931\u8d25\u3002", (String)"TdaUtils_020", (String)"ai-cvp-common", (Object[])new Object[0]));
        }
        if (!resultVO.getCancelResult()) {
            String alertMsg;
            int code = resultVO.getCode();
            switch (code) {
                case 30007: {
                    alertMsg = ResManager.loadKDString((String)"\u6587\u6863\u5df2\u5b8c\u6210\u8bc6\u522b\u6216\u63d0\u53d6\uff0c\u65e0\u6cd5\u53d6\u6d88\u4efb\u52a1\u3002\u7ed3\u679c\u6b63\u5728\u540c\u6b65\u4e2d\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\u3002", (String)"TdaUtils_003", (String)"ai-cvp-common", (Object[])new Object[0]);
                    break;
                }
                case 30008: {
                    alertMsg = ResManager.loadKDString((String)"\u53d6\u6d88\u4efb\u52a1\u5931\u8d25\uff0c\u5df2\u53d6\u6d88\u7684\u4efb\u52a1\u65e0\u6cd5\u518d\u6b21\u53d6\u6d88\u3002", (String)"TdaUtils_004", (String)"ai-cvp-common", (Object[])new Object[0]);
                    break;
                }
                case 30009: {
                    alertMsg = ResManager.loadKDString((String)"\u53d6\u6d88\u4efb\u52a1\u5931\u8d25\uff0c\u5f02\u5e38\u7684\u4efb\u52a1\u65e0\u6cd5\u53d6\u6d88\u3002", (String)"TdaUtils_005", (String)"ai-cvp-common", (Object[])new Object[0]);
                    break;
                }
                default: {
                    alertMsg = ResManager.loadKDString((String)"\u4e0d\u53ef\u9884\u6599\u7684\u5f02\u5e38\u7ed3\u679c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"TdaUtils_006", (String)"ai-cvp-common", (Object[])new Object[0]);
                }
            }
            throw new KDBizException(alertMsg);
        }
        CommonUtil.ensureCallPages(resultVO, taskId, licenseCountEnum, sourceTypeEnum);
        return resultVO;
    }

    private static void ensureCallPages(TdaCancelTaskResultVO resultVO, String taskId, LicenseCountServiceNameEnum licenseCountEnum, SourceTypeEnum sourceTypeEnum) {
        boolean result = resultVO.getCancelResult();
        int usedCount = resultVO.getUsedNum();
        if (result && usedCount > 0) {
            boolean ensureResult = LicenseUtils.ensurePracticalCallNumByTaskIdAndPageNum(taskId, usedCount, licenseCountEnum.getName(), sourceTypeEnum);
            logger.info("\u53d6\u6d88\u4efb\u52a1\u6210\u529f,\u4efb\u52a1id:{},\u6838\u9500\u7ed3\u679c\uff1a{}", (Object)taskId, (Object)ensureResult);
        }
    }

    public static TdaCancelTaskResultVO doCancelTask(String taskId) {
        String traceId = RequestContext.get().getTraceId();
        long currUserId = RequestContext.get().getCurrUserId();
        return CommonUtil.doCancelTask(taskId, traceId, currUserId);
    }

    public static TdaCancelTaskResultVO doCancelTask(String taskId, String traceId, long userId) {
        String resultQuery;
        ArrayList<OcrParam> params = new ArrayList<OcrParam>(1);
        params.add(new OcrParam("taskId", taskId));
        params.add(new OcrParam("userId", userId));
        logger.info("\u8bf7\u6c42\u53d6\u6d88\u4efb\u52a1, taskId:{},userId:{},traceId:{}", new Object[]{taskId, userId, traceId});
        try {
            resultQuery = OcrHttpClientUtils.kdCloudHttpClientGet("/vrsp/doc/cancelTask", params);
        }
        catch (Exception e) {
            throw new KDBizException(new ErrorCode(String.valueOf(40000), ResManager.loadKDString((String)"\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"TdaUtils_021", (String)"ai-cvp-common", (Object[])new Object[0])), new Object[0]);
        }
        logger.info("\u53d6\u6d88\u7ed3\u679c, result:{},traceId:{}", (Object)resultQuery, (Object)traceId);
        String description = ResManager.loadKDString((String)"\u53d6\u6d88\u4efb\u52a1\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"TdaUtils_012", (String)"ai-cvp-common", (Object[])new Object[0]);
        int errorCode = 40000;
        if (!kd.bos.util.StringUtils.isEmpty((String)resultQuery)) {
            AlgoResultData resultData = (AlgoResultData)JSON.parseObject((String)resultQuery, AlgoResultData.class);
            if (0 == resultData.getErrorCode()) {
                if (resultData.getData() != null) {
                    logger.info("\u53d6\u6d88\u8fd4\u56de\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)resultData.getData()));
                    return (TdaCancelTaskResultVO)JSON.parseObject((String)resultData.getData().toString(), TdaCancelTaskResultVO.class);
                }
            } else {
                logger.info("\u53d6\u6d88\u4efb\u52a1\u63a5\u53e3\u8fd4\u56decode:{}", (Object)resultData.getErrorCode());
                errorCode = 40007;
                String apiResDescription = resultData.getDescription();
                description = kd.bos.util.StringUtils.isEmpty((String)apiResDescription) ? description : apiResDescription;
            }
        }
        throw new KDBizException(new ErrorCode(String.valueOf(errorCode), description), new Object[0]);
    }

    public static FormShowParameter getTestShowParameter(long pkValue) {
        FormShowParameter showParameter = CommonUtil.getFormShowParameter();
        showParameter.setCustomParam("ie_plan_id", (Object)pkValue);
        showParameter.setCustomParam("ie_operate_type", (Object)"ie_test_task");
        showParameter.setCustomParam("billid", (Object)"");
        DynamicObject mouldObj = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"cvp_ie_mouldplan");
        if (mouldObj == null) {
            throw new KDBizException("\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002");
        }
        showParameter.setCustomParam("businessconfig", (Object)mouldObj.getString("businessconfig"));
        return showParameter;
    }

    private static FormShowParameter getFormShowParameter() {
        FormShowParameter showParameter = new FormShowParameter();
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("90%");
        styleCss.setHeight("90%");
        showParameter.setFormId("cvp_ie_info");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        return showParameter;
    }

    public static String buildCommonParams(List<DynamicObject> llmCommonFieldsList) {
        String com_mustInput = "\u5b57\u6bb5%s\u540d\u79f0\uff1a{%s}\u3002\u5b57\u6bb5%s\u7c7b\u578b\uff1a{%s}\u3001";
        String com_optInput_desc = "\u5b57\u6bb5%s\u63cf\u8ff0\u4e0e\u63d0\u53d6\u8981\u6c42\uff1a{%s}\u3001";
        String com_optInput_output = "\u5b57\u6bb5%s\u8f93\u51fa\u7ed3\u679c\u8981\u6c42\uff1a{%s}\u3001";
        StringBuilder sb = new StringBuilder();
        StringBuilder param = new StringBuilder();
        for (int i = 0; i < llmCommonFieldsList.size(); ++i) {
            DynamicObject obj = llmCommonFieldsList.get(i);
            sb.append(com_mustInput);
            String llmextractfield = obj.getString("llmextractfield");
            String typeNameByType = obj.getDynamicObject("llmfieldtype").getString("name");
            param.append(i + 1).append(",");
            param.append(llmextractfield).append(",");
            param.append(i + 1).append(",");
            param.append(typeNameByType).append(",");
            String llmexdescription = obj.getString("llmexdescription");
            String llmoutput = obj.getString("llmoutput");
            if (kd.bos.util.StringUtils.isNotEmpty((String)llmexdescription) && kd.bos.util.StringUtils.isNotEmpty((String)llmexdescription.trim())) {
                sb.append(com_optInput_desc);
                param.append(i + 1).append(",");
                param.append(llmexdescription).append(",");
            }
            if (kd.bos.util.StringUtils.isNotEmpty((String)llmoutput) && kd.bos.util.StringUtils.isNotEmpty((String)llmoutput.trim())) {
                sb.append(com_optInput_output);
                param.append(i + 1).append(",");
                param.append(llmoutput).append(",");
            }
            sb.append("\n");
        }
        return String.format(sb.toString(), param.toString().split(","));
    }

    public static Map<String, Object> buildReqParam4KiMi(String prompt) {
        if (prompt == null) {
            throw new KDBizException("\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u8bd5\u3002");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("model", "moonshot-v1-32k");
        ArrayList list = new ArrayList();
        HashMap<String, String> userMap = new HashMap<String, String>();
        userMap.put("content", prompt);
        userMap.put("role", "system");
        list.add(userMap);
        map.put("messages", list);
        map.put("stream", true);
        return map;
    }

    public static Map<String, Object> buildReqParam(String prompt, String serviceNumber) {
        if (prompt == null) {
            throw new KDBizException("\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u8bd5\u3002");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("model", serviceNumber.equals("DOUBAO_PRO_32K") ? "ep-20240520095118-z694q" : "ep-20240520095146-hl96s");
        map.put("stream", true);
        ArrayList maps = new ArrayList();
        HashMap<String, String> systemMap = new HashMap<String, String>();
        systemMap.put("role", "system");
        systemMap.put("content", "You are a helpful assistant.");
        maps.add(systemMap);
        HashMap<String, String> userMap = new HashMap<String, String>();
        userMap.put("role", "user");
        userMap.put("content", prompt);
        maps.add(userMap);
        map.put("messages", maps);
        return map;
    }

    public static Map<String, String> buildCallBackParam() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("priority", "1");
        map.put("stream", "true");
        map.put("notify_ms_cloudid", "ai");
        map.put("notify_ms_appid", "cvp");
        map.put("notify_ms_service_name", "OcrService");
        map.put("notify_ms_method_name", "llmStreamResponseHandler");
        return map;
    }

    public static String buildMarkDownTab(boolean isBegin, DocTotalRecLayoutDataVO layout) {
        StringBuilder sb = new StringBuilder();
        if (!isBegin) {
            sb.append("\n");
        }
        int pageNum = layout.getPageNum();
        boolean continued = layout.getContinued();
        PicAndPdfTableVO table = layout.getTable();
        List<PicAndPdfCellVO> cells = table.getCells();
        int colNumber = table.getColNumber();
        int rowNumber = table.getRowNumber();
        HashMap<IeCellEntity, String> cellEntityMap = new HashMap<IeCellEntity, String>();
        for (PicAndPdfCellVO cell : cells) {
            int startRow = cell.getStartRow();
            int endRow = cell.getEndRow();
            int startCol = cell.getStartCol();
            int endCol = cell.getEndCol();
            String text = cell.getCombinedText();
            cellEntityMap.putAll(CommonUtil.createCellsByCell(startRow, endRow, startCol, endCol, text));
        }
        for (int j = 0; j < rowNumber; ++j) {
            for (int i = 0; i < colNumber; ++i) {
                IeCellEntity ieCellEntity = new IeCellEntity();
                ieCellEntity.setCellRow(j + 1);
                ieCellEntity.setCellCol(i + 1);
                if (!cellEntityMap.containsKey(ieCellEntity)) {
                    cellEntityMap.put(ieCellEntity, "");
                }
                String text = (String)cellEntityMap.get(ieCellEntity);
                sb.append("|").append(text);
            }
            sb.append("|").append("\n");
            if (j != 0) continue;
            for (int k = 0; k < colNumber; ++k) {
                sb.append("|").append("---");
            }
            sb.append("|").append("\n");
        }
        return sb.toString();
    }

    private static Map<IeCellEntity, String> createCellsByCell(int startRow, int endRow, int startCol, int endCol, String text) {
        int deltRow = endRow - startRow;
        int deltCol = endCol - startCol;
        HashMap<IeCellEntity, String> map = new HashMap<IeCellEntity, String>();
        for (int i = startRow; i < startRow + deltRow + 1; ++i) {
            for (int j = startCol; j < startCol + deltCol + 1; ++j) {
                IeCellEntity ieCellEntity = new IeCellEntity();
                ieCellEntity.setCellRow(i);
                ieCellEntity.setCellCol(j);
                map.put(ieCellEntity, text);
            }
        }
        return map;
    }

    public static String getFieldParam(DynamicObject planObj) {
        StringBuilder sb = new StringBuilder();
        DynamicObjectCollection llmObjCol = planObj.getDynamicObjectCollection("llmentryentity");
        if (llmObjCol != null && !llmObjCol.isEmpty()) {
            List<DynamicObject> llmCommonFieldsList = llmObjCol.stream().filter(obj -> kd.bos.util.StringUtils.isEmpty((String)obj.getString("llmtabname"))).collect(Collectors.toList());
            if (!llmCommonFieldsList.isEmpty()) {
                sb.append(CommonUtil.buildCommonParams(llmCommonFieldsList)).append("\n");
            }
            List tabNameList = llmObjCol.stream().filter(obj -> kd.bos.util.StringUtils.isNotEmpty((String)obj.getString("llmtabname"))).map(obj -> obj.getString("llmtabname")).collect(Collectors.toList());
            HashMap<String, List<DynamicObject>> tabFieldMap = new HashMap<String, List<DynamicObject>>(tabNameList.size());
            for (String tabName : tabNameList) {
                List tabList = llmObjCol.stream().filter(obj -> kd.bos.util.StringUtils.isNotEmpty((String)obj.getString("llmtabname")) && obj.getString("llmtabname").equals(tabName)).collect(Collectors.toList());
                tabFieldMap.put(tabName, tabList);
            }
            if (!tabFieldMap.isEmpty()) {
                sb.append(CommonUtil.buildTabParams(tabFieldMap)).append("\n");
            }
        }
        return sb.toString();
    }

    private static String buildTabParams(Map<String, List<DynamicObject>> tabFieldMap) {
        String tabMustInput = "%s-\u5b57\u6bb5%s\u540d\u79f0\uff1a{%s}\u3002\u5b57\u6bb5\u7c7b\u578b\uff1a{%s}\u3001";
        String tabOptInputDesc = "%s-\u5b57\u6bb5%s\u63cf\u8ff0\u4e0e\u63d0\u53d6\u8981\u6c42\uff1a{%s}\u3001";
        String tabOptInputOutput = "%s-\u5b57\u6bb5%s\u8f93\u51fa\u7ed3\u679c\u8981\u6c42\uff1a{%s}\u3001";
        StringBuilder sb = new StringBuilder();
        StringBuilder param = new StringBuilder();
        for (Map.Entry<String, List<DynamicObject>> entry : tabFieldMap.entrySet()) {
            List<DynamicObject> fieldsList = entry.getValue();
            String tabName = entry.getKey();
            for (int i = 0; i < fieldsList.size(); ++i) {
                DynamicObject obj = fieldsList.get(i);
                sb.append(tabMustInput);
                String llmextractfield = obj.getString("llmextractfield");
                String typeNameByType = obj.getDynamicObject("llmfieldtype").getString("name");
                param.append(tabName).append(",");
                param.append(i + 1).append(",");
                param.append(llmextractfield).append(",");
                param.append(typeNameByType).append(",");
                String llmexdescription = obj.getString("llmexdescription");
                String llmoutput = obj.getString("llmoutput");
                if (kd.bos.util.StringUtils.isNotEmpty((String)llmexdescription) && kd.bos.util.StringUtils.isNotEmpty((String)llmexdescription.trim())) {
                    sb.append(tabOptInputDesc);
                    param.append(tabName).append(",");
                    param.append(i + 1).append(",");
                    param.append(llmexdescription).append(",");
                }
                if (kd.bos.util.StringUtils.isNotEmpty((String)llmoutput) && kd.bos.util.StringUtils.isNotEmpty((String)llmoutput.trim())) {
                    sb.append(tabOptInputOutput);
                    param.append(tabName).append(",");
                    param.append(i + 1).append(",");
                    param.append(llmoutput).append(",");
                }
                sb.append("\n");
            }
        }
        return String.format(sb.toString(), param.toString().split(","));
    }

    public static String createLLMTask(Map<String, String> varParams) {
        if (varParams != null && !varParams.isEmpty()) {
            String docWord = varParams.get("docWord");
            String fieldParam = varParams.get("fieldParam");
            String docDescription = varParams.get("docDescription");
            Map<String, String> modelMap = CommonUtil.getLLMModelAndPrompt("\u4f60\u7684\u4efb\u52a1\u662f\u4ece\u7ed9\u5b9a\u7684\u62c6\u5206\u597d\u7684\u6587\u6863\u7247\u6bb5\u4e2d\u63d0\u53d6\u548c\u603b\u7ed3\u4fe1\u606f\u3002\u8fd9\u4e2a\u6587\u6863\u63cf\u8ff0\u7684\u5185\u5bb9\u662f\uff1a%s\u3002\u8bf7\u5e2e\u6211\u4ece\u7247\u6bb5\u4e2d\u63d0\u53d6\u5982\u4e0b\u51e0\u4e2a\u975e\u8868\u683c\u5b57\u6bb5\u548c\u8868\u683c\u5b57\u6bb5\uff0c\u8868\u683c\u5b57\u6bb5\u4ee5\u683c\u5f0f\u5316\u8868\u683c\u7684\u5f62\u5f0f\u7684json\u8f93\u51fa\uff08\u6309\u7167\u4e0b\u65b9\u8f93\u51fa\u793a\u4f8b\u4e2d\u7684\u793a\u4f8b\u8f93\u51fa\uff09\uff0c\u9700\u6ce8\u610f\u8868\u683c\u5b57\u6bb5\u7684key\u548cvalue\u4e5f\u662f\u6309\u7167\u4e00\u4e00\u5bf9\u5e94\u7684\u6837\u5f0f\u8f93\u51fa\uff0c\u975e\u8868\u683c\u5b57\u6bb5\u4ee5\u6807\u51c6json\u5f62\u5f0f\u8f93\u51fa\u3002\u5b57\u6bb5\u7684\u8981\u6c42\u3001\u7c7b\u578b\u3001\u63cf\u8ff0\u3001\u548c\u8f93\u51fa\u7ed3\u679c\u7684\u8981\u6c42\u5982\u4e0b\uff1a\n%s\n\u8f93\u51fa\u8981\u6c42\uff1a\n1.\u7528\u6807\u51c6\u7684json\u8f93\u51fa\n2.json\u91cc\u7684\u975e\u8868\u683c\u5b57\u6bb5\u4e2d\u7684key\u4e3a\uff1a{\u5b57\u6bb51\u540d\u79f0}\u3001{\u5b57\u6bb52\u540d\u79f0}\u3001{\u5b57\u6bb5n\u540d\u79f0}\n3.json\u91cc\u8868\u683c1\u5b57\u6bb5\u4e2d\u7684key\u5206\u522b\u4e3a\u4e0a\u65b9{\u8868\u683c1-\u5b57\u6bb51\u540d\u79f0}\u3001{\u8868\u683c1-\u5b57\u6bb52\u540d\u79f0}....{\u8868\u683c1-\u5b57\u6bb5n\u540d\u79f0}\uff0c\u8868\u683c2\u5b57\u6bb5\u4e2d\u7684key\u5206\u522b\u4e3a\u4e0a\u65b9{\u8868\u683c2-\u5b57\u6bb51\u540d\u79f0}\u3001{\u8868\u683c2-\u5b57\u6bb52\u540d\u79f0}....{\u8868\u683c2-\u5b57\u6bb5n\u540d\u79f0}\uff0c\u4ee5\u6b64\u7c7b\u63a8\u3002\n4.\u6bcf\u4e2akey\u5bf9\u5e94\u7684value\u503c\u8bf7\u60a8\u6839\u636e\u4e0a\u6587\u63d0\u5230\u7684\u6bcf\u4e2a\u5b57\u6bb5\u7684\u201c\u63cf\u8ff0\u4e0e\u63d0\u53d6\u8981\u6c42\u201d\u603b\u7ed3\u5e76\u6309\u7167\u6bcf\u4e2a\u5b57\u6bb5\u201c\u8f93\u51fa\u7ed3\u679c\u8981\u6c42\u201d\u4e2d\u7684\u8981\u6c42\u8f93\u51fa\uff0c\u5982\u679c\u6709\u7684key\u6309\u7167\u8981\u6c42\u6ca1\u6709\u63d0\u53d6\u51favalue\u503c\uff0c\u5219\u6b64key\u5bf9\u5e94\u7684value\u8f93\u51fa\"not found\"\u3002\n5.\u8981\u63d0\u53d6\u7684\u8868\u683c\u884c\u6bd4\u8f83\u591a\u7684\u60c5\u51b5\u4e0b\u8bf7\u5168\u90e8\u8f93\u51fa\uff0c\u4e0d\u8981\u53ea\u8f93\u51fa\u90e8\u5206\u884c\u3002\n6.\u8f93\u51fa\u7ed3\u679c\u793a\u4f8b\uff08\u793a\u4f8b\u4e2d\u201c\u975e\u8868\u683c\u5b57\u6bb5\u201d\u3001\u201c\u8868\u683c\u5b57\u6bb5\u201d\u3001\u201c\u8868\u683c1\u5b57\u6bb5\u201d\u7b49\u5206\u7c7b\u6807\u8bc6\u9700\u8fde\u5e26\u4e00\u8d77\u8f93\u51fa\uff09:\n{\n\"\u975e\u8868\u683c\u5b57\u6bb5\": {\n\"\u5546\u54c1\u540d\u79f0\": \"xxxxx\",\n\"\u7532\u65b9\": \"xx\"\n},\n\"\u8868\u683c\u5b57\u6bb5\": {\n\"\u8868\u683c1\u5b57\u6bb5\": [{\n\"\u59d3\u540d\": \"\u5f20\u4e09\",\n\"\u8bed\u6587\u6210\u7ee9\": 88,\n\"\u6570\u5b66\u6210\u7ee9\": 77\n},\n{\n\"\u59d3\u540d\": \"\u674e\u56db\",\n\"\u8bed\u6587\u6210\u7ee9\": 98,\n\"\u6570\u5b66\u6210\u7ee9\": 67\n}\n],\n\"\u8868\u683c2\u5b57\u6bb5\": [{\n\"\u5e8f\u53f7\": \"01\",\n\"\u5546\u54c1\u540d\u79f0\": \"\u5496\u5561\",\n\"\u4ef7\u683c\": 77\n},\n{\n\"\u5e8f\u53f7\": \"02\",\n\"\u5546\u54c1\u540d\u79f0\": \"\u725b\u5976\",\n\"\u4ef7\u683c\": 67\n}\n]\n}\n}\n\u62c6\u5206\u597d\u7684\u6587\u6863\u7247\u6bb5\uff1a\n%s", docDescription, fieldParam, docWord);
            if (!modelMap.isEmpty()) {
                String prompt = modelMap.get(KEY_PROMPT);
                String serviceNumber = modelMap.get(KEY_SERVICE);
                Map<String, Object> params = CommonUtil.buildReqParam(prompt, serviceNumber);
                Map<String, String> callbackMap = CommonUtil.buildCallBackParam();
                Object[] objects = new Object[]{callbackMap, serviceNumber, JSON.toJSONString(params)};
                String paramsStr = JSON.toJSONString((Object)objects);
                logger.info("aicc\u8c03\u7528\u53c2\u6570\uff1a{},\u53c2\u6570\u957f\u5ea6\uff1a{}", (Object)(kd.bos.util.StringUtils.isNotEmpty((String)paramsStr) ? paramsStr.substring(0, 1000) : ""), (Object)(kd.bos.util.StringUtils.isNotEmpty((String)paramsStr) ? paramsStr.length() : 0));
                Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"ai", (String)"aicc", (String)"AiccService", (String)"asyncService", (Object[])objects);
                if (resultMap != null) {
                    if ("0".equals(resultMap.get("errorCode"))) {
                        return (String)resultMap.get("id");
                    }
                    String errorCode = (String)resultMap.get("errorCode");
                    String message = (String)resultMap.get("message");
                    logger.error("error:{},message:{}", (Object)errorCode, (Object)message);
                    throw new KDBizException(new ErrorCode(errorCode, message), new Object[0]);
                }
                logger.error("\u8c03\u7528aicc\u521b\u5efa\u4efb\u52a1\u5931\u8d25\u3002");
                throw new KDBizException(new ErrorCode("403001", "\u5927\u6a21\u578b\u4efb\u52a1\u521b\u5efa\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u3002"), new Object[0]);
            }
        }
        throw new KDBizException(new ErrorCode("403001", "\u5927\u6a21\u578b\u4efb\u52a1\u521b\u5efa\u5931\u8d25,\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a\u3002"), new Object[0]);
    }

    private static Map<String, String> getLLMModelAndPrompt(String tieLLMPrompt, String docDescription, String fieldParam, String docWord) {
        HashMap<String, String> map = new HashMap<String, String>();
        String prompt = String.format(tieLLMPrompt, docDescription, fieldParam, docWord);
        int length = prompt.length();
        if (length <= 25000) {
            map.put(KEY_PROMPT, prompt);
            map.put(KEY_SERVICE, "DOUBAO_PRO_32K");
        } else if (length < 110000) {
            map.put(KEY_PROMPT, prompt);
            map.put(KEY_SERVICE, "DOUBAO_PRO_128K");
        } else {
            logger.info("\u957f\u5ea6\u8d85\u8fc7110k,\u622a\u53d6\u5f85\u63d0\u53d6\u5185\u5bb9");
            String format = String.format(tieLLMPrompt, docDescription, fieldParam, "");
            docWord = docWord.substring(0, 110000 - format.length());
            prompt = String.format(tieLLMPrompt, docDescription, fieldParam, docWord);
            map.put(KEY_PROMPT, prompt);
            map.put(KEY_SERVICE, "DOUBAO_PRO_128K");
        }
        return map;
    }

    public static enum TypeTransferEnum {
        ToBase64Str(1),
        ToCommonStr(2);

        int type;

        private TypeTransferEnum(int type) {
            this.type = type;
        }
    }
}

