/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.UUID;
import kd.ai.cvp.common.Enum.StorageTypeEnum;
import kd.ai.cvp.utils.CommonUtil;
import kd.ai.cvp.utils.OcrControlUtils;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.session.SessionManager;
import kd.bos.util.FileNameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.io.IOUtils;

public abstract class CvpFileServiceUtils {
    private static Log logger = LogFactory.getLog(CvpFileServiceUtils.class);
    private static final int timeout = 86400;

    public static InputStream getImageFileZipIn(StorageTypeEnum storageType, String path) throws IOException {
        InputStream in = CvpFileServiceUtils.getFileIn(storageType, path);
        return OcrControlUtils.getZipImageInputStream(in, true);
    }

    public static InputStream getFileIn(StorageTypeEnum storageType, String path) {
        InputStream in;
        logger.info("\u5f00\u59cb\u83b7\u53d6\u6587\u4ef6\u6d41\uff0cpath", (Object)path);
        if (Objects.isNull((Object)storageType)) {
            throw new KDBizException("\u5b58\u50a8\u65b9\u5f0f\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)path)) {
            throw new KDBizException("\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        }
        switch (storageType) {
            case TMP: {
                in = CacheFactory.getCommonCacheFactory().getTempFileCache().getInputStream(path);
                break;
            }
            case ATTACHMENT: {
                in = FileServiceFactory.getAttachmentFileService().getInputStream(path);
                break;
            }
            case IMAGE: {
                in = FileServiceFactory.getImageFileService().getInputStream(path);
                break;
            }
            default: {
                throw new KDBizException("\u88ab\u8bc6\u522b\u6587\u4ef6\u975e\u82cd\u7a79\u6587\u4ef6\u670d\u52a1\u5b58\u50a8\uff0c\u65e0\u6cd5\u83b7\u53d6\u5230\u6587\u4ef6\u8d44\u6e90");
            }
        }
        logger.info("\u83b7\u53d6\u6587\u4ef6\u6d41\u7ed3\u675f\uff0cpath\uff1a{}", (Object)path);
        return in;
    }

    public static boolean fileExist(StorageTypeEnum storageType, String path) {
        if (Objects.isNull((Object)storageType)) {
            throw new KDBizException("\u5b58\u50a8\u65b9\u5f0f\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)path)) {
            return false;
        }
        boolean existFlag = false;
        switch (storageType) {
            case TMP: {
                existFlag = CacheFactory.getCommonCacheFactory().getTempFileCache().exists(path);
                break;
            }
            case ATTACHMENT: {
                existFlag = FileServiceFactory.getAttachmentFileService().exists(path);
                break;
            }
            case IMAGE: {
                existFlag = FileServiceFactory.getImageFileService().exists(path);
                break;
            }
            default: {
                throw new KDBizException("\u88ab\u8bc6\u522b\u6587\u4ef6\u975e\u82cd\u7a79\u6587\u4ef6\u670d\u52a1\u5b58\u50a8\uff0c\u65e0\u6cd5\u83b7\u53d6\u5230\u6587\u4ef6\u8d44\u6e90");
            }
        }
        return existFlag;
    }

    public static String saveFile(StorageTypeEnum storageType, String fileName, byte[] fileBytes) {
        String path;
        long l = System.currentTimeMillis();
        logger.info("saveFile begin");
        switch (storageType) {
            case TMP: {
                path = CvpFileServiceUtils.saveTmpFile(fileName, fileBytes);
                break;
            }
            case ATTACHMENT: {
                path = CvpFileServiceUtils.saveAttachmentFile(fileName, fileBytes);
                break;
            }
            case IMAGE: {
                path = CvpFileServiceUtils.saveImageFile(fileName, fileBytes);
                break;
            }
            default: {
                throw new KDBizException("\u88ab\u8bc6\u522b\u6587\u4ef6\u975e\u82cd\u7a79\u6587\u4ef6\u670d\u52a1\u5b58\u50a8\uff0c\u65e0\u6cd5\u83b7\u53d6\u5230\u6587\u4ef6\u8d44\u6e90");
            }
        }
        logger.info("\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - l));
        return path;
    }

    private static String saveTmpFile(String fileName, byte[] fileByte) {
        TempFileCache tfc = CacheFactory.getCommonCacheFactory().getTempFileCache();
        String fullUrl = tfc.saveAsUrl(fileName, fileByte, 86400);
        if (StringUtils.isNotBlank((CharSequence)fullUrl) && !fullUrl.contains("kd_cs_ticket")) {
            String sessionId = RequestContext.get().getGlobalSessionId();
            String csrfTokenValue = SessionManager.getCSRFTokenValue((String)sessionId);
            StringBuilder builder = new StringBuilder(fullUrl);
            builder.append('&').append("kd_cs_ticket=").append(csrfTokenValue);
            fullUrl = builder.toString();
        }
        return CommonUtil.getAccountUrl(fullUrl);
    }

    private static String saveAttachmentFile(String fileName, byte[] fileByte) {
        long attpk = DB.genLongId((String)"cvp_classifier");
        String path = FileNameUtils.getAttachmentFileName((String)RequestContext.get().getTenantId(), (String)RequestContext.get().getAccountId(), (String)"cvp", (String)"cvp_classifier", (Object)attpk, (String)fileName);
        FileService attachmentFileService = FileServiceFactory.getAttachmentFileService();
        FileItem item = new FileItem(fileName, path, (InputStream)new ByteArrayInputStream(fileByte));
        return attachmentFileService.upload(item);
    }

    private static String saveImageFile(String fileName, byte[] fileByte) {
        String path = FileNameUtils.getBillImageFileName((String)RequestContext.get().getTenantId(), (String)RequestContext.get().getAccountId(), (String)"cvp_cls_info", (String)fileName);
        FileService imageFileService = FileServiceFactory.getImageFileService();
        FileItem item = new FileItem(fileName, path, (InputStream)new ByteArrayInputStream(fileByte));
        return imageFileService.upload(item);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String attFile2Temp(String path) {
        try (InputStream fin = CvpFileServiceUtils.getFileIn(StorageTypeEnum.ATTACHMENT, path);){
            byte[] fileBytes = IOUtils.toByteArray((InputStream)fin);
            String fileName = String.format("%s.png", UUID.randomUUID().toString().replaceAll("-", ""));
            String string = CvpFileServiceUtils.saveFile(StorageTypeEnum.TMP, fileName, fileBytes);
            return string;
        }
        catch (IOException e) {
            throw new KDBizException(String.format("\u6d4b\u8bd5\u670d\u52a1-\u8f6c\u4e34\u65f6\u5b58\u50a8\u5f02\u5e38\uff1a%s", e.getMessage()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String attFile2TempFile(String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw new KDBizException(new ErrorCode("31001", ResManager.loadKDString((String)"\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"CvpFileServiceUtils_001", (String)"ai-cvp-common", (Object[])new Object[0])), new Object[0]);
        }
        String filetype = path.substring(path.lastIndexOf(46) + 1);
        try (InputStream fin = CvpFileServiceUtils.getFileIn(StorageTypeEnum.ATTACHMENT, path);){
            byte[] fileBytes = IOUtils.toByteArray((InputStream)fin);
            String fileName = String.format("%s.%s", UUID.randomUUID().toString().replaceAll("-", ""), filetype);
            String tempFileUrl = CvpFileServiceUtils.saveFile(StorageTypeEnum.TMP, fileName, fileBytes);
            String string = CommonUtil.getAccountUrl(tempFileUrl);
            return string;
        }
        catch (IOException e) {
            throw new KDBizException(new ErrorCode("40000", String.format("\u6d4b\u8bd5\u670d\u52a1-\u8f6c\u4e34\u65f6\u5b58\u50a8\u5f02\u5e38\uff1a%s", e.getMessage())), new Object[0]);
        }
    }
}

