/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.utils;

import com.aspose.words.Document;
import com.aspose.words.FontSettings;
import com.aspose.words.IWarningCallback;
import com.aspose.words.License;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import kd.ai.cvp.utils.AsposeFontWarningCallback;
import kd.ai.cvp.utils.CvpEncryptUtils;
import kd.ai.cvp.utils.StreamHandleUtils;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

class CvpWordUtils {
    private static Log logger;

    CvpWordUtils() {
    }

    public static int getWordPageCount(InputStream inputStream) {
        try {
            logger.info("\u5f00\u59cbdoc\u83b7\u53d6\u6587\u4ef6\u9875\u6570\u3002\u3002\u3002");
            Document doc = new Document(inputStream);
            AsposeFontWarningCallback callback = new AsposeFontWarningCallback();
            doc.setWarningCallback((IWarningCallback)callback);
            FontSettings fontSettings = new FontSettings();
            fontSettings.setFontsFolder("/usr/share/fonts/", true);
            fontSettings.getSubstitutionSettings().getDefaultFontSubstitution().setDefaultFontName("Arial");
            fontSettings.getSubstitutionSettings().getFontConfigSubstitution().setEnabled(true);
            doc.setFontSettings(fontSettings);
            return doc.getPageCount();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6word\u9875\u7801\u6570\u5f02\u5e38", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"doc \u83b7\u53d6\u9875\u6570\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"CvpWordUtils_001", (String)"ai-cvp-common", (Object[])new Object[0]));
        }
    }

    static {
        ByteArrayInputStream inputStream;
        block42: {
            logger = LogFactory.getLog(CvpWordUtils.class);
            inputStream = null;
            try (InputStream resourceAsStream = CvpWordUtils.class.getResourceAsStream("/dict/Aspose.Words.Product.Family.lic");
                 InputStreamReader inputStreamReader = new InputStreamReader(resourceAsStream);
                 BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                String line;
                StringBuilder stringBuilder = new StringBuilder();
                while ((line = bufferedReader.readLine()) != null) {
                    stringBuilder.append(line);
                }
                String licStr = CvpEncryptUtils.decodeDefault(stringBuilder.toString());
                if (StringUtils.isNotEmpty((String)licStr)) {
                    inputStream = new ByteArrayInputStream(licStr.getBytes(StandardCharsets.UTF_8));
                    License license = new License();
                    license.setLicense((InputStream)inputStream);
                    break block42;
                }
                throw new KDBizException(ResManager.loadKDString((String)"doc\u3001docx\u3001wps\u6587\u6863\u5904\u7406\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"CvpWordUtils_001", (String)"ai-cvp-common", (Object[])new Object[0]));
            }
            catch (Exception e) {
                try {
                    logger.error("aspose \u8bb8\u53ef\u52a0\u8f7d\u5f02\u5e38", (Throwable)e);
                    throw new KDBizException(ResManager.loadKDString((String)"doc\u3001docx\u3001wps\u6587\u6863\u5904\u7406\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"CvpWordUtils_001", (String)"ai-cvp-common", (Object[])new Object[0]));
                }
                catch (Throwable throwable) {
                    StreamHandleUtils.closeResource(inputStream);
                    throw throwable;
                }
            }
        }
        StreamHandleUtils.closeResource(inputStream);
    }
}

