/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.ai.cvp.common.OcrDtsCommon;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.db.DB;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class DtsManage {
    private static Log log = LogFactory.getLog(DtsManage.class);

    public static void saveDtsCfg(long planId, String businessTypeStr) {
        Set<String> entityNames = DtsManage.getEntityNames(businessTypeStr);
        log.info(String.format("\u4e1a\u52a1\u5bf9\u8c61\u540c\u6b65\u914d\u7f6e start: plan: %s,entityNames : %s", planId, entityNames));
        DtsManage.createSynBusiness(planId, entityNames.stream().collect(Collectors.toList()));
        log.info("DTS start \u51c6\u5907\u540c\u6b65\u914d\u7f6e entityNames : " + entityNames);
        Set<String> exitsNames = DtsManage.getExitDtsCfgAllByEntityNames(entityNames);
        entityNames.removeAll(exitsNames);
        log.info("DTS start \u589e\u91cf\u66f4\u65b0: entityNames :" + entityNames);
        if (entityNames.size() > 0) {
            log.info("\u65b9\u6848\u540c\u6b65\u914d\u7f6e start: entityNames :" + entityNames);
            List<String> collect = entityNames.stream().collect(Collectors.toList());
            DtsManage.bachCreateDefaultBaseDts(collect);
        }
    }

    public static Set<String> getExitDtsCfgAllByEntityNames(Set<String> entityNames) {
        String selectFields = String.join((CharSequence)",", Arrays.asList("id", "entitynumber", "region"));
        QFilter filter = new QFilter("entitynumber", "in", entityNames).and("businesstype", "=", (Object)"cvpsearch").and("region", "=", (Object)"cvpsearch");
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"data_sync_config", (String)selectFields, (QFilter[])filters);
        Set<String> exitEntityNames = objs.stream().map(o -> o.getString("entitynumber")).collect(Collectors.toSet());
        return exitEntityNames;
    }

    public static boolean isExitDtsCfg(String entityName) {
        QFilter filter = new QFilter("entitynumber", "=", (Object)entityName).and("businesstype", "=", (Object)"cvpsearch").and("enable", "=", (Object)OcrDtsCommon.DtsKey.DEFAULT_ENABLE).and("region", "=", (Object)"cvpsearch");
        QFilter[] filters = new QFilter[]{filter};
        return QueryServiceHelper.exists((String)"data_sync_config", (QFilter[])filters);
    }

    public static Set<String> getEntityNames(String businessTypeString) {
        LinkedHashSet<String> entityNames = new LinkedHashSet<String>(2);
        if (StringUtils.isNotEmpty((String)businessTypeString)) {
            entityNames.add(businessTypeString);
            DataEntityPropertyCollection props = MetadataServiceHelper.getDataEntityType((String)businessTypeString).getProperties();
            for (IDataEntityProperty prop : props) {
                if (prop instanceof BasedataProp) {
                    String basedataName = ((BasedataProp)prop).getComplexType().getName();
                    entityNames.add(basedataName);
                    continue;
                }
                if (!(prop instanceof EntryProp)) continue;
                DataEntityPropertyCollection entryType = ((EntryType)((EntryProp)prop).getItemType()).getProperties();
                for (IDataEntityProperty p : entryType) {
                    if (!(p instanceof BasedataProp)) continue;
                    String basedataName = ((BasedataProp)p).getComplexType().getName();
                    entityNames.add(basedataName);
                }
            }
        }
        return entityNames;
    }

    public static void bachCreateDefaultBaseDts(List<String> entityNames) {
        ArrayList<DynamicObject> objs = new ArrayList<DynamicObject>(entityNames.size());
        long[] pkIds = DB.genLongIds((String)"data_sync_config", (int)entityNames.size());
        for (int i = 0; i < pkIds.length; ++i) {
            DynamicObject object = DtsManage.insertOneDefault(pkIds[i], entityNames.get(i));
            if (object == null) continue;
            objs.add(object);
        }
        DynamicObject[] dynamicObjects = objs.toArray(new DynamicObject[0]);
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
    }

    public static void createSynBusiness(long planId, List<String> entityNames) {
        QFilter f = new QFilter("plannumber", "=", (Object)planId);
        DynamicObjectCollection exits = QueryServiceHelper.query((String)"cvp_plan_syn_business", (String)"entitynumber", (QFilter[])new QFilter[]{f});
        exits.stream().forEach(o -> entityNames.remove(o.getString("entitynumber")));
        if (!entityNames.isEmpty()) {
            ArrayList<DynamicObject> objs = new ArrayList<DynamicObject>(entityNames.size());
            long[] pkIds = DB.genLongIds((String)"cvp_plan_syn_business", (int)entityNames.size());
            for (int i = 0; i < pkIds.length; ++i) {
                DynamicObject object = DtsManage.createSynBusinessDO(pkIds[i], planId, entityNames.get(i));
                objs.add(object);
            }
            DynamicObject[] dynamicObjects = objs.toArray(new DynamicObject[0]);
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        }
    }

    public static DynamicObject insertOneDefault(Object id, String entityName) {
        return DtsManage.createDtsDO(id, entityName, ",id,number,name,", OcrDtsCommon.DtsKey.DEFAULT_ENABLE);
    }

    public static DynamicObject createDtsDO(Object id, String entityNumber, String fields, boolean enable) {
        DynamicProperty pName;
        DynamicProperty pNumber;
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"data_sync_config");
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        StringBuilder entitys = new StringBuilder(",");
        DynamicProperty pId = entityType.getProperty("id");
        if (pId != null) {
            entitys.append("id,");
        }
        if ((pNumber = entityType.getProperty("number")) != null) {
            entitys.append("number,");
        }
        if ((pName = entityType.getProperty("name")) == null) {
            return null;
        }
        entitys.append("name,");
        if (entitys.capacity() <= 1) {
            entitys = null;
        }
        dynamicObject.set("id", id);
        dynamicObject.set("destinationtype", (Object)"fulltext");
        dynamicObject.set("timingsequence", (Object)"");
        dynamicObject.set("region", (Object)"cvpsearch");
        dynamicObject.set("businesstype", (Object)"cvpsearch");
        dynamicObject.set("mappingrule", (Object)"");
        dynamicObject.set("enable", (Object)enable);
        dynamicObject.set("entitynumber", (Object)entityNumber);
        dynamicObject.set("entityfields", (Object)(entitys != null ? entitys.toString() : ""));
        return dynamicObject;
    }

    public static DynamicObject createSynBusinessDO(Object id, Object planId, String entityNumber) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"cvp_plan_syn_business");
        dynamicObject.set("id", id);
        dynamicObject.set("entitynumber", (Object)entityNumber);
        dynamicObject.set("plannumber", planId);
        dynamicObject.set("creatorid", (Object)String.valueOf(RequestContext.get().getCurrUserId()));
        dynamicObject.set("createdate", (Object)new Date());
        return dynamicObject;
    }
}

