/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.ai.cvp.common.Enum.IeExtractBizType;
import kd.ai.cvp.common.Enum.IeExtractTypeEnum;
import kd.ai.cvp.common.Enum.IeSelectRangeEnum;
import kd.ai.cvp.common.Enum.LicenseCountServiceNameEnum;
import kd.ai.cvp.common.Enum.SourceTypeEnum;
import kd.ai.cvp.common.Enum.StorageTypeEnum;
import kd.ai.cvp.common.Enum.VisualTypeEnum;
import kd.ai.cvp.common.IeCommon;
import kd.ai.cvp.common.IeRecognizeVO;
import kd.ai.cvp.entity.AlgoPageNumAndFileIdVO;
import kd.ai.cvp.entity.AlgoResultData;
import kd.ai.cvp.entity.AlgoResultDataVO;
import kd.ai.cvp.entity.IeExtractPlanVO;
import kd.ai.cvp.entity.InitTdaTieAttData;
import kd.ai.cvp.entity.TieShowF7ResultVO;
import kd.ai.cvp.entity.TieShowF7VO;
import kd.ai.cvp.entity.ie.ExtractSeq;
import kd.ai.cvp.entity.ie.GeneralIEResult;
import kd.ai.cvp.entity.ie.IeInitCustomVO;
import kd.ai.cvp.entity.ie.IeLLMExtractResultVO;
import kd.ai.cvp.entity.ie.PageSelection;
import kd.ai.cvp.entity.ie.StartExtract;
import kd.ai.cvp.entity.ie.TieCustomOpResult;
import kd.ai.cvp.entity.ie.TieExtractData;
import kd.ai.cvp.entity.ie.TieHistory;
import kd.ai.cvp.entity.ie.TieImportExtractResult;
import kd.ai.cvp.entity.ie.TieImportExtractVO;
import kd.ai.cvp.entity.ie.TieRelateConfigField;
import kd.ai.cvp.entity.ie.TieSaveExtractResultVO;
import kd.ai.cvp.entity.ie.TieViewResult;
import kd.ai.cvp.entity.tda.StartComparisonFile;
import kd.ai.cvp.entity.tda.TdaCancelTaskResultVO;
import kd.ai.cvp.entity.tda.TdaCancelTaskVO;
import kd.ai.cvp.entity.tda.algoCompare.ConversionAlgoInfo;
import kd.ai.cvp.task.TiePullResultService;
import kd.ai.cvp.utils.CommonUtil;
import kd.ai.cvp.utils.CvpFileServiceUtils;
import kd.ai.cvp.utils.LicenseUtils;
import kd.ai.cvp.utils.OcrControlUtils;
import kd.ai.cvp.utils.OcrHttpClientUtils;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.message.BasicNameValuePair;

public class IeUtils {
    private static Log logger = LogFactory.getLog(IeUtils.class);
    private static final String VALID_FILE_ERROR = "validFileError";
    private static final String VALID_LICENSE_ERROR = "validLicenseError";
    private static final String SYSTEM_ERROR = "systemError";
    private static final String APP_PLUGIN = "ai-cvp-plugin";
    public static final String GET_CURRENCY_BILLFORMID = "bd_currency";
    public static final String SHOW_F7_ACTIONID = "showF7ActionId";

    private IeUtils() {
        throw new KDBizException("tools class should not init by Constructors.");
    }

    public static void customOperate(IFormView view, String eventName, String args) {
        logger.info("IE \u81ea\u5b9a\u4e49\u63a7\u4ef6\u64cd\u4f5c - \u5f53\u524d\u64cd\u4f5c\u7c7b\u578b \uff1a{} ", (Object)eventName);
        if (OcrControlUtils.checkWebStatus(view, eventName, args)) {
            return;
        }
        try {
            switch (eventName) {
                case "validExtractFile": {
                    CommonUtil.validSelectedFile(view, args, "customtda", eventName, VisualTypeEnum.INFO_EXTRACT);
                    break;
                }
                case "showF7": {
                    IeUtils.showF7(view, args);
                    break;
                }
                case "startExtract": {
                    IeUtils.startExtract(view, args);
                    break;
                }
                case "polling": {
                    IeUtils.pollingResult(view, args);
                    break;
                }
                case "init": {
                    IeUtils.initCustom(view);
                    break;
                }
                case "getAttachmentList": {
                    CommonUtil.createAttachmentList(view, args, "customtda", "getAttachmentList", IeCommon.InfoExtract.TIE_FILTER_TYPES);
                    break;
                }
                case "ie_history_task": {
                    long billid = Long.parseLong(args);
                    IeUtils.retHistoryList(view, billid);
                    break;
                }
                case "ie_show_task": {
                    long fid = Long.parseLong(args);
                    IeUtils.retOneHistory(view, fid);
                    break;
                }
                case "ie_delhistory_task": {
                    long delFid = Long.parseLong(args);
                    IeUtils.delHistory(view, delFid);
                    break;
                }
                case "recognize": {
                    IeUtils.recognize(view, args);
                    break;
                }
                case "saveExtractInfo": {
                    IeUtils.saveExtractUpdateData(view, args);
                    break;
                }
                case "importExtractInfo": {
                    IeUtils.importDataToBusinessBill(view, args);
                    break;
                }
                case "cancelExtract": {
                    IeUtils.cancelTask(view, args);
                    break;
                }
                default: {
                    view.showErrorNotification("\u4e0d\u5b58\u5728\u3010" + eventName + "\u3011\u7684\u64cd\u4f5c\u547d\u4ee4\u3002");
                    break;
                }
            }
        }
        catch (Exception e) {
            view.showErrMessage(e.getMessage(), ResManager.loadKDString((String)"\u6587\u6863\u4fe1\u606f\u63d0\u53d6\u5f02\u5e38:", (String)"InfoExtractPlugin_0", (String)APP_PLUGIN, (Object[])new Object[0]));
            logger.error(" \u81ea\u5b9a\u4e49\u4fe1\u606f\u63d0\u53d6 \u63a7\u4ef6 \u64cd\u4f5c\u7801: " + eventName + "\u4fe1\u606f\u63d0\u53d6\u5f02\u5e38: " + e.getMessage(), (Throwable)e);
            String traceId = RequestContext.get().getTraceId();
            LicenseUtils.ensureCallNumToAlgo(false, traceId, SourceTypeEnum.INFOEXTRACT);
            OcrControlUtils.setTdaOrTieCustomcontrolData(view, "customtda", "ieBreakOff", Boolean.TRUE);
        }
    }

    private static void cancelTask(IFormView view, String args) {
        if (StringUtils.isEmpty((CharSequence)args)) {
            String tips = ResManager.loadKDString((String)"\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"TdaUtils_006", (String)"ai-cvp-common", (Object[])new Object[0]);
            view.showTipNotification(tips);
            OcrControlUtils.setTdaOrTieCustomcontrolData(view, "customtda", "ieBreakOff", "");
            return;
        }
        TdaCancelTaskVO tdaCancelTaskVO = (TdaCancelTaskVO)JSON.parseObject((String)args, TdaCancelTaskVO.class);
        if (tdaCancelTaskVO == null || StringUtils.isEmpty((CharSequence)tdaCancelTaskVO.getFid()) && StringUtils.isEmpty((CharSequence)tdaCancelTaskVO.getTaskId())) {
            logger.info("\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a...");
            String tips = ResManager.loadKDString((String)"\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"TdaUtils_007", (String)"ai-cvp-common", (Object[])new Object[0]);
            view.showTipNotification(tips);
            OcrControlUtils.setTdaOrTieCustomcontrolData(view, "customtda", "ieBreakOff", "");
            return;
        }
        String taskId = tdaCancelTaskVO.getTaskId();
        String fid = tdaCancelTaskVO.getFid();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (StringUtils.isNotEmpty((CharSequence)fid)) {
            filters.add(new QFilter("id", "=", (Object)Long.parseLong(fid)));
        } else if (StringUtils.isNotEmpty((CharSequence)taskId)) {
            filters.add(new QFilter("taskid", "=", (Object)taskId));
        }
        DynamicObject taskObj = BusinessDataServiceHelper.loadSingle((String)"cvp_ie_history", (String)"id,taskid,extractstatus,progressinfo,billenddate", (QFilter[])filters.toArray(new QFilter[0]));
        if (taskObj == null) {
            String noTaskTips = ResManager.loadKDString((String)"\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e\u540e\u91cd\u8bd5\u3002", (String)"IeUtils_008", (String)"ai-cvp-common", (Object[])new Object[0]);
            view.showTipNotification(noTaskTips);
            OcrControlUtils.setTdaOrTieCustomcontrolData(view, "customtda", "ieBreakOff", "");
            return;
        }
        taskId = taskObj.getString("taskid");
        if (StringUtils.isEmpty((CharSequence)taskId)) {
            logger.error("\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002");
            String noTaskTips = ResManager.loadKDString((String)"\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e\u540e\u91cd\u8bd5\u3002", (String)"TdaUtils_010", (String)"ai-cvp-common", (Object[])new Object[0]);
            view.showTipNotification(noTaskTips);
            OcrControlUtils.setTdaOrTieCustomcontrolData(view, "customtda", "ieBreakOff", "");
            return;
        }
        String billstatus = taskObj.getString("extractstatus");
        if (!"running".equals(billstatus)) {
            logger.error("\u975e\u8fd0\u884c\u4e2d\u7684\u4efb\u52a1\uff0c\u65e0\u6cd5\u53d6\u6d88\u3002");
            view.showTipNotification(ResManager.loadKDString((String)"\u975e\u8fd0\u884c\u4e2d\u7684\u4efb\u52a1\uff0c\u65e0\u6cd5\u53d6\u6d88\u3002", (String)"IeUtils_009", (String)"ai-cvp-common", (Object[])new Object[0]));
            OcrControlUtils.setTdaOrTieCustomcontrolData(view, "customtda", "ieBreakOff", "");
            return;
        }
        try {
            TdaCancelTaskResultVO resultVO = CommonUtil.cancelTask(taskId, LicenseCountServiceNameEnum.TIE_SERVICE_FOR_PDF, SourceTypeEnum.INFOEXTRACT);
            if (resultVO == null || !resultVO.getCancelResult()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53d6\u6d88\u4efb\u52a1\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"IeUtils_010", (String)"ai-cvp-common", (Object[])new Object[0]));
            }
            String alertMsg = ResManager.loadKDString((String)String.format("\u53d6\u6d88\u4efb\u52a1\u6210\u529f\uff0c\u4efb\u52a1\u7f16\u7801\uff1a%s\uff0c\u5f53\u524d\u5df2\u8bc6\u522b\u9875\u6570\uff1a%d\uff0c\u5df2\u8bc6\u522b\u7684\u9875\u6570\u5df2\u8ba1\u5165\u8bb8\u53ef\u6d88\u8017\u6570\u91cf\u4e2d\u3002", taskId, resultVO.getUsedNum()), (String)"TdaUtils_013", (String)"ai-cvp-common", (Object[])new Object[0]);
            logger.info(alertMsg);
            IeUtils.updateDB(taskObj, resultVO);
            view.showSuccessNotification(alertMsg);
        }
        catch (KDBizException ke) {
            logger.error("\u53d6\u6d88\u4efb\u52a1\u5931\u8d25\u3002", (Throwable)ke);
            String message = ke.getMessage();
            if (StringUtils.isEmpty((CharSequence)message)) {
                message = ResManager.loadKDString((String)"\u53d6\u6d88\u5931\u8d25\uff0c\u82e5\u4efb\u52a1\u8fd8\u672a\u505c\u6b62\uff0c\u8bf7\u518d\u6b21\u5c1d\u8bd5\u3002", (String)"IeUtils_011", (String)"ai-cvp-common", (Object[])new Object[0]);
            }
            view.showTipNotification(message);
        }
        catch (Exception e) {
            logger.error("\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u3002", (Throwable)e);
            view.showTipNotification(ResManager.loadKDString((String)"\u672a\u77e5\u5f02\u5e38\uff0c\u82e5\u4efb\u52a1\u8fd8\u672a\u505c\u6b62\uff0c\u8bf7\u518d\u6b21\u5c1d\u8bd5\u3002\u82e5\u591a\u6b21\u51fa\u73b0\u672c\u63d0\u793a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"TdaUtils_015", (String)"ai-cvp-common", (Object[])new Object[0]));
        }
        OcrControlUtils.setTdaOrTieCustomcontrolData(view, "customtda", "cancelExtract", "");
    }

    private static void updateDB(DynamicObject taskObj, TdaCancelTaskResultVO resultVO) {
        int usedCount = resultVO.getUsedNum();
        int totalCount = resultVO.getTotalNum();
        taskObj.set("extractstatus", (Object)"cancel");
        taskObj.set("billenddate", (Object)new Date());
        taskObj.set("progressinfo", (Object)String.format("\u5171%s\u9875\uff0c\u5df2\u8bc6\u522b  %s  \u9875\uff0c\u8bf7\u7a0d\u5019...", totalCount, usedCount));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskObj});
    }

    private static void showF7(IFormView view, String args) {
        if (StringUtils.isEmpty((CharSequence)args)) {
            CommonUtil.errorTips(view, "\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", "\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", "customtda", "showF7");
            return;
        }
        TieShowF7VO tieShowF7VO = (TieShowF7VO)JSON.parseObject((String)args, TieShowF7VO.class);
        String type = tieShowF7VO.getType();
        String basebillFromId = null;
        if (type.equals("currency")) {
            basebillFromId = GET_CURRENCY_BILLFORMID;
        } else {
            logger.error("\u4e0d\u5b58\u5728\u7684F7\u57fa\u7840\u8d44\u6599\u7b26\u53f7");
        }
        if (StringUtils.isEmpty((CharSequence)basebillFromId)) {
            CommonUtil.errorTips(view, "\u4e0d\u5b58\u5728\u7684\u57fa\u7840\u8d44\u6599\u9009\u9879\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", "\u4e0d\u5b58\u5728\u7684\u57fa\u7840\u8d44\u6599\u9009\u9879\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", "customtda", "showF7");
            return;
        }
        if (StringUtils.isEmpty((CharSequence)view.getPageId())) {
            CommonUtil.errorTips(view, "\u5c55\u793a\u57fa\u7840\u8d44\u6599\u5217\u8868\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", "\u9875\u9762pageid\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5c55\u793a\u57fa\u7840\u8d44\u6599\u3002", "customtda", "showF7");
            return;
        }
        view.getPageCache().put(view.getPageId().concat("_").concat("billFormId"), basebillFromId);
        TieShowF7ResultVO tieShowF7ResultVO = new TieShowF7ResultVO();
        tieShowF7ResultVO.setType(type);
        view.getPageCache().put(view.getPageId().concat("_").concat("returnEntity"), JSON.toJSONString((Object)tieShowF7ResultVO));
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(statusFilter);
        qFilters.add(enableFilter);
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listFilterParameter.setQFilters(qFilters);
        IeUtils.openF7List(view, listFilterParameter, "kd.ai.cvp.plugin.ie.InfoExtractPlugin", basebillFromId, SHOW_F7_ACTIONID);
    }

    private static void openF7List(IFormView view, ListFilterParameter listFilterParameter, String callbackClassName, String billformid, String actionId) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("bos_listf7");
        showParameter.setBillFormId(billformid);
        showParameter.setListFilterParameter(listFilterParameter);
        showParameter.setHasRight(true);
        showParameter.setMultiSelect(false);
        showParameter.setShowApproved(true);
        showParameter.setShowTitle(false);
        showParameter.setShowQuickFilter(true);
        showParameter.setShowUsed(true);
        showParameter.setLookUp(true);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss styleCss = new StyleCss();
        styleCss.setHeight("580px");
        styleCss.setWidth("960px");
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        showParameter.setPageMode(2);
        showParameter.setCloseCallBack(new CloseCallBack(callbackClassName, actionId));
        view.showForm((FormShowParameter)showParameter);
    }

    public static void setDataChangeFalse(IFormView view, String ... modelKey) {
        IDataModel model = view.getModel();
        MainEntityType dataEntityType = model.getDataEntityType();
        if (modelKey != null) {
            Arrays.stream(modelKey).forEach(mkey -> {
                int planConfigOrdinal = dataEntityType.getProperty(mkey).getOrdinal();
                model.getDataEntity().getDataEntityState().setBizChanged(planConfigOrdinal, false);
            });
        }
    }

    private static void importDataToBusinessBill(IFormView view, String args) {
        if (StringUtils.isEmpty((CharSequence)args)) {
            OcrControlUtils.setTdaOrTieCustomcontrolData(view, "customtda", "ieBreakOff", Boolean.TRUE);
            return;
        }
        TieImportExtractVO saveResultVO = (TieImportExtractVO)JSON.parseObject((String)args, TieImportExtractVO.class);
        String taskId = saveResultVO.getTaskId();
        Object updateData = saveResultVO.getUpdateData();
        List<Map<String, TieImportExtractResult>> importData = saveResultVO.getImportData();
        Map<String, List<Map<String, Object>>> importTableData = saveResultVO.getImportTableData();
        String errorMsg = IeUtils.validParam(saveResultVO);
        if (!StringUtils.isEmpty((CharSequence)errorMsg)) {
            view.showTipNotification("\u5bfc\u5165\u5355\u636e\u5931\u8d25\uff0c\u53c2\u6570\u6821\u9a8c\u5f02\u5e38\uff1a" + errorMsg);
            OcrControlUtils.setTdaOrTieCustomcontrolData(view, "customtda", "ieBreakOff", Boolean.TRUE);
            return;
        }
        TieSaveExtractResultVO saveVO = new TieSaveExtractResultVO();
        saveVO.setTaskId(taskId);
        saveVO.setUpdateData(updateData);
        boolean saveResultFlag = IeUtils.saveExtractUpdateData(view, JSON.toJSONString((Object)saveVO));
        if (!saveResultFlag) {
            return;
        }
        AlgoResultDataVO resultData = IeUtils.setAlgoResultData(taskId, importData, importTableData);
        if (resultData.getRepCode() != 0) {
            logger.error("\u5bfc\u5165\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002");
            OcrControlUtils.setTdaOrTieCustomcontrolData(view, "customtda", "importExtractInfo", new TieCustomOpResult(false, 40000, "\u5bfc\u5165\u5931\u8d25," + resultData.getRepMessage(), RequestContext.get().getTraceId()));
            return;
        }
        view.returnDataToParent((Object)SerializationUtils.toJsonString((Object)resultData));
        view.close();
        OcrControlUtils.setTdaOrTieCustomcontrolData(view, "customtda", "importExtractInfo", new TieCustomOpResult(true, 0, "\u6210\u529f", RequestContext.get().getTraceId()));
    }

    private static AlgoResultDataVO setAlgoResultData(String taskId, List<Map<String, TieImportExtractResult>> importData, Map<String, List<Map<String, Object>>> importTableData) {
        DynamicObject historyObj = IeUtils.queryHistory(taskId);
        if (historyObj == null) {
            return new AlgoResultDataVO(20010, "\u5386\u53f2\u8bb0\u5f55\u5df2\u88ab\u5220\u9664,\u5bfc\u5165\u5355\u636e\u5931\u8d25\u3002", null);
        }
        DynamicObject busObj = historyObj.getDynamicObject("businessobj");
        DynamicObject mouldObj = historyObj.getDynamicObject("iemould");
        if (busObj == null || mouldObj == null) {
            return new AlgoResultDataVO(20010, "\u4e1a\u52a1\u5bf9\u8c61\u4e3a\u7a7a,\u5bfc\u5165\u5355\u636e\u5931\u8d25\u3002", null);
        }
        DynamicObject relateConfigObj = IeUtils.queryRelateConfig(busObj.getPkValue());
        if (relateConfigObj == null) {
            return new AlgoResultDataVO(20010, "\u4e1a\u52a1\u5bf9\u8c61\u672a\u505a\u63d0\u53d6\u5173\u8054\u8bbe\u7f6e\uff0c\u8bf7\u5148\u8bbe\u7f6e\u3002", null);
        }
        String relateConfigObjString = relateConfigObj.getString("relateconfig");
        if (StringUtils.isEmpty((CharSequence)relateConfigObjString)) {
            return new AlgoResultDataVO(20010, "\u63d0\u53d6\u5173\u8054\u8bbe\u7f6e\u4e2d\u7684\u6620\u5c04\u5173\u7cfb\u4e3a\u7a7a,\u5bfc\u5165\u5355\u636e\u5931\u8d25\u3002", null);
        }
        JSONObject relateObj = JSON.parseObject((String)relateConfigObjString);
        String templateIdStr = String.valueOf(mouldObj.getPkValue());
        TieRelateConfigField tieRelateConfigField = (TieRelateConfigField)JSON.parseObject((String)relateObj.get((Object)templateIdStr).toString(), TieRelateConfigField.class);
        List<Map<String, String>> value = tieRelateConfigField.getValue();
        return new AlgoResultDataVO(0, "\u5bfc\u5165\u6210\u529f", IeUtils.getDataMap(value, importData, importTableData));
    }

    private static Map<String, Object> getDataMap(List<Map<String, String>> value, List<Map<String, TieImportExtractResult>> importData, Map<String, List<Map<String, Object>>> importTableData) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        Map<String, String> extractResultMap = IeUtils.rebuildExtractResult(importData);
        Map<String, List<Map<String, Object>>> resultTableMap = IeUtils.rebuildExtractTableResult(importTableData);
        Map<Object, Object> textOcr = new HashMap();
        if (!extractResultMap.isEmpty()) {
            textOcr = IeUtils.handleCommonFields(value, extractResultMap);
        }
        Map<Object, Object> tableOcr = new HashMap();
        if (!resultTableMap.isEmpty()) {
            tableOcr = IeUtils.handleBizFields(value, resultTableMap);
        }
        result.put("textOcr", textOcr);
        result.put("tablesOcr", tableOcr);
        return result;
    }

    private static Map<String, Object> handleCommonFields(List<Map<String, String>> value, Map<String, String> extractResultMap) {
        HashMap<String, Object> textOcr = new HashMap<String, Object>(16);
        for (Map<String, String> obj : value) {
            boolean flag;
            String key = obj.keySet().toArray(new String[0])[0];
            if (StringUtils.isEmpty((CharSequence)key) || key.contains(".") || !(flag = extractResultMap.containsKey(key))) continue;
            textOcr.put(obj.get(key), extractResultMap.get(key));
        }
        textOcr.remove("");
        return textOcr;
    }

    private static Map<String, List<Map<String, Object>>> handleBizFields(List<Map<String, String>> value, Map<String, List<Map<String, Object>>> tableResult) {
        HashMap<String, List<Map<String, Object>>> tables = new HashMap<String, List<Map<String, Object>>>(16);
        if (tableResult == null || tableResult.isEmpty() || value == null || value.isEmpty()) {
            return tables;
        }
        tableResult.forEach((k, v) -> {
            ArrayList valueList = new ArrayList();
            v.forEach(m -> {
                HashSet tieK = new HashSet();
                tieK.addAll(m.keySet());
                value.forEach(map -> {
                    Set entries = map.entrySet();
                    entries.forEach(ent -> {
                        String key = (String)ent.getKey();
                        String value1 = (String)ent.getValue();
                        if (!key.contains(".")) {
                            return;
                        }
                        if (StringUtils.isNotEmpty((CharSequence)value1) && m.get(key) != null) {
                            m.put(value1, m.get(key));
                        }
                    });
                });
                HashMap map2 = new HashMap(m.size());
                map2.putAll(m);
                tieK.forEach(tk -> {
                    if (map2.get(tk) != null) {
                        map2.remove(tk);
                    }
                });
                valueList.add(map2);
            });
            tables.put((String)k, valueList);
        });
        return tables;
    }

    private static Map<String, List<Map<String, Object>>> rebuildExtractTableResult(Map<String, List<Map<String, Object>>> importTableData) {
        HashMap<String, List<Map<String, Object>>> table = new HashMap<String, List<Map<String, Object>>>();
        if (importTableData == null || importTableData.isEmpty()) {
            return table;
        }
        importTableData.forEach((key, value) -> {
            ArrayList allRows = new ArrayList();
            if (!value.isEmpty()) {
                value.forEach(v -> {
                    Set entries = v.entrySet();
                    HashMap rowMap = new HashMap();
                    entries.forEach(en -> {
                        String key1 = (String)en.getKey();
                        Object value1 = en.getValue();
                        rowMap.put(key.concat(".").concat(key1), value1);
                    });
                    allRows.add(rowMap);
                });
            }
            table.put((String)key, allRows);
        });
        return table;
    }

    private static Map<String, String> rebuildExtractResult(List<Map<String, TieImportExtractResult>> importData) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (importData == null || importData.isEmpty()) {
            return map;
        }
        importData.forEach(m -> {
            Set entries = m.entrySet();
            entries.forEach(e -> {
                TieImportExtractResult value = (TieImportExtractResult)e.getValue();
                map.put((String)e.getKey(), value.getValue());
            });
        });
        return map;
    }

    private static DynamicObject queryRelateConfig(Object pkValue) {
        QFilter filter = new QFilter("businessobj", "=", pkValue);
        QFilter[] filters = new QFilter[]{filter};
        String selectFields = "id,relateconfig";
        return BusinessDataServiceHelper.loadSingle((String)"cvp_ie_relateconfig", (String)selectFields, (QFilter[])filters);
    }

    private static DynamicObject queryHistory(String taskId) {
        QFilter filter = new QFilter("taskid", "=", (Object)taskId);
        QFilter[] filters = new QFilter[]{filter};
        String selectFields = "id,businessobj,iemould";
        return BusinessDataServiceHelper.loadSingle((String)"cvp_ie_history", (String)selectFields, (QFilter[])filters);
    }

    private static String validParam(TieImportExtractVO saveResultVO) {
        String taskId = saveResultVO.getTaskId();
        Object updateData = saveResultVO.getUpdateData();
        List<Map<String, TieImportExtractResult>> importData = saveResultVO.getImportData();
        Map<String, List<Map<String, Object>>> importTableData = saveResultVO.getImportTableData();
        if (StringUtils.isEmpty((CharSequence)taskId) || Objects.isNull(updateData)) {
            return "\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002";
        }
        return "";
    }

    private static boolean saveExtractUpdateData(IFormView view, String args) {
        if (StringUtils.isEmpty((CharSequence)args)) {
            OcrControlUtils.setTdaOrTieCustomcontrolData(view, "customtda", "ieBreakOff", Boolean.TRUE);
            return false;
        }
        TieSaveExtractResultVO saveResultVO = (TieSaveExtractResultVO)JSON.parseObject((String)args, TieSaveExtractResultVO.class);
        if (saveResultVO != null && !StringUtils.isEmpty((CharSequence)saveResultVO.getTaskId())) {
            String taskId = saveResultVO.getTaskId();
            Object updateData = saveResultVO.getUpdateData();
            QFilter taskFilter = new QFilter("taskid", "=", (Object)taskId);
            DynamicObject extractObj = BusinessDataServiceHelper.loadSingle((String)"cvp_ie_history", (String)"id,taskid,isupdate,updatedata", (QFilter[])new QFilter[]{taskFilter});
            if (extractObj != null) {
                extractObj.set("isupdate", (Object)Boolean.TRUE);
                extractObj.set("updatedata", (Object)CommonUtil.encryptString(String.valueOf(updateData)));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{extractObj});
                view.showSuccessNotification("\u4fdd\u5b58\u6210\u529f");
                return true;
            }
            logger.info("\u4e0d\u5b58\u5728\u8be5\u5386\u53f2\u8bb0\u5f55\uff0c\u8bf7\u6838\u5b9e\u540e\u91cd\u8bd5\u3002");
        } else {
            logger.info("\u5f85\u4fdd\u5b58\u7684\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25\u3002");
        }
        view.showTipNotification("\u4fdd\u5b58\u5931\u8d25");
        OcrControlUtils.setTdaOrTieCustomcontrolData(view, "customtda", "ieBreakOff", Boolean.TRUE);
        return false;
    }

    private static void recognize(IFormView view, String args) throws Exception {
        if (StringUtils.isEmpty((CharSequence)args)) {
            OcrControlUtils.setTdaOrTieCustomcontrolData(view, "customtda", "ieBreakOff", Boolean.TRUE);
            return;
        }
        IeRecognizeVO ieRecognizeVO = (IeRecognizeVO)JSON.parseObject((String)args, IeRecognizeVO.class);
        String requestData = ieRecognizeVO.getRequestData().replaceAll("data:image/png;base64,", "");
        if (StringUtils.isNotEmpty((CharSequence)requestData)) {
            ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>(4);
            list.add(new BasicNameValuePair("imageBase64", requestData));
            UrlEncodedFormEntity httpEntity = new UrlEncodedFormEntity(list, StandardCharsets.UTF_8);
            String resultStr = OcrHttpClientUtils.kdCloudHttpClientPost("/template/textRecognize", (HttpEntity)httpEntity);
            logger.info("TIE \u4fe1\u606f\u63d0\u53d6 - \u63a5\u53e3:/template/textRecognize - traceId: " + RequestContext.get().getTraceId());
            JSONObject obj = JSON.parseObject((String)resultStr);
            int errorCode = (Integer)obj.get("errorCode");
            if (0 == errorCode) {
                String data = obj.get("data").toString();
                IeRecognizeVO recognizeVO = new IeRecognizeVO(ieRecognizeVO.getShapeId(), ieRecognizeVO.getPageNum(), "", data);
                OcrControlUtils.setTdaOrTieCustomcontrolData(view, "customtda", "recognize", recognizeVO);
            } else {
                String description = (String)obj.get("description");
                view.showTipNotification(description);
            }
        }
    }

    private static void delHistory(IFormView view, long delFid) {
        OcrControlUtils.setTdaOrTieCustomcontrolData(view, "customtda", "ie_delhistory_task", IeUtils.doDelHistory(delFid));
    }

    public static TieCustomOpResult doDelHistory(long delFid) {
        TieCustomOpResult tieCustomOpResult;
        QFilter historyFilter = new QFilter("id", "=", (Object)delFid);
        DynamicObject historyObj = IeUtils.getTaskInfoByFilters(new QFilter[]{historyFilter});
        String traceId = RequestContext.get().getTraceId();
        if (historyObj != null) {
            String status = historyObj.getString("extractstatus");
            if ("running".equalsIgnoreCase(status)) {
                String message = ResManager.loadKDString((String)"\u6587\u6863\u4fe1\u606f\u63d0\u53d6\u4efb\u52a1\u8fdb\u884c\u4e2d\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"InfoExtractPlugin_1", (String)APP_PLUGIN, (Object[])new Object[0]);
                tieCustomOpResult = new TieCustomOpResult(false, -1, message, traceId);
            } else {
                String docPath = historyObj.getString("billdocpath");
                String taskId = historyObj.getString("taskid");
                logger.info(String.format("TIE \u6587\u6863\u4fe1\u606f\u63d0\u53d6\uff0c\u6e05\u7406\u9644\u4ef6 \u4efb\u52a1ID:%s ,\u6587\u6863:%s ,", taskId, docPath));
                FileService fs = FileServiceFactory.getAttachmentFileService();
                try (TXHandle h = TX.requiresNew();){
                    try {
                        int delete = DeleteServiceHelper.delete((String)"cvp_ie_history", (QFilter[])new QFilter[]{historyFilter});
                        logger.info("TIE \u5386\u53f2\u8bb0\u5f55\u5220\u9664\u7ed3\u679c\uff1a{}\u6761\u8bb0\u5f55\u88ab\u5220\u9664\uff0ctaskId:{}", (Object)delete, (Object)taskId);
                        fs.delete(docPath);
                        logger.info("TIE \u5220\u9664\u63d0\u53d6\u6587\u6863\u5b8c\u6210");
                        IeUtils.delImages(taskId);
                    }
                    catch (Exception e1) {
                        h.markRollback();
                        throw e1;
                    }
                }
                String message = ResManager.loadKDString((String)"\u4efb\u52a1\u5220\u9664\u6210\u529f\u3002", (String)"InfoExtractPlugin_2", (String)APP_PLUGIN, (Object[])new Object[0]);
                tieCustomOpResult = new TieCustomOpResult(true, 0, message, traceId);
            }
        } else {
            String message = ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u5b9a\u8be5\u63d0\u53d6\u4efb\u52a1\u662f\u5426\u5df2\u88ab\u6e05\u7406", (String)"InfoExtractPlugin_3", (String)APP_PLUGIN, (Object[])new Object[0]);
            tieCustomOpResult = new TieCustomOpResult(false, -1, message, traceId);
        }
        return tieCustomOpResult;
    }

    private static void delImages(String taskId) {
        String selectFile = "imageid,taskid,imagepath";
        QFilter filter = new QFilter("taskid", "=", (Object)taskId);
        DynamicObjectCollection objCol = QueryServiceHelper.query((String)"cvp_tda_task_image", (String)selectFile, (QFilter[])new QFilter[]{filter});
        FileService ifs = FileServiceFactory.getImageFileService();
        logger.info("TIE \u6587\u6863\u4fe1\u606f\u63d0\u53d6\uff0c\u5f00\u59cb\u6e05\u7406\u63d0\u53d6\u56fe\u7247 taskId:{}", (Object)taskId);
        if (objCol != null && !objCol.isEmpty()) {
            int size = objCol.size();
            objCol.forEach(image -> {
                String imagePath = image.getString("imagepath");
                if (!StringUtils.isEmpty((CharSequence)imagePath)) {
                    ifs.delete(imagePath);
                }
            });
            logger.info("TIE \u6587\u6863\u4fe1\u606f\u63d0\u53d6\uff0c\u6e05\u7406\u63d0\u53d6\u56fe\u7247\u7ed3\u675f taskId:{},size:{}", (Object)taskId, (Object)size);
        }
    }

    private static void retOneHistory(IFormView view, long fid) {
        TieExtractData extractData = IeUtils.getHistory(fid);
        if (extractData != null) {
            TieViewResult viewResult = new TieViewResult(extractData.getTaskId(), extractData.getStatus(), extractData.getProgress(), extractData);
            OcrControlUtils.setTdaOrTieCustomcontrolData(view, "customtda", "ie_show_task", viewResult);
        } else {
            String message = ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u53d6\u6d88\uff0c\u8bf7\u786e\u5b9a\u8be5\u4efb\u52a1\u72b6\u6001\u540e\u518d\u8bd5\u3002", (String)"TdaInfoPlugin_1", (String)APP_PLUGIN, (Object[])new Object[0]);
            logger.info(String.format("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u5dee\u5f02\u5206\u6790\uff0c%s", message));
            view.showTipNotification(message);
            OcrControlUtils.setTdaOrTieCustomcontrolData(view, "customtda", "ieBreakOff", Boolean.TRUE);
        }
    }

    private static TieExtractData getHistory(long fid) {
        QFilter historyFilter = new QFilter("id", "=", (Object)fid);
        DynamicObject historyObj = IeUtils.getTaskInfoByFilters(new QFilter[]{historyFilter});
        TieExtractData extractData = null;
        if (historyObj != null && !"cancel".equalsIgnoreCase(historyObj.getString("extractstatus"))) {
            extractData = IeUtils.queryHistoryByLocalDb(historyObj);
        }
        return extractData;
    }

    private static void retHistoryList(IFormView view, long billid) {
        List<TieHistory> tieHistories = IeUtils.getHistoryList(billid);
        OcrControlUtils.setTdaOrTieCustomcontrolData(view, "customtda", "ie_history_task", tieHistories);
    }

    private static List<TieHistory> getHistoryList(long billid) {
        String orderBy;
        String selectField = "billno,busbillno,busbillname,billdoc,billdocpath,billcreatedate,billenddate,extractstatus,extractpages,billieresult,taskid,billid,iemould,iemould.name,businessobj,updatedata,isupdate,\ncreator,progressinfo,totalpage";
        QFilter filter = new QFilter("billid", "=", (Object)billid);
        DynamicObject[] tasks = BusinessDataServiceHelper.load((String)"cvp_ie_history", (String)selectField, (QFilter[])new QFilter[]{filter}, (String)(orderBy = "billcreatedate desc"));
        if (tasks != null && tasks.length > 0) {
            return Arrays.stream(tasks).map(t -> {
                String mouldName = "";
                try {
                    DynamicObject iemould = t.getDynamicObject("iemould");
                    if (iemould != null) {
                        mouldName = iemould.getString("name");
                    }
                }
                catch (Exception e) {
                    logger.error("\u6a21\u677f\u5df2\u88ab\u5220\u9664", (Throwable)e);
                }
                String createName = "";
                try {
                    DynamicObject creator = t.getDynamicObject("creator");
                    if (creator != null) {
                        createName = creator.getString("name");
                    }
                }
                catch (Exception e) {
                    logger.error("\u7528\u6237\u5df2\u88ab\u5220\u9664", (Throwable)e);
                }
                return new TieHistory(String.valueOf(t.getPkValue()), t.getString("billdoc"), mouldName, t.getDate("billcreatedate") != null ? t.getDate("billcreatedate").getTime() : 0L, t.getDate("billenddate") != null ? t.getDate("billenddate").getTime() : 0L, t.getString("extractpages"), t.getString("extractstatus"), createName, t.getString("progressinfo"), t.getInt("totalpage"));
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static void pollingResult(IFormView view, String args) throws Exception {
        String operateType = (String)view.getFormShowParameter().getCustomParam("ie_operate_type");
        JSONObject objMap = JSON.parseObject((String)args);
        String taskId = (String)objMap.get((Object)"taskId");
        logger.info(String.format("IE \u67e5\u8be2\u6587\u6863\u4fe1\u606f\u63d0\u53d6\u4efb\u52a1\uff0c\u4efb\u52a1ID\uff1a%s , \u4e1a\u52a1\u64cd\u4f5c\u7c7b\u578b\uff1a%s \uff0ctraceId\uff1a%s", taskId, operateType, RequestContext.get().getTraceId()));
        TieExtractData extractData = IeUtils.queryTieBillResult(taskId);
        TieViewResult viewResult = new TieViewResult(extractData.getTaskId(), extractData.getStatus(), extractData.getProgress(), extractData);
        OcrControlUtils.setTdaOrTieCustomcontrolData(view, "customtda", "polling", viewResult);
    }

    public static TieExtractData queryTieBillResult(String taskId) {
        QFilter historyFilter = new QFilter("taskid", "=", (Object)taskId);
        DynamicObject historyObj = IeUtils.getTaskInfoByFilters(new QFilter[]{historyFilter});
        TieExtractData extractData = historyObj != null ? IeUtils.queryHistoryByLocalDb(historyObj) : new TieExtractData(RequestContext.get().getTraceId(), taskId, "error", "\u67e5\u8be2\u5931\u8d25\uff0c\u4e0d\u5b58\u5728\u8be5\u8bb0\u5f55\u3002");
        return extractData;
    }

    private static IeLLMExtractResultVO getLLMCieTaskInfoByFilters(DynamicObject history) {
        IeExtractTypeEnum typeEnum;
        String tieType = history.getString("tietype");
        String llmTaskId = history.getString("llmtaskid");
        if (StringUtils.isEmpty((CharSequence)tieType)) {
            tieType = IeExtractTypeEnum.COMMON_EXTRACT.getExtractType() + "";
        }
        if ((typeEnum = IeExtractTypeEnum.getTypeEnum(Integer.parseInt(tieType))) != null) {
            switch (typeEnum) {
                case LLM_EXTRACT: 
                case COMMON_AND_LLM_EXTRACT: 
                case COMMON_TABLE_EXTRACT: {
                    if (StringUtils.isNotEmpty((CharSequence)llmTaskId)) {
                        QFilter qFilter = new QFilter("llmtaskid", "=", (Object)llmTaskId);
                        DynamicObject llmTaskObj = BusinessDataServiceHelper.loadSingle((String)"cvp_ie_llm_history", (String)"id,extractstatus,llmresult_tag", (QFilter[])new QFilter[]{qFilter});
                        if (llmTaskObj == null || !"success".equals(llmTaskObj.getString("extractstatus"))) break;
                        String llmresultTag = llmTaskObj.getString("llmresult_tag");
                        return (IeLLMExtractResultVO)JSON.parseObject((String)llmresultTag, IeLLMExtractResultVO.class);
                    }
                    IeLLMExtractResultVO ieLLMExtractResultVO = new IeLLMExtractResultVO();
                    ieLLMExtractResultVO.setLlmTableInfo(new HashMap<String, List<Map<String, GeneralIEResult.Dict>>>());
                    ieLLMExtractResultVO.setLlmInfo(new HashMap<String, List<GeneralIEResult.Dict>>());
                    return ieLLMExtractResultVO;
                }
                default: {
                    logger.info("\u975e\u5927\u6a21\u578b\u4efb\u52a1\uff0c\u4e0d\u67e5\u8be2\u5927\u6a21\u578b\u7ed3\u679c\u3002");
                    return null;
                }
            }
        }
        return null;
    }

    private static void setExtractSequence(DynamicObject plan, TieExtractData extractData) {
        QFilter statusFilter;
        QFilter enableFilter;
        DynamicObject[] objCol;
        DynamicObject planObj = BusinessDataServiceHelper.loadSingle((Object)plan.getPkValue(), (String)"cvp_ie_mouldplan");
        boolean commonextract = planObj.getBoolean("commonextract");
        boolean usellmextract = planObj.getBoolean("usellmextract");
        if (commonextract && (objCol = BusinessDataServiceHelper.load((String)"cvp_ie_extract_common", (String)"id,extractfield,extractnum,fieldtype,tabnum,tabname,createtime", (QFilter[])new QFilter[]{enableFilter = new QFilter("enable", "=", (Object)"1"), statusFilter = new QFilter("status", "=", (Object)"C")}, (String)"createtime asc")) != null && objCol.length > 0) {
            List<ExtractSeq> extractSeqs = Arrays.stream(objCol).map(obj -> {
                String extractfield = obj.getString("extractfield");
                String extractnum = obj.getString("extractnum");
                DynamicObject ftypeObj = obj.getDynamicObject("fieldtype");
                String tabnum = obj.getString("tabnum");
                String tabname = obj.getString("tabname");
                ExtractSeq extractSeq = new ExtractSeq();
                extractSeq.setFieldType(ftypeObj.getString("types"));
                extractSeq.setTypeName(ftypeObj.getString("name"));
                extractSeq.setExtractNum(extractnum);
                boolean tableFlag = StringUtils.isNotEmpty((CharSequence)tabnum) && StringUtils.isNotEmpty((CharSequence)tabname);
                extractSeq.setTableFlag(tableFlag);
                if (tableFlag) {
                    extractSeq.setExtractFieldName(tabname.concat(".").concat(extractfield));
                    extractSeq.setTableName(tabname);
                    extractSeq.setTableNum(tabnum);
                } else {
                    extractSeq.setExtractFieldName(extractfield);
                    extractSeq.setTableName("");
                    extractSeq.setTableNum("");
                }
                return extractSeq;
            }).collect(Collectors.toList());
            extractData.setExtractSeq(extractSeqs);
        }
        if (usellmextract) {
            DynamicObjectCollection llmentryentity = planObj.getDynamicObjectCollection("llmentryentity");
            List<ExtractSeq> llmExtractSeq = llmentryentity.stream().map(entry -> {
                String llmtabnum = entry.getString("llmtabnum");
                String llmextractnum = entry.getString("llmextractnum");
                String llmtabname = entry.getString("llmtabname");
                String llmextractfield = entry.getString("llmextractfield");
                DynamicObject llmfieldtype = entry.getDynamicObject("llmfieldtype");
                ExtractSeq extractSeq = new ExtractSeq();
                extractSeq.setFieldType(llmfieldtype.getString("types"));
                extractSeq.setTypeName(llmfieldtype.getString("name"));
                extractSeq.setExtractNum(llmextractnum);
                boolean tableFlag = StringUtils.isNotEmpty((CharSequence)llmtabnum) && StringUtils.isNotEmpty((CharSequence)llmtabname);
                extractSeq.setTableFlag(tableFlag);
                if (tableFlag) {
                    extractSeq.setExtractFieldName(llmtabname.concat(".").concat(llmextractfield));
                    extractSeq.setTableName(llmtabname);
                    extractSeq.setTableNum(llmtabnum);
                } else {
                    extractSeq.setExtractFieldName(llmextractfield);
                    extractSeq.setTableName("");
                    extractSeq.setTableNum("");
                }
                return extractSeq;
            }).collect(Collectors.toList());
            extractData.setLlmSeq(llmExtractSeq);
        }
    }

    private static TieExtractData queryHistoryByLocalDb(DynamicObject historyObj) {
        String extractResult = CommonUtil.decodeString(historyObj.getString("billieresult"));
        String extractStatus = historyObj.getString("extractstatus");
        String taskId = historyObj.getString("taskid");
        Date endDate = historyObj.getDate("billenddate");
        String updateData = CommonUtil.decodeString(String.valueOf(historyObj.get("updatedata")));
        boolean isUpdate = historyObj.getBoolean("isupdate");
        String docName = historyObj.getString("billdoc");
        String docpath = CommonUtil.getAccountUrl(historyObj.getString("billdocpath"));
        boolean isTest = historyObj.getBoolean("istest");
        DynamicObject businessobj = historyObj.getDynamicObject("businessobj");
        DynamicObject mouldObj = historyObj.getDynamicObject("iemould");
        String progressInfo = historyObj.getString("progressinfo");
        String traceId = RequestContext.get().getTraceId();
        String llmTaskId = historyObj.getString("llmtaskid");
        TieExtractData tieExtractData = null;
        StartComparisonFile startComparisonFile = new StartComparisonFile(docpath, docName);
        if (!Arrays.asList("success", "cancel", "error").contains(extractStatus)) {
            extractStatus = "running";
            tieExtractData = new TieExtractData(traceId, taskId, extractStatus, startComparisonFile);
            tieExtractData.setProgress(progressInfo);
        } else if (Arrays.asList("error", "cancel").contains(extractStatus)) {
            tieExtractData = new TieExtractData(traceId, taskId, extractStatus, startComparisonFile);
            tieExtractData.setProgress(progressInfo);
        } else {
            tieExtractData = (TieExtractData)JSON.parseObject((String)extractResult, TieExtractData.class);
            tieExtractData.setTraceId(traceId);
            tieExtractData.setEndDate(endDate);
            tieExtractData.setIsUpdate(isUpdate);
            tieExtractData.setFileData(startComparisonFile);
            tieExtractData.setProgress(progressInfo);
            IeLLMExtractResultVO llmResult = IeUtils.getLLMCieTaskInfoByFilters(historyObj);
            if (llmResult != null) {
                tieExtractData.setLlmInfo(llmResult.getLlmInfo());
                tieExtractData.setLlmTableInfo(llmResult.getLlmTableInfo());
            }
            if (isUpdate && !Objects.isNull(updateData)) {
                tieExtractData.setUpdateData(updateData);
            }
            if (StringUtils.isNotEmpty((CharSequence)llmTaskId)) {
                tieExtractData.setIsNew(true);
            } else if (tieExtractData.getTieInfo() != null) {
                boolean newFlag;
                JSONObject tieJSONObject = JSON.parseObject((String)JSON.toJSONString((Object)tieExtractData.getTieInfo()));
                boolean bl = newFlag = tieExtractData.getTieTableInfo() != null || IeUtils.isNewData(tieJSONObject);
                if (newFlag) {
                    tieExtractData.getTieDocContents().clear();
                }
                tieExtractData.setIsNew(newFlag);
            }
            if ("success".equals(extractStatus)) {
                IeUtils.setFullUrlToDBData(tieExtractData, taskId, isTest);
                IeUtils.setExtractSequenceInBillEx(tieExtractData, businessobj, mouldObj, isTest);
            }
        }
        return tieExtractData;
    }

    private static boolean isNewData(JSONObject tieJSONObject) {
        if (tieJSONObject == null) {
            throw new KDBizException("\u4fe1\u606f\u63d0\u53d6\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002");
        }
        Set entries = tieJSONObject.entrySet();
        if (!entries.isEmpty()) {
            for (Map.Entry entry : entries) {
                if (((JSONArray)entry.getValue()).isEmpty() || ((JSONObject)((JSONArray)entry.getValue()).get(0)).get((Object)"indexNew") == null) continue;
                return true;
            }
        }
        return false;
    }

    private static void setExtractSequenceInBillEx(TieExtractData tieExtractData, DynamicObject busObj, DynamicObject mouldObj, boolean isTest) {
        logger.info("busObj:{}", (Object)(busObj != null ? busObj.getString("number") : ""));
        if (isTest || busObj == null || busObj.getString("number").equalsIgnoreCase("cvp_template")) {
            IeUtils.setExtractSequence(mouldObj, tieExtractData);
        } else {
            IeUtils.setBizExtractSequence(mouldObj, busObj, tieExtractData);
        }
    }

    private static void setBizExtractSequence(DynamicObject mouldObj, DynamicObject busObj, TieExtractData tieExtractData) {
        QFilter qFilter;
        DynamicObject relateObj;
        if (busObj != null && mouldObj != null && (relateObj = BusinessDataServiceHelper.loadSingle((String)"cvp_ie_relateconfig", (String)"id,relateconfig,number", (QFilter[])new QFilter[]{qFilter = new QFilter("businessobj.id", "=", busObj.getPkValue())})) != null) {
            DynamicObject planObj;
            String relateconfigStr = relateObj.getString("relateconfig");
            JSONObject jsonObject = JSON.parseObject((String)relateconfigStr);
            Object o = jsonObject.get((Object)mouldObj.getPkValue().toString());
            TieRelateConfigField tieRelateConfigField = (TieRelateConfigField)JSON.parseObject((String)o.toString(), TieRelateConfigField.class);
            List<Map<String, String>> value = tieRelateConfigField.getValue();
            HashSet showSequenceList = new HashSet();
            if (!value.isEmpty()) {
                value.stream().filter(vMap -> vMap.entrySet().stream().anyMatch(entry -> !StringUtils.isEmpty((CharSequence)((CharSequence)entry.getValue())))).forEach(vMap -> showSequenceList.addAll(vMap.keySet()));
            }
            if (!showSequenceList.isEmpty() && (planObj = BusinessDataServiceHelper.loadSingle((Object)mouldObj.getPkValue(), (String)"cvp_ie_mouldplan")) != null) {
                boolean commonextract = planObj.getBoolean("commonextract");
                boolean usellmextract = planObj.getBoolean("usellmextract");
                logger.info("\u5386\u53f2\u8bb0\u5f55\u6807\u8bb0\uff1a\u901a\u7528\u63d0\u53d6\u6807\u8bb0\uff1a{}\uff0c\u5927\u6a21\u578b\u63d0\u53d6\u6807\u8bb0\uff1a{}", (Object)commonextract, (Object)usellmextract);
                ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
                if (commonextract) {
                    QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
                    QFilter statusFilter = new QFilter("status", "=", (Object)"C");
                    DynamicObject[] objCol = BusinessDataServiceHelper.load((String)"cvp_ie_extract_common", (String)"id,extractfield,extractnum,fieldtype,tabnum,tabname,createtime", (QFilter[])new QFilter[]{enableFilter, statusFilter}, (String)"createtime asc");
                    List objList = Arrays.stream(objCol).collect(Collectors.toList());
                    list.addAll(objList);
                }
                if (usellmextract) {
                    list.addAll((Collection<DynamicObject>)planObj.getDynamicObjectCollection("llmentryentity"));
                }
                ArrayList<ExtractSeq> extractSeqs = new ArrayList<ExtractSeq>();
                ArrayList<ExtractSeq> llmSeqs = new ArrayList<ExtractSeq>();
                JSONObject dbObj = new JSONObject();
                IeUtils.mapKeyAndDynamicObj(dbObj, list);
                showSequenceList.forEach(showSeq -> {
                    DynamicObject dObj = (DynamicObject)dbObj.get(showSeq);
                    String extractFieldName = "";
                    String extractnum = "";
                    DynamicObject ftypeObj = null;
                    String tableNum = "";
                    String tabName = "";
                    IDataEntityType dataEntityType = dObj.getDataEntityType();
                    if (dataEntityType instanceof EntryType) {
                        extractFieldName = dObj.getString("llmextractfield");
                        extractnum = dObj.getString("llmextractnum");
                        ftypeObj = dObj.getDynamicObject("llmfieldtype");
                        tableNum = dObj.getString("llmtabnum");
                        tabName = dObj.getString("llmtabname");
                    } else if (dataEntityType instanceof BasedataEntityType) {
                        extractFieldName = dObj.getString("extractfield");
                        extractnum = dObj.getString("extractnum");
                        ftypeObj = dObj.getDynamicObject("fieldtype");
                        tableNum = dObj.getString("tabnum");
                        tabName = dObj.getString("tabname");
                    } else {
                        throw new KDBizException(new ErrorCode("40000", ResManager.loadKDString((String)"\u5b57\u6bb5\u5e8f\u5217\u8bbe\u7f6e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"IeUtils_300", (String)"ai-cvp-common", (Object[])new Object[0])), new Object[0]);
                    }
                    ExtractSeq extractSeq = new ExtractSeq();
                    extractSeq.setExtractNum(extractnum);
                    extractSeq.setFieldType(ftypeObj.getString("types"));
                    extractSeq.setTypeName(ftypeObj.getString("name"));
                    boolean tableFlag = StringUtils.isNotEmpty((CharSequence)tableNum) && StringUtils.isNotEmpty((CharSequence)tabName);
                    extractSeq.setTableFlag(tableFlag);
                    if (tableFlag) {
                        extractSeq.setExtractFieldName(tabName.concat(".").concat(extractFieldName));
                        extractSeq.setTableNum(tableNum);
                        extractSeq.setTableName(tabName);
                    } else {
                        extractSeq.setExtractFieldName(extractFieldName);
                        extractSeq.setTableNum("");
                        extractSeq.setTableName("");
                    }
                    if (StringUtils.isNotEmpty((CharSequence)extractnum)) {
                        if (extractnum.startsWith("cf") || extractnum.startsWith("tf")) {
                            llmSeqs.add(extractSeq);
                        } else {
                            extractSeqs.add(extractSeq);
                        }
                    }
                });
                if (!extractSeqs.isEmpty()) {
                    tieExtractData.setExtractSeq(extractSeqs);
                }
                if (!llmSeqs.isEmpty()) {
                    tieExtractData.setLlmSeq(llmSeqs);
                }
            }
        }
    }

    private static JSONObject mapKeyAndDynamicObj(JSONObject jsonObject, List<DynamicObject> entryentity) {
        if (entryentity == null || entryentity.isEmpty()) {
            return null;
        }
        entryentity.forEach(entry -> {
            IDataEntityType dataEntityType = entry.getDataEntityType();
            String tableNum = "";
            String extractnum = "";
            if (dataEntityType instanceof EntryType) {
                extractnum = entry.getString("llmextractnum");
                tableNum = entry.getString("llmtabnum");
            } else if (dataEntityType instanceof BasedataEntityType) {
                extractnum = entry.getString("extractnum");
                tableNum = entry.getString("tabnum");
            }
            boolean tableFlag = StringUtils.isNotEmpty((CharSequence)tableNum);
            if (tableFlag) {
                jsonObject.put(tableNum.concat(".").concat(extractnum), entry);
            } else {
                jsonObject.put(extractnum, entry);
            }
        });
        return jsonObject;
    }

    private static void setFullUrlToDBData(TieExtractData dbExtractData, String taskId, boolean isTest) {
        String selectFile = "imageid,imagepath,imagewidth,imageheight,pagenum";
        String oderBys = "pagenum asc";
        QFilter filter = new QFilter("taskid", "=", (Object)taskId);
        DynamicObjectCollection imagesObjCol = QueryServiceHelper.query((String)"cvp_tda_task_image", (String)selectFile, (QFilter[])new QFilter[]{filter}, (String)oderBys);
        List<ConversionAlgoInfo> images = imagesObjCol.stream().map(o -> new ConversionAlgoInfo(o.getLong("imageid"), CommonUtil.getAccountUrl(UrlService.getImageFullUrl((String)o.getString("imagepath"))), o.getInt("imagewidth"), o.getInt("imageheight"), o.getInt("pagenum"))).collect(Collectors.toList());
        dbExtractData.setTieImages(images);
    }

    private static DynamicObject getTaskInfoByFilters(QFilter[] historyFilters) {
        String selectFiled = String.format("%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s", "billieresult", "billdoc", "billdocpath", "extractstatus", "taskid", "billenddate", "updatedata", "isupdate", "businessobj", "iemould", "progressinfo", "tietype", "llmtaskid", "istest");
        return BusinessDataServiceHelper.loadSingle((String)"cvp_ie_history", (String)selectFiled, (QFilter[])historyFilters);
    }

    private static void startExtract(IFormView view, String args) throws Exception {
        FormShowParameter showParameter = view.getFormShowParameter();
        String btnType = (String)showParameter.getCustomParam("ie_operate_type");
        if ("ie_test_task".equals(btnType)) {
            IeUtils.ieStartTask(view, args, true);
        } else {
            String billKey = (String)showParameter.getCustomParam("businessobject");
            QFilter filter = new QFilter("businessobj", "=", (Object)billKey);
            DynamicObject relateConfigObj = BusinessDataServiceHelper.loadSingleFromCache((String)"cvp_ie_relateconfig", (QFilter[])new QFilter[]{filter});
            if (relateConfigObj == null) {
                view.showTipNotification("\u8be5\u4e1a\u52a1\u5bf9\u8c61\u672a\u505a\u63d0\u53d6\u5173\u8054\u8bbe\u7f6e\uff0c\u8bf7\u5148\u8bbe\u7f6e\u3002");
                OcrControlUtils.setTdaOrTieCustomcontrolData(view, "customtda", "ieBreakOff", Boolean.TRUE);
                return;
            }
            IeUtils.ieStartTask(view, args, false);
        }
    }

    public static String ieStartTaskForMservice(String url, String pageListStr, String planNumber, String businessObj, String billId, String invokeType) {
        String traceId = RequestContext.get().getTraceId();
        AlgoResultData algoResultData = new AlgoResultData();
        StartExtract startExtract = null;
        Map<String, Object> planInfoMap = null;
        try {
            startExtract = IeUtils.getStartExtract(url, pageListStr);
            planInfoMap = IeUtils.getPlanInfo(planNumber);
        }
        catch (KDBizException kde) {
            String message = kde.getErrorCode().getMessage();
            String code = kde.getErrorCode().getCode();
            algoResultData.setErrorCode(Integer.parseInt(code));
            algoResultData.setDescription(message);
            algoResultData.setRequestId(traceId);
            return SerializationUtils.toJsonString((Object)algoResultData);
        }
        TreeSet<Integer> pagesSet = new TreeSet<Integer>();
        try {
            IeUtils.fileValid(startExtract, pagesSet);
        }
        catch (KDBizException kde) {
            logger.error("\u6587\u4ef6\u6821\u9a8c\u5931\u8d25\uff0c\u8fd4\u56de\u9519\u8bef\u63d0\u793a\u4e3a\uff1a{}", (Object)kde.getMessage(), (Object)kde);
            algoResultData.setErrorCode(40002);
            algoResultData.setDescription(kde.getMessage());
            algoResultData.setRequestId(traceId);
            return SerializationUtils.toJsonString((Object)algoResultData);
        }
        catch (Throwable th) {
            logger.error("\u6587\u4ef6\u6821\u9a8c\u5931\u8d25\uff0c\u672a\u77e5\u7684\u7cfb\u7edf\u5f02\u5e38\uff0c\u8fd4\u56de\u9519\u8bef\u63d0\u793a\u4e3a\uff1a{}", (Object)th.getMessage(), (Object)th);
            algoResultData.setErrorCode(40000);
            algoResultData.setDescription(StringUtils.isEmpty((CharSequence)th.getMessage()) ? ResManager.loadKDString((String)"\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"IeUtils_003", (String)"ai-cvp-common", (Object[])new Object[0]) : th.getMessage());
            algoResultData.setRequestId(traceId);
            return SerializationUtils.toJsonString((Object)algoResultData);
        }
        String countKey = UUID.randomUUID().toString();
        try {
            boolean status = LicenseUtils.checkLicense(pagesSet.size(), LicenseCountServiceNameEnum.TIE_SERVICE_FOR_PDF.getName(), countKey);
            logger.info("\u8bb8\u53ef\u6821\u9a8c\u7ed3\u679c\uff1a" + status + " \uff08\u6ce8\uff1atrue\u4e3a\u8bb8\u53ef\u6821\u9a8c\u901a\u8fc7\u4e14\u6d41\u91cf\u6821\u9a8c\u901a\u8fc7\uff0cfalse\u4e3a\u8bb8\u53ef\u6821\u9a8c\u5f02\u5e38\uff09\u3002");
            if (!status) {
                throw new KDBizException(new ErrorCode("401001", ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u4efb\u4f55\u89c6\u89c9\u8bc6\u522b\u8bb8\u53ef\uff0c\u65e0\u6cd5\u4f7f\u7528\u672c\u529f\u80fd\uff0c\u8bf7\u7acb\u5373\u8d2d\u4e70\uff0c\u8c22\u8c22\u3002", (String)"IeUtils_004", (String)"ai-cvp-common", (Object[])new Object[0])), new Object[0]);
            }
        }
        catch (KDBizException e) {
            logger.error("\u8bb8\u53ef\u6821\u9a8c\u5f02\u5e38", (Throwable)e);
            algoResultData.setErrorCode(401001);
            algoResultData.setDescription(e.getMessage());
            algoResultData.setRequestId(traceId);
            return SerializationUtils.toJsonString((Object)algoResultData);
        }
        try {
            StartComparisonFile file = startExtract.getFile();
            Map<String, Object> resultMap = IeUtils.getAlgoResult(file, null, pagesSet, (String)planInfoMap.get("businessConfig"), (Integer)planInfoMap.get("ieExtractType"));
            String algoResultStr = String.valueOf(resultMap.get("result"));
            long costTime = Long.parseLong(String.valueOf(resultMap.get("costTime")));
            AlgoResultData resultData = (AlgoResultData)JSON.parseObject((String)algoResultStr, AlgoResultData.class);
            Object data = resultData.getData();
            Object taskId = null;
            if (data == null) {
                throw new KDBizException(new ErrorCode("40000", ResManager.loadKDString((String)"\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u6765\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"IeUtils_005", (String)"ai-cvp-common", (Object[])new Object[0])), new Object[0]);
            }
            JSONObject createTaskObj = JSON.parseObject((String)String.valueOf(data));
            taskId = createTaskObj.get((Object)"taskId");
            Map<String, String> billMap = IeUtils.getBillInfo(businessObj, billId);
            IeUtils.saveDataByParam(resultData, file, costTime, startExtract.getPageSelection(), businessObj, billMap, planInfoMap, invokeType, pagesSet.size());
            CommonUtil.setTaskIdAndTraceIdRelation(String.valueOf(taskId), countKey);
            TiePullResultService.syncPullTieResult(RequestContext.get());
            HashMap<String, Object> resMap = new HashMap<String, Object>();
            resMap.put("taskId", taskId);
            algoResultData.setData(resMap);
            algoResultData.setRequestId(traceId);
            algoResultData.setDescription(ResManager.loadKDString((String)"\u8bf7\u6c42\u6210\u529f\u3002", (String)"IeUtils_005", (String)"ai-cvp-common", (Object[])new Object[0]));
            algoResultData.setErrorCode(0);
            return SerializationUtils.toJsonString((Object)algoResultData);
        }
        catch (KDBizException kde) {
            logger.error("\u4fe1\u606f\u63d0\u53d6\u5fae\u670d\u52a1\u63a5\u53e3\u5f02\u5e38\uff1a{},traceId:{}", new Object[]{kde.getMessage(), traceId, kde});
            LicenseUtils.ensureCallNumToAlgo(false, countKey, SourceTypeEnum.INFOEXTRACT);
        }
        catch (Exception e) {
            logger.error("\u4fe1\u606f\u63d0\u53d6\u5fae\u670d\u52a1\u63a5\u53e3\u672a\u77e5\u5f02\u5e38:{},traceId:{}", new Object[]{e.getMessage(), traceId, e});
            LicenseUtils.ensureCallNumToAlgo(false, countKey, SourceTypeEnum.INFOEXTRACT);
        }
        algoResultData.setData(null);
        algoResultData.setRequestId(traceId);
        algoResultData.setDescription(ResManager.loadKDString((String)"\u8bf7\u6c42\u5931\u8d25\u3002", (String)"IeUtils_006", (String)"ai-cvp-common", (Object[])new Object[0]));
        algoResultData.setErrorCode(40000);
        return SerializationUtils.toJsonString((Object)algoResultData);
    }

    private static Map<String, Object> getPlanInfo(String planNumber) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        QFilter qFilter = new QFilter("number", "=", (Object)planNumber);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        DynamicObject planInfoObj = BusinessDataServiceHelper.loadSingle((String)"cvp_ie_mouldplan", (String)"id,name,commonextract,usellmextract,businessconfig", (QFilter[])new QFilter[]{qFilter, statusFilter});
        if (planInfoObj == null) {
            throw new KDBizException(new ErrorCode("40002", ResManager.loadKDString((String)"\u4fe1\u606f\u63d0\u53d6\u65b9\u6848\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u8bd5\u3002", (String)"IeUtils_103", (String)"ai-cvp-common", (Object[])new Object[0])), new Object[0]);
        }
        String name = planInfoObj.getString("name");
        Object pkValue = planInfoObj.getPkValue();
        boolean commonextract = planInfoObj.getBoolean("commonextract");
        boolean usellmextract = planInfoObj.getBoolean("usellmextract");
        String businessConfig = planInfoObj.getString("businessconfig");
        String bizType = IeExtractBizType.getBizType(businessConfig);
        if (StringUtils.isEmpty((CharSequence)businessConfig) || StringUtils.isEmpty((CharSequence)bizType)) {
            throw new KDBizException(new ErrorCode("40002", ResManager.loadKDString((String)"\u5fc5\u8981\u53c2\u6570[businessconfig]\u4e3a\u7a7a\u6216\u975e\u6cd5\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u8bd5", (String)"IeUtils_106", (String)"ai-cvp-common", (Object[])new Object[0])), new Object[0]);
        }
        map.put("businessConfig", bizType);
        map.put("planName", name);
        map.put("planId", pkValue);
        if (!commonextract && !usellmextract) {
            throw new KDBizException(new ErrorCode("40002", ResManager.loadKDString((String)"\u4fe1\u606f\u63d0\u53d6\u65b9\u6848\u914d\u7f6e\u9519\u8bef,\u672a\u627e\u5230\u63d0\u53d6\u914d\u7f6e\u4fe1\u606f\u3002", (String)"IeUtils_104", (String)"ai-cvp-common", (Object[])new Object[0])), new Object[0]);
        }
        int extractType = IeExtractTypeEnum.COMMON_EXTRACT.getExtractType();
        if (commonextract && usellmextract) {
            extractType = IeExtractTypeEnum.COMMON_AND_LLM_EXTRACT.getExtractType();
        } else if (usellmextract) {
            extractType = IeExtractTypeEnum.LLM_EXTRACT.getExtractType();
        }
        map.put("ieExtractType", extractType);
        return map;
    }

    private static Map<String, String> getBillInfo(String businessObj, String billId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("billId", billId);
        DynamicObject billObj = null;
        try {
            QFilter qFilter = new QFilter("id", "=", (Object)Long.parseLong(billId));
            billObj = BusinessDataServiceHelper.loadSingle((String)businessObj, (String)"id,number,billno,name", (QFilter[])new QFilter[]{qFilter});
            String billNumber = null;
            String billName = null;
            if (billObj != null) {
                billNumber = MetadataServiceHelper.getDataEntityType((String)businessObj) instanceof BasedataEntityType ? billObj.getString("number") : billObj.getString("billno");
                billName = billObj.getString("name");
                map.put("billNumber", billNumber);
                map.put("billName", billName);
            }
        }
        catch (Exception e) {
            logger.error("\u4e1a\u52a1\u5bf9\u8c61\uff1a{} \u4e2d\u5355\u636eid:{} \u4e0d\u5b58\u5728\u6216\u5355\u636e\u5b58\u5728\u5f02\u5e38\u3002", new Object[]{businessObj, billId, e});
        }
        return map;
    }

    private static StartExtract getStartExtract(String url, String pageListStr) {
        StartExtract startExtract = new StartExtract();
        StartComparisonFile f = new StartComparisonFile();
        f.setUrl(url);
        f.setTempFileId("");
        String fileName = "";
        FileService attachmentFileService = FileServiceFactory.getAttachmentFileService();
        if (StringUtils.isEmpty((CharSequence)url) || !attachmentFileService.exists(url)) {
            throw new KDBizException(new ErrorCode("40002", ResManager.loadKDString((String)"\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e\u540e\u91cd\u8bd5\u3002", (String)"IeUtils_004", (String)"ai-cvp-common", (Object[])new Object[0])), new Object[0]);
        }
        String realPath = attachmentFileService.getFileServiceExt().getRealPath(url);
        f.setUrl(realPath);
        if (realPath.contains("/")) {
            fileName = realPath.substring(realPath.lastIndexOf("/") + 1);
        } else {
            logger.info("\u6587\u4ef6\u540d\u79f0\u4e3a\u7a7a...");
        }
        f.setFileName(fileName);
        startExtract.setFile(f);
        PageSelection ps = new PageSelection();
        pageListStr = pageListStr == null ? "" : pageListStr.trim();
        if (pageListStr.contains("\uff0c")) {
            pageListStr = pageListStr.replace("\uff0c", ",");
        }
        if (StringUtils.isEmpty((CharSequence)pageListStr) || "all".equalsIgnoreCase(pageListStr)) {
            ps.setType(2);
        } else {
            ps.setType(3);
            ps.setFreeSelection(pageListStr);
        }
        startExtract.setPageSelection(ps);
        return startExtract;
    }

    private static void ieStartTask(IFormView view, String args, boolean isTest) throws Exception {
        AlgoPageNumAndFileIdVO algoFileVO;
        StartExtract startExtract = (StartExtract)JSON.parseObject((String)args, StartExtract.class);
        StartComparisonFile file = startExtract.getFile();
        String planId = startExtract.getPlanId();
        String tempFileId = file.getTempFileId();
        String url = file.getUrl();
        if (StringUtils.isEmpty((CharSequence)planId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u63d0\u53d6\u65b9\u6848\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"IeUtils_100", (String)"ai-cvp-common", (Object[])new Object[0]));
        }
        DynamicObject planObj = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(planId), (String)"cvp_ie_mouldplan", (String)"id,commonextract,usellmextract,businessconfig");
        if (planObj == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65b9\u6848\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u8bd5\u3002", (String)"IeUtils_105", (String)"ai-cvp-common", (Object[])new Object[0]));
        }
        String businessConfig = planObj.getString("businessconfig");
        TreeSet<Integer> pagesSet = new TreeSet<Integer>();
        try {
            FileService attachmentFileService = FileServiceFactory.getAttachmentFileService();
            boolean localTempExist = CvpFileServiceUtils.fileExist(StorageTypeEnum.TMP, tempFileId);
            if (!localTempExist) {
                boolean exists = attachmentFileService.exists(url);
                if (!exists) {
                    throw new KDBizException("\u63d0\u53d6\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u4e0a\u4f20\u540e\u91cd\u8bd5\uff01");
                }
                tempFileId = CvpFileServiceUtils.attFile2TempFile(url);
                file.setTempFileId(tempFileId);
            }
            algoFileVO = IeUtils.valid(startExtract, pagesSet);
        }
        catch (KDBizException kde) {
            logger.error("\u6587\u4ef6\u6821\u9a8c\u5931\u8d25\uff0c\u8fd4\u56de\u9519\u8bef\u63d0\u793a\u4e3a\uff1a{}", (Object)kde.getMessage(), (Object)kde);
            view.showTipNotification(StringUtils.isEmpty((CharSequence)kde.getMessage()) ? "\u6587\u4ef6\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002" : kde.getMessage());
            OcrControlUtils.setTdaOrTieCustomcontrolData(view, "customtda", "startExtract", VALID_FILE_ERROR);
            return;
        }
        catch (Exception th) {
            logger.error("\u6587\u4ef6\u6821\u9a8c\u5931\u8d25\uff0c\u672a\u77e5\u7684\u7cfb\u7edf\u5f02\u5e38\uff0c\u8fd4\u56de\u9519\u8bef\u63d0\u793a\u4e3a\uff1a{}", (Object)th.getMessage(), (Object)th);
            view.showTipNotification("\u6587\u4ef6\u6821\u9a8c\u5931\u8d25\uff0c\u672a\u77e5\u7684\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002");
            OcrControlUtils.setTdaOrTieCustomcontrolData(view, "customtda", "startExtract", VALID_FILE_ERROR);
            return;
        }
        String countKey = UUID.randomUUID().toString();
        if (!isTest) {
            try {
                boolean status = LicenseUtils.checkLicense(pagesSet.size(), LicenseCountServiceNameEnum.TIE_SERVICE_FOR_PDF.getName(), countKey);
                logger.info("\u8bb8\u53ef\u6821\u9a8c\u7ed3\u679c\uff1a" + status + " \uff08\u6ce8\uff1atrue\u4e3a\u8bb8\u53ef\u6821\u9a8c\u901a\u8fc7\u4e14\u6d41\u91cf\u6821\u9a8c\u901a\u8fc7\uff0cfalse\u4e3a\u8bb8\u53ef\u6821\u9a8c\u5f02\u5e38\uff09\u3002");
                if (!status) {
                    OcrControlUtils.setTdaOrTieCustomcontrolData(view, "customtda", "startExtract", VALID_LICENSE_ERROR);
                    return;
                }
            }
            catch (KDBizException e) {
                logger.error("\u8bb8\u53ef\u6821\u9a8c\u5f02\u5e38", (Throwable)e);
                view.showTipNotification(e.getMessage());
                OcrControlUtils.setTdaOrTieCustomcontrolData(view, "customtda", "startExtract", VALID_LICENSE_ERROR);
                return;
            }
        }
        IeExtractTypeEnum extractTypeEnum = IeUtils.getExtractType(planObj);
        CustomControl customcontrol = (CustomControl)view.getControl("customtda");
        HashMap<String, String> toWeb = new HashMap<String, String>(2);
        Map<String, Object> resultMap = IeUtils.getAlgoResult(file, algoFileVO, pagesSet, businessConfig, extractTypeEnum.getExtractType());
        if (resultMap.isEmpty()) {
            view.showTipNotification("\u6587\u6863\u4fe1\u606f\u63d0\u53d6\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002");
            OcrControlUtils.setTdaOrTieCustomcontrolData(view, "customtda", "startExtract", SYSTEM_ERROR);
            return;
        }
        long costTime = Long.parseLong(String.valueOf(resultMap.get("costTime")));
        String algoResultStr = String.valueOf(resultMap.get("result"));
        AlgoResultData resultData = (AlgoResultData)JSON.parseObject((String)algoResultStr, AlgoResultData.class);
        Object data = resultData.getData();
        Object taskId = null;
        if (data == null) {
            throw new KDBizException("\u6587\u6863\u4fe1\u606f\u63d0\u53d6\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002");
        }
        JSONObject createTaskObj = JSON.parseObject((String)String.valueOf(data));
        taskId = createTaskObj.get((Object)"taskId");
        toWeb.put("startExtract", String.valueOf(taskId));
        IeUtils.saveData(countKey, view, resultData, file, costTime, startExtract.getPageSelection(), pagesSet.size(), planId, extractTypeEnum, isTest);
        TiePullResultService.syncPullTieResult(RequestContext.get());
        if (isTest) {
            IPageCache pageCache = view.getPageCache();
            String pageId = pageCache.getPageId();
            pageCache.put("tieTestTaskId_".concat(pageId), taskId != null ? taskId.toString() : "");
        }
        customcontrol.setData(toWeb);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static IeExtractTypeEnum getExtractType(DynamicObject planObj) {
        if (planObj == null) throw new KDBizException(ResManager.loadKDString((String)"\u4fe1\u606f\u63d0\u53d6\u65b9\u6848\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u8bd5\u3002", (String)"IeUtils_102", (String)"ai-cvp-common", (Object[])new Object[0]));
        boolean commonextract = planObj.getBoolean("commonextract");
        boolean usellmextract = planObj.getBoolean("usellmextract");
        if (commonextract && usellmextract) {
            return IeExtractTypeEnum.COMMON_AND_LLM_EXTRACT;
        }
        if (usellmextract) {
            return IeExtractTypeEnum.LLM_EXTRACT;
        }
        if (!commonextract) throw new KDBizException(ResManager.loadKDString((String)"\u4fe1\u606f\u63d0\u53d6\u65b9\u6848\u672a\u52fe\u9009\u4efb\u4f55\u63d0\u53d6\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u4fe1\u606f\u63d0\u53d6\u65b9\u6848\u914d\u7f6e\u3002", (String)"IeUtils_101", (String)"ai-cvp-common", (Object[])new Object[0]));
        return IeExtractTypeEnum.COMMON_EXTRACT;
    }

    private static void fileValid(StartExtract startExtract, Set<Integer> pagesSet) throws Exception {
        StartComparisonFile file = startExtract.getFile();
        String tempFileId = file.getTempFileId();
        String url = file.getUrl();
        FileService attachmentFileService = FileServiceFactory.getAttachmentFileService();
        boolean localTempExist = CvpFileServiceUtils.fileExist(StorageTypeEnum.TMP, tempFileId);
        if (!localTempExist) {
            boolean exists = attachmentFileService.exists(url);
            if (!exists) {
                throw new KDBizException(new ErrorCode("31001", ResManager.loadKDString((String)"\u63d0\u53d6\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u4e0a\u4f20\u540e\u91cd\u8bd5\uff01", (String)"IeUtils_001", (String)"ai-cvp-common", (Object[])new Object[0])), new Object[0]);
            }
            tempFileId = CvpFileServiceUtils.attFile2TempFile(url);
            file.setTempFileId(tempFileId);
        }
        IeUtils.valid(startExtract, pagesSet);
    }

    private static AlgoPageNumAndFileIdVO valid(StartExtract startExtract, Set<Integer> pagesSet) throws Exception {
        String fileName;
        StartComparisonFile file = startExtract.getFile();
        String tempFileId = file.getTempFileId();
        AlgoPageNumAndFileIdVO algoPageNumAndFileIdVO = CommonUtil.fileValid(tempFileId, fileName = file.getFileName(), null, "jpg,jpeg,png,bmp,pdf,doc,docx,wps,ofd", 0x3200000L, 500);
        if (algoPageNumAndFileIdVO == null) {
            throw new KDBizException(new ErrorCode("40002", ResManager.loadKDString((String)"\u9875\u7801\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"IeUtils_010", (String)"ai-cvp-common", (Object[])new Object[0])), new Object[0]);
        }
        int pageNum = algoPageNumAndFileIdVO.getPageNum();
        logger.info("pagenum:{}", (Object)pageNum);
        IeUtils.paramValid(startExtract, pagesSet);
        IeUtils.getPageList(startExtract, pagesSet, pageNum);
        if (pagesSet.isEmpty()) {
            logger.info("\u4f20\u5165\u7684\u9875\u7801\u9519\u8bef\u3002\u3002\u3002");
            throw new KDBizException("\u81ea\u5b9a\u4e49\u63d0\u53d6\u8303\u56f4\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u540e\u518d\u8bd5\u3002");
        }
        return algoPageNumAndFileIdVO;
    }

    private static void getPageList(StartExtract startExtract, Set<Integer> pagesSet, int filePages) throws Exception {
        int type = startExtract.getPageSelection().getType();
        int beginAndEndNum = 5;
        IeSelectRangeEnum anEnumBySelectType = IeSelectRangeEnum.getAnEnumBySelectType(type);
        if (anEnumBySelectType == null) {
            throw new KDBizException("\u63d0\u53d6\u8303\u56f4\u65e0\u6548\uff0c\u8bf7\u6309\u7167\u8981\u6c42\u8f93\u5165\u63d0\u53d6\u8303\u56f4\u3002");
        }
        switch (anEnumBySelectType) {
            case CUSTOMIZE: {
                if (pagesSet.isEmpty()) {
                    throw new KDBizException("\u81ea\u5b9a\u4e49\u63d0\u53d6\u8303\u56f4\u65e0\u6548\uff0c\u8bf7\u6309\u8981\u6c42\u8f93\u5165\u63d0\u53d6\u8303\u56f4\u3002");
                }
                List minValue = pagesSet.stream().filter(result -> result < 1).collect(Collectors.toList());
                if (!minValue.isEmpty()) {
                    throw new KDBizException("\u81ea\u5b9a\u4e49\u63d0\u53d6\u8303\u56f4\u65e0\u6548\uff0c\u8bf7\u6309\u8981\u6c42\u8f93\u5165\u63d0\u53d6\u8303\u56f4\u3002");
                }
                List collect = pagesSet.stream().filter(result -> result > filePages).collect(Collectors.toList());
                if (collect.isEmpty()) break;
                throw new KDBizException("\u81ea\u5b9a\u4e49\u63d0\u53d6\u8303\u56f4\u5927\u4e8e\u6587\u4ef6\u9875\u6570\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u540e\u518d\u8bd5\u3002");
            }
            case ALL: {
                IeUtils.getPages(pagesSet, filePages, true, beginAndEndNum);
                break;
            }
            case FIVE_BEGIN_FIVE_END: {
                IeUtils.getPages(pagesSet, filePages, false, beginAndEndNum);
                break;
            }
            default: {
                throw new KDBizException("\u63d0\u53d6\u8303\u56f4\u65e0\u6548\uff0c\u8bf7\u6309\u7167\u8981\u6c42\u8f93\u5165\u63d0\u53d6\u8303\u56f4\u3002");
            }
        }
    }

    private static void getPages(Set<Integer> pagesSet, int filePages, boolean allFlag, int beginEndNum) {
        if (filePages < 1) {
            throw new KDBizException("\u6587\u6863\u9875\u7801\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002");
        }
        if (filePages <= 2 * beginEndNum || allFlag) {
            IeUtils.setAllPages(pagesSet, filePages);
        } else {
            IeUtils.setBeginAndEndPages(pagesSet, filePages, beginEndNum);
        }
    }

    private static void setBeginAndEndPages(Set<Integer> pagesSet, int filePages, int beginEndNum) {
        int i;
        int begin = filePages - beginEndNum;
        for (i = 0; i < beginEndNum; ++i) {
            pagesSet.add(i + 1);
        }
        for (i = begin; i < filePages; ++i) {
            pagesSet.add(i + 1);
        }
    }

    private static void setAllPages(Set<Integer> pagesSet, int filePages) {
        for (int i = 0; i < filePages; ++i) {
            pagesSet.add(i + 1);
        }
    }

    private static void saveDataByParam(AlgoResultData resultData, StartComparisonFile file, long costTime, PageSelection pageSelection, String busObj, Map<String, String> billInfoMap, Map<String, Object> planMap, String invokeType, int pageCount) {
        String billId = "";
        String billNumber = "";
        String billName = "";
        if (!billInfoMap.isEmpty()) {
            billId = billInfoMap.get("billId");
            billNumber = billInfoMap.get("billNumber");
            billName = billInfoMap.get("billName");
        }
        Object planId = "";
        String planName = "";
        int ieExtractType = IeExtractTypeEnum.COMMON_EXTRACT.getExtractType();
        if (!planMap.isEmpty()) {
            planId = planMap.get("planId");
            planName = planMap.get("name") + "";
            ieExtractType = (Integer)planMap.get("ieExtractType");
        }
        Object data = resultData.getData();
        Object taskId = null;
        Object createTime = null;
        if (data == null) {
            throw new KDBizException("\u4fe1\u606f\u63d0\u53d6\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002");
        }
        JSONObject jsonObject = JSON.parseObject((String)String.valueOf(data));
        taskId = jsonObject.get((Object)"taskId");
        createTime = jsonObject.get((Object)"createTime");
        OcrControlUtils.saveApiInfo(invokeType, resultData.getErrorCode(), planId, planName, costTime, RequestContext.get(), busObj, taskId);
        DynamicObject historyTask = BusinessDataServiceHelper.newDynamicObject((String)"cvp_ie_history");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"cvp_ie_history");
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        String number = codeRuleService.getNumber(entityType.getName(), historyTask, String.valueOf(RequestContext.get().getOrgId()));
        historyTask.set("billno", (Object)number);
        historyTask.set("billid", (Object)billId);
        historyTask.set("busbillno", (Object)billNumber);
        historyTask.set("busbillname", (Object)billName);
        historyTask.set("creator", (Object)RequestContext.get().getCurrUserId());
        historyTask.set("billvalid", (Object)"1");
        historyTask.set("billcreatedate", (Object)(createTime != null ? new Date((Long)createTime) : new Date()));
        historyTask.set("billdoc", (Object)file.getFileName());
        historyTask.set("billdocpath", (Object)file.getUrl());
        historyTask.set("extractstatus", (Object)"running");
        historyTask.set("taskid", taskId);
        historyTask.set("iemould", planId);
        historyTask.set("businessobj", (Object)busObj);
        historyTask.set("totalpage", (Object)pageCount);
        historyTask.set("istest", (Object)false);
        historyTask.set("tietype", (Object)ieExtractType);
        int type = pageSelection.getType();
        String freeSelection = pageSelection.getFreeSelection();
        String pageStr = "";
        if (type == IeSelectRangeEnum.CUSTOMIZE.getSelectType()) {
            pageStr = freeSelection;
        } else if (type == IeSelectRangeEnum.ALL.getSelectType()) {
            pageStr = IeSelectRangeEnum.ALL.getDescription();
        } else if (type == IeSelectRangeEnum.FIVE_BEGIN_FIVE_END.getSelectType()) {
            pageStr = IeSelectRangeEnum.FIVE_BEGIN_FIVE_END.getDescription();
        }
        historyTask.set("extractpages", (Object)pageStr);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{historyTask});
    }

    private static void saveData(String countKey, IFormView view, AlgoResultData resultData, StartComparisonFile file, long costTime, PageSelection pageSelection, int pageCount, String planId, IeExtractTypeEnum ieExtractTypeEnum, boolean isTest) {
        String billName = "";
        long billId = 0L;
        String billNumber = "";
        DynamicObject busObj = null;
        String billKey = "";
        if (!isTest) {
            FormShowParameter showParameter = view.getFormShowParameter();
            String parentPageId = (String)showParameter.getCustomParam("pageId");
            billId = (Long)showParameter.getCustomParam("billid");
            billKey = (String)showParameter.getCustomParam("businessobject");
            billNumber = (String)showParameter.getCustomParam("billNumber");
            billName = (String)showParameter.getCustomParam("billName");
            if (!StringUtils.isEmpty((CharSequence)parentPageId) && view.getViewNoPlugin(parentPageId) != null) {
                IDataModel parentModel = view.getViewNoPlugin(parentPageId).getModel();
                DynamicObject parentObj = BusinessDataServiceHelper.loadSingle((Object)parentModel.getDataEntity().getPkValue(), (DynamicObjectType)parentModel.getDataEntityType());
                billId = (Long)parentObj.getPkValue();
                billKey = parentObj.getDataEntityType().getName();
                billNumber = CommonUtil.getBillNumber(parentObj);
                billName = CommonUtil.getBillName(parentObj);
            }
            QFilter filter = new QFilter("businessobj", "=", (Object)billKey);
            DynamicObject relateConfigObj = BusinessDataServiceHelper.loadSingleFromCache((String)"cvp_ie_relateconfig", (QFilter[])new QFilter[]{filter});
            busObj = relateConfigObj.getDynamicObject("businessobj");
        }
        DynamicObject ieMouldPlan = BusinessDataServiceHelper.loadSingle((Object)planId, (String)"cvp_ie_mouldplan");
        Object data = resultData.getData();
        Object taskId = null;
        Object createTime = null;
        if (data == null) {
            throw new KDBizException("\u4fe1\u606f\u63d0\u53d6\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002");
        }
        JSONObject jsonObject = JSON.parseObject((String)String.valueOf(data));
        taskId = jsonObject.get((Object)"taskId");
        createTime = jsonObject.get((Object)"createTime");
        if (!isTest) {
            OcrControlUtils.saveApiInfo("G", resultData.getErrorCode(), ieMouldPlan.getPkValue(), ieMouldPlan.getString("name"), costTime, RequestContext.get(), billKey, taskId);
        }
        DynamicObject historyTask = BusinessDataServiceHelper.newDynamicObject((String)"cvp_ie_history");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"cvp_ie_history");
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        String number = codeRuleService.getNumber(entityType.getName(), historyTask, String.valueOf(RequestContext.get().getOrgId()));
        historyTask.set("billno", (Object)number);
        historyTask.set("creator", (Object)RequestContext.get().getCurrUserId());
        historyTask.set("billvalid", (Object)"1");
        historyTask.set("billcreatedate", (Object)(createTime != null ? new Date((Long)createTime) : new Date()));
        historyTask.set("billdoc", (Object)file.getFileName());
        historyTask.set("billdocpath", (Object)file.getUrl());
        historyTask.set("extractstatus", (Object)"running");
        historyTask.set("taskid", taskId);
        historyTask.set("iemould", ieMouldPlan.getPkValue());
        if (!isTest) {
            historyTask.set("billid", (Object)billId);
            historyTask.set("busbillno", (Object)billNumber);
            historyTask.set("busbillname", (Object)billName);
            historyTask.set("businessobj", (Object)busObj);
        }
        historyTask.set("totalpage", (Object)pageCount);
        historyTask.set("istest", (Object)isTest);
        historyTask.set("tietype", (Object)ieExtractTypeEnum.getExtractType());
        int type = pageSelection.getType();
        String freeSelection = pageSelection.getFreeSelection();
        String pageStr = "";
        if (type == IeSelectRangeEnum.CUSTOMIZE.getSelectType()) {
            pageStr = freeSelection;
        } else if (type == IeSelectRangeEnum.ALL.getSelectType()) {
            pageStr = IeSelectRangeEnum.ALL.getDescription();
        } else if (type == IeSelectRangeEnum.FIVE_BEGIN_FIVE_END.getSelectType()) {
            pageStr = IeSelectRangeEnum.FIVE_BEGIN_FIVE_END.getDescription();
        }
        historyTask.set("extractpages", (Object)pageStr);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{historyTask});
        if (!isTest) {
            CommonUtil.setTaskIdAndTraceIdRelation(String.valueOf(taskId), countKey);
        }
    }

    private static void paramValid(StartExtract startExtract, Set<Integer> resultSet) {
        PageSelection pageSelection = startExtract.getPageSelection();
        int type = pageSelection.getType();
        String freeSelection = pageSelection.getFreeSelection();
        if (!IeSelectRangeEnum.existSelectType(type)) {
            throw new KDBizException("\u63d0\u53d6\u8303\u56f4\u65e0\u6548\uff0c\u8bf7\u6309\u8981\u6c42\u8f93\u5165\u63d0\u53d6\u8303\u56f4\u3002");
        }
        if (IeSelectRangeEnum.CUSTOMIZE.getSelectType() == type) {
            if (StringUtils.isEmpty((CharSequence)freeSelection) || StringUtils.isEmpty((CharSequence)freeSelection.trim())) {
                throw new KDBizException("\u81ea\u5b9a\u4e49\u63d0\u53d6\u8303\u56f4\u65e0\u6548\uff0c\u8f93\u5165\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            if (freeSelection.length() > 50) {
                throw new KDBizException("\u81ea\u5b9a\u4e49\u63d0\u53d6\u8303\u56f4\u8f93\u5165\u5185\u5bb9\u4e0d\u80fd\u8d85\u8fc750\u4e2a\u5b57\u7b26,\u8bf7\u6309\u8981\u6c42\u91cd\u65b0\u5c1d\u8bd5\u3002");
            }
            boolean flag = CommonUtil.validStrByPattern(freeSelection = freeSelection.trim(), "^[,\uff0c \\-\\d]+$");
            if (!flag) {
                throw new KDBizException("\u81ea\u5b9a\u4e49\u63d0\u53d6\u8303\u56f4\u8f93\u5165\u9519\u8bef\uff0c\u8bf7\u6309\u8981\u6c42\u8f93\u5165\u63d0\u53d6\u8303\u56f4\u3002");
            }
            CommonUtil.validAndGetInputPages(resultSet, freeSelection);
            if (resultSet.isEmpty()) {
                throw new KDBizException("\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002");
            }
            pageSelection.setFreeSelection(IeUtils.formatCusomizeInput(freeSelection));
        }
    }

    private static String formatCusomizeInput(String freeSelection) {
        if (StringUtils.isEmpty((CharSequence)freeSelection)) {
            return freeSelection;
        }
        freeSelection = freeSelection.trim();
        if ((freeSelection = freeSelection.replace('\uff0c', ',')).contains(" ")) {
            freeSelection = freeSelection.replace(" ", "");
        }
        return freeSelection;
    }

    private static Map<String, Object> getAlgoResult(StartComparisonFile file, AlgoPageNumAndFileIdVO algoFileVO, Set<Integer> pagesSet, String businessConfig, int tieType) throws Exception {
        String fileName = file.getFileName();
        String tempFileId = file.getTempFileId();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        RequestContext requestContext = RequestContext.get();
        String tenantCode = requestContext.getTenantCode();
        String tenantName = requestContext.getTenantInfo().getName();
        try (InputStream inputStream = CvpFileServiceUtils.getFileIn(StorageTypeEnum.TMP, tempFileId);){
            if (inputStream == null) {
                throw new KDBizException("\u7cfb\u7edf\u5f02\u5e38\uff0c\u83b7\u53d6\u6587\u4ef6\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002");
            }
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
            multipartEntityBuilder.setCharset(StandardCharsets.UTF_8);
            multipartEntityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            if (algoFileVO != null && algoFileVO.getFileId() != null) {
                multipartEntityBuilder.addTextBody("fileId", algoFileVO.getFileId() + "");
            } else {
                multipartEntityBuilder.addBinaryBody("tieFile", inputStream, ContentType.MULTIPART_FORM_DATA, fileName);
            }
            String pageStr = pagesSet.stream().map(String::valueOf).collect(Collectors.joining(","));
            multipartEntityBuilder.addTextBody("targetPageNums", pageStr);
            multipartEntityBuilder.addTextBody("businessConfig", businessConfig);
            multipartEntityBuilder.addTextBody("sourceType", "cvp");
            multipartEntityBuilder.addTextBody("tenantCode", tenantCode);
            multipartEntityBuilder.addTextBody("tenantName", tenantName);
            multipartEntityBuilder.addTextBody("tieType", tieType + "");
            HttpEntity httpEntity = multipartEntityBuilder.build();
            logger.info("IE \u521b\u5efa\u6587\u6863\u4fe1\u606f\u63d0\u53d6\u4efb\u52a1");
            long startTime = System.currentTimeMillis();
            String resultStr = OcrHttpClientUtils.kdCloudHttpClientPost("/vrsp/tie/createTask", httpEntity);
            long endTime = System.currentTimeMillis();
            logger.info(String.format("IE \u521b\u5efa\u4fe1\u606f\u63d0\u53d6\u4efb\u52a1\u5b8c\u6210,\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\uff1a%s", resultStr));
            resultMap.put("result", resultStr);
            resultMap.put("costTime", endTime - startTime);
            HashMap<String, Object> hashMap = resultMap;
            return hashMap;
        }
    }

    private static void initCustom(IFormView view) {
        IeInitCustomVO initDataVO;
        String domainContextUrl = UrlService.getDomainContextUrl();
        String attUrl = String.format("%s/attachment/upload.do", domainContextUrl);
        FormShowParameter showParameter = view.getFormShowParameter();
        String operate = (String)showParameter.getCustomParam("ie_operate_type");
        Object billId = showParameter.getCustomParam("billid");
        String businessObj = (String)showParameter.getCustomParam("businessobject");
        String pageId = view.getPageId();
        Object planIdObj = null;
        try {
            planIdObj = showParameter.getCustomParam("ie_plan_id");
            if (planIdObj != null) {
                view.getPageCache().put(pageId + "_planId", planIdObj.toString());
            }
        }
        catch (Exception e) {
            logger.error("\u672a\u83b7\u53d6\u5230\u89c6\u56fe\u4e2d\u7684\u65b9\u6848id");
        }
        if ("ie_test_task".equals(operate)) {
            initDataVO = new IeInitCustomVO(operate, attUrl, billId != null ? billId.toString() : "");
            List<IeExtractPlanVO> list = IeUtils.buildPlanList(planIdObj, businessObj);
            initDataVO.setPlanList(list);
        } else if ("ie_show_task".equals(operate)) {
            logger.info("\u8fdb\u5165\u64cd\u4f5c\uff1a{}", (Object)"ie_show_task");
            long fid = (Long)showParameter.getCustomParam("id");
            TieExtractData history = IeUtils.getHistory(fid);
            if (history == null) {
                String message = ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u53d6\u6d88\uff0c\u8bf7\u786e\u5b9a\u8be5\u63d0\u53d6\u4efb\u52a1\u72b6\u6001\u540e\u518d\u8bd5\u3002", (String)"IeMouldInfoPlugin_1", (String)APP_PLUGIN, (Object[])new Object[0]);
                logger.info(String.format("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u6587\u6863\u4fe1\u606f\u63d0\u53d6\uff0c%s", message));
                view.showTipNotification(message);
                OcrControlUtils.setTdaOrTieCustomcontrolData(view, "customtda", "ieBreakOff", Boolean.TRUE);
                return;
            }
            initDataVO = new IeInitCustomVO(operate, attUrl, billId != null ? billId.toString() : "", history.getFileData(), history);
        } else if ("ie_create_task".equals(operate)) {
            initDataVO = new IeInitCustomVO(operate, attUrl, billId != null ? billId.toString() : "");
            initDataVO.setPlanList(IeUtils.buildPlanList(planIdObj, businessObj));
            InitTdaTieAttData initAttData = IeUtils.getBizBillFileInfo(view);
            initDataVO.setInitAttData(initAttData);
        } else {
            initDataVO = new IeInitCustomVO(operate, attUrl, billId != null ? billId.toString() : "");
        }
        OcrControlUtils.setTdaOrTieCustomcontrolData(view, "customtda", "init", initDataVO);
    }

    private static List<IeExtractPlanVO> buildPlanList(Object planIdObj, String businessObj) {
        ArrayList<IeExtractPlanVO> planVOS = new ArrayList<IeExtractPlanVO>();
        if (planIdObj != null) {
            DynamicObject planObj = BusinessDataServiceHelper.loadSingle((Object)planIdObj, (String)"cvp_ie_mouldplan");
            if (planObj != null) {
                String planName = planObj.getString("name");
                long planPkValue = (Long)planObj.getPkValue();
                IeExtractPlanVO ieExtractPlanVO = new IeExtractPlanVO();
                ieExtractPlanVO.setPlanId(String.valueOf(planPkValue));
                ieExtractPlanVO.setPlanName(planName);
                planVOS.add(ieExtractPlanVO);
            }
        } else {
            QFilter businessFilter = new QFilter("businessobj", "=", (Object)businessObj);
            DynamicObject relateObj = BusinessDataServiceHelper.loadSingle((String)"cvp_ie_relateconfig", (String)"id,businessobj,mulieplan", (QFilter[])new QFilter[]{businessFilter});
            if (relateObj != null) {
                DynamicObjectCollection mulieplan = relateObj.getDynamicObjectCollection("mulieplan");
                planVOS.addAll(mulieplan.stream().map(p -> {
                    DynamicObject fbasedataid = p.getDynamicObject("fbasedataid");
                    IeExtractPlanVO ieExtractPlanVO = new IeExtractPlanVO();
                    ieExtractPlanVO.setPlanName(fbasedataid.getString("name"));
                    ieExtractPlanVO.setPlanId(String.valueOf(fbasedataid.getPkValue()));
                    return ieExtractPlanVO;
                }).collect(Collectors.toList()));
            }
        }
        return planVOS;
    }

    private static InitTdaTieAttData getBizBillFileInfo(IFormView view) {
        InitTdaTieAttData initAttData = new InitTdaTieAttData();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Object parentPageId = formShowParameter.getCustomParam("pageId");
        if (parentPageId == null) {
            logger.error("parent pageId is null,default with no file select.");
            return initAttData;
        }
        IFormView parentView = view.getViewNoPlugin(String.valueOf(parentPageId));
        if (parentView == null) {
            logger.info("parent view is null,default with no file select.");
            return initAttData;
        }
        IPageCache pageCache = parentView.getPageCache();
        String fileInfo = pageCache.get("tieFileInfo");
        if (StringUtils.isEmpty((CharSequence)fileInfo)) {
            logger.info("no preset file,return");
            return initAttData;
        }
        initAttData = (InitTdaTieAttData)JSON.parseObject((String)fileInfo, InitTdaTieAttData.class);
        if (initAttData == null) {
            logger.error("\u672a\u8f6c\u6362\u4e3a\u53ef\u8bc6\u522b\u7684\u5bf9\u8c61\uff0c\u7ed3\u675f\u3002");
            return new InitTdaTieAttData();
        }
        try {
            CommonUtil.validFileWhenInit(initAttData, "");
        }
        catch (Exception e) {
            logger.info("\u6821\u9a8c\u5f02\u5e38\uff0c\u8bb0\u5f55\u65e5\u5fd7,\u5e76\u6e05\u7a7a\u5bf9\u5e94\u7684\u6587\u4ef6\u4fe1\u606f", (Object)e);
        }
        return initAttData;
    }

    public static List<Map<String, String>> getBusinessFieldsList(MainEntityType businessObjType, String currentPlanFormId) {
        List<Map<String, String>> businessFields = null;
        if (businessObjType != null) {
            EntityTypeUtil helper = new EntityTypeUtil();
            List catalogs = helper.getFilterColumns((IDataEntityType)businessObjType, false);
            businessFields = catalogs == null || catalogs.isEmpty() ? IeUtils.buildDynamicFields(businessObjType) : IeUtils.createBusinessFields(currentPlanFormId, businessObjType.getName(), catalogs);
        }
        return businessFields;
    }

    private static List<Map<String, String>> buildDynamicFields(MainEntityType businessObjType) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        Map allFields = businessObjType.getAllFields();
        for (Map.Entry entry : allFields.entrySet()) {
            Map<String, String> props = IeUtils.getProps((IDataEntityProperty)entry.getValue(), businessObjType);
            if (props == null || props.isEmpty()) continue;
            list.add(props);
        }
        return list;
    }

    private static Map<String, String> getProps(IDataEntityProperty value, MainEntityType businessObjType) {
        Map<String, String> map = new HashMap<String, String>();
        if (value != null) {
            IDataEntityType parent = value.getParent();
            if (parent instanceof MainEntityType) {
                if (parent.equals(businessObjType)) {
                    map = IeUtils.getRefProp(value);
                }
            } else if (parent instanceof EntryType) {
                LocaleString parentLocal = parent.getDisplayName();
                String entryName = parentLocal.getLocaleValue();
                String entryCode = parent.getName();
                Map<String, String> refProp = IeUtils.getRefProp(value);
                if (refProp != null && !refProp.isEmpty()) {
                    for (Map.Entry<String, String> entry : refProp.entrySet()) {
                        String refKey = entry.getKey();
                        String refValue = entry.getValue();
                        map.put(entryCode.concat(".").concat(refKey), entryName.concat(".").concat(refValue));
                    }
                }
            }
        }
        return map;
    }

    private static Map<String, String> getRefProp(IDataEntityProperty value) {
        String fieldCode = value.getName();
        LocaleString fieldLocalName = value.getDisplayName();
        String fieldName = fieldLocalName.getLocaleValue();
        HashMap<String, String> map = new HashMap<String, String>();
        if (value instanceof BasedataProp) {
            RefEntityType refEnityType = (RefEntityType)((BasedataProp)value).getDynamicComplexPropertyType();
            Map fields = refEnityType.getFields();
            for (Map.Entry subEntry : fields.entrySet()) {
                IDataEntityProperty subValue = (IDataEntityProperty)subEntry.getValue();
                Map<String, String> refProp = IeUtils.getRefProp(subValue);
                for (Map.Entry<String, String> entry : refProp.entrySet()) {
                    String refKey = entry.getKey();
                    String refValue = entry.getValue();
                    map.put(fieldCode.concat(".").concat(refKey), fieldName.concat(".").concat(refValue));
                }
            }
        } else if (value instanceof MulBasedataProp) {
            logger.info("\u6682\u65f6\u5ffd\u7565\u591a\u9009\u57fa\u7840\u8d44\u6599..");
        } else {
            map.put(fieldCode, fieldName);
        }
        return map;
    }

    public static List<Map<String, String>> createBusinessFields(String entityNumber, String businessObjName, List<Map<String, Object>> listNodes) {
        if (listNodes == null) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(listNodes.size());
        for (Map<String, Object> map : listNodes) {
            int fieldType = (Integer)map.get("fieldType");
            if (fieldType != -9 && fieldType != 3 && fieldType != 4 && fieldType != 91 && fieldType != 93) continue;
            String entryEntity = (String)map.get("entryEntity");
            String fieldName = (String)map.get("fieldName");
            String fieldCaption = (String)map.get("fieldCaption");
            String key = fieldName;
            if (!(StringUtils.isEmpty((CharSequence)entryEntity) || entityNumber.equals(entryEntity) || businessObjName.equals(entryEntity))) {
                key = entryEntity + "." + fieldName;
            }
            LinkedHashMap<String, String> bussinesMap = new LinkedHashMap<String, String>(2);
            bussinesMap.put(key, fieldCaption);
            list.add(bussinesMap);
        }
        return list;
    }

    public static FormShowParameter getHistoryShowParameter(long id) {
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        DynamicObject historyObj = QueryServiceHelper.queryOne((String)"cvp_ie_history", (String)"id,busbillname,busbillno,billid", (QFilter[])new QFilter[]{qFilter});
        if (historyObj == null) {
            throw new KDBizException("\u67e5\u8be2\u4e0d\u5230\u8bb0\u5f55\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01");
        }
        FormShowParameter showParameter = IeUtils.getFormShowParameter();
        showParameter.setCustomParam("id", (Object)id);
        showParameter.setCustomParam("ie_operate_type", (Object)"ie_show_task");
        showParameter.setCustomParam("billid", (Object)String.valueOf(historyObj.getLong("billid")));
        showParameter.setCustomParam("ie_bill_number", (Object)historyObj.getString("busbillno"));
        showParameter.setCustomParam("ie_bill_name", (Object)historyObj.getString("busbillname"));
        return showParameter;
    }

    private static FormShowParameter getFormShowParameter() {
        FormShowParameter showParameter = new FormShowParameter();
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("90%");
        styleCss.setHeight("90%");
        showParameter.setFormId("cvp_ie_info");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        return showParameter;
    }
}

