/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import kd.ai.cvp.common.Enum.DistingushComFileTypeEnum;
import kd.ai.cvp.entity.OcrImage;
import kd.ai.cvp.entity.OcrTempReferenVO;
import kd.ai.cvp.utils.LocalTempFileCache;
import kd.ai.cvp.utils.StreamHandleUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.FileNameUtils;
import kd.bos.util.StringUtils;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;

public class OcrControlUtils {
    private static final Log log = LogFactory.getLog(OcrControlUtils.class);

    public static int getGuideSize(IFormView view) {
        Tab tab = (Tab)view.getControl("guidecontent");
        String currentTab = tab.getCurrentTab();
        List items = tab.getItems();
        return items.size();
    }

    public static String getGuideCurrenName(IFormView view) {
        Tab tab = (Tab)view.getControl("guidecontent");
        String currentTab = tab.getCurrentTab();
        return currentTab;
    }

    public static void setCustomcontrolData(IFormView view, String customDiy, String key, Object data) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(2);
        dataMap.put(key, data);
        dataMap.put("flush", UUID.randomUUID().toString().replace("-", ""));
        String userId = String.valueOf(RequestContext.get().getCurrUserId());
        DynamicObject config = OcrControlUtils.getStatusByTemplateConfig(userId);
        String renfenceStatus = "1";
        String distinguishStatus = "1";
        if (config != null) {
            renfenceStatus = config.getString("step2HelperStatus");
            distinguishStatus = config.getString("step3HelperStatus");
        }
        dataMap.put("step2HelperStatus", renfenceStatus);
        dataMap.put("step3HelperStatus", distinguishStatus);
        CustomControl customcontrol = (CustomControl)view.getControl(customDiy);
        customcontrol.setData(dataMap);
    }

    public static void setTdaOrTieCustomcontrolData(IFormView view, String customDiy, String key, Object data) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(2);
        dataMap.put(key, data);
        dataMap.put("flush", UUID.randomUUID().toString().replace("-", ""));
        CustomControl customcontrol = (CustomControl)view.getControl(customDiy);
        customcontrol.setData(dataMap);
    }

    public static DynamicObject getStatusByTemplateConfig(String userId) {
        QFilter filter = new QFilter("userid", "=", (Object)userId);
        QFilter[] filters = new QFilter[]{filter};
        String selectFields = String.join((CharSequence)",", Arrays.asList("id", "userid", "modifydate", "step2HelperStatus", "step3HelperStatus"));
        DynamicObject config = ORM.create().queryOne("cvp_template_config", selectFields, filters);
        return config;
    }

    public static String imageToBase64(String imageFullUrl) throws IOException {
        String url = UrlService.getImageFullUrl((String)imageFullUrl);
        log.info("OCR-\u6a21\u677f\u56fe\u7247\u5730\u5740: " + url);
        InputStream in = OcrControlUtils.imageFileUrl2Io(imageFullUrl);
        String encode = OcrControlUtils.getImageBase64ByIO(in);
        return encode;
    }

    public static String imageFileToBase64(String imageFullUrl) throws IOException {
        log.info(String.format("OCR-\u6a21\u677f\u56fe\u7247\u5730\u5740: %s,\u8f6cbase64\u65b9\u5f0f\uff1a\u9644\u4ef6", imageFullUrl));
        return OcrControlUtils.getImageBase64ByIO(FileServiceFactory.getAttachmentFileService().getInputStream(imageFullUrl));
    }

    public static String pdfToBase64(String pdfUrl) throws IOException {
        log.info(String.format("fileUrl:%s,\u8f6cbase64\u65b9\u5f0f\uff1a\u9644\u4ef6", !StringUtils.isBlank((String)pdfUrl) ? pdfUrl.substring(0, pdfUrl.lastIndexOf(46)) : "\u56fe\u7247\u5730\u5740\u4e3a\u7a7a"));
        return OcrControlUtils.getPdfBase64ByIO(FileServiceFactory.getAttachmentFileService().getInputStream(pdfUrl));
    }

    public static String fileToBase64(String fileUrl, String suffixStr) throws IOException {
        if (Arrays.asList(DistingushComFileTypeEnum.IMAGE.getVlaue().split(",")).contains(suffixStr.toLowerCase())) {
            return OcrControlUtils.imageFileToBase64(fileUrl);
        }
        if (DistingushComFileTypeEnum.PDF.getVlaue().equalsIgnoreCase(suffixStr)) {
            return OcrControlUtils.pdfToBase64(fileUrl);
        }
        return null;
    }

    public static String fileToBase64WithoutHead(String fileUrl, String suffixStr) throws IOException {
        String base64Str = OcrControlUtils.fileToBase64(fileUrl, suffixStr);
        if (base64Str == null || StringUtils.isEmpty((String)base64Str)) {
            return null;
        }
        if (Arrays.asList(DistingushComFileTypeEnum.IMAGE.getVlaue().split(",")).contains(suffixStr.toLowerCase())) {
            return base64Str.replaceAll("data:image/png;base64,", "");
        }
        if (DistingushComFileTypeEnum.PDF.getVlaue().equalsIgnoreCase(suffixStr)) {
            return base64Str.replaceAll("data:application/pdf;base64,", "");
        }
        return null;
    }

    /*
     * Loose catch block
     */
    private static String getPdfBase64ByIO(InputStream in) throws IOException {
        try {
            try (ByteArrayOutputStream ba = new ByteArrayOutputStream();){
                int len;
                byte[] bs = new byte[1024];
                while ((len = in.read(bs)) != -1) {
                    ba.write(bs, 0, len);
                }
                Base64.Encoder encoder = Base64.getEncoder();
                byte[] pdfByte = encoder.encode(ba.toByteArray());
                String string = "data:application/pdf;base64," + new String(pdfByte, "UTF-8");
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            StreamHandleUtils.closeResource(in);
        }
    }

    public static InputStream getPDFFirstInputStream(InputStream inputStream) throws IOException {
        return OcrControlUtils.getPDFInputStreamByIndex(inputStream, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> splitPdfNew(InputStream inputStream, String fileNamePrefix, Integer pageStep) throws IOException {
        ArrayList<String> localDirList = new ArrayList<String>();
        ByteArrayOutputStream byteArrayOutputStream = null;
        PDPage page = null;
        ByteArrayInputStream bInputStream = null;
        try (PDDocument document = PDDocument.load((InputStream)inputStream);){
            int pageSize = document.getNumberOfPages();
            int count = pageSize / pageStep + (pageSize % pageStep == 0 ? 0 : 1);
            log.info("pageSize : {}, pageStep : {}, count : {}", new Object[]{pageSize, pageStep, count});
            String splitName = null;
            PDDocument doc = null;
            for (int i = 0; i < count; ++i) {
                try {
                    doc = new PDDocument();
                    int startPage = i * pageStep;
                    int endPage = startPage + pageStep;
                    if (endPage > pageSize) {
                        endPage = pageSize;
                    }
                    splitName = fileNamePrefix + "-" + (startPage + 1) + "_" + endPage + "-" + (i + 1) + "_" + count + ".pdf";
                    for (int index = startPage; index < endPage; ++index) {
                        page = document.getPage(index);
                        doc.addPage(page);
                    }
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    doc.save((OutputStream)byteArrayOutputStream);
                    bInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                    localDirList.add(LocalTempFileCache.saveToLocalTempPath(bInputStream, splitName));
                }
                catch (Throwable throwable) {
                    StreamHandleUtils.closeResource((Closeable)doc);
                    StreamHandleUtils.closeResource(bInputStream);
                    StreamHandleUtils.closeResource(byteArrayOutputStream);
                    throw throwable;
                }
                StreamHandleUtils.closeResource((Closeable)doc);
                StreamHandleUtils.closeResource(bInputStream);
                StreamHandleUtils.closeResource(byteArrayOutputStream);
            }
            ArrayList<String> arrayList = localDirList;
            return arrayList;
        }
    }

    /*
     * Exception decompiling
     */
    public static InputStream getPDFInputStreamByIndex(InputStream inputStream, int pageNum) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<InputStream> getImageInputStreamsByPdfInputStream(InputStream inputStream) throws IOException {
        ArrayList<InputStream> inputStreams = new ArrayList<InputStream>();
        try (PDDocument load = PDDocument.load((InputStream)inputStream);){
            int numberOfPages = load.getNumberOfPages();
            float dpi = 200.0f;
            PDFRenderer pdfRenderer = new PDFRenderer(load);
            ByteArrayOutputStream byteArrayOutputStream = null;
            for (int i = 0; i < numberOfPages; ++i) {
                try {
                    BufferedImage bufferedImage = pdfRenderer.renderImageWithDPI(i, dpi, ImageType.RGB);
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
                    inputStreams.add(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
                }
                catch (Throwable throwable) {
                    StreamHandleUtils.closeResource(byteArrayOutputStream);
                    throw throwable;
                }
                StreamHandleUtils.closeResource(byteArrayOutputStream);
            }
        }
        return inputStreams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream getImageInputStreamByPDFInputStream(InputStream inputStream) throws IOException {
        PDDocument load = null;
        InputStream imageIn = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            load = PDDocument.load((InputStream)inputStream);
            int numberOfPages = load.getNumberOfPages();
            float dpi = 200.0f;
            PDFRenderer pdfRenderer = new PDFRenderer(load);
            byteArrayOutputStream = new ByteArrayOutputStream();
            for (int i = 0; i < numberOfPages; ++i) {
                BufferedImage bufferedImage = pdfRenderer.renderImageWithDPI(i, dpi, ImageType.RGB);
                ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
            }
            InputStream inputStream2 = imageIn = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            return inputStream2;
        }
        finally {
            if (load != null) {
                load.close();
            }
            if (imageIn != null) {
                imageIn.close();
            }
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static InputStream getZipImageInputStream(InputStream inputStream, boolean validExcept) throws IOException {
        block4: {
            byteArrayOutputStream = null;
            try {
                if (!validExcept) ** GOTO lbl22
                bytes = StreamHandleUtils.copyStream(inputStream);
                if (bytes == null || bytes.length < 1) {
                    throw new KDBizException("\u7cfb\u7edf\u5f02\u5e38,\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002");
                }
                inputStream = new ByteArrayInputStream(bytes);
                validFlag = OcrControlUtils.isExcept(inputStream);
                if (!validFlag) break block4;
                OcrControlUtils.log.info("\u4f8b\u5916\u7684\u56fe\u7247\u6d41\u7c7b\u578b,\u4e0d\u518d\u8fdb\u884c\u56fe\u7247\u538b\u7f29\u3002");
                var5_5 = new ByteArrayInputStream(bytes);
            }
            catch (Throwable var6_6) {
                StreamHandleUtils.closeResource(byteArrayOutputStream);
                StreamHandleUtils.closeResource(inputStream);
                throw var6_6;
            }
            StreamHandleUtils.closeResource(byteArrayOutputStream);
            StreamHandleUtils.closeResource(inputStream);
            return var5_5;
        }
        inputStream = new ByteArrayInputStream(bytes);
lbl22:
        // 2 sources

        byteArrayOutputStream = new ByteArrayOutputStream();
        Thumbnails.of((InputStream[])new InputStream[]{inputStream}).scale(1.0).outputQuality(0.75f).outputFormat("jpg").toOutputStream((OutputStream)byteArrayOutputStream);
        var3_3 = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        StreamHandleUtils.closeResource(byteArrayOutputStream);
        StreamHandleUtils.closeResource(inputStream);
        return var3_3;
    }

    private static boolean isExcept(InputStream inputStream) {
        try {
            String typeResult = StreamHandleUtils.getTypeResult(inputStream);
            log.info("current file hex type string:{}", (Object)typeResult);
            if (!StringUtils.isEmpty((String)typeResult) && "52494646".equals(typeResult)) {
                return true;
            }
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6\u6587\u4ef6\u7c7b\u578b\u5f02\u5e38", (Throwable)e);
            return true;
        }
        return false;
    }

    /*
     * Loose catch block
     */
    public static String getFileBase64ByIO(InputStream in) throws IOException {
        try {
            try (ByteArrayOutputStream ba = new ByteArrayOutputStream();){
                int len;
                byte[] bs = new byte[1024];
                while ((len = in.read(bs)) != -1) {
                    ba.write(bs, 0, len);
                }
                Base64.Encoder encoder = Base64.getEncoder();
                byte[] bytes = encoder.encode(ba.toByteArray());
                String string = new String(bytes, "UTF-8");
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            StreamHandleUtils.closeResource(in);
        }
    }

    /*
     * Loose catch block
     */
    public static String getImageBase64ByIO(InputStream in) throws IOException {
        try {
            try (ByteArrayOutputStream ba = new ByteArrayOutputStream();){
                int len;
                byte[] bs = new byte[1024];
                while ((len = in.read(bs)) != -1) {
                    ba.write(bs, 0, len);
                }
                Base64.Encoder encoder = Base64.getEncoder();
                byte[] imgByte = encoder.encode(ba.toByteArray());
                String string = "data:image/png;base64," + new String(imgByte, "UTF-8");
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            StreamHandleUtils.closeResource(in);
        }
    }

    public static boolean isGreatThenMax(InputStream in, long maxSize) throws IOException {
        int len;
        int perSize = 8192;
        long total = 0L;
        byte[] bs = new byte[perSize];
        while ((len = in.read(bs)) != -1) {
            if ((total += (long)len) <= maxSize) continue;
            log.info("\u8d85\u8fc7\u9650\u5236\uff0ctotal:{}", (Object)total);
            log.info("\u8f93\u5165\u6d41\u5927\u4e8e" + maxSize / 0x100000L + "mb\u5b57\u8282\u957f\u5ea6");
            return true;
        }
        log.info("\u6b63\u5e38\u5927\u5c0f\uff0ctotal:{}", (Object)total);
        return false;
    }

    public static InputStream imageFileUrl2Io(String imageFullUrl) {
        log.info(String.format("OCR-\u6a21\u677f\u56fe\u7247\u5730\u5740: %s,\u8f6cbase64\u65b9\u5f0f\uff1a\u56fe\u7247\u670d\u52a1\u5668", imageFullUrl));
        FileService imageFileService = FileServiceFactory.getImageFileService();
        return imageFileService.getInputStream(imageFullUrl);
    }

    public static InputStream fileUrl2Io(String fileUrl) {
        log.info("\u9644\u4ef6\u670d\u52a1\u5668\u83b7\u53d6\u6d41\uff1aurl:" + fileUrl);
        FileService attachmentFileService = FileServiceFactory.getAttachmentFileService();
        return attachmentFileService.getInputStream(fileUrl);
    }

    public static String imageIoToBase64(InputStream in) throws IOException {
        int len;
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        byte[] bs = new byte[1024];
        while ((len = in.read(bs)) != -1) {
            ba.write(bs, 0, len);
        }
        Base64.Encoder encoder = Base64.getEncoder();
        byte[] imgByte = encoder.encode(ba.toByteArray());
        String encode = "data:image/png;base64," + new String(imgByte, "UTF-8");
        in.close();
        return encode;
    }

    public static String base64ToImage(IFormView view, String imageBase64) throws IOException {
        String entityId = view.getEntityId();
        imageBase64 = imageBase64.replaceAll("data:image/png;base64,", "");
        ByteArrayInputStream in = OcrControlUtils.getByteArrayInputStreamByBase64(imageBase64);
        return OcrControlUtils.setUploadFile(entityId, in);
    }

    public static ByteArrayInputStream getByteArrayInputStreamByBase64(String imageBase64) {
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] b = decoder.decode(imageBase64.getBytes(StandardCharsets.UTF_8));
        for (int i = 0; i < b.length; ++i) {
            if (b[i] >= 0) continue;
            int n = i;
            b[n] = (byte)(b[n] + 256);
        }
        return new ByteArrayInputStream(b);
    }

    public static String setUploadFile(String entityId, InputStream in) {
        RequestContext rc = RequestContext.get();
        String tenantId = rc.getTenantId();
        String accountId = rc.getAccountId();
        String fileName = UUID.randomUUID().toString().replace("-", "") + ".jpg";
        String path = FileNameUtils.getBillImageFileName((String)tenantId, (String)accountId, (String)entityId, (String)fileName);
        FileService imageFileService = FileServiceFactory.getImageFileService();
        FileItem item = new FileItem(fileName, path, in);
        return imageFileService.upload(item);
    }

    public static String getFileName(String url) {
        String suffixes = "jpeg|jpg|png";
        String fileName = "";
        Pattern pat = Pattern.compile("[\\w]+[\\.](" + suffixes + ")");
        Matcher mc = pat.matcher(url);
        while (mc.find()) {
            fileName = mc.group();
        }
        return fileName;
    }

    public static void setCustDistData(IFormView view, IDataModel model) throws IOException {
        DynamicObject currenObjTemp = OcrControlUtils.getCurrenObjTemplate(model);
        String imgeReferenceUrl = (String)currenObjTemp.get("referenceimg");
        if (StringUtils.isNotEmpty((String)imgeReferenceUrl)) {
            String disStr = (String)currenObjTemp.get("temptageinfo");
            JSONObject saveMap = new HashMap(3);
            String fileName = OcrControlUtils.getFileName(imgeReferenceUrl);
            String imgBase64 = OcrControlUtils.imageToBase64(imgeReferenceUrl);
            if (StringUtils.isNotEmpty((String)disStr)) {
                saveMap = JSON.parseObject((String)disStr);
                saveMap.remove("distinguishPos");
            }
            saveMap.put("image", new OcrImage(imgBase64, fileName));
            OcrControlUtils.setCustomcontrolData(view, "customdistinguish", "dataFromSql", saveMap);
        } else {
            OcrControlUtils.setCustomInitReferenData("customdistinguish", "init", view, model);
        }
    }

    public static void setCustRenfData(IFormView view, IDataModel model) throws IOException {
        String imgeReferenceUrl = (String)model.getValue("referenceimg");
        if (StringUtils.isNotEmpty((String)imgeReferenceUrl)) {
            String fileName = OcrControlUtils.getFileName(imgeReferenceUrl);
            String imgBase64 = OcrControlUtils.imageToBase64(imgeReferenceUrl);
            String temprenfenceinfo = (String)model.getValue("temprenfenceinfo");
            JSONObject saveMap = new HashMap(3);
            if (StringUtils.isNotEmpty((String)temprenfenceinfo)) {
                saveMap = JSON.parseObject((String)temprenfenceinfo);
                saveMap.remove("anchor");
            } else {
                saveMap.put("referenceData", "");
            }
            saveMap.put("image", new OcrImage(imgBase64, fileName));
            OcrControlUtils.setCustomcontrolData(view, "customrenfence", "dataFromSql", saveMap);
        } else {
            OcrControlUtils.setCustomInitReferenData("customrenfence", "init", view, model);
        }
    }

    public static void setRenfDistData(IFormView view, IDataModel model) throws IOException {
        DynamicObject currenObjTemp = OcrControlUtils.getCurrenObjTemplate(model);
        String imgeReferenceUrl = (String)currenObjTemp.get("referenceimg");
        if (StringUtils.isNotEmpty((String)imgeReferenceUrl)) {
            String disStr = (String)currenObjTemp.get("temptageinfo");
            String temprenfenceinfo = (String)currenObjTemp.get("temprenfenceinfo");
            JSONObject saveMap = new HashMap(10);
            String fileName = OcrControlUtils.getFileName(imgeReferenceUrl);
            String imgBase64 = OcrControlUtils.imageToBase64(imgeReferenceUrl);
            if (!"".equals(disStr.trim())) {
                saveMap = JSON.parseObject((String)disStr);
                saveMap.remove("distinguishPos");
            }
            saveMap.put("referenceData", new Object());
            if (StringUtils.isNotEmpty((String)temprenfenceinfo)) {
                JSONObject renMap = JSON.parseObject((String)temprenfenceinfo);
                saveMap.put("referenceData", renMap.get("referenceData"));
            }
            saveMap.put("image", new OcrImage(imgBase64, fileName));
            saveMap.put("tempName", model.getValue("name"));
            saveMap.put("tempCode", model.getValue("number"));
            saveMap.put("tempReason", model.getValue("description"));
            saveMap.put("createName", RequestContext.get().getUserName());
            OcrControlUtils.setCustomcontrolData(view, "customcomlete", "dataFromSql", saveMap);
        } else {
            OcrControlUtils.setCustomcontrolData(view, "customcomlete", "dataFromSql", null);
        }
    }

    public static void setCustomInitReferenData(String comsumer, String key, IFormView view, IDataModel model) throws IOException {
        String url = (String)model.getValue("templateimg");
        String imgeReferenceUrl = String.valueOf(model.getValue("referenceimg"));
        if (StringUtils.isNotEmpty((String)imgeReferenceUrl)) {
            url = imgeReferenceUrl;
        }
        String fileName = OcrControlUtils.getFileName(url);
        String imgBase64 = OcrControlUtils.imageToBase64(url);
        OcrTempReferenVO initVO = new OcrTempReferenVO(new OcrImage(imgBase64, fileName));
        OcrControlUtils.setCustomcontrolData(view, comsumer, key, initVO);
    }

    public static DynamicObject getOprationObjByTempalteNumber(String number) {
        QFilter filter = new QFilter("number", "=", (Object)number);
        filter.and("bindingdata", "=", (Object)"0");
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject template = BusinessDataServiceHelper.loadSingleFromCache((String)"cvp_template", (QFilter[])filters);
        return template;
    }

    public static DynamicObject getObjByTempalteNumber(String number) {
        QFilter filter = new QFilter("number", "=", (Object)number);
        QFilter bindFilter = new QFilter("bindingdata", "=", (Object)"0");
        QFilter qFilter = new QFilter("isvalid", "=", (Object)"1");
        QFilter qFilter1 = new QFilter("isvalid", "=", (Object)"2");
        QFilter orQFilter = bindFilter.or(qFilter).or(qFilter1);
        QFilter[] filters = new QFilter[]{filter.and(orQFilter)};
        DynamicObject template = BusinessDataServiceHelper.loadSingleFromCache((String)"cvp_template", (QFilter[])filters);
        return template;
    }

    public static boolean objByPlanNumberExit(String number) {
        QFilter filter = new QFilter("number", "=", (Object)number);
        QFilter[] filters = new QFilter[]{filter};
        return QueryServiceHelper.exists((String)"cvp_plan", (QFilter[])filters);
    }

    public static DynamicObject getObjByPlanNumber(String number) {
        QFilter filter = new QFilter("number", "=", (Object)number);
        QFilter[] filters = new QFilter[]{filter};
        String selectFields = "id,number,description,useclassifier,templateconfig,createdate,modifydate,templatenumber";
        DynamicObject plan = QueryServiceHelper.queryOne((String)"cvp_plan", (String)selectFields, (QFilter[])filters);
        return plan;
    }

    public static DynamicObject getObjByPlanBusinessObject(String businessObject) {
        QFilter filter = new QFilter("businessobject", "=", (Object)businessObject);
        QFilter[] filters = new QFilter[]{filter};
        String selectFields = "id,number,description,templateconfig,createdate,modifydate,templatenumber";
        DynamicObject plan = QueryServiceHelper.queryOne((String)"cvp_plan", (String)selectFields, (QFilter[])filters);
        return plan;
    }

    public static DynamicObject getTemplateEditByNumber(String number) {
        QFilter filterNumber = new QFilter("number", "=", (Object)number);
        filterNumber.and("bindingdata", "=", (Object)"0");
        QFilter[] filters = new QFilter[]{filterNumber};
        DynamicObject template = BusinessDataServiceHelper.loadSingleFromCache((String)"cvp_template", (QFilter[])filters);
        long pkId = DB.genLongId((String)"cvp_template");
        template.set("id", (Object)pkId);
        return template;
    }

    public static DynamicObject getObjCacheByNumber(String objStr, String number) {
        QFilter filter = new QFilter("number", "=", (Object)number);
        filter.and("bindingdata", "=", (Object)"0");
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)objStr, (QFilter[])filters);
        return obj;
    }

    public static DynamicObject getBindingObjCacheByNumber(String objStr, String number) {
        QFilter filter = new QFilter("number", "=", (Object)number);
        filter.and("bindingdata", "=", (Object)"1");
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)objStr, (QFilter[])filters);
        return obj;
    }

    public static DynamicObject[] getPlanConfigObjByNumbers(String planNumber) {
        String selectFields = "id,plannumber,templatenumber,templateconfig";
        return OcrControlUtils.getObjByNumbers("cvp_plan_config", "plannumber", selectFields, planNumber);
    }

    public static DynamicObject[] getObjByNumbers(String objStr, String key, String selectFields, String planNumber) {
        QFilter filter = new QFilter(key, "=", (Object)planNumber);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection query = QueryServiceHelper.query((String)objStr, (String)selectFields, (QFilter[])filters);
        DynamicObject[] dynamicObjects = (DynamicObject[])query.toArray((Object[])new DynamicObject[0]);
        return dynamicObjects;
    }

    public static DynamicObjectCollection getPlanConfigObjList(Object planNumber) {
        String selectFields = "id,plannumber,templatenumber,templateconfig";
        return OcrControlUtils.getObjListByNumbers("cvp_plan_config", "plannumber", selectFields, planNumber);
    }

    public static DynamicObjectCollection getObjListByNumbers(String objStr, String key, String selectFields, Object planNumber) {
        QFilter filter = new QFilter(key, "=", planNumber);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection query = QueryServiceHelper.query((String)objStr, (String)selectFields, (QFilter[])filters);
        return query;
    }

    public static DynamicObject getCurrenObjTemplate(IDataModel model) {
        String ftempnumber = (String)model.getValue("number");
        return OcrControlUtils.getOprationObjByTempalteNumber(ftempnumber);
    }

    public static DynamicObject getCurrenObjTemplateByKey(IDataModel model) {
        Object pkValue = model.getDataEntity().getPkValue();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)pkValue, (String)"cvp_template");
        return dynamicObject;
    }

    public static List<DynamicObject> getPlanConfigObjByKey(String qcp, String key, Object v) {
        String selectFields = "id,plannumber,templatenumber,templateconfig";
        DynamicObject[] configs = OcrControlUtils.getObjByNumbers(qcp, "cvp_plan_config", key, selectFields, v);
        return Arrays.asList(configs);
    }

    public static List<DynamicObject> getPlanConfigObjByTemplateKey(String qcp, String key, Object[] v) {
        String selectFields = "id,plannumber,templatenumber,templateconfig";
        DynamicObject[] configs = OcrControlUtils.getObjByNumbers(qcp, "cvp_plan_config", key, selectFields, v);
        return Arrays.asList(configs);
    }

    public static DynamicObject[] getObjByNumbers(String qcp, String objStr, String key, String selectFields, Object v) {
        QFilter filter = new QFilter(key, qcp, v);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection query = QueryServiceHelper.query((String)objStr, (String)selectFields, (QFilter[])filters);
        DynamicObject[] dynamicObjects = (DynamicObject[])query.toArray((Object[])new DynamicObject[0]);
        return dynamicObjects;
    }

    public static String geNumberCode(String per) {
        long number = new Date().getTime();
        return per + number;
    }

    public static boolean checkWebStatus(IFormView view, String eventName, String args) {
        if ("resultData".equals(eventName)) {
            JSONObject resultMap = JSON.parseObject((String)args);
            String code = (String)resultMap.get((Object)"code");
            String message = resultMap.getString("message");
            if ("100".equals(code)) {
                view.showSuccessNotification(message);
            } else if ("0".equals(code)) {
                if (StringUtils.isEmpty((String)message)) {
                    log.info("\u672a\u77e5\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u3002");
                    message = ResManager.loadKDString((String)"\u672a\u77e5\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u3002", (String)"OcrControlUtils_01", (String)"ai-cvp-common", (Object[])new Object[0]);
                }
                view.showTipNotification(message);
            }
            return true;
        }
        return false;
    }

    public static String unicodeDecode(String string) {
        StringBuilder ss = new StringBuilder();
        ss.append("(\\\\u(\\p{XDigit}");
        ss.append("{4}))");
        Pattern pattern = Pattern.compile(ss.toString());
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            char ch = (char)Integer.parseInt(matcher.group(2), 16);
            string = string.replace(matcher.group(1), ch + "");
        }
        return string;
    }

    public static void saveApiInfo(String invokeType, int repCode, Object templateID, String templateName, long callTime, RequestContext rc, String businessObject, Object resultInfo) {
        DynamicObject apiInfo = ORM.create().newDynamicObject("cvp_api_invoke_info");
        String businessName = MetadataServiceHelper.getDataEntityType((String)businessObject).getDisplayName().getLocaleValue();
        apiInfo.set("createdate", (Object)new Date());
        apiInfo.set("calltime", (Object)callTime);
        apiInfo.set("errorcode", (Object)repCode);
        apiInfo.set("traceid", (Object)rc.getTraceId());
        apiInfo.set("templateid", templateID);
        apiInfo.set("templatename", (Object)templateName);
        apiInfo.set("callobjectid", (Object)businessObject);
        apiInfo.set("callobjectname", (Object)businessName);
        apiInfo.set("userid", (Object)String.valueOf(rc.getCurrUserId()));
        apiInfo.set("username", (Object)rc.getUserName());
        apiInfo.set("status", (Object)invokeType);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{apiInfo});
    }
}

