/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.utils;

import java.io.IOException;
import kd.ai.cvp.utils.OcrSimilarityDictUtils;
import kd.bos.util.StringUtils;

public class OcrStringUtils {
    public static String strConversion(String str) throws IOException {
        String dbc = OcrStringUtils.toDBC(str);
        return OcrStringUtils.strStrokeConversion(dbc);
    }

    public static String strStrokeConversion(String str) throws IOException {
        char[] chars;
        if (StringUtils.isEmpty((String)str)) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        for (char c : chars = str.toCharArray()) {
            String dictValue = OcrSimilarityDictUtils.getDictValue(String.valueOf(c));
            s.append(StringUtils.isNotEmpty((String)dictValue) ? dictValue : String.valueOf(c));
        }
        return s.toString();
    }

    public static String toSBC(String input) {
        StringBuilder sb = new StringBuilder(input);
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == ' ') {
                sb.setCharAt(i, '\u3000');
                continue;
            }
            if (c >= '\u007f') continue;
            sb.setCharAt(i, (char)(c + 65248));
        }
        return sb.toString();
    }

    public static String toDBC(String input) {
        StringBuilder sb = new StringBuilder(input);
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\u3000') {
                sb.setCharAt(i, ' ');
                continue;
            }
            if (c <= '\uff00' || c >= '\uff5f') continue;
            sb.setCharAt(i, (char)(c - 65248));
        }
        return sb.toString();
    }
}

