/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.utils;

import com.alibaba.fastjson.JSON;
import com.google.common.primitives.Bytes;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class PDFPageNumUtil {
    private static final Log logger = LogFactory.getLog(PDFPageNumUtil.class);
    private static final byte[] beginByte = "<<".getBytes(StandardCharsets.UTF_8);
    private static final byte[] endByte = ">>".getBytes(StandardCharsets.UTF_8);
    private static final byte[] typePageBByte = "/Type /Page".getBytes(StandardCharsets.UTF_8);
    private static final byte[] typePageByte = "/Type/Page".getBytes(StandardCharsets.UTF_8);
    private static final byte[] countByte = "/Count".getBytes(StandardCharsets.UTF_8);
    private static final byte[] parentByte = "/Parent".getBytes(StandardCharsets.UTF_8);
    private static final byte[] pagesByte = "/Pages".getBytes(StandardCharsets.UTF_8);
    private static final byte[] endStreamByte = "endstream".getBytes(StandardCharsets.UTF_8);
    private static final byte[] endWithBeginMarkByte = "<".getBytes(StandardCharsets.UTF_8);
    private static final byte[] beginStreamByte = "stream".getBytes(StandardCharsets.UTF_8);
    private static final byte[] seperatorByte = "/".getBytes(StandardCharsets.UTF_8);
    private static final byte[] beginByteHalf = "<".getBytes(StandardCharsets.UTF_8);
    private static final byte[] endByteHalf = ">".getBytes(StandardCharsets.UTF_8);
    private static final int readSize = 1024;

    private static int indexOf(byte[] array, byte[] target, int fromIndex) {
        if (array == null || target == null) {
            throw new NullPointerException("\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002");
        }
        if (target.length == 0) {
            return -1;
        }
        block0: for (int i = fromIndex; i < array.length - target.length + 1; ++i) {
            for (int j = 0; j < target.length; ++j) {
                if (array[i + j] != target[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    private static void getLastEndMarkSite(Map<String, Object> result, byte[] newBuf, byte[] beginByte, byte[] endByte, int nowSite, int nowEndSite) {
        int nextSite = -1;
        int nextEnd = -1;
        nextSite = PDFPageNumUtil.indexOf(newBuf, beginByte, nowSite + beginByte.length);
        if (nextSite != -1) {
            if (nextSite < nowEndSite) {
                nextEnd = PDFPageNumUtil.indexOf(newBuf, endByte, nowEndSite + endByte.length);
                if (nextEnd != -1) {
                    PDFPageNumUtil.getLastEndMarkSite(result, newBuf, beginByte, endByte, nextSite, nextEnd);
                } else {
                    result.put("concatFlag", Boolean.TRUE);
                }
            } else {
                result.put("endSite", nowEndSite);
                result.put("concatFlag", Boolean.FALSE);
            }
        } else {
            result.put("endSite", nowEndSite);
            result.put("concatFlag", Boolean.FALSE);
        }
    }

    private static void getLastEndMarkSite(Map<String, Object> result, byte[] newBuf, int nowSite) {
        LinkedList<Integer> stack = new LinkedList<Integer>();
        for (int i = nowSite; i < newBuf.length - 1; ++i) {
            boolean flag = false;
            if (newBuf[i] == endByteHalf[0] && newBuf[i + 1] == endByteHalf[0]) {
                if (i == 0 || i - 1 >= 0 && newBuf[i - 1] != endByteHalf[0] || i - 1 > 0 && i - 2 > 0 && newBuf[i - 1] == endByteHalf[0] && newBuf[i - 2] == endByteHalf[0]) {
                    logger.debug("i pop:" + i);
                    stack.pop();
                    flag = true;
                }
            } else if (newBuf[i] == beginByteHalf[0] && newBuf[i + 1] == beginByteHalf[0] && (i == 0 || i - 1 >= 0 && newBuf[i - 1] != beginByteHalf[0] || i - 1 > 0 && i - 2 > 0 && newBuf[i - 1] == beginByteHalf[0] && newBuf[i - 2] == beginByteHalf[0])) {
                logger.debug("i push:" + i);
                stack.push(1);
                flag = true;
            }
            if (stack.isEmpty()) {
                result.put("endSite", i);
                result.put("concatFlag", Boolean.FALSE);
                return;
            }
            if (!flag) continue;
            ++i;
        }
        if (!stack.isEmpty()) {
            result.put("concatFlag", Boolean.TRUE);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static int getPdfPageNumByBufferedArrNew(InputStream inputStream) {
        pageNum = 0;
        num = 0;
        try {
            lastBuf = null;
            buf = new byte[1024];
            while (inputStream.read(buf, 0, 1024) != -1) {
                newBuf = lastBuf != null ? Bytes.concat((byte[][])new byte[][]{lastBuf, buf}) : buf;
                from = 0;
                site = -1;
                endSite = -1;
                endStreamSite = -1;
                while ((site = PDFPageNumUtil.indexOf(newBuf, PDFPageNumUtil.beginByte, from)) != -1) {
                    endSite = PDFPageNumUtil.indexOf(newBuf, PDFPageNumUtil.endByte, site);
                    if (endSite != -1) {
                        endStreamSite = PDFPageNumUtil.indexOf(newBuf, PDFPageNumUtil.endStreamByte, site);
                        if (endStreamSite != -1 && endStreamSite < endSite) {
                            from = endStreamSite + PDFPageNumUtil.endStreamByte.length;
                            continue;
                        }
                        result = new HashMap<String, Object>();
                        PDFPageNumUtil.getLastEndMarkSite(result, newBuf, site);
                        PDFPageNumUtil.logger.debug("\u4f4d\u7f6e\uff1a\uff1a\uff1a" + JSON.toJSONString(result));
                        concatFlag = result.get("concatFlag");
                        lastEndSite = result.get("endSite");
                        if (concatFlag != null && Boolean.parseBoolean(concatFlag.toString())) {
                            if (lastBuf != null && newBuf.length > 10240) {
                                lastBuf = null;
                                break;
                            }
                            lastBuf = Arrays.copyOfRange(newBuf, site, newBuf.length);
                            break;
                        }
                        if (lastEndSite != null) {
                            endSite = Integer.parseInt(lastEndSite.toString());
                        }
                        targetByte = Arrays.copyOfRange(newBuf, site, endSite + PDFPageNumUtil.endByte.length);
                        countByteIndex = -1;
                        countByteIndex = PDFPageNumUtil.indexOf(targetByte, PDFPageNumUtil.countByte, 0);
                        if (countByteIndex != -1) {
                            if (PDFPageNumUtil.indexOf(targetByte, PDFPageNumUtil.parentByte, 0) == -1 && PDFPageNumUtil.indexOf(targetByte, PDFPageNumUtil.pagesByte, 0) != -1) {
                                begin = countByteIndex + PDFPageNumUtil.countByte.length + 1;
                                PDFPageNumUtil.logger.debug("begin:" + begin);
                                nextMarkSite = PDFPageNumUtil.indexOf(targetByte, PDFPageNumUtil.seperatorByte, begin);
                                endMarkSite = PDFPageNumUtil.indexOf(targetByte, PDFPageNumUtil.endByte, begin);
                                pageNumbytes = Arrays.copyOfRange(targetByte, begin, nextMarkSite != -1 ? nextMarkSite : endMarkSite);
                                PDFPageNumUtil.logger.debug("pageNumbytes:" + Arrays.toString(pageNumbytes));
                                pageNumStr = new String(pageNumbytes, StandardCharsets.UTF_8);
                                PDFPageNumUtil.logger.debug("pageNumStr:" + pageNumStr);
                                try {
                                    currentCount = Integer.parseInt(pageNumStr.trim());
                                    if (pageNum >= currentCount) ** GOTO lbl57
                                    pageNum = currentCount;
                                }
                                catch (Exception ex) {
                                    return -1;
                                }
                            }
                        } else {
                            site = PDFPageNumUtil.indexOf(targetByte, PDFPageNumUtil.typePageByte, 0);
                            if ((site != -1 || (site = PDFPageNumUtil.indexOf(targetByte, PDFPageNumUtil.typePageBByte, 0)) != -1) && PDFPageNumUtil.indexOf(targetByte, PDFPageNumUtil.pagesByte, 0) == -1) {
                                PDFPageNumUtil.logger.debug("num:" + ++num);
                                PDFPageNumUtil.logger.debug("num:" + num + "\u5185\u5bb9:===========" + (site >= 10 ? new String(Arrays.copyOfRange(targetByte, site - 10, site), StandardCharsets.UTF_8) : new String(Arrays.copyOfRange(targetByte, site, site + 10), StandardCharsets.UTF_8)));
                            }
                        }
lbl57:
                        // 6 sources

                        from = endSite + PDFPageNumUtil.endByte.length;
                        lastBuf = null;
                        continue;
                    }
                    endStreamSite = PDFPageNumUtil.indexOf(newBuf, PDFPageNumUtil.endStreamByte, site);
                    lastBuf = endStreamSite != -1 ? Arrays.copyOfRange(newBuf, endStreamSite + PDFPageNumUtil.endStreamByte.length, newBuf.length) : (lastBuf != null && newBuf.length > 10240 ? null : Arrays.copyOfRange(newBuf, site, newBuf.length));
                    break;
                }
                if (lastBuf != null || newBuf[newBuf.length - 1] != PDFPageNumUtil.endWithBeginMarkByte[0] || newBuf[newBuf.length - 2] == PDFPageNumUtil.endWithBeginMarkByte[0]) continue;
                lastBuf = Arrays.copyOfRange(newBuf, newBuf.length - 1, newBuf.length);
            }
            if (pageNum > 0) {
                return pageNum;
            }
            return num;
        }
        catch (IOException ie) {
            PDFPageNumUtil.logger.error("\u7cfb\u7edfio\u5f02\u5e38", (Throwable)ie);
            return -1;
        }
    }

    private static byte[] ignoreStream(byte[] newBuf) {
        int endIndex;
        int index;
        int from = 0;
        while ((index = PDFPageNumUtil.indexOf(newBuf, beginStreamByte, from)) != -1) {
            endIndex = PDFPageNumUtil.indexOf(newBuf, endStreamByte, index);
            if (endIndex != -1) {
                newBuf = Bytes.concat((byte[][])new byte[][]{Arrays.copyOfRange(newBuf, 0, index), Arrays.copyOfRange(newBuf, endIndex + endStreamByte.length, newBuf.length)});
                continue;
            }
            newBuf = Arrays.copyOfRange(newBuf, 0, index);
        }
        endIndex = PDFPageNumUtil.indexOf(newBuf, endStreamByte, 0);
        if (endIndex != -1) {
            newBuf = Arrays.copyOfRange(newBuf, endIndex + endStreamByte.length, newBuf.length);
        }
        return newBuf;
    }
}

