/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import kd.ai.cvp.common.Enum.FileValidTypeEnum;
import kd.ai.cvp.common.Enum.LicenseCountServiceNameEnum;
import kd.ai.cvp.common.Enum.SourceTypeEnum;
import kd.ai.cvp.common.Enum.StorageTypeEnum;
import kd.ai.cvp.common.Enum.VisualTypeEnum;
import kd.ai.cvp.common.TdaCommon;
import kd.ai.cvp.entity.AlgoPageNumAndFileIdVO;
import kd.ai.cvp.entity.AlgoResultData;
import kd.ai.cvp.entity.InitTdaTieAttData;
import kd.ai.cvp.entity.param.OcrParam;
import kd.ai.cvp.entity.tda.CompareData;
import kd.ai.cvp.entity.tda.CompareResult;
import kd.ai.cvp.entity.tda.InitCustomVO;
import kd.ai.cvp.entity.tda.StartComparison;
import kd.ai.cvp.entity.tda.StartComparisonFile;
import kd.ai.cvp.entity.tda.TdaBatchTaskInfoResult;
import kd.ai.cvp.entity.tda.TdaCancelTaskResultVO;
import kd.ai.cvp.entity.tda.TdaCancelTaskVO;
import kd.ai.cvp.entity.tda.TdaInitFileInfo;
import kd.ai.cvp.entity.tda.TdaOneHistory;
import kd.ai.cvp.entity.tda.TdaOneTaskInfo;
import kd.ai.cvp.entity.tda.TdaPlanIgnore;
import kd.ai.cvp.entity.tda.TdaTaskDelVO;
import kd.ai.cvp.entity.tda.algoCompare.AlgoCompareData;
import kd.ai.cvp.entity.tda.algoCompare.ConversionAlgoInfo;
import kd.ai.cvp.entity.tda.algoCompare.DiffDetails;
import kd.ai.cvp.entity.tda.algoCompare.DiffEntityVO;
import kd.ai.cvp.entity.tda.algoCompare.DiffSummary;
import kd.ai.cvp.entity.tda.algoCompare.TabInfo;
import kd.ai.cvp.task.TdaFlushDataExcutors;
import kd.ai.cvp.utils.CommonUtil;
import kd.ai.cvp.utils.CvpFileServiceUtils;
import kd.ai.cvp.utils.LicenseUtils;
import kd.ai.cvp.utils.LocalTempFileCache;
import kd.ai.cvp.utils.OcrControlUtils;
import kd.ai.cvp.utils.OcrHttpClientUtils;
import kd.ai.cvp.utils.ThreadUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.url.UrlService;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;

public class TdaUtils {
    private static Log LOGGER = LogFactory.getLog(TdaUtils.class);
    private static final String VALID_LICENSE_ERROR = "validLicenseError";
    private static final String KEY_COMMON = "ai-cvp-common";

    private TdaUtils() {
        throw new KDBizException("init error");
    }

    public static void initCustom(IFormView view) {
        InitCustomVO initDataVO;
        String domainContextUrl = UrlService.getDomainContextUrl();
        String attUrl = String.format("%s/attachment/upload.do", domainContextUrl);
        FormShowParameter showParameter = view.getFormShowParameter();
        String opreate = (String)showParameter.getCustomParam("tda_operate_type");
        long planId = (Long)showParameter.getCustomParam("tda_plan_id");
        String baseFileStr = (String)showParameter.getCustomParam("baseFile");
        String compareFileStr = (String)showParameter.getCustomParam("compareFile");
        if ("tda_test_task".equals(opreate)) {
            initDataVO = new InitCustomVO(opreate, attUrl);
        } else if ("tda_show_task".equals(opreate)) {
            String billId = (String)showParameter.getCustomParam("billid");
            long fid = (Long)showParameter.getCustomParam("id");
            TdaOneTaskInfo oneTaskInfo = TdaUtils.getTdaOneTaskInfo(fid, planId);
            if (oneTaskInfo == null) {
                String message = ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u53d6\u6d88\uff0c\u8bf7\u786e\u5b9a\u8be5\u6bd4\u5bf9\u4efb\u52a1\u7684\u72b6\u6001\u540e\u518d\u8bd5\u3002", (String)"TdaInfoPlugin_1", (String)KEY_COMMON, (Object[])new Object[0]);
                LOGGER.info(String.format("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u5dee\u5f02\u5206\u6790\uff0c%s", message));
                view.showTipNotification(message);
                OcrControlUtils.setTdaOrTieCustomcontrolData(view, "customtda", "tdaBreakOff", Boolean.TRUE);
                return;
            }
            initDataVO = new InitCustomVO(opreate, attUrl, billId, oneTaskInfo.getFileData(), oneTaskInfo.getTdaData());
        } else if ("tda_create_task".equals(opreate)) {
            Object billId = showParameter.getCustomParam("billid");
            initDataVO = new InitCustomVO(opreate, attUrl, String.valueOf(billId));
            TdaInitFileInfo tdaInitFileInfo = TdaUtils.getBizBillFileInfo(view);
            if (tdaInitFileInfo != null) {
                InitTdaTieAttData baseAttData = tdaInitFileInfo.getBaseAttData();
                InitTdaTieAttData compareAttData = tdaInitFileInfo.getCompareAttData();
                initDataVO.setBaseAttData(baseAttData);
                initDataVO.setCompareAttData(compareAttData);
            }
        } else {
            Object billId = showParameter.getCustomParam("billid");
            initDataVO = new InitCustomVO(opreate, attUrl, String.valueOf(billId));
            TdaUtils.validAndSetParam(initDataVO, baseFileStr, compareFileStr);
        }
        initDataVO.setPlanId(planId);
        OcrControlUtils.setTdaOrTieCustomcontrolData(view, "customtda", "init", initDataVO);
    }

    private static TdaInitFileInfo getBizBillFileInfo(IFormView view) {
        TdaInitFileInfo tdaInitFileInfo = new TdaInitFileInfo();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Object parentPageId = formShowParameter.getCustomParam("pageId");
        if (parentPageId == null) {
            LOGGER.error("parent pageId is null,default with no file select.");
            return tdaInitFileInfo;
        }
        IFormView parentView = view.getViewNoPlugin(String.valueOf(parentPageId));
        if (parentView == null) {
            LOGGER.info("parent view is null,default with no file select.");
            return tdaInitFileInfo;
        }
        IPageCache pageCache = parentView.getPageCache();
        String fileInfo = pageCache.get("tdaFileInfo");
        if (kd.bos.util.StringUtils.isEmpty((String)fileInfo)) {
            LOGGER.info("no preset file,return");
            return tdaInitFileInfo;
        }
        tdaInitFileInfo = (TdaInitFileInfo)JSON.parseObject((String)fileInfo, TdaInitFileInfo.class);
        if (tdaInitFileInfo == null) {
            LOGGER.error("\u672a\u8f6c\u6362\u4e3a\u53ef\u8bc6\u522b\u7684\u5bf9\u8c61\uff0c\u7ed3\u675f\u3002");
            return new TdaInitFileInfo();
        }
        InitTdaTieAttData baseAttData = tdaInitFileInfo.getBaseAttData();
        InitTdaTieAttData compareAttData = tdaInitFileInfo.getCompareAttData();
        try {
            CommonUtil.validFileWhenInit(baseAttData, "b");
        }
        catch (Exception e) {
            LOGGER.info("\u6821\u9a8c\u5f02\u5e38\uff0c\u8bb0\u5f55\u65e5\u5fd7,\u5e76\u6e05\u7a7a\u5bf9\u5e94\u7684\u6587\u4ef6\u4fe1\u606f", (Object)e);
            tdaInitFileInfo.setBaseAttData(new InitTdaTieAttData());
        }
        try {
            CommonUtil.validFileWhenInit(compareAttData, "c");
        }
        catch (Exception e) {
            LOGGER.info("\u6821\u9a8c\u5f02\u5e38\uff0c\u8bb0\u5f55\u65e5\u5fd7,\u5e76\u6e05\u7a7a\u5bf9\u5e94\u7684\u6587\u4ef6\u4fe1\u606f", (Object)e);
            tdaInitFileInfo.setCompareAttData(new InitTdaTieAttData());
        }
        return tdaInitFileInfo;
    }

    private static void validAndSetParam(InitCustomVO initDataVO, String baseFileStr, String compareFileStr) {
        try {
            Map<String, Map<String, String>> resultMap = TdaUtils.validParam(baseFileStr, compareFileStr);
            Map<String, String> baseFile = resultMap.get("baseFile");
            Map<String, String> compareFile = resultMap.get("compareFile");
            String baseUrl = baseFile.get("url");
            String compareUrl = compareFile.get("url");
            baseFile.put("tempFileId", CvpFileServiceUtils.attFile2TempFile(baseUrl));
            compareFile.put("tempFileId", CvpFileServiceUtils.attFile2TempFile(compareUrl));
            initDataVO.setBaseFile(baseFile);
            initDataVO.setCompareFile(compareFile);
        }
        catch (Exception e) {
            LOGGER.warn("\u4e1a\u52a1\u5355\u636e\u8bf7\u6c42\u76f4\u63a5\u521b\u5efa\u4efb\u52a1\u5931\u8d25,\u5f02\u5e38\u4e3a", (Throwable)e);
        }
    }

    private static Map<String, Map<String, String>> validParam(String baseFileStr, String compareFileStr) {
        HashMap<String, Map<String, String>> resultMap = new HashMap<String, Map<String, String>>();
        Map baseFileMap = (Map)JSON.parseObject((String)baseFileStr, Map.class);
        Map compareFileMap = (Map)JSON.parseObject((String)compareFileStr, Map.class);
        String baseUrl = (String)baseFileMap.get("url");
        String baseFileName = (String)baseFileMap.get("fileName");
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        String compareUrl = (String)compareFileMap.get("url");
        String compareFileName = (String)compareFileMap.get("fileName");
        if (kd.bos.util.StringUtils.isEmpty((String)baseUrl) || !fileService.exists(baseUrl) || kd.bos.util.StringUtils.isEmpty((String)baseFileName)) {
            LOGGER.error("\u4e1a\u52a1\u5355\u636e\u5feb\u901f\u5f00\u59cb\u6bd4\u5bf9\u5931\u8d25\uff0c\u6e90\u6587\u4ef6\u76f8\u5173\u53c2\u6570\u4e3a\u7a7a\u3002");
            throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u5feb\u901f\u5f00\u59cb\u6bd4\u5bf9\u5931\u8d25,\u6e90\u6587\u6863\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"TdaUtils_050", (String)KEY_COMMON, (Object[])new Object[0]));
        }
        if (kd.bos.util.StringUtils.isEmpty((String)compareUrl) || !fileService.exists(compareUrl) || kd.bos.util.StringUtils.isEmpty((String)compareFileName)) {
            LOGGER.error("\u4e1a\u52a1\u5355\u636e\u5feb\u901f\u5f00\u59cb\u6bd4\u5bf9\u5931\u8d25\uff0c\u6bd4\u5bf9\u6587\u4ef6\u76f8\u5173\u53c2\u6570\u4e3a\u7a7a\u3002");
            throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u5feb\u901f\u5f00\u59cb\u6bd4\u5bf9\u5931\u8d25,\u6bd4\u5bf9\u6587\u6863\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"TdaUtils_051", (String)KEY_COMMON, (Object[])new Object[0]));
        }
        resultMap.put("baseFile", baseFileMap);
        resultMap.put("compareFile", compareFileMap);
        return resultMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String netTxtFile2Json(String filePath) {
        try (InputStream in = FileServiceFactory.getAttachmentFileService().getInputStream(filePath);){
            int len;
            InputStreamReader reader = new InputStreamReader(in);
            StringBuilder s = new StringBuilder();
            while ((len = ((Reader)reader).read()) != -1) {
                s.append((char)len);
            }
            String string = s.toString();
            return string;
        }
        catch (IOException ioe) {
            LOGGER.error("\u83b7\u53d6\u6587\u4ef6io\u5f02\u5e38", (Throwable)ioe);
            return "";
        }
    }

    public static FormShowParameter getTestShowParameter(long tdaPlanId) {
        FormShowParameter showParameter = TdaUtils.getFormShowParameter();
        showParameter.setCustomParam("tda_plan_id", (Object)tdaPlanId);
        showParameter.setCustomParam("tda_operate_type", (Object)"tda_test_task");
        return showParameter;
    }

    public static FormShowParameter getHistoryShowParameter(long id) {
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        DynamicObject historyObj = QueryServiceHelper.queryOne((String)"cvp_tda_task_history", (String)"id,billname,billno,billid,businessobj", (QFilter[])new QFilter[]{qFilter});
        if (historyObj == null) {
            throw new KDBizException("\u67e5\u8be2\u4e0d\u5230\u8bb0\u5f55\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01");
        }
        Object businessobj = historyObj.get("businessobj");
        QFilter busFilter = new QFilter("businessobject.id", "=", businessobj);
        DynamicObject planObj = BusinessDataServiceHelper.loadSingle((String)"cvp_tda_plan", (String)"id", (QFilter[])new QFilter[]{busFilter});
        if (planObj == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65b9\u6848\u5df2\u88ab\u5220\u9664\uff0c\u65e0\u6cd5\u67e5\u8be2\u8be5\u5386\u53f2\u8bb0\u5f55\uff0c\u8bf7\u91cd\u65b0\u6bd4\u5bf9\u540e\u518d\u8bd5\u3002", (String)"TdaUtils_0030", (String)KEY_COMMON, (Object[])new Object[0]));
        }
        FormShowParameter showParameter = TdaUtils.getFormShowParameter();
        showParameter.setCustomParam("id", (Object)id);
        showParameter.setCustomParam("tda_plan_id", planObj.getPkValue());
        showParameter.setCustomParam("tda_operate_type", (Object)"tda_show_task");
        showParameter.setCustomParam("billid", (Object)String.valueOf(historyObj.getLong("billid")));
        showParameter.setCustomParam("tda_bill_number", (Object)historyObj.getString("billno"));
        showParameter.setCustomParam("tda_bill_name", (Object)historyObj.getString("billname"));
        return showParameter;
    }

    public static FormShowParameter getFormShowParameter() {
        FormShowParameter showParameter = new FormShowParameter();
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("90%");
        styleCss.setHeight("90%");
        showParameter.setFormId("cvp_tda_info");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        return showParameter;
    }

    public static String tdaCreateTaskForMservice(String baseUrl, String compareUrl, String planNumber, String billId) {
        String traceId = RequestContext.get().getTraceId();
        AlgoResultData algoResultData = new AlgoResultData();
        algoResultData.setRequestId(traceId);
        algoResultData.setErrorCode(0);
        algoResultData.setDescription(ResManager.loadKDString((String)"\u8bf7\u6c42\u6210\u529f\u3002", (String)"TdaUtils_056", (String)KEY_COMMON, (Object[])new Object[0]));
        try {
            StartComparison tdaComparisonObj = TdaUtils.buildParam(baseUrl, compareUrl);
            Map<String, AlgoPageNumAndFileIdVO> algoTempFileMap = TdaUtils.tdaMserviceParamValid(tdaComparisonObj, planNumber, billId);
            HashMap<String, Object> planMap = new HashMap<String, Object>();
            TdaUtils.bizValid(planNumber, billId, planMap);
            return TdaUtils.tdaStartTaskForMservice(tdaComparisonObj, planMap, algoTempFileMap, billId);
        }
        catch (KDBizException ke) {
            LOGGER.error("\u4e1a\u52a1\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u5206\u6790\u3002traceId:{}", (Object)traceId, (Object)ke);
            ErrorCode errorCode = ke.getErrorCode();
            String message = errorCode.getMessage();
            String code = errorCode.getCode();
            algoResultData.setErrorCode(kd.bos.util.StringUtils.isEmpty((String)code) ? 40000 : Integer.parseInt(code));
            algoResultData.setDescription(kd.bos.util.StringUtils.isEmpty((String)message) ? "\u4e1a\u52a1\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u3002" : message);
            algoResultData.setData(null);
        }
        catch (Exception e) {
            LOGGER.error("\u4e1a\u52a1\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u5206\u6790\u3002traceId:{}", (Object)traceId, (Object)e);
            algoResultData.setErrorCode(40000);
            algoResultData.setDescription(kd.bos.util.StringUtils.isNotEmpty((String)e.getMessage()) ? e.getMessage() : ResManager.loadKDString((String)"\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u3002", (String)"TdaUtils_057", (String)KEY_COMMON, (Object[])new Object[0]));
            algoResultData.setData(null);
        }
        return SerializationUtils.toJsonString((Object)algoResultData);
    }

    private static void bizValid(String planNumber, String billId, Map<String, Object> map) {
        LOGGER.info("biz valid begin..");
        if (kd.bos.util.StringUtils.isEmpty((String)planNumber)) {
            throw new KDBizException(new ErrorCode("40002", ResManager.loadKDString((String)"\u5dee\u5f02\u5206\u6790\u65b9\u6848\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u5b9e\u540e\u91cd\u8bd5\u3002", (String)"TdaUtils_052", (String)KEY_COMMON, (Object[])new Object[0])), new Object[0]);
        }
        QFilter filter = new QFilter("number", "=", (Object)planNumber);
        DynamicObject tdaPlan = BusinessDataServiceHelper.loadSingleFromCache((String)"cvp_tda_plan", (QFilter[])new QFilter[]{filter});
        if (tdaPlan == null) {
            throw new KDBizException(new ErrorCode("40008", ResManager.loadKDString((String)"\u5dee\u5f02\u5206\u6790\u65b9\u6848\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u914d\u7f6e\u597d\u5dee\u5f02\u5206\u6790\u65b9\u6848\u540e\u518d\u8bd5\uff01", (String)"TdaUtils_053", (String)KEY_COMMON, (Object[])new Object[0])), new Object[0]);
        }
        String bizFormId = tdaPlan.getDynamicObject("businessobject").getString("number");
        map.put("businessObject", bizFormId);
        if (kd.bos.util.StringUtils.isEmpty((String)bizFormId)) {
            throw new KDBizException(new ErrorCode("40002", ResManager.loadKDString((String)"\u65b9\u6848\u7f16\u7801\u4e0d\u5305\u542b\u6709\u6548\u7684\u4e1a\u52a1\u5bf9\u8c61\uff0c\u8bf7\u6838\u5b9e\u540e\u91cd\u8bd5\u3002", (String)"TdaUtils_054", (String)KEY_COMMON, (Object[])new Object[0])), new Object[0]);
        }
        String bizField = tdaPlan.getString("field");
        map.put("businessConfig", bizField);
        String planName = tdaPlan.getString("name");
        map.put("planName", planName);
        map.put("planId", tdaPlan.getPkValue());
        if (kd.bos.util.StringUtils.isEmpty((String)billId)) {
            QFilter qFilter = new QFilter("id", "=", (Object)billId);
            DynamicObject bizObj = BusinessDataServiceHelper.loadSingle((String)bizFormId, (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (bizObj == null) {
                throw new KDBizException(new ErrorCode("40009", ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u8bd5\u3002", (String)"TdaUtils_055", (String)KEY_COMMON, (Object[])new Object[0])), new Object[0]);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static String tdaStartTaskForMservice(StartComparison tdaComparisonObj, Map<String, Object> planMap, Map<String, AlgoPageNumAndFileIdVO> validMap, String billId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void saveAndTrickUpdate(String billId, Map<String, Object> planMap, StartComparisonFile baseFile, StartComparisonFile compareFile, AlgoPageNumAndFileIdVO baseVO, AlgoPageNumAndFileIdVO compareVO, int errorCode, String taskId, long startTime, long endTime, Object createTime, String countKey) {
        Object bizObject = planMap.get("businessObject");
        Object planName = planMap.get("planName");
        Object planId = planMap.get("planId");
        String billno = "";
        String billName = "";
        try {
            DynamicObject bizObj = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(billId), (String)bizObject.toString(), (String)"id,billno,number,name");
            if (bizObj != null) {
                billno = MetadataServiceHelper.getDataEntityType((String)bizObject.toString()) instanceof BasedataEntityType ? bizObj.getString("number") : bizObj.getString("billno");
                billName = bizObj.getString("name");
            }
        }
        catch (Exception e) {
            LOGGER.error("error in bizobject");
        }
        OcrControlUtils.saveApiInfo("D", errorCode, planId, planName.toString(), endTime - startTime, RequestContext.get(), bizObject.toString(), taskId);
        DynamicObject historyTask = BusinessDataServiceHelper.newDynamicObject((String)"cvp_tda_task_history");
        historyTask.set("billid", (Object)billId);
        historyTask.set("billno", (Object)billno);
        historyTask.set("billname", (Object)billName);
        historyTask.set("billcreaterid", (Object)RequestContext.get().getCurrUserId());
        historyTask.set("billvalid", (Object)"1");
        historyTask.set("billcreatedate", (Object)(createTime != null ? new Date((Long)createTime) : new Date()));
        historyTask.set("billoriginaldoc", (Object)baseFile.getFileName());
        historyTask.set("billcomparedoc", (Object)compareFile.getFileName());
        historyTask.set("billoriginaldocpath", (Object)baseFile.getUrl());
        historyTask.set("billcomparedocpath", (Object)compareFile.getUrl());
        historyTask.set("billstatus", (Object)"running");
        historyTask.set("taskid", (Object)taskId);
        historyTask.set("planname", planName);
        historyTask.set("businessobj", (Object)bizObject.toString());
        int basePageNum = baseVO.getPageNum();
        int comparePageNum = compareVO.getPageNum();
        LOGGER.info("basePageNum:{},comparePageNum:{}", (Object)basePageNum, (Object)comparePageNum);
        historyTask.set("totalpage", (Object)(basePageNum + comparePageNum));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{historyTask});
        TdaUtils.setTracIdAndTaskId(String.valueOf(taskId), countKey);
        TdaFlushDataExcutors.excuteTask(RequestContext.get());
    }

    private static Map<String, AlgoPageNumAndFileIdVO> tdaMserviceParamValid(StartComparison tdaComparisonObj, String planNumber, String billId) throws Exception {
        HashMap<String, AlgoPageNumAndFileIdVO> validMap = new HashMap<String, AlgoPageNumAndFileIdVO>();
        if (tdaComparisonObj == null) {
            String errorTips = ResManager.loadKDString((String)"\u6587\u4ef6\u91cd\u590d\u6027\u6821\u9a8c\u5931\u8d25\uff0c\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"TdaUtils_001", (String)KEY_COMMON, (Object[])new Object[0]);
            throw new KDBizException(new ErrorCode("40002", errorTips), new Object[0]);
        }
        StartComparisonFile compareFile = tdaComparisonObj.getCompareFile();
        StartComparisonFile baseFile = tdaComparisonObj.getBaseFile();
        if (baseFile == null || baseFile.getTempFileId() == null || baseFile.getUrl() == null || compareFile == null || compareFile.getTempFileId() == null || compareFile.getUrl() == null) {
            String errorTips = ResManager.loadKDString((String)"\u6587\u4ef6\u91cd\u590d\u6027\u6821\u9a8c\u5931\u8d25\uff0c\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"TdaUtils_001", (String)KEY_COMMON, (Object[])new Object[0]);
            throw new KDBizException(new ErrorCode("40002", errorTips), new Object[0]);
        }
        String baseUrl = baseFile.getUrl();
        String baseTempFileId = baseFile.getTempFileId();
        String compareUrl = compareFile.getUrl();
        String compareTempFileId = compareFile.getTempFileId();
        FileService attachmentFileService = FileServiceFactory.getAttachmentFileService();
        boolean baseExists = attachmentFileService.exists(baseUrl);
        if (!baseExists) {
            throw new KDBizException(new ErrorCode("31001", ResManager.loadKDString((String)"\u539f\u6587\u6863\u4e0d\u5b58\u5728\uff0c\u8bf7\u4e0a\u4f20\u540e\u91cd\u8bd5\uff01", (String)"TdaUtils_050", (String)KEY_COMMON, (Object[])new Object[0])), new Object[0]);
        }
        boolean compareExists = attachmentFileService.exists(compareUrl);
        if (!compareExists) {
            throw new KDBizException(new ErrorCode("31001", ResManager.loadKDString((String)"\u6bd4\u5bf9\u6587\u6863\u4e0d\u5b58\u5728\uff0c\u8bf7\u4e0a\u4f20\u540e\u91cd\u8bd5\uff01", (String)"TdaUtils_051", (String)KEY_COMMON, (Object[])new Object[0])), new Object[0]);
        }
        baseFile.setTempFileId(LocalTempFileCache.updateTempFileId(baseTempFileId, baseUrl, FileValidTypeEnum.BASE, attachmentFileService));
        compareFile.setTempFileId(LocalTempFileCache.updateTempFileId(compareTempFileId, compareUrl, FileValidTypeEnum.COMPARISON, attachmentFileService));
        TdaUtils.validFileParam(baseFile, compareFile, validMap);
        if (validMap.isEmpty()) {
            throw new KDBizException(new ErrorCode("40000", ResManager.loadKDString((String)"\u83b7\u53d6\u6587\u4ef6\u9875\u6570\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"TdaUtils_027", (String)KEY_COMMON, (Object[])new Object[0])), new Object[0]);
        }
        return validMap;
    }

    private static StartComparison buildParam(String baseUrl, String compareUrl) {
        LOGGER.info("\u5f00\u59cb\u6821\u9a8c\u6570\u636e\u3002\u3002\u3002baseUrl:{},compareUrl:{}", (Object)baseUrl, (Object)compareUrl);
        StartComparisonFile baseFile = new StartComparisonFile();
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        if (kd.bos.util.StringUtils.isNotEmpty((String)baseUrl)) {
            baseUrl = fileService.getFileServiceExt().getRealPath(baseUrl);
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)compareUrl)) {
            compareUrl = fileService.getFileServiceExt().getRealPath(compareUrl);
        }
        baseFile.setUrl(baseUrl);
        baseFile.setTempFileId("");
        if (kd.bos.util.StringUtils.isNotEmpty((String)baseUrl) && baseUrl.contains("/")) {
            baseFile.setFileName(baseUrl.substring(baseUrl.lastIndexOf("/") + 1));
        }
        StartComparisonFile compareFile = new StartComparisonFile();
        compareFile.setUrl(compareUrl);
        compareFile.setTempFileId("");
        if (kd.bos.util.StringUtils.isNotEmpty((String)compareUrl) && compareUrl.contains("/")) {
            compareFile.setFileName(compareUrl.substring(compareUrl.lastIndexOf("/") + 1));
        }
        StartComparison startComparison = new StartComparison();
        startComparison.setBaseFile(baseFile);
        startComparison.setCompareFile(compareFile);
        return startComparison;
    }

    public static void tdaStartTask(IFormView view, String args, String businessConfig, String planId, boolean isSave) throws Exception {
        List<String> ignoreList;
        StartComparison startComparison = (StartComparison)JSON.parseObject((String)args, StartComparison.class);
        StartComparisonFile baseFile = startComparison.getBaseFile();
        StartComparisonFile compareFile = startComparison.getCompareFile();
        String baseFileUrl = baseFile.getUrl();
        String baseTempFileId = baseFile.getTempFileId();
        String compareFileUrl = compareFile.getUrl();
        String compareTempFileId = compareFile.getTempFileId();
        FileService attachmentFileService = FileServiceFactory.getAttachmentFileService();
        baseFile.setTempFileId(LocalTempFileCache.updateTempFileId(baseTempFileId, baseFileUrl, FileValidTypeEnum.BASE, attachmentFileService));
        compareFile.setTempFileId(LocalTempFileCache.updateTempFileId(compareTempFileId, compareFileUrl, FileValidTypeEnum.COMPARISON, attachmentFileService));
        String countKey = UUID.randomUUID().toString();
        HashMap<String, AlgoPageNumAndFileIdVO> validMap = new HashMap<String, AlgoPageNumAndFileIdVO>();
        try {
            TdaUtils.validFileParam(baseFile, compareFile, validMap);
            if (validMap.isEmpty()) {
                throw new KDBizException(new ErrorCode("40000", ResManager.loadKDString((String)"\u83b7\u53d6\u6587\u4ef6\u9875\u6570\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"TdaUtils_027", (String)KEY_COMMON, (Object[])new Object[0])), new Object[0]);
            }
            ignoreList = TdaUtils.getIgnoreItemScore(planId);
        }
        catch (KDBizException kde) {
            LOGGER.error("\u4e1a\u52a1\u5f02\u5e38\uff1a", (Throwable)kde);
            String message = ResManager.loadKDString((String)"\u53c2\u6570\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u5c1d\u8bd5\u3002\u82e5\u591a\u6b21\u51fa\u73b0\u672c\u63d0\u793a\uff0c\u8bf7\u68c0\u67e5\u65e5\u5fd7\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"TdaUtils_025", (String)KEY_COMMON, (Object[])new Object[0]);
            ErrorCode errorCode = kde.getErrorCode();
            if (kd.bos.util.StringUtils.isNotEmpty((String)errorCode.getMessage())) {
                message = errorCode.getMessage();
            }
            view.showTipNotification(message);
            OcrControlUtils.setTdaOrTieCustomcontrolData(view, "customtda", "tdaBreakOff", Boolean.TRUE);
            return;
        }
        catch (Exception e) {
            LOGGER.error("\u53c2\u6570\u6821\u9a8c\u5f02\u5e38", (Throwable)e);
            view.showTipNotification(e.getMessage());
            OcrControlUtils.setTdaOrTieCustomcontrolData(view, "customtda", "tdaBreakOff", Boolean.TRUE);
            return;
        }
        if (isSave) {
            try {
                boolean status = TdaUtils.preCheckLicense(countKey, validMap);
                LOGGER.info("\u8bb8\u53ef\u6821\u9a8c\u7ed3\u679c\uff1a" + status + " \uff08\u6ce8\uff1atrue\u4e3a\u8bb8\u53ef\u6821\u9a8c\u901a\u8fc7\u4e14\u6d41\u91cf\u6821\u9a8c\u901a\u8fc7\uff0cfalse\u4e3a\u8bb8\u53ef\u6821\u9a8c\u5f02\u5e38\uff09\u3002");
                if (!status) {
                    OcrControlUtils.setTdaOrTieCustomcontrolData(view, "customtda", "startComparison", VALID_LICENSE_ERROR);
                    return;
                }
            }
            catch (KDBizException e) {
                LOGGER.error("\u8bb8\u53ef\u6821\u9a8c\u5f02\u5e38", (Throwable)e);
                view.showTipNotification(e.getMessage());
                OcrControlUtils.setTdaOrTieCustomcontrolData(view, "customtda", "startComparison", VALID_LICENSE_ERROR);
                return;
            }
        }
        AlgoPageNumAndFileIdVO baseVO = (AlgoPageNumAndFileIdVO)validMap.get("baseFile");
        AlgoPageNumAndFileIdVO compareVO = (AlgoPageNumAndFileIdVO)validMap.get("compareFile");
        CustomControl customcontrol = (CustomControl)view.getControl("customtda");
        HashMap<String, String> toWeb = new HashMap<String, String>(2);
        try (InputStream baseIn = CvpFileServiceUtils.getFileIn(StorageTypeEnum.TMP, baseFile.getTempFileId());
             InputStream compareIn = CvpFileServiceUtils.getFileIn(StorageTypeEnum.TMP, compareFile.getTempFileId());){
            if (baseIn == null || compareIn == null) {
                throw new KDBizException("\u7cfb\u7edf\u5f02\u5e38\uff0c\u83b7\u53d6\u6587\u4ef6\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002");
            }
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
            multipartEntityBuilder.setCharset(StandardCharsets.UTF_8);
            multipartEntityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            multipartEntityBuilder.addTextBody("businessConfig", businessConfig);
            multipartEntityBuilder.addTextBody("sourceType", "cvp");
            multipartEntityBuilder.addTextBody("ignoreItem", JSON.toJSONString(ignoreList));
            multipartEntityBuilder.addTextBody("resultTime", "true");
            if (Objects.isNull(baseVO.getFileId())) {
                LOGGER.info("\u6e90\u6587\u4ef6\u4f20\u9012\u6587\u4ef6\u6d41...");
                multipartEntityBuilder.addBinaryBody("originalFile", baseIn, ContentType.MULTIPART_FORM_DATA, baseFile.getFileName());
            } else {
                multipartEntityBuilder.addTextBody("originalFileId", baseVO.getFileId() + "");
            }
            if (Objects.isNull(compareVO.getFileId())) {
                LOGGER.info("\u6bd4\u5bf9\u6587\u4ef6\u4f20\u9012\u6587\u4ef6\u6d41...");
                multipartEntityBuilder.addBinaryBody("compareFile", compareIn, ContentType.MULTIPART_FORM_DATA, compareFile.getFileName());
            } else {
                multipartEntityBuilder.addTextBody("compareFileId", compareVO.getFileId() + "");
            }
            HttpEntity httpEntity = multipartEntityBuilder.build();
            LOGGER.info("TDA \u521b\u5efa\u5206\u6790\u4efb\u52a1");
            long startTime = System.currentTimeMillis();
            String resultStr = OcrHttpClientUtils.kdCloudHttpClientPost("/vrsp/doc/createTask", httpEntity);
            long endTime = System.currentTimeMillis();
            LOGGER.info(String.format("TDA \u521b\u5efa\u5206\u6790\u4efb\u52a1\u5b8c\u6210,\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\uff1a%s", resultStr));
            AlgoResultData resultData = (AlgoResultData)JSON.parseObject((String)resultStr, AlgoResultData.class);
            Object data = resultData.getData();
            Object taskId = null;
            Object createTime = null;
            if (data == null) {
                throw new KDBizException("\u521b\u5efa\u6587\u6863\u5dee\u5f02\u5206\u6790\u4efb\u52a1\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002");
            }
            JSONObject createTaskObj = JSON.parseObject((String)String.valueOf(data));
            taskId = createTaskObj.get((Object)"taskId");
            createTime = createTaskObj.get((Object)"createTime");
            toWeb.put("startComparison", String.valueOf(taskId));
            if (isSave) {
                FormShowParameter showParameter = view.getFormShowParameter();
                String parentPageId = (String)showParameter.getCustomParam("pageId");
                Object billId = showParameter.getCustomParam("billid");
                String billKey = (String)showParameter.getCustomParam("businessobject");
                String billNumber = (String)showParameter.getCustomParam("tda_bill_number");
                String billName = (String)showParameter.getCustomParam("tda_bill_name");
                QFilter filter = new QFilter("businessobject", "=", (Object)billKey);
                DynamicObject tdaPlan = BusinessDataServiceHelper.loadSingleFromCache((String)"cvp_tda_plan", (QFilter[])new QFilter[]{filter});
                if (!kd.bos.util.StringUtils.isEmpty((String)parentPageId) && view.getViewNoPlugin(parentPageId) != null) {
                    IDataModel parentModel = view.getViewNoPlugin(parentPageId).getModel();
                    DynamicObject parentObj = BusinessDataServiceHelper.loadSingle((Object)parentModel.getDataEntity().getPkValue(), (DynamicObjectType)parentModel.getDataEntityType());
                    billId = parentObj.getPkValue();
                    billKey = parentObj.getDataEntityType().getName();
                    billNumber = CommonUtil.getBillNumber(parentObj);
                    billName = CommonUtil.getBillName(parentObj);
                }
                OcrControlUtils.saveApiInfo("D", resultData.getErrorCode(), tdaPlan.getPkValue(), tdaPlan.getString("name"), endTime - startTime, RequestContext.get(), billKey, taskId);
                String planName = tdaPlan.getString("name");
                DynamicObject busObj = tdaPlan.getDynamicObject("businessobject");
                DynamicObject historyTask = BusinessDataServiceHelper.newDynamicObject((String)"cvp_tda_task_history");
                historyTask.set("billid", billId);
                historyTask.set("billno", (Object)billNumber);
                historyTask.set("billname", (Object)billName);
                historyTask.set("billcreaterid", (Object)RequestContext.get().getCurrUserId());
                historyTask.set("billvalid", (Object)"1");
                historyTask.set("billcreatedate", (Object)(createTime != null ? new Date((Long)createTime) : new Date()));
                historyTask.set("billoriginaldoc", (Object)baseFile.getFileName());
                historyTask.set("billcomparedoc", (Object)compareFile.getFileName());
                historyTask.set("billoriginaldocpath", (Object)baseFileUrl);
                historyTask.set("billcomparedocpath", (Object)compareFileUrl);
                historyTask.set("billstatus", (Object)"running");
                historyTask.set("taskid", taskId);
                historyTask.set("planname", (Object)planName);
                historyTask.set("businessobj", (Object)busObj);
                int basePageNum = baseVO.getPageNum();
                int comparePageNum = compareVO.getPageNum();
                LOGGER.info("basePageNum:{},comparePageNum:{}", (Object)basePageNum, (Object)comparePageNum);
                historyTask.set("totalpage", (Object)(basePageNum + comparePageNum));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{historyTask});
                TdaUtils.setTracIdAndTaskId(String.valueOf(taskId), countKey);
                TdaFlushDataExcutors.excuteTask(RequestContext.get());
            } else {
                IPageCache pageCache = view.getPageCache();
                String pageId = pageCache.getPageId();
                pageCache.put("tdaTestTaskId_".concat(pageId), taskId != null ? taskId.toString() : "");
            }
            customcontrol.setData(toWeb);
        }
    }

    private static List<String> getIgnoreItemScore(String planId) {
        ArrayList<String> list = new ArrayList<String>();
        DynamicObject planObj = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(planId), (String)"cvp_tda_plan", (String)"id,number,mulignore");
        if (planObj == null) {
            throw new KDBizException(new ErrorCode("30014", "\u7cfb\u7edf\u5f02\u5e38\uff0c\u65b9\u6848\u83b7\u53d6\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002"), new Object[0]);
        }
        String mulignore = planObj.getString("mulignore");
        if (kd.bos.util.StringUtils.isNotEmpty((String)mulignore)) {
            List<Integer> vals = Arrays.stream(mulignore.split(",")).filter(kd.bos.util.StringUtils::isNotEmpty).map(Integer::parseInt).collect(Collectors.toList());
            list.addAll(TdaPlanIgnore.getEntityStrListByValue(vals));
        }
        return list;
    }

    private static boolean preCheckLicense(String countKey, Map<String, AlgoPageNumAndFileIdVO> validMap) {
        int total = 1;
        if (validMap.isEmpty()) {
            throw new KDBizException(new ErrorCode("40000", ResManager.loadKDString((String)"\u83b7\u53d6\u6587\u4ef6\u9875\u6570\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"TdaUtils_027", (String)KEY_COMMON, (Object[])new Object[0])), new Object[0]);
        }
        AlgoPageNumAndFileIdVO baseVO = validMap.get("baseFile");
        AlgoPageNumAndFileIdVO compareVO = validMap.get("compareFile");
        int basePageNum = baseVO.getPageNum();
        int comparePageNum = compareVO.getPageNum();
        if (basePageNum < 1 || comparePageNum < 1) {
            throw new KDBizException(new ErrorCode("40000", ResManager.loadKDString((String)"\u83b7\u53d6\u6587\u4ef6\u9875\u6570\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"TdaUtils_027", (String)KEY_COMMON, (Object[])new Object[0])), new Object[0]);
        }
        LOGGER.info("baseNum:{},compareNum:{}", (Object)basePageNum, (Object)comparePageNum);
        total = basePageNum + comparePageNum;
        return LicenseUtils.checkLicense(total, LicenseCountServiceNameEnum.TDA_SERVICE_FOR_PDF.getName(), countKey);
    }

    private static void validFileParam(StartComparisonFile baseFile, StartComparisonFile compareFile, Map<String, AlgoPageNumAndFileIdVO> resultMap) throws Exception {
        if (baseFile == null || compareFile == null) {
            throw new KDBizException(new ErrorCode("40002", ResManager.loadKDString((String)"\u539f\u6587\u6863\u6216\u6bd4\u5bf9\u6587\u6863\u4e3a\u7a7a\uff0c\u8bf7\u4e0a\u4f20\u540e\u518d\u8bd5\uff01", (String)"TdaUtils_0010", (String)KEY_COMMON, (Object[])new Object[0])), new Object[0]);
        }
        String baseUrl = baseFile.getUrl();
        String baseFileName = baseFile.getFileName();
        String baseTempFileId = baseFile.getTempFileId();
        String compareUrl = compareFile.getUrl();
        String compareFileName = compareFile.getFileName();
        String compareTempFileId = compareFile.getTempFileId();
        if (kd.bos.util.StringUtils.isEmpty((String)baseUrl) || kd.bos.util.StringUtils.isEmpty((String)compareUrl) || kd.bos.util.StringUtils.isEmpty((String)baseFileName) || kd.bos.util.StringUtils.isEmpty((String)compareFileName)) {
            throw new KDBizException(new ErrorCode("40002", ResManager.loadKDString((String)"\u6821\u9a8c\u5931\u8d25\uff0c\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"TdaUtils_0011", (String)KEY_COMMON, (Object[])new Object[0])), new Object[0]);
        }
        HashMap errorMap = new HashMap();
        ThreadPool threadPool = ThreadUtils.get();
        CountDownLatch cd = new CountDownLatch(2);
        String baseErrorKey = "baseError";
        threadPool.submit(() -> {
            try {
                AlgoPageNumAndFileIdVO algoPageNumAndFileIdVO = CommonUtil.fileValid(baseTempFileId, baseFileName, FileValidTypeEnum.BASE, "jpg,jpeg,png,bmp,pdf,doc,docx,ofd,wps", 0xC800000L, 500);
                resultMap.put("baseFile", algoPageNumAndFileIdVO);
            }
            catch (KDBizException ke) {
                LOGGER.error("bizException:", (Throwable)ke);
                errorMap.put(baseErrorKey, ke.getErrorCode());
            }
            catch (Exception e) {
                LOGGER.error("\u672a\u77e5\u5f02\u5e38\uff1a", (Throwable)e);
                String message = e.getMessage();
                String errorCode = "30113";
                ErrorCode errorCode1 = new ErrorCode(errorCode, message);
                errorMap.put(baseErrorKey, errorCode1);
            }
            finally {
                cd.countDown();
            }
            return null;
        }, RequestContext.get());
        String compareErrorKey = "compareError";
        threadPool.submit(() -> {
            try {
                AlgoPageNumAndFileIdVO algoPageNumAndFileIdVO = CommonUtil.fileValid(compareTempFileId, compareFileName, FileValidTypeEnum.COMPARISON, "jpg,jpeg,png,bmp,pdf,doc,docx,ofd,wps", 0xC800000L, 500);
                resultMap.put("compareFile", algoPageNumAndFileIdVO);
            }
            catch (KDBizException ke) {
                LOGGER.error("bizException:", (Throwable)ke);
                errorMap.put(compareErrorKey, ke.getErrorCode());
            }
            catch (Exception e) {
                LOGGER.error("\u672a\u77e5\u5f02\u5e38\uff1a", (Throwable)e);
                String message = e.getMessage();
                String errorCode = "30113";
                ErrorCode errorCode1 = new ErrorCode(errorCode, message);
                errorMap.put(compareErrorKey, errorCode1);
            }
            finally {
                cd.countDown();
            }
            return null;
        }, RequestContext.get());
        cd.await();
        if (!errorMap.isEmpty()) {
            ErrorCode baseErrorCode = (ErrorCode)errorMap.get(baseErrorKey);
            if (baseErrorCode != null) {
                LOGGER.error("\u5f02\u5e38code:{},message:{}", (Object)baseErrorCode.getCode(), (Object)baseErrorCode.getMessage());
                throw new KDBizException(baseErrorCode, new Object[0]);
            }
            ErrorCode compareErrorCode = (ErrorCode)errorMap.get(compareErrorKey);
            if (compareErrorCode != null) {
                LOGGER.error("\u5f02\u5e38code:{},message:{}", (Object)compareErrorCode.getCode(), (Object)compareErrorCode.getMessage());
                throw new KDBizException(compareErrorCode, new Object[0]);
            }
        }
        CommonUtil.md5SumValid(baseTempFileId, compareTempFileId);
    }

    private static void setTracIdAndTaskId(String taskId, String traceId) {
        boolean cvprn_License = LicenseServiceHelper.checkPerformGroup((String)"PROCVPRN").getHasLicense();
        String productVersion = LicenseServiceHelper.getProductVersion();
        if ("1.0".equalsIgnoreCase(productVersion) || !cvprn_License) {
            return;
        }
        IAppCache appCache = AppCache.get((String)"ai-cvp");
        appCache.put(taskId, (Object)traceId);
    }

    public static void refreshCache(String taskId) {
        boolean hasRDLicense = LicenseUtils.checkHasRDLicense();
        if (!hasRDLicense) {
            boolean cvprn_License = LicenseServiceHelper.checkPerformGroup((String)"PROCVPRN").getHasLicense();
            String productVersion = LicenseServiceHelper.getProductVersion();
            if ("1.0".equalsIgnoreCase(productVersion) || !cvprn_License) {
                return;
            }
            RequestContext rc = RequestContext.get();
            String tenantCode = rc.getTenantCode();
            String tenantName = rc.getTenantInfo().getName();
            Map productInfo = LicenseServiceHelper.getProductInfo();
            String productID = (String)productInfo.get("productID");
            LOGGER.info("\u5237\u65b0\u7f13\u5b58\u65f6\u95f4\u3002\u3002\u3002");
            LicenseUtils.refreshPresetNumInCache(tenantCode, tenantName, productID, taskId);
        }
    }

    public static void execNotRunningTask(TdaBatchTaskInfoResult.BatchTaskInfoVO taskInfoVO) {
        String taskId = taskInfoVO.getTaskId();
        try {
            DBRoute dbRoute = DBRoute.of((String)"aidb");
            boolean isSuc = false;
            if ("success".equals(taskInfoVO.getStatus())) {
                isSuc = true;
                taskInfoVO.setProgress(ResManager.loadKDString((String)"\u6bd4\u5bf9\u5b8c\u6210", (String)"TdaUtils_001", (String)KEY_COMMON, (Object[])new Object[0]));
                TdaUtils.updateSuc(taskInfoVO, dbRoute);
            } else if ("error".equals(taskInfoVO.getStatus())) {
                TdaUtils.updateFailed(taskInfoVO, dbRoute, true);
            } else if ("cancel".equals(taskInfoVO.getStatus())) {
                TdaUtils.updateFailed(taskInfoVO, dbRoute, false);
            }
            LicenseUtils.ensureCallNumToAlgoAsync(isSuc, taskId, SourceTypeEnum.FILEDIFFERENCE);
        }
        catch (KDBizException e) {
            LOGGER.error("\u6267\u884c\u4efb\u52a1\u7684\u5b8c\u6bd5\u5904\u7406\u65f6\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u6b64\u5904\u3002", (Throwable)e);
            LicenseUtils.ensureCallNumToAlgoAsync(false, taskId, SourceTypeEnum.FILEDIFFERENCE);
        }
    }

    public static void batchUpdateTdaTasks(List<TdaBatchTaskInfoResult.BatchTaskInfoVO> runningTasks) {
        List taskList;
        QFilter taskIdFilter;
        Object[] taskObjArr;
        if (runningTasks != null && !runningTasks.isEmpty() && (taskObjArr = BusinessDataServiceHelper.load((String)"cvp_tda_task_history", (String)"id,taskid,billstatus,progressinfo", (QFilter[])new QFilter[]{taskIdFilter = new QFilter("taskid", "in", taskList = runningTasks.stream().map(TdaBatchTaskInfoResult.BatchTaskInfoVO::getTaskId).collect(Collectors.toList()))})) != null && taskObjArr.length > 0) {
            IDataEntityType dataEntityType = taskObjArr[0].getDataEntityType();
            runningTasks.forEach(arg_0 -> TdaUtils.lambda$batchUpdateTdaTasks$3((DynamicObject[])taskObjArr, arg_0));
            SaveServiceHelper.save((IDataEntityType)dataEntityType, (Object[])taskObjArr);
            LOGGER.info("\u66f4\u65b0\u4efb\u52a1\u8fdb\u5ea6\u4fe1\u606f\u7ed3\u675f\uff0c\u66f4\u65b0\u5217\u8868\uff1a{}", (Object)JSON.toJSONString(taskList));
        }
    }

    private static void updateFailed(TdaBatchTaskInfoResult.BatchTaskInfoVO taskInfo, DBRoute dbRoute, boolean clearProgress) {
        String sql = "update t_cvp_tda_comparison_task set fbillstatus=?,fbillenddate=?,fbilltdaresult=?,fprogressinfo=? where ftaskid=? and fbillstatus=?";
        String encode = CommonUtil.encryptString(SerializationUtils.toJsonString((Object)taskInfo));
        Object[] parmas = new Object[]{taskInfo.getStatus(), taskInfo.getEndDate(), encode, clearProgress ? "" : taskInfo.getProgress(), taskInfo.getTaskId(), "running"};
        DB.update((DBRoute)dbRoute, (String)sql, (Object[])parmas);
    }

    private static void updateSuc(TdaBatchTaskInfoResult.BatchTaskInfoVO taskInfo, DBRoute dbRoute) {
        List<String> zipFilePathList;
        List<ConversionAlgoInfo> baseImageList = taskInfo.getBaseImageList();
        List<ConversionAlgoInfo> compareImageList = taskInfo.getCompareImageList();
        String taskId = taskInfo.getTaskId();
        TdaUtils.updateDBAlert(taskId, dbRoute);
        ArrayList<ConversionAlgoInfo> conversionAlgoInfos = new ArrayList<ConversionAlgoInfo>();
        conversionAlgoInfos.addAll(baseImageList);
        conversionAlgoInfos.addAll(compareImageList);
        try {
            zipFilePathList = CommonUtil.batchUploadImagesNew(conversionAlgoInfos, taskId, false);
        }
        catch (Exception e) {
            LOGGER.error("\u6279\u91cf\u5904\u7406\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff0c\u7a0d\u540e\u91cd\u8bd5", (Throwable)e);
            return;
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                CommonUtil.batchSaveImages(baseImageList, taskId, "originalFile");
                CommonUtil.batchSaveImages(compareImageList, taskId, "compareFile");
                LOGGER.info("\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6bd5\uff0c\u5f00\u59cb\u66f4\u65b0\u4efb\u52a1\u72b6\u6001\u3002");
                TdaUtils.updateToTDADb(taskInfo, baseImageList, compareImageList, dbRoute);
            }
            catch (Exception e1) {
                h.markRollback();
                throw e1;
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5dee\u5f02\u5206\u6790\u4efb\u52a1\u72b6\u6001\u66f4\u65b0\u5931\u8d25\uff0c\u7b49\u5f85\u4e0b\u6b21\u66f4\u65b0\u5904\u7406\u3002", (Throwable)e);
        }
        try {
            CommonUtil.deleteZipAndTempFile(zipFilePathList);
        }
        catch (Exception e) {
            LOGGER.error("\u6e05\u7406\u7b97\u6cd5\u8c03\u5ea6\u4e34\u65f6\u6587\u4ef6\u548c\u538b\u7f29\u6587\u4ef6\u5f02\u5e38,\u4efb\u52a1id:{}", (Object)taskId, (Object)e);
        }
    }

    private static void updateDBAlert(String taskId, DBRoute dbRoute) {
        String sql = "update t_cvp_tda_comparison_task set fprogressinfo=? where ftaskid=? and fbillstatus=?";
        String progress = ResManager.loadKDString((String)"\u5b8c\u6210\u6bd4\u5bf9\uff0c\u6b63\u5728\u540c\u6b65\u5dee\u5f02\u70b9", (String)"TdaUtils_030", (String)KEY_COMMON, (Object[])new Object[0]);
        Object[] parmas = new Object[]{progress, taskId, "running"};
        DB.update((DBRoute)dbRoute, (String)sql, (Object[])parmas);
    }

    private static void updateToTDADb(TdaBatchTaskInfoResult.BatchTaskInfoVO taskInfo, List<ConversionAlgoInfo> baseImageWithPath, List<ConversionAlgoInfo> compareImageWithPath, DBRoute dbRoute) {
        DiffSummary diffSummary = (DiffSummary)JSON.parseObject((String)taskInfo.getSummary(), DiffSummary.class);
        BigDecimal similarity = diffSummary.getSimilarity();
        BigDecimal variationRate = new BigDecimal(1).subtract(similarity);
        List diffDetails = JSON.parseArray((String)taskInfo.getDetails(), DiffDetails.class);
        AlgoCompareData compareData = new AlgoCompareData(diffSummary, diffDetails, baseImageWithPath, compareImageWithPath);
        String encode = CommonUtil.encryptString(SerializationUtils.toJsonString((Object)compareData));
        String sql = "update t_cvp_tda_comparison_task set fbillstatus=?,fbillenddate=?,fdifnumber=?,fvariationrate=?,fbilltdaresult=?,fprogressinfo=? where ftaskid=? and fbillstatus=?";
        Object[] parmas = new Object[]{taskInfo.getStatus(), taskInfo.getEndDate(), diffSummary.getDiffSum(), variationRate, encode, taskInfo.getProgress(), taskInfo.getTaskId(), "running"};
        DB.update((DBRoute)dbRoute, (String)sql, (Object[])parmas);
    }

    public static void excuteQueryTask(IFormView view, String args) throws Exception {
        String opreateType = (String)view.getFormShowParameter().getCustomParam("tda_operate_type");
        long planId = (Long)view.getFormShowParameter().getCustomParam("tda_plan_id");
        JSONObject objMap = JSON.parseObject((String)args);
        String taskId = (String)objMap.get((Object)"taskId");
        LOGGER.info(String.format("TDA \u67e5\u8be2\u5dee\u5f02\u5206\u6790\u4efb\u52a1\uff0c\u4efb\u52a1ID\uff1a%s , \u4e1a\u52a1\u64cd\u4f5c\u7c7b\u578b\uff1a%s \uff0ctraceId\uff1a%s", taskId, opreateType, RequestContext.get().getTraceId()));
        CompareData compareData = "tda_test_task".equals(opreateType) ? TdaUtils.tdaTestDataTempSave(taskId, planId) : TdaUtils.tdaQueryDataByDb(taskId, planId);
        OcrControlUtils.setTdaOrTieCustomcontrolData(view, "customtda", "polling", compareData);
    }

    public static CompareData tdaQueryDataByDb(String taskId, long planId) {
        QFilter historyFilter = new QFilter("taskid", "=", (Object)taskId);
        DynamicObject taskInfo = TdaUtils.getTaskInfoByFilters(new QFilter[]{historyFilter});
        CompareData compareData = taskInfo != null ? TdaUtils.getCompareData(taskInfo, planId) : new CompareData(RequestContext.get().getTraceId(), taskId, "error");
        return compareData;
    }

    private static CompareData tdaTestDataTempSave(String taskId, long planId) throws Exception {
        ArrayList<OcrParam> params = new ArrayList<OcrParam>(2);
        params.add(new OcrParam("taskId", taskId));
        params.add(new OcrParam("resultIncludeFileContent", Boolean.FALSE));
        String resultQuery = OcrHttpClientUtils.kdCloudHttpClientGet("/vrsp/doc/queryCompareDataByTaskId", params);
        CompareResult compareResult = (CompareResult)JSON.parseObject((String)resultQuery, CompareResult.class);
        if (0 == compareResult.getErrorCode()) {
            CompareData compareData = compareResult.getData();
            if ("success".equals(compareData.getStatus())) {
                TdaUtils.updateDBAlert(taskId, DBRoute.of((String)"aidb"));
                AlgoCompareData algoCompareData = compareData.getCompareData();
                if (algoCompareData.getDiffSummary() != null) {
                    BigDecimal similarity = algoCompareData.getDiffSummary().getSimilarity();
                    algoCompareData.getDiffSummary().setVariationRate(new BigDecimal(1).subtract(similarity));
                }
                TdaUtils.setShowList(algoCompareData, planId);
                TdaUtils.batchTempUpload(taskId, "originalFile", algoCompareData.getBaseImageList());
                TdaUtils.batchTempUpload(taskId, "compareFile", algoCompareData.getCompareImageList());
            }
            return compareData;
        }
        return new CompareData(RequestContext.get().getTraceId(), taskId, "error");
    }

    private static void setShowList(AlgoCompareData algoCompareData, long planId) {
        DiffSummary diffSummary = algoCompareData.getDiffSummary();
        if (diffSummary != null) {
            diffSummary.setDiffShowList(new ArrayList<String>());
            DiffEntityVO diffEntityVO = new DiffEntityVO();
            diffEntityVO.setSupportEntity(false);
            diffEntityVO.setShowLevel2Detail(false);
            QFilter qFilter = new QFilter("id", "=", (Object)planId);
            DynamicObjectCollection objCol = QueryServiceHelper.query((String)"cvp_tda_plan", (String)"id,number,supportentity,showlevel2,entryentity.*", (QFilter[])new QFilter[]{qFilter}, (String)"entryentity.seq asc");
            ArrayList<TabInfo> diffShowList = new ArrayList<TabInfo>();
            if (objCol != null && !objCol.isEmpty()) {
                for (DynamicObject obj : objCol) {
                    boolean supportentity = obj.getBoolean("supportentity");
                    diffEntityVO.setSupportEntity(supportentity);
                    if (!supportentity) break;
                    diffEntityVO.setShowLevel2Detail(obj.getBoolean("showlevel2"));
                    TabInfo tabInfo = new TabInfo();
                    tabInfo.setType(obj.getString("entryentity.difftype"));
                    tabInfo.setShowName(obj.getString("entryentity.showname"));
                    diffShowList.add(tabInfo);
                }
                diffEntityVO.setSequenceObj(diffShowList);
            }
            diffSummary.setDiffShowListV2(diffEntityVO);
        }
    }

    public static DynamicObject getTaskInfoByFilters(QFilter[] historyFilters) {
        String selectFiled = String.format("%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s", "billoriginalimagespath", "billcompareimagespath", "billtdaresult", "billcomparedocpath", "billoriginaldocpath", "variationrate", "billstatus", "taskid", "billoriginaldoc", "billcomparedoc", "progressinfo");
        return QueryServiceHelper.queryOne((String)"cvp_tda_task_history", (String)selectFiled, (QFilter[])historyFilters);
    }

    private static CompareData getCompareData(DynamicObject historyTask, long planId) {
        String orImagePath = historyTask.getString("billoriginalimagespath");
        String cmImagePath = historyTask.getString("billcompareimagespath");
        String progressInfo = historyTask.getString("progressinfo");
        String historyResult = CommonUtil.decodeString(historyTask.getString("billtdaresult"));
        BigDecimal variationRate = historyTask.getBigDecimal("variationrate");
        String historyStatus = historyTask.getString("billstatus");
        String historyTaskId = historyTask.getString("taskid");
        CompareData compareData = new CompareData(RequestContext.get().getTraceId(), historyTaskId, historyStatus);
        if ("success".equals(historyStatus)) {
            AlgoCompareData algoCompareData = (AlgoCompareData)JSON.parseObject((String)historyResult, AlgoCompareData.class);
            if (StringUtils.isNotBlank((CharSequence)orImagePath) && StringUtils.isNotBlank((CharSequence)cmImagePath)) {
                String orJson = TdaUtils.netTxtFile2Json(orImagePath);
                String cmJson = TdaUtils.netTxtFile2Json(cmImagePath);
                List orImages = JSON.parseArray((String)orJson, ConversionAlgoInfo.class);
                List cmImages = JSON.parseArray((String)cmJson, ConversionAlgoInfo.class);
                algoCompareData.setBaseImageList(orImages);
                algoCompareData.setCompareImageList(cmImages);
            } else {
                DiffSummary diffSummary = algoCompareData.getDiffSummary();
                if (diffSummary != null) {
                    diffSummary.setVariationRate(variationRate);
                    algoCompareData.setDiffSummary(diffSummary);
                    if (planId != 0L) {
                        TdaUtils.setShowList(algoCompareData, planId);
                    }
                }
                TdaUtils.getAlgoComareDataImageURL(historyTaskId, algoCompareData);
            }
            compareData.setCompareData(algoCompareData);
            compareData.setProgress("\u6bd4\u5bf9\u5b8c\u6210");
        } else if ("error".equals(historyStatus)) {
            CompareData compareDataAlgo = (CompareData)JSON.parseObject((String)historyResult, CompareData.class);
            if (compareDataAlgo != null) {
                compareData = compareDataAlgo;
                compareData.setTraceId(RequestContext.get().getTraceId());
            } else {
                compareData.setProgress("\u5dee\u5f02\u5206\u6790\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u8054\u7ba1\u7406\u5458");
            }
        } else {
            if (kd.bos.util.StringUtils.isEmpty((String)progressInfo)) {
                progressInfo = "\u6bd4\u5bf9\u5206\u6790\u4e2d\uff0c\u8bf7\u7a0d\u540e";
            }
            compareData.setProgress(progressInfo);
        }
        return compareData;
    }

    private static void getAlgoComareDataImageURL(String historyTaskId, AlgoCompareData algoCompareData) {
        String selectFile = "imageid,imagepath,imagewidth,imageheight,pagenum";
        String oderBys = "pagenum asc";
        QFilter oriFilter = new QFilter("taskid", "=", (Object)historyTaskId).and("sourcefiletype", "=", (Object)"originalFile");
        QFilter comFilter = new QFilter("taskid", "=", (Object)historyTaskId).and("sourcefiletype", "=", (Object)"compareFile");
        DynamicObjectCollection oris = QueryServiceHelper.query((String)"cvp_tda_task_image", (String)selectFile, (QFilter[])new QFilter[]{oriFilter}, (String)oderBys);
        DynamicObjectCollection coms = QueryServiceHelper.query((String)"cvp_tda_task_image", (String)selectFile, (QFilter[])new QFilter[]{comFilter}, (String)oderBys);
        List<ConversionAlgoInfo> oriConversion = oris.stream().map(o -> new ConversionAlgoInfo(o.getLong("imageid"), CommonUtil.getAccountUrl(UrlService.getImageFullUrl((String)o.getString("imagepath"))), o.getInt("imagewidth"), o.getInt("imageheight"), o.getInt("pagenum"))).collect(Collectors.toList());
        List<ConversionAlgoInfo> comConversion = coms.stream().map(o -> new ConversionAlgoInfo(o.getLong("imageid"), CommonUtil.getAccountUrl(UrlService.getImageFullUrl((String)o.getString("imagepath"))), o.getInt("imagewidth"), o.getInt("imageheight"), o.getInt("pagenum"))).collect(Collectors.toList());
        algoCompareData.setBaseImageList(oriConversion);
        algoCompareData.setCompareImageList(comConversion);
    }

    private static StartComparison getTdaStartComparison(DynamicObject historyTask) {
        String orName = historyTask.getString("billoriginaldoc");
        String orPath = CommonUtil.getAccountUrl(historyTask.getString("billcomparedocpath"));
        String cmName = historyTask.getString("billcomparedoc");
        String cmPath = CommonUtil.getAccountUrl(historyTask.getString("billoriginaldocpath"));
        return new StartComparison(new StartComparisonFile(orPath, orName), new StartComparisonFile(cmPath, cmName));
    }

    public static void tdaCustomOpreat(IFormView view, String eventName, String args) {
        LOGGER.info(String.format("TDA \u81ea\u5b9a\u4e49\u63a7\u4ef6\u64cd\u4f5c - \u5f53\u524d\u64cd\u4f5c\u7c7b\u578b \uff1a%s", eventName));
        if (OcrControlUtils.checkWebStatus(view, eventName, args)) {
            return;
        }
        try {
            if ("validBaseFile".equals(eventName) || "validCompareFile".equals(eventName)) {
                CommonUtil.validSelectedFile(view, args, "customtda", eventName, VisualTypeEnum.DIFF_COMPARISON);
            } else if ("startComparison".equals(eventName)) {
                TdaUtils.createTask(view, args);
            } else if ("polling".equals(eventName)) {
                TdaUtils.excuteQueryTask(view, args);
            } else if ("init".equals(eventName)) {
                TdaUtils.initCustom(view);
            } else if ("getAttachmentList".equals(eventName)) {
                CommonUtil.createAttachmentList(view, args, "customtda", "getAttachmentList", TdaCommon.Tda.TDA_FILTER_TYPES);
            } else if ("getHistoricalDataList".equals(eventName)) {
                long billid = Long.parseLong(args);
                List<TdaOneHistory> tdahistorys = TdaUtils.getTdaHistoriesByBillId(billid);
                OcrControlUtils.setTdaOrTieCustomcontrolData(view, "customtda", "getHistoricalDataList", tdahistorys);
            } else if ("getHistoricalDetailById".equals(eventName)) {
                long planId;
                long fid = Long.parseLong(args);
                TdaOneTaskInfo oneTaskInfo = TdaUtils.getTdaOneTaskInfo(fid, planId = ((Long)view.getFormShowParameter().getCustomParam("tda_plan_id")).longValue());
                if (oneTaskInfo == null) {
                    String message = ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u53d6\u6d88\uff0c\u8bf7\u786e\u5b9a\u8be5\u6bd4\u5bf9\u4efb\u52a1\u7684\u72b6\u6001\u540e\u518d\u8bd5\u3002", (String)"TdaInfoPlugin_1", (String)KEY_COMMON, (Object[])new Object[0]);
                    LOGGER.info(String.format("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u5dee\u5f02\u5206\u6790\uff0c%s", message));
                    view.showTipNotification(message);
                    OcrControlUtils.setTdaOrTieCustomcontrolData(view, "customtda", "tdaBreakOff", Boolean.TRUE);
                    return;
                }
                OcrControlUtils.setTdaOrTieCustomcontrolData(view, "customtda", "getHistoricalDetailById", oneTaskInfo);
            } else if ("deleteHistoricalDetailById".equals(eventName)) {
                TdaUtils.delTdaHistory(view, args);
            } else if ("cancelComparison".equals(eventName)) {
                TdaUtils.cancelTdaTask(view, args, "customtda", eventName);
            }
        }
        catch (Exception ex) {
            view.showErrMessage(ex.getMessage(), ResManager.loadKDString((String)"\u6587\u6863\u5dee\u5f02\u5206\u6790\u5f02\u5e38:", (String)"TdaInfoPlugin_0", (String)KEY_COMMON, (Object[])new Object[0]));
            LOGGER.error(" \u81ea\u5b9a\u4e49\u5dee\u5f02\u5206\u6790 \u63a7\u4ef6 \u64cd\u4f5c\u7801: " + eventName + "\u6587\u6863\u5dee\u5f02\u5206\u6790\u5f02\u5e38: " + ex.getMessage(), (Throwable)ex);
            String traceId = RequestContext.get().getTraceId();
            LicenseUtils.ensureCallNumToAlgo(false, traceId, SourceTypeEnum.FILEDIFFERENCE);
            OcrControlUtils.setTdaOrTieCustomcontrolData(view, "customtda", "tdaBreakOff", Boolean.TRUE);
        }
    }

    private static void cancelTdaTask(IFormView view, String args, String selfControlName, String commandStr) throws Exception {
        if (kd.bos.util.StringUtils.isEmpty((String)args)) {
            String tips = ResManager.loadKDString((String)"\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"TdaUtils_009", (String)KEY_COMMON, (Object[])new Object[0]);
            view.showTipNotification(tips);
            OcrControlUtils.setTdaOrTieCustomcontrolData(view, selfControlName, commandStr, "");
            return;
        }
        TdaCancelTaskVO tdaCancelTaskVO = (TdaCancelTaskVO)JSON.parseObject((String)args, TdaCancelTaskVO.class);
        if (tdaCancelTaskVO == null || kd.bos.util.StringUtils.isEmpty((String)tdaCancelTaskVO.getFid()) && kd.bos.util.StringUtils.isEmpty((String)tdaCancelTaskVO.getTaskId())) {
            LOGGER.info("\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a...");
            String tips = ResManager.loadKDString((String)"\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"TdaUtils_009", (String)KEY_COMMON, (Object[])new Object[0]);
            view.showTipNotification(tips);
            OcrControlUtils.setTdaOrTieCustomcontrolData(view, selfControlName, commandStr, "");
            return;
        }
        String taskId = tdaCancelTaskVO.getTaskId();
        String fid = tdaCancelTaskVO.getFid();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (kd.bos.util.StringUtils.isNotEmpty((String)fid)) {
            filters.add(new QFilter("id", "=", (Object)Long.parseLong(fid)));
        } else if (kd.bos.util.StringUtils.isNotEmpty((String)taskId)) {
            filters.add(new QFilter("taskid", "=", (Object)taskId));
        }
        if (filters.isEmpty()) {
            String tips = ResManager.loadKDString((String)"\u53d6\u6d88\u4efb\u52a1\u5931\u8d25\uff0c\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"TdaUtils_010", (String)KEY_COMMON, (Object[])new Object[0]);
            view.showTipNotification(tips);
            OcrControlUtils.setTdaOrTieCustomcontrolData(view, selfControlName, commandStr, "");
            return;
        }
        DynamicObject taskObj = BusinessDataServiceHelper.loadSingle((String)"cvp_tda_task_history", (String)"id,taskid,billstatus,progressinfo,billenddate", (QFilter[])filters.toArray(new QFilter[0]));
        if (taskObj == null) {
            String noTaskTips = ResManager.loadKDString((String)"\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e\u540e\u91cd\u8bd5\u3002", (String)"TdaUtils_010", (String)KEY_COMMON, (Object[])new Object[0]);
            view.showTipNotification(noTaskTips);
            OcrControlUtils.setTdaOrTieCustomcontrolData(view, selfControlName, commandStr, "");
            return;
        }
        taskId = taskObj.getString("taskid");
        if (kd.bos.util.StringUtils.isEmpty((String)taskId)) {
            LOGGER.error("\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002");
            String noTaskTips = ResManager.loadKDString((String)"\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e\u540e\u91cd\u8bd5\u3002", (String)"TdaUtils_010", (String)KEY_COMMON, (Object[])new Object[0]);
            view.showTipNotification(noTaskTips);
            OcrControlUtils.setTdaOrTieCustomcontrolData(view, selfControlName, commandStr, "");
            return;
        }
        String billstatus = taskObj.getString("billstatus");
        if (!"running".equals(billstatus)) {
            LOGGER.error("\u975e\u8fd0\u884c\u4e2d\u7684\u4efb\u52a1\uff0c\u65e0\u6cd5\u53d6\u6d88\u3002");
            view.showTipNotification(ResManager.loadKDString((String)"\u975e\u8fd0\u884c\u4e2d\u7684\u4efb\u52a1\uff0c\u65e0\u6cd5\u53d6\u6d88\u3002", (String)"TdaUtils_021", (String)KEY_COMMON, (Object[])new Object[0]));
            OcrControlUtils.setTdaOrTieCustomcontrolData(view, selfControlName, commandStr, "");
            return;
        }
        try {
            TdaCancelTaskResultVO resultVO = CommonUtil.cancelTask(taskId, LicenseCountServiceNameEnum.TDA_SERVICE_FOR_PDF, SourceTypeEnum.FILEDIFFERENCE);
            if (resultVO == null || !resultVO.getCancelResult()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53d6\u6d88\u4efb\u52a1\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TdaUtils_035", (String)KEY_COMMON, (Object[])new Object[0]));
            }
            int usedCount = resultVO.getUsedNum();
            TdaUtils.updateDB(taskObj, resultVO);
            view.showSuccessNotification(ResManager.loadKDString((String)String.format("\u53d6\u6d88\u4efb\u52a1\u6210\u529f\uff0c\u4efb\u52a1\u7f16\u7801\uff1a%s\uff0c\u5f53\u524d\u5df2\u8bc6\u522b\u9875\u6570\uff1a%d\uff0c\u5df2\u8bc6\u522b\u7684\u9875\u6570\u5df2\u8ba1\u5165\u8bb8\u53ef\u6d88\u8017\u6570\u91cf\u4e2d\u3002", taskId, usedCount), (String)"TdaUtils_013", (String)KEY_COMMON, (Object[])new Object[0]));
        }
        catch (KDBizException ke) {
            LOGGER.error("\u53d6\u6d88\u4efb\u52a1\u5931\u8d25\u3002", (Throwable)ke);
            String message = ke.getMessage();
            if (kd.bos.util.StringUtils.isEmpty((String)message)) {
                message = ResManager.loadKDString((String)"\u53d6\u6d88\u5931\u8d25\uff0c\u82e5\u4efb\u52a1\u8fd8\u672a\u505c\u6b62\uff0c\u8bf7\u518d\u6b21\u5c1d\u8bd5\u3002", (String)"TdaUtils_014", (String)KEY_COMMON, (Object[])new Object[0]);
            }
            view.showTipNotification(message);
        }
        catch (Exception e) {
            LOGGER.error("\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u3002", (Throwable)e);
            view.showTipNotification(ResManager.loadKDString((String)"\u672a\u77e5\u5f02\u5e38\uff0c\u82e5\u4efb\u52a1\u8fd8\u672a\u505c\u6b62\uff0c\u8bf7\u518d\u6b21\u5c1d\u8bd5\u3002\u82e5\u591a\u6b21\u51fa\u73b0\u672c\u63d0\u793a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"TdaUtils_015", (String)KEY_COMMON, (Object[])new Object[0]));
            LicenseUtils.ensureCallNumToAlgoAsync(false, taskId, SourceTypeEnum.FILEDIFFERENCE);
        }
        OcrControlUtils.setTdaOrTieCustomcontrolData(view, selfControlName, commandStr, "");
    }

    private static void updateDB(DynamicObject taskObj, TdaCancelTaskResultVO resultVO) {
        int totalCount = resultVO.getTotalNum();
        int usedCount = resultVO.getUsedNum();
        taskObj.set("billstatus", (Object)"cancel");
        taskObj.set("billenddate", (Object)new Date());
        taskObj.set("progressinfo", (Object)String.format("\u5171%s\u9875\uff0c\u5df2\u8bc6\u522b  %s  \u9875\uff0c\u8bf7\u7a0d\u5019...", totalCount, usedCount));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskObj});
    }

    private static void validTdaFileExist(StartComparisonFile file, FileValidTypeEnum typeEnum, Map<String, Object> resultMap) {
        String fileUrl = file.getUrl();
        String fileId = file.getTempFileId();
        FileService attachmentFileService = FileServiceFactory.getAttachmentFileService();
        String newTempFileId = LocalTempFileCache.updateTempFileId(fileId, fileUrl, typeEnum, attachmentFileService);
        file.setTempFileId(newTempFileId);
        if (!fileId.equals(newTempFileId)) {
            resultMap.put(typeEnum == FileValidTypeEnum.BASE ? "baseTempFileId" : "compareTempFileId", newTempFileId);
        } else {
            resultMap.put(typeEnum == FileValidTypeEnum.BASE ? "baseTempFileId" : "compareTempFileId", "");
        }
    }

    private static void delTdaHistory(IFormView view, String args) {
        TdaTaskDelVO result;
        String selectField = "taskid,billstatus,billoriginaldocpath,billoriginalimagespath,billcomparedocpath,billcompareimagespath";
        long fid = Long.parseLong(args);
        QFilter q = new QFilter("id", "=", (Object)fid);
        DynamicObject histotryObj = QueryServiceHelper.queryOne((String)"cvp_tda_task_history", (String)selectField, (QFilter[])new QFilter[]{q});
        if (null != histotryObj) {
            String status = histotryObj.getString("billstatus");
            if ("running".equals(status)) {
                String message = ResManager.loadKDString((String)"\u6587\u6863\u6bd4\u5bf9\u4efb\u52a1\u8fdb\u884c\u4e2d\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"TdaInfoPlugin_2", (String)KEY_COMMON, (Object[])new Object[0]);
                result = new TdaTaskDelVO(false, -1, message, RequestContext.get().getTraceId());
            } else {
                int i = DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"delete from t_cvp_tda_comparison_task where fentryid = ?", (Object[])new Object[]{fid});
                String historyTaskId = histotryObj.getString("taskid");
                String bodp = histotryObj.getString("billoriginaldocpath");
                String boip = histotryObj.getString("billoriginalimagespath");
                String bcdp = histotryObj.getString("billcomparedocpath");
                String bcip = histotryObj.getString("billcompareimagespath");
                LOGGER.info(String.format("TDA \u5dee\u5f02\u5206\u6790\uff0c\u6e05\u7406\u9644\u4ef6 \u4efb\u52a1ID:%s ,\u539f\u6587\u6863:%s ,\u6bd4\u8f83\u6587\u6863:%s ,\u539f\u6587\u6863\u8f6c\u56fe\u7247Base64(\u65e7):%s,\u6bd4\u8f83\u6587\u6863\u8f6c\u56fe\u7247Base64(\u65e7):%s ", historyTaskId, bodp, bcdp, boip, bcip));
                FileService afs = FileServiceFactory.getAttachmentFileService();
                afs.delete(bodp);
                afs.delete(boip);
                if (StringUtils.isNotBlank((CharSequence)bcdp)) {
                    afs.delete(bcdp);
                }
                if (StringUtils.isNotBlank((CharSequence)bcip)) {
                    afs.delete(bcip);
                }
                String selectFile = "imageid,imagepath";
                QFilter oriFilter = new QFilter("taskid", "=", (Object)historyTaskId);
                DynamicObjectCollection images = QueryServiceHelper.query((String)"cvp_tda_task_image", (String)selectFile, (QFilter[])new QFilter[]{oriFilter});
                FileService ifs = FileServiceFactory.getImageFileService();
                int totalSize = 0;
                LOGGER.info(String.format("TDA \u5dee\u5f02\u5206\u6790\uff0c\u5f00\u59cb\u6e05\u7406\u8f6c\u6362\u56fe\u7247 taskID:%s ", historyTaskId));
                if (images != null) {
                    totalSize = images.size();
                    images.forEach(f -> {
                        String imagepath = f.getString("imagepath");
                        ifs.delete(imagepath);
                    });
                }
                LOGGER.info(String.format("TDA \u5dee\u5f02\u5206\u6790\uff0c\u5b8c\u6210\u6e05\u7406\u8f6c\u6362\u56fe\u7247 taskID:%s ,totalSize:%s", historyTaskId, totalSize));
                String message = ResManager.loadKDString((String)"\u4efb\u52a1\u5220\u9664\u6210\u529f\u3002", (String)"TdaInfoPlugin_3", (String)KEY_COMMON, (Object[])new Object[0]);
                result = new TdaTaskDelVO(i > 0, 0, message, RequestContext.get().getTraceId());
            }
        } else {
            String message = ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u5b9a\u8be5\u6bd4\u5bf9\u4efb\u52a1\u662f\u5426\u5df2\u88ab\u6e05\u7406", (String)"TdaInfoPlugin_1", (String)KEY_COMMON, (Object[])new Object[0]);
            result = new TdaTaskDelVO(false, -1, message, RequestContext.get().getTraceId());
        }
        OcrControlUtils.setTdaOrTieCustomcontrolData(view, "customtda", "deleteHistoricalDetailById", result);
    }

    private static void createTask(IFormView view, String args) throws Exception {
        String businessConfig = "A";
        FormShowParameter showParameter = view.getFormShowParameter();
        String btnType = (String)showParameter.getCustomParam("tda_operate_type");
        Object planId = showParameter.getCustomParam("tda_plan_id");
        if (ObjectUtils.isEmpty((Object)planId)) {
            view.showErrorNotification("\u672a\u9009\u4e2d\u5dee\u5f02\u5206\u6790\u65b9\u6848\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u8bd5\u3002");
            OcrControlUtils.setTdaOrTieCustomcontrolData(view, "customtda", "tdaBreakOff", Boolean.TRUE);
        }
        if ("tda_test_task".equals(btnType)) {
            TdaUtils.tdaStartTask(view, args, businessConfig, planId.toString(), false);
        } else {
            String billKey = (String)showParameter.getCustomParam("businessobject");
            QFilter filter = new QFilter("businessobject", "=", (Object)billKey);
            DynamicObject tdaPlan = BusinessDataServiceHelper.loadSingleFromCache((String)"cvp_tda_plan", (QFilter[])new QFilter[]{filter});
            if (tdaPlan == null) {
                view.showTipNotification("\u5dee\u5f02\u5206\u6790\u65b9\u6848\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u914d\u7f6e\u597d\u5dee\u5f02\u5206\u6790\u65b9\u6848\u540e\u518d\u8bd5\uff01");
                OcrControlUtils.setTdaOrTieCustomcontrolData(view, "customtda", "tdaBreakOff", Boolean.TRUE);
                return;
            }
            TdaUtils.tdaStartTask(view, args, businessConfig, planId.toString(), true);
        }
    }

    public static List<TdaOneHistory> getTdaHistoriesByBillId(long billid) {
        String selectField = "id,billoriginaldoc,billcomparedoc,billcreatedate,billenddate,billstatus,progressinfo,variationrate,totalpage,billdifnumber,billcreaterid";
        QFilter filter = new QFilter("billid", "=", (Object)billid);
        DynamicObjectCollection tasks = QueryServiceHelper.query((String)"cvp_tda_task_history", (String)selectField, (QFilter[])new QFilter[]{filter});
        return tasks.stream().map(t -> new TdaOneHistory(String.valueOf(t.getLong("id")), t.getString("billoriginaldoc"), t.getString("billcomparedoc"), t.getDate("billcreatedate") != null ? t.getDate("billcreatedate").getTime() : 0L, t.getDate("billenddate") != null ? t.getDate("billenddate").getTime() : 0L, t.getString("billstatus"), t.getString("progressinfo"), t.getBigDecimal("variationrate"), t.getInt("totalpage"), String.valueOf(t.getLong("billdifnumber")), TdaUtils.getUserName(t.getLong("billcreaterid")))).sorted(Comparator.comparing(TdaOneHistory::getCreationDate).reversed()).collect(Collectors.toList());
    }

    public static String getUserName(long fid) {
        try {
            DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)fid, (String)"bos_user");
            if (user != null) {
                return user.getString("name");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            LOGGER.info("TDA \u5dee\u5f02\u5206\u6790\u6bd4\u5bf9\u4efb\u52a1\u67e5\u8be2\u7528\u6237\u4e0d\u5b58\u5728 FID \uff1a%s", (Object)fid);
        }
        return kd.bos.util.StringUtils.getEmpty();
    }

    public static TdaOneTaskInfo getTdaOneTaskInfo(long fid, long planId) {
        QFilter historyFilter = new QFilter("id", "=", (Object)fid);
        DynamicObject taskInfo = TdaUtils.getTaskInfoByFilters(new QFilter[]{historyFilter});
        if (taskInfo != null) {
            StartComparison startComparison = TdaUtils.getTdaStartComparison(taskInfo);
            CompareData compareData = TdaUtils.getCompareData(taskInfo, planId);
            return new TdaOneTaskInfo("taskhistoryview", startComparison, compareData);
        }
        return null;
    }

    public static FormShowParameter getTdaPlanHistoryShowParameter(IDataModel model) {
        FormShowParameter showParameter = TdaUtils.getFormShowParameter();
        DynamicObjectCollection taskHistory = model.getEntryEntity("cvp_tda_comparison_task");
        DynamicObject comparisonTask = (DynamicObject)taskHistory.get(model.getEntryCurrentRowIndex("cvp_tda_comparison_task"));
        showParameter.setCustomParam("entryid", (Object)String.valueOf(comparisonTask.getPkValue()));
        showParameter.setCustomParam("billid", (Object)String.valueOf(comparisonTask.getLong("billid")));
        showParameter.setCustomParam("tda_bill_number", (Object)comparisonTask.getString("billno"));
        showParameter.setCustomParam("tda_bill_name", (Object)comparisonTask.getString("billname"));
        showParameter.setCustomParam("businessobject", (Object)comparisonTask.getDataEntityType().getExtendName());
        showParameter.setCustomParam("tda_operate_type", (Object)"tda_show_task");
        return showParameter;
    }

    protected static void batchTempUpload(String currenTaskId, String sourceFileType, List<ConversionAlgoInfo> imageList) {
        LOGGER.info(String.format("TDA \u5f00\u59cb\u6267\u884c\u56fe\u7247\u8f6c\u5b58-\u4e34\u65f6\uff0c\u4efb\u52a1ID\uff1a%s , \u6587\u4ef6\u4e1a\u52a1\u7c7b\u578b\uff1a%s ,\u603b\u6570", currenTaskId, sourceFileType));
        int totalSize = 0;
        if (null != imageList) {
            totalSize = imageList.size();
            imageList.forEach(file -> {
                try {
                    file.setImagePath(CommonUtil.getPicFromAlgoForCosmicTempUrl(file.getImageId() + ""));
                }
                catch (Exception e) {
                    String message = ResManager.loadKDString((String)String.format("TDA \u5dee\u5f02\u5206\u6790\u4fdd\u5b58\u4e34\u65f6\u56fe\u7247\u5230\u56fe\u7247\u670d\u52a1\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%s", e.getMessage()), (String)"TdaUitls_1", (String)KEY_COMMON, (Object[])new Object[0]);
                    LOGGER.error(message, (Throwable)e);
                    throw new KDBizException(message);
                }
            });
        }
        LOGGER.info(String.format("TDA \u5b8c\u6210\u6267\u884c\u56fe\u7247\u8f6c\u5b58-\u4e34\u65f6\uff0c\u4efb\u52a1ID\uff1a%s , \u6587\u4ef6\u4e1a\u52a1\u7c7b\u578b\uff1a%s ,\u603b\u6570\uff1a%s", currenTaskId, sourceFileType, totalSize));
    }

    private static /* synthetic */ void lambda$batchUpdateTdaTasks$3(DynamicObject[] taskObjArr, TdaBatchTaskInfoResult.BatchTaskInfoVO rTask) {
        String taskId = rTask.getTaskId();
        String progress = rTask.getProgress();
        Arrays.stream(taskObjArr).forEach(toa -> {
            if (toa.getString("taskid").equals(taskId)) {
                toa.set("progressinfo", (Object)progress);
            }
        });
    }
}

