/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.mservice;

import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import java.util.UUID;
import kd.ai.cvp.common.ClsCommon;
import kd.ai.cvp.common.Enum.AlgoApiEnum;
import kd.ai.cvp.common.Enum.SourceTypeEnum;
import kd.ai.cvp.common.Enum.StorageTypeEnum;
import kd.ai.cvp.core.op.ClassifierOperateMService;
import kd.ai.cvp.entity.classifier.ClsMServiceSingleData;
import kd.ai.cvp.entity.classifier.ClsTargetFile;
import kd.ai.cvp.entity.rpc.CvpMServiceResult;
import kd.ai.cvp.entity.rpc.ParamsCheckResult;
import kd.ai.cvp.mservice.OcrClassifierService;
import kd.ai.cvp.utils.LicenseUtils;
import kd.ai.cvp.utils.OcrControlUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.time.StopWatch;

public class OcrClassifierServiceImpl
implements OcrClassifierService {
    private final Log logger = LogFactory.getLog(OcrClassifierServiceImpl.class);
    private static final String APPID = "ai-cvp-mservice";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String singleClassify(String businessObject, long classifierId, String fileName, String fileType, long fileSize, String filePath, String storageType) {
        CvpMServiceResult result;
        String requestId = String.format("%s_%s", RequestContext.get().getTraceId(), ORM.create().genStringId("cvp_distinguish"));
        boolean status = false;
        String templateNumber = "";
        try {
            this.logger.info(String.format("\u89c6\u89c9\u8bc6\u522b\u3010\u7ec4\u5408\u8bc6\u522b\u5668\u3011\u5fae\u670d\u52a1API\u8c03\u7528-start \u8bf7\u6c42ID:%s, params: businessObject:%s,classifierId:%s,fileName:%s,fileType:%s,filePath:%s,storageType:%s", requestId, businessObject, classifierId, fileName, fileType, filePath, storageType));
            StopWatch watch = new StopWatch();
            watch.start();
            ParamsCheckResult checkResult = this.getValidMessage("K", businessObject, classifierId, fileName, fileType, fileSize, filePath, storageType);
            if (checkResult.isNoStatus()) {
                this.logger.error(String.format("\u89c6\u89c9\u8bc6\u522b\u3010\u7ec4\u5408\u8bc6\u522b\u5668\u3011\u5fae\u670d\u52a1API\uff0c\u53c2\u6570\u6821\u9a8c\u4e0d\u901a\u8fc7: %s", checkResult.getMsg()));
                result = CvpMServiceResult.ERROR((String)requestId, (String)String.valueOf(40002), (String)checkResult.getMsg());
            } else {
                this.logger.info("\u89c6\u89c9\u8bc6\u522b\u3010\u7ec4\u5408\u8bc6\u522b\u5668\u3011\u5fae\u670d\u52a1API\u8c03\u7528-\u8bb8\u53ef\u6821\u9a8c \u5f00\u59cb");
                LicenseUtils.checkLicense((int)1, (String)"", (String)requestId);
                this.logger.info("\u89c6\u89c9\u8bc6\u522b\u3010\u7ec4\u5408\u8bc6\u522b\u5668\u3011\u5fae\u670d\u52a1API\u8c03\u7528-\u8bb8\u53ef\u6821\u9a8c \u7ed3\u675f");
                fileType = fileType.replaceAll("/.", "").toLowerCase();
                StorageTypeEnum storageTypeEnum = StorageTypeEnum.getStorageTypeEnum((String)storageType);
                ClsTargetFile clsTargetFile = new ClsTargetFile(filePath, UUID.randomUUID().toString().replaceAll("-", ""), fileName, fileType, String.valueOf(fileSize), storageTypeEnum);
                ClsMServiceSingleData mserviceData = ClassifierOperateMService.instance.operate(clsTargetFile, classifierId);
                String errorCode = mserviceData.getErrorCode();
                if (StringUtils.isNotBlank((CharSequence)errorCode)) {
                    this.logger.error(String.format("\u89c6\u89c9\u8bc6\u522b\u3010\u7ec4\u5408\u8bc6\u522b\u5668\u3011\u5fae\u670d\u52a1API\u8c03\u7528\uff0c\u5206\u7c7b\u8c03\u7528\u5f02\u5e38: %s", Objects.nonNull(mserviceData) ? mserviceData.toString() : "ClassifierOperateMService \u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a"));
                    result = new CvpMServiceResult(requestId, errorCode, false, mserviceData.getProgress(), null);
                } else {
                    result = CvpMServiceResult.OK((String)requestId, (Object)mserviceData);
                    templateNumber = mserviceData.getTemplateNumber();
                    status = true;
                    this.logger.info(String.format("\u89c6\u89c9\u8bc6\u522b\u3010\u7ec4\u5408\u8bc6\u522b\u5668\u3011\u5fae\u670d\u52a1API\u8c03\u7528,\u5339\u914d\u6a21\u7248\uff1a%s", templateNumber));
                }
            }
            watch.stop();
            this.setApiInfo(businessObject, templateNumber, result, "B", watch.getTime());
        }
        catch (Exception e) {
            ErrorCode code;
            String message = String.format("\u89c6\u89c9\u8bc6\u522b\u3010\u7ec4\u5408\u8bc6\u522b\u5668\u3011\u5fae\u670d\u52a1API\u8c03\u7528\u5f02\u5e38\uff0c%s", e.getMessage());
            this.logger.error(message, (Throwable)e);
            result = e instanceof KDBizException ? (Objects.nonNull(code = ((KDBizException)e).getErrorCode()) ? CvpMServiceResult.ERROR((String)requestId, (String)code.getCode(), (String)code.getMessage()) : CvpMServiceResult.ERROR((String)requestId, (String)String.valueOf(40000), (String)message)) : CvpMServiceResult.ERROR((String)requestId, (String)String.valueOf(40000), (String)message);
        }
        finally {
            String api = AlgoApiEnum.getValue((String)templateNumber);
            if (StringUtils.isEmpty((CharSequence)api)) {
                LicenseUtils.ensureCallNumToAlgo((boolean)status, (String)requestId, (SourceTypeEnum)SourceTypeEnum.SELFDESIGNTEMPLATE);
            } else {
                LicenseUtils.ensureCallNumToAlgo((boolean)status, (String)requestId, (SourceTypeEnum)SourceTypeEnum.PRESETTEMPLATE);
            }
            this.logger.info("\u89c6\u89c9\u8bc6\u522b\u3010\u7ec4\u5408\u8bc6\u522b\u5668\u3011\u5fae\u670d\u52a1API\u8c03\u7528-\u8bb8\u53ef\u6838\u9500 \u7ed3\u675f");
        }
        this.logger.info("\u89c6\u89c9\u8bc6\u522b\u3010\u7ec4\u5408\u8bc6\u522b\u5668\u3011\u5fae\u670d\u52a1API\u8c03\u7528-\u7ed3\u675f");
        return SerializationUtils.toJsonString((Object)result);
    }

    private ParamsCheckResult getValidMessage(String invokeType, String businessObject, long classifierId, String fileName, String fileType, long fileSize, String filePath, String storageType) {
        boolean no_exists;
        String msg = null;
        if (!"L".equals(invokeType)) {
            if (StringUtils.isEmpty((CharSequence)businessObject)) {
                msg = ResManager.loadKDString((String)"\u53c2\u6570:businessObject \u4e1a\u52a1\u5bf9\u8c61\u6807\u8bc6 \u4e3a\u7a7a ", (String)"OcrClassifierServiceImpl_0", (String)APPID, (Object[])new Object[0]);
            } else {
                MainEntityType entityType = null;
                try {
                    entityType = MetadataServiceHelper.getDataEntityType((String)businessObject);
                }
                catch (Exception e) {
                    msg = ResManager.loadKDString((String)"\u53c2\u6570:businessObject \u4e1a\u52a1\u5bf9\u8c61\u6807\u8bc6 \u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728,\u8bf7\u4f20\u6709\u6548\u6807\u8bc6 ", (String)"OcrClassifierServiceImpl_01", (String)APPID, (Object[])new Object[0]);
                }
                if (entityType == null) {
                    msg = ResManager.loadKDString((String)"\u53c2\u6570:businessObject \u4e1a\u52a1\u5bf9\u8c61\u6807\u8bc6 \u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728,\u8bf7\u4f20\u6709\u6548\u6807\u8bc6 ", (String)"OcrClassifierServiceImpl_02", (String)APPID, (Object[])new Object[0]);
                }
            }
        }
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            msg = ResManager.loadKDString((String)"\u53c2\u6570:fileName \u6587\u4ef6\u540d \u4e3a\u7a7a ", (String)"OcrClassifierServiceImpl_03", (String)APPID, (Object[])new Object[0]);
        }
        if (StringUtils.isEmpty((CharSequence)fileType)) {
            msg = ResManager.loadKDString((String)"\u53c2\u6570:fileType \u6587\u4ef6\u7c7b\u578b \u4e3a\u7a7a ", (String)"OcrClassifierServiceImpl_04", (String)APPID, (Object[])new Object[0]);
        } else if (Arrays.stream(ClsCommon.ViewParam.FILE_ALL_TYPE).noneMatch(t -> t.equalsIgnoreCase(fileType))) {
            msg = ResManager.loadKDString((String)"\u53c2\u6570:fileType \u6587\u4ef6\u7c7b\u578b\u53c2\u6570\u6709\u8bef,\u53ef\u652f\u6301\u7684\u7c7b\u578b\uff1ajpg,jpeg,png,pdf", (String)"OcrClassifierServiceImpl_05", (String)APPID, (Object[])new Object[0]);
        } else if ("pdf".equalsIgnoreCase(fileType)) {
            if (fileSize > 0x800000L) {
                msg = ResManager.loadKDString((String)"\u53c2\u6570:fileSize \u6587\u4ef6\u8d85\u51fa\u9650\u5236\uff0c\u56fe\u7247\u5355\u5f20<=8m ", (String)"OcrClassifierServiceImpl_07", (String)APPID, (Object[])new Object[0]);
            }
        } else if (Arrays.stream(ClsCommon.ViewParam.FILE_IMAGE_TYPE).anyMatch(t -> t.equalsIgnoreCase(fileType)) && fileSize > 0xA00000L) {
            msg = ResManager.loadKDString((String)"\u53c2\u6570:fileSize \u6587\u4ef6\u8d85\u51fa\u9650\u5236\uff0cpdf\u6587\u5355\u9875\u5927\u5c0f<=10m ", (String)"OcrClassifierServiceImpl_07", (String)APPID, (Object[])new Object[0]);
        }
        if (StringUtils.isEmpty((CharSequence)storageType)) {
            msg = ResManager.loadKDString((String)"\u53c2\u6570:storageType \u6587\u4ef6\u5b58\u50a8\u7c7b\u578b \u4e3a\u7a7a ", (String)"OcrClassifierServiceImpl_06", (String)APPID, (Object[])new Object[0]);
        } else {
            StorageTypeEnum storageTypeEnum = StorageTypeEnum.getStorageTypeEnum((String)storageType);
            if (Objects.isNull(storageTypeEnum)) {
                msg = ResManager.loadKDString((String)"\u53c2\u6570:storageType \u6587\u4ef6\u5b58\u50a8\u7c7b\u578b\u53c2\u6570\u6709\u8bef\uff0c\u652f\u6301\uff1aatt:\u9644\u4ef6\u670d\u52a1\u5668\u5b58\u50a8; img:\u56fe\u7247\u670d\u52a1\u5668\u5b58\u50a8", (String)"OcrClassifierServiceImpl_06", (String)APPID, (Object[])new Object[0]);
            }
        }
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            msg = ResManager.loadKDString((String)"\u53c2\u6570:filePath \u6587\u4ef6\u8def\u5f84 \u4e3a\u7a7a ", (String)"OcrClassifierServiceImpl_08", (String)APPID, (Object[])new Object[0]);
        }
        boolean bl = no_exists = !QueryServiceHelper.exists((String)"cvp_cls_info", (Object)classifierId);
        if (no_exists) {
            msg = ResManager.loadKDString((String)"\u53c2\u6570:classifierId \u9009\u62e9\u7684\u7ec4\u5408\u7ec4\u5408\u8bc6\u522b\u5668\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u88ab\u5220\u9664 ", (String)"OcrClassifierServiceImpl_09", (String)APPID, (Object[])new Object[0]);
        }
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            return ParamsCheckResult.NO((String)msg);
        }
        return ParamsCheckResult.OK();
    }

    public void setApiInfo(String businessObject, String templateNumber, CvpMServiceResult resultData, String invokeType, long callTime) {
        this.logger.info(String.format("\u6a21\u7248\uff1a%s  ,\u8bb0\u5f55\u82cd\u7a79-API \u8c03\u7528\u4fe1\u606f", templateNumber));
        RequestContext rc = RequestContext.get();
        DynamicObject template = OcrControlUtils.getBindingObjCacheByNumber((String)"cvp_template", (String)templateNumber);
        DynamicObject apiInfo = ORM.create().newDynamicObject("cvp_api_invoke_info");
        String businessName = MetadataServiceHelper.getDataEntityType((String)businessObject).getDisplayName().getLocaleValue();
        apiInfo.set("createdate", (Object)new Date());
        apiInfo.set("calltime", (Object)callTime);
        apiInfo.set("errorcode", (Object)resultData.getErrorCode());
        apiInfo.set("traceid", (Object)rc.getTraceId());
        apiInfo.set("templateid", template != null ? template.getPkValue() : Integer.valueOf(0));
        apiInfo.set("templatename", (Object)(template != null ? template.getString("name") : ""));
        apiInfo.set("callobjectid", (Object)businessObject);
        apiInfo.set("callobjectname", (Object)businessName);
        apiInfo.set("userid", (Object)String.valueOf(rc.getCurrUserId()));
        apiInfo.set("username", (Object)rc.getUserName());
        apiInfo.set("status", (Object)invokeType);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{apiInfo});
    }
}

