/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.agent.tool;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.ai.gai.core.agent.entity.AgentHistoryMessage;
import kd.ai.gai.core.domain.llm.base.MessageItem4AzureBaiduTencentXf;
import kd.ai.gai.core.enuz.LlmRole;
import kd.ai.gai.core.util.GaiFieldTypeInitUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.field.ComboItem;

public class LLMUtil {
    public Map<String, String> getAllLLMs() {
        List<ComboItem> comboItems = GaiFieldTypeInitUtils.createLlmComboItem();
        HashMap<String, String> comboMap = new HashMap<String, String>(50);
        for (ComboItem comboItem : comboItems) {
            String key = comboItem.getCaption().getLocaleValue();
            String value = comboItem.getValue();
            comboMap.put(key, value);
        }
        return comboMap;
    }

    public static String getGPT40Content(JSONObject llmParam) {
        JSONArray messageArray = llmParam.getJSONArray("messages");
        Iterator iterator = messageArray.iterator();
        StringBuilder needCheckStr = new StringBuilder();
        String promptStr = "";
        String contentStr = "";
        while (iterator.hasNext()) {
            JSONObject roleJson = (JSONObject)iterator.next();
            String role = roleJson.getString("role");
            if (role.equals("system")) {
                promptStr = roleJson.getString("content");
            }
            if (!role.equals("user")) continue;
            contentStr = roleJson.getString("content");
        }
        needCheckStr.append(promptStr);
        needCheckStr.append("\n");
        needCheckStr.append(contentStr);
        return needCheckStr.toString();
    }

    public static List<AgentHistoryMessage> getGPT40History(JSONObject llmParam) {
        JSONArray messageArray = llmParam.getJSONArray("messages");
        final ArrayList<AgentHistoryMessage> list = new ArrayList<AgentHistoryMessage>(messageArray.size());
        messageArray.stream().forEach(new Consumer<Object>(){

            @Override
            public void accept(Object o) {
                JSONObject contentJson = (JSONObject)o;
                String role = contentJson.getString("role");
                String content = contentJson.getString("content");
                AgentHistoryMessage agentHistoryMessage = new AgentHistoryMessage();
                if (StringUtils.equals((CharSequence)role, (CharSequence)"user")) {
                    agentHistoryMessage.setUser(content);
                }
                if (StringUtils.equals((CharSequence)role, (CharSequence)"assistant")) {
                    agentHistoryMessage.setAssistant(content);
                }
                if (StringUtils.equals((CharSequence)role, (CharSequence)"system")) {
                    agentHistoryMessage.setSystem(content);
                }
                list.add(agentHistoryMessage);
            }
        });
        return list;
    }

    public static List<MessageItem4AzureBaiduTencentXf> getGPTMessageByHistory(List<AgentHistoryMessage> userHistoryMessages) {
        final ArrayList<MessageItem4AzureBaiduTencentXf> messageItem = new ArrayList<MessageItem4AzureBaiduTencentXf>(userHistoryMessages.size());
        userHistoryMessages.stream().forEach(new Consumer<AgentHistoryMessage>(){

            @Override
            public void accept(AgentHistoryMessage agentHistoryMessage) {
                MessageItem4AzureBaiduTencentXf messageItem4AzureBaiduTencentXf = new MessageItem4AzureBaiduTencentXf();
                String user = agentHistoryMessage.getUser();
                String assistant = agentHistoryMessage.getAssistant();
                String system = agentHistoryMessage.getSystem();
                if (!StringUtils.isEmpty((CharSequence)user)) {
                    messageItem4AzureBaiduTencentXf.setRole(LlmRole.user);
                    messageItem4AzureBaiduTencentXf.setContent(user);
                    messageItem.add(messageItem4AzureBaiduTencentXf);
                }
                if (!StringUtils.isEmpty((CharSequence)assistant)) {
                    messageItem4AzureBaiduTencentXf.setRole(LlmRole.assistant);
                    messageItem4AzureBaiduTencentXf.setContent(assistant);
                    messageItem.add(messageItem4AzureBaiduTencentXf);
                }
                if (!StringUtils.isEmpty((CharSequence)system)) {
                    messageItem4AzureBaiduTencentXf.setRole(LlmRole.system);
                    messageItem4AzureBaiduTencentXf.setContent(system);
                    messageItem.add(messageItem4AzureBaiduTencentXf);
                }
            }
        });
        return messageItem;
    }

    public static String updateOpenAIResultContent(String result, String content) {
        JSONObject resultJson = JSON.parseObject((String)result);
        JSONObject choiceJson = resultJson.getJSONArray("choices").getJSONObject(0);
        JSONObject messageJSON = choiceJson.getJSONObject("message");
        messageJSON.put("content", (Object)content);
        return resultJson.toJSONString();
    }

    public static String getOpenAIContent(String result) {
        JSONObject resultJson = JSON.parseObject((String)result);
        JSONObject choiceJson = resultJson.getJSONArray("choices").getJSONObject(0);
        JSONObject messageJSON = choiceJson.getJSONObject("message");
        String centent = messageJSON.getString("content");
        return centent;
    }
}

